/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.svek.image.SmallestEnclosingCircle;
import net.sourceforge.plantuml.svek.image.YTransformer;

public class ContainingEllipse {
    private final SmallestEnclosingCircle sec = new SmallestEnclosingCircle();
    private final YTransformer ytransformer;
    private double deltaShadow;

    public String toString() {
        return "ContainingEllipse " + this.getWidth() + " " + this.getHeight();
    }

    public ContainingEllipse(double coefY) {
        this.ytransformer = new YTransformer(coefY);
    }

    public void append(XPoint2D pt) {
        pt = this.ytransformer.getReversePoint2D(pt);
        this.sec.append(pt);
    }

    public void append(double x, double y) {
        this.append(new XPoint2D(x, y));
    }

    public double getWidth() {
        return 2.0 * this.sec.getCircle().getRadius();
    }

    public double getHeight() {
        return 2.0 * this.sec.getCircle().getRadius() * this.ytransformer.getAlpha();
    }

    public XPoint2D getCenter() {
        return this.ytransformer.getPoint2D(this.sec.getCircle().getCenter());
    }

    public UEllipse asUEllipse() {
        UEllipse ellipse = UEllipse.build(this.getWidth(), this.getHeight());
        ellipse.setDeltaShadow(this.deltaShadow);
        return ellipse;
    }

    public void setDeltaShadow(double deltaShadow) {
        this.deltaShadow = deltaShadow;
    }
}

