/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import net.sourceforge.plantuml.klimt.creole.NeutronType;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.creole.legacy.AtomText;
import net.sourceforge.plantuml.klimt.font.StringBounder;

public class Neutron {
    private final String data;
    private final NeutronType type;
    private final Atom asAtom;

    private Neutron(String data, NeutronType type, Atom asAtom) {
        this.data = data;
        this.type = type;
        this.asAtom = asAtom;
    }

    public static Neutron create(Atom atom) {
        if (atom instanceof AtomText) {
            String text = ((AtomText)atom).getText();
            return new Neutron(text, Neutron.getNeutronTypeFromChar(text.charAt(0)), atom);
        }
        return new Neutron(null, NeutronType.OTHER, atom);
    }

    public static Neutron zwspSeparator() {
        return new Neutron(null, NeutronType.ZWSP_SEPARATOR, null);
    }

    public String toString() {
        if (this.type == NeutronType.ZWSP_SEPARATOR) {
            return "ZWSP";
        }
        return (Object)((Object)this.type) + "(" + this.data + ")";
    }

    public Atom asAtom() {
        return this.asAtom;
    }

    public NeutronType getType() {
        return this.type;
    }

    public static boolean isSeparator(char ch) {
        return Character.isWhitespace(ch);
    }

    private static boolean isSentenceBoundaryUnused(char ch) {
        return ch == '.' || ch == ',';
    }

    public static boolean isChineseSentenceBoundary(char ch) {
        return ch == '\uff01' || ch == '\uff0c' || ch == '\uff1a' || ch == '\uff1b' || ch == '\uff1f' || ch == '\u3002';
    }

    public double getWidth(StringBounder stringBounder) {
        if (this.type == NeutronType.ZWSP_SEPARATOR) {
            return 0.0;
        }
        return this.asAtom.calculateDimension(stringBounder).getWidth();
    }

    public static NeutronType getNeutronTypeFromChar(char ch) {
        if (Neutron.isSeparator(ch)) {
            return NeutronType.SPACE;
        }
        return NeutronType.TEXT;
    }
}

