/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax.styles;

import java.awt.Color;
import java.awt.Font;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.atpfivt.jsyntrax.Main;
import org.atpfivt.jsyntrax.styles.NodeBoxStyle;
import org.atpfivt.jsyntrax.styles.NodeBubbleStyle;
import org.atpfivt.jsyntrax.styles.NodeHexStyle;
import org.atpfivt.jsyntrax.styles.NodeStyle;
import org.atpfivt.jsyntrax.styles.NodeTokenStyle;
import org.atpfivt.jsyntrax.styles.TitlePosition;
import org.atpfivt.jsyntrax.util.StringUtils;
import org.ini4j.Profile;
import org.ini4j.Wini;

public final class StyleConfig {
    private int lineWidth = 2;
    private int outlineWidth = 2;
    private int padding = 5;
    private Color lineColor = new Color(0, 0, 0);
    private int maxRadius = 9;
    private int hSep = 17;
    private int vSep = 9;
    private boolean arrows = true;
    private TitlePosition titlePos = TitlePosition.tl;
    private Color bulletFill = new Color(255, 255, 255);
    private Color textColor = new Color(0, 0, 0);
    private boolean shadow = true;
    private Color shadowFill = new Color(0, 0, 0, 127);
    private Font titleFont = new Font("Sans", 1, 22);
    private double scale;
    private boolean transparency;
    private NodeStyle defNodeStyle = new NodeStyle();
    private List<NodeStyle> nodeStyles = new ArrayList<NodeHexStyle>(List.of(new NodeBubbleStyle(), new NodeBoxStyle(), new NodeTokenStyle(), new NodeHexStyle()));

    private void parseStyleArgs(Profile.Section s) throws IOException {
        try {
            this.parseField(s, this, "line_width", Integer::parseInt);
            this.parseField(s, this, "outline_width", Integer::parseInt);
            this.parseField(s, this, "padding", Integer::parseInt);
            this.parseField(s, this, "line_color", StringUtils::colorFromString);
            this.parseField(s, this, "max_radius", Integer::parseInt);
            this.parseField(s, this, "h_sep", Integer::parseInt);
            this.parseField(s, this, "v_sep", Integer::parseInt);
            this.parseField(s, this, "arrows", Boolean::parseBoolean);
            this.parseField(s, this, "title_pos", v -> TitlePosition.valueOf(v.substring(1, v.length() - 1)));
            this.parseField(s, this, "bullet_fill", StringUtils::colorFromString);
            this.parseField(s, this, "text_color", StringUtils::colorFromString);
            this.parseField(s, this, "shadow", Boolean::parseBoolean);
            this.parseField(s, this, "shadow_fill", StringUtils::colorFromString);
            this.parseField(s, this, "title_font", StringUtils::fontFromString);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException(e);
        }
    }

    private void parseNodeStyle(Profile.Section s, NodeStyle ns) throws IOException {
        try {
            Function<String, Object> patFunc = v -> Pattern.compile(v.substring(1, v.length() - 1));
            this.parseField(s, ns, "pattern", patFunc);
            this.parseField(s, ns, "shape", v -> v.substring(1, v.length() - 1));
            this.parseField(s, ns, "font", StringUtils::fontFromString);
            this.parseField(s, ns, "text_color", StringUtils::colorFromString);
            this.parseField(s, ns, "fill", StringUtils::colorFromString);
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            throw new IOException(e);
        }
    }

    private void parseField(Profile.Section s, Object obj, String propertyName, Function<String, Object> parser) throws NoSuchFieldException, IllegalAccessException {
        if (s.containsKey((Object)propertyName)) {
            Field field = obj.getClass().getDeclaredField(StringUtils.snakeToCamelCase(propertyName));
            field.setAccessible(true);
            field.set(obj, parser.apply((String)s.get((Object)propertyName)));
        } else {
            System.out.println("[StyleConfigParser] Warning: section [" + s.getName() + "] does not contain property [" + propertyName + "]");
        }
    }

    public StyleConfig(double scale, boolean transparency) throws IOException {
        this.setTransparency(transparency);
        this.setScale(scale);
        Wini config = new Wini(Main.class.getResourceAsStream("/jsyntrax.ini"));
        if (config.containsKey((Object)"style")) {
            this.parseStyleArgs((Profile.Section)config.get((Object)"style"));
        }
    }

    public StyleConfig(double scale, boolean transparency, Path style) throws IOException {
        this.setTransparency(transparency);
        this.setScale(scale);
        Wini ini = new Wini(style.toFile());
        if (ini.containsKey((Object)"style")) {
            this.parseStyleArgs((Profile.Section)ini.get((Object)"style"));
        }
        this.getNodeStyles().clear();
        for (Profile.Section s : ini.values()) {
            if (s.getName().equals("style")) continue;
            NodeStyle ns = new NodeStyle();
            ns.setName(s.getName());
            this.parseNodeStyle(s, ns);
            this.getNodeStyles().add(ns);
        }
    }

    public NodeStyle getNodeStyle(String txt) {
        for (NodeStyle ns : this.getNodeStyles()) {
            if (!ns.match(txt)) continue;
            return ns;
        }
        return this.getDefNodeStyle();
    }

    public boolean getArrows() {
        return this.isArrows();
    }

    public int getLineWidth() {
        return this.lineWidth;
    }

    public int getOutlineWidth() {
        return this.outlineWidth;
    }

    public int getPadding() {
        return this.padding;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public int getMaxRadius() {
        return this.maxRadius;
    }

    public int getHSep() {
        return this.gethSep();
    }

    public int getVSep() {
        return this.getvSep();
    }

    public TitlePosition getTitlePos() {
        return this.titlePos;
    }

    public Color getBulletFill() {
        return this.bulletFill;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public boolean isShadow() {
        return this.shadow;
    }

    public Color getShadowFill() {
        return this.shadowFill;
    }

    public Font getTitleFont() {
        return this.titleFont;
    }

    public List<NodeStyle> getNodeStyles() {
        return this.nodeStyles;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean isTransparent() {
        return this.isTransparency();
    }

    public int gethSep() {
        return this.hSep;
    }

    public int getvSep() {
        return this.vSep;
    }

    public boolean isArrows() {
        return this.arrows;
    }

    public boolean isTransparency() {
        return this.transparency;
    }

    public void setLineWidth(int lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setOutlineWidth(int outlineWidth) {
        this.outlineWidth = outlineWidth;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public void setMaxRadius(int maxRadius) {
        this.maxRadius = maxRadius;
    }

    public void sethSep(int hSep) {
        this.hSep = hSep;
    }

    public void setvSep(int vSep) {
        this.vSep = vSep;
    }

    public void setArrows(boolean arrows) {
        this.arrows = arrows;
    }

    public void setTitlePos(TitlePosition titlePos) {
        this.titlePos = titlePos;
    }

    public void setBulletFill(Color bulletFill) {
        this.bulletFill = bulletFill;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public void setShadow(boolean shadow) {
        this.shadow = shadow;
    }

    public void setShadowFill(Color shadowFill) {
        this.shadowFill = shadowFill;
    }

    public void setTitleFont(Font titleFont) {
        this.titleFont = titleFont;
    }

    public void setScale(double scale) {
        this.scale = scale;
    }

    public void setTransparency(boolean transparency) {
        this.transparency = transparency;
    }

    public NodeStyle getDefNodeStyle() {
        return this.defNodeStyle;
    }

    public void setDefNodeStyle(NodeStyle defNodeStyle) {
        this.defNodeStyle = defNodeStyle;
    }

    public void setNodeStyles(List<NodeStyle> nodeStyles) {
        this.nodeStyles = nodeStyles;
    }
}

