/*
 * Decompiled with CFR 0.152.
 */
package org.atpfivt.jsyntrax.generators.elements;

import org.atpfivt.jsyntrax.generators.elements.Element;
import org.atpfivt.jsyntrax.styles.StyleConfig;
import org.atpfivt.jsyntrax.util.Pair;
import org.atpfivt.jsyntrax.util.StringUtils;

public class LineElement
extends Element {
    private final String arrow;
    private int width;

    public LineElement(Pair<Integer, Integer> start, Pair<Integer, Integer> end, String arrow, int width, String tag) {
        super(tag);
        super.setStart(start);
        super.setEnd(end);
        this.arrow = arrow;
        this.width = width;
    }

    @Override
    public void addShadow(StringBuilder sb, StyleConfig style) {
    }

    @Override
    public void toSVG(StringBuilder sb, StyleConfig style) {
        String attributes = "stroke=\"" + StringUtils.toHex(style.getLineColor()) + "\" stroke-width=\"" + this.width + "\"";
        if (this.arrow != null) {
            attributes = attributes + " marker-end=\"url(#arrow)\"";
            if ("first".equals(this.arrow)) {
                Pair<Integer, Integer> tmp = super.getStart();
                super.setStart(super.getEnd());
                super.setEnd(tmp);
            }
            double len = Math.sqrt(((Integer)super.getEnd().f - (Integer)super.getStart().f) * ((Integer)super.getEnd().f - (Integer)super.getStart().f) + ((Integer)super.getEnd().s - (Integer)super.getStart().s) * ((Integer)super.getEnd().s - (Integer)super.getStart().s));
            double angle = Math.atan2((Integer)super.getEnd().s - (Integer)super.getStart().s, (Integer)super.getEnd().f - (Integer)super.getStart().f);
            super.getEnd().f = (int)((double)((Integer)super.getStart().f).intValue() + (len -= 4.0) * Math.cos(angle));
            super.getEnd().s = (int)((double)((Integer)super.getStart().s).intValue() + len * Math.sin(angle));
        }
        sb.append("<line ").append("x1=\"").append(super.getStart().f).append("\" ").append("y1=\"").append(super.getStart().s).append("\" ").append("x2=\"").append(super.getEnd().f).append("\" ").append("y2=\"").append(super.getEnd().s).append("\" ").append(attributes).append(" />\n");
    }

    @Override
    public void scale(double scale) {
        super.scale(scale);
        this.width = (int)((double)this.width * scale);
    }
}

