/*
 * Decompiled with CFR 0.152.
 */
package org.stathissideris.ditaa.core;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.ListIterator;
import javax.imageio.ImageIO;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.stathissideris.ditaa.core.ConversionOptions;
import org.stathissideris.ditaa.core.RenderingOptions;
import org.stathissideris.ditaa.graphics.BitmapRenderer;
import org.stathissideris.ditaa.graphics.Diagram;
import org.stathissideris.ditaa.graphics.SVGRenderer;
import org.stathissideris.ditaa.text.TextGrid;

public class CommandLineConverter {
    public static void main(String[] args) {
        try {
            CommandLineConverter.convert(args);
            System.exit(0);
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convert(String[] args) throws IOException {
        ListIterator<String> argsIt = Arrays.asList(args).listIterator();
        ConversionOptions options = ConversionOptions.parseCommandLineOptions(argsIt);
        if (!argsIt.hasNext()) {
            throw new IOException("Input file not specified");
        }
        String inputFile = argsIt.next();
        String outputFile = argsIt.hasNext() ? argsIt.next() : (inputFile.equals("-") ? "-" : inputFile + "." + options.renderingOptions.getImageType().getExtension());
        InputStream in = null;
        OutputStream out = null;
        try {
            in = inputFile.equals("-") ? System.in : new FileInputStream(inputFile);
            out = outputFile.equals("-") ? System.out : new FileOutputStream(outputFile);
            CommandLineConverter.doConvert(in, out, options);
        }
        finally {
            if (in instanceof FileInputStream) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (out instanceof FileOutputStream) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int convert(String[] args, InputStream input, OutputStream output) {
        try {
            CommandLineConverter.doConvert(input, output, ConversionOptions.parseCommandLineOptions(args));
            return 0;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return 1;
        }
        catch (IOException e) {
            e.printStackTrace();
            return 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doConvert(InputStream input, OutputStream output, ConversionOptions options) throws IOException {
        Diagram diagram = CommandLineConverter.convertToImage(input, options);
        RenderingOptions.ImageType imageType = options.renderingOptions.getImageType();
        if (imageType == RenderingOptions.ImageType.SVG) {
            String content = new SVGRenderer().renderToImage(diagram, options.renderingOptions);
            OutputStreamWriter writer = new OutputStreamWriter(output, Charset.forName("UTF-8"));
            try {
                writer.write(content);
            }
            finally {
                writer.flush();
            }
        } else {
            BufferedImage image = new BitmapRenderer().renderToImage(diagram, options.renderingOptions);
            MemoryCacheImageOutputStream memCache = new MemoryCacheImageOutputStream(output);
            ImageIO.write((RenderedImage)image, imageType.getFormatName(), memCache);
            memCache.flush();
        }
    }

    private static Diagram convertToImage(InputStream input, ConversionOptions options) throws IOException {
        TextGrid grid = new TextGrid();
        if (options.processingOptions.getCustomShapes() != null) {
            grid.addToMarkupTags(options.processingOptions.getCustomShapes().keySet());
        }
        grid.loadFrom(input, options.processingOptions);
        if (options.processingOptions.printDebugOutput()) {
            grid.printDebug(System.out);
        }
        return new Diagram(grid, options);
    }
}

