/*
 * Decompiled with CFR 0.152.
 */
package org.asciidoctor.diagram.plantuml;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Option;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.error.PSystemError;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.security.SFile;
import net.sourceforge.plantuml.version.IteratorCounter2;
import org.asciidoctor.diagram.DiagramGeneratorFunction;
import org.asciidoctor.diagram.HTTPHeader;
import org.asciidoctor.diagram.MimeType;
import org.asciidoctor.diagram.Request;
import org.asciidoctor.diagram.ResponseData;

public class PlantUMLPreprocessor
implements DiagramGeneratorFunction {
    private static final MimeType DEFAULT_OUTPUT_FORMAT = MimeType.TEXT_PLAIN_UTF8;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResponseData generate(Request request) throws IOException {
        String preprocessed;
        MimeType format = (MimeType)request.headers.getValue(HTTPHeader.ACCEPT);
        if (format == null) {
            format = DEFAULT_OUTPUT_FORMAT;
        }
        if (!format.equals((Object)MimeType.TEXT_PLAIN_UTF8)) {
            throw new IOException("Unsupported output format: " + format);
        }
        String default_includeDir = System.getProperty("plantuml.include.path");
        try {
            PlantUMLPreprocessor plantUMLPreprocessor = this;
            synchronized (plantUMLPreprocessor) {
                List includeDirs = request.headers.getValues("X-PlantUML-IncludeDir");
                if (!includeDirs.isEmpty()) {
                    System.setProperty("plantuml.include.path", includeDirs.stream().collect(Collectors.joining(File.pathSeparator)));
                }
                preprocessed = PlantUMLPreprocessor.preprocess(request.asString(), request.headers.getValue("X-PlantUML-Config"), request.headers.getValue("X-PlantUML-Basedir"));
            }
        }
        finally {
            if (default_includeDir != null) {
                System.setProperty("plantuml.include.path", default_includeDir);
            } else {
                System.clearProperty("plantuml.include.path");
            }
        }
        return new ResponseData(format, preprocessed.getBytes(StandardCharsets.UTF_8));
    }

    static String preprocess(String input, String plantUmlConfig, String baseDir) throws IOException {
        Option option = new Option();
        if (plantUmlConfig != null) {
            option.initConfig(plantUmlConfig);
        }
        StringBuilder out = new StringBuilder();
        BlockUmlBuilder builder = new BlockUmlBuilder(option.getConfig(), "UTF-8", Defines.createEmpty(), (Reader)new StringReader(input), baseDir != null ? new SFile(baseDir) : FileSystem.getInstance().getCurrentDir(), "<input>");
        List blocks = builder.getBlockUmls();
        if (blocks.size() == 0) {
            throw new IOException("No @startuml found");
        }
        for (BlockUml b : blocks) {
            Diagram system = b.getDiagram();
            if (system instanceof PSystemError) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                system.exportDiagram((OutputStream)baos, 0, new FileFormatOption(FileFormat.UTXT));
                throw new IOException(new String(baos.toByteArray(), StandardCharsets.UTF_8));
            }
            UmlSource source = system.getSource();
            if (source == null) continue;
            IteratorCounter2 lines = source.iterator2();
            while (lines.hasNext()) {
                Object line = lines.next();
                if (out.length() > 0) {
                    out.append('\n');
                }
                out.append(line);
            }
        }
        if (out.length() == 0) {
            return "@startuml\n@enduml";
        }
        return out.toString();
    }
}

