// Code generated by sdkgen. DO NOT EDIT.

// nolint
package waf

import (
	"context"

	"google.golang.org/grpc"

	"github.com/yandex-cloud/go-genproto/yandex/cloud/operation"
	waf "github.com/yandex-cloud/go-genproto/yandex/cloud/smartwebsecurity/v1/waf"
)

//revive:disable

// WafProfileServiceClient is a waf.WafProfileServiceClient with
// lazy GRPC connection initialization.
type WafProfileServiceClient struct {
	getConn func(ctx context.Context) (*grpc.ClientConn, error)
}

// Create implements waf.WafProfileServiceClient
func (c *WafProfileServiceClient) Create(ctx context.Context, in *waf.CreateWafProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return waf.NewWafProfileServiceClient(conn).Create(ctx, in, opts...)
}

// Delete implements waf.WafProfileServiceClient
func (c *WafProfileServiceClient) Delete(ctx context.Context, in *waf.DeleteWafProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return waf.NewWafProfileServiceClient(conn).Delete(ctx, in, opts...)
}

// Get implements waf.WafProfileServiceClient
func (c *WafProfileServiceClient) Get(ctx context.Context, in *waf.GetWafProfileRequest, opts ...grpc.CallOption) (*waf.WafProfile, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return waf.NewWafProfileServiceClient(conn).Get(ctx, in, opts...)
}

// List implements waf.WafProfileServiceClient
func (c *WafProfileServiceClient) List(ctx context.Context, in *waf.ListWafProfilesRequest, opts ...grpc.CallOption) (*waf.ListWafProfilesResponse, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return waf.NewWafProfileServiceClient(conn).List(ctx, in, opts...)
}

type WafProfileIterator struct {
	ctx  context.Context
	opts []grpc.CallOption

	err           error
	started       bool
	requestedSize int64
	pageSize      int64

	client  *WafProfileServiceClient
	request *waf.ListWafProfilesRequest

	items []*waf.WafProfile
}

func (c *WafProfileServiceClient) WafProfileIterator(ctx context.Context, req *waf.ListWafProfilesRequest, opts ...grpc.CallOption) *WafProfileIterator {
	var pageSize int64
	const defaultPageSize = 1000

	if pageSize == 0 {
		pageSize = defaultPageSize
	}
	return &WafProfileIterator{
		ctx:      ctx,
		opts:     opts,
		client:   c,
		request:  req,
		pageSize: pageSize,
	}
}

func (it *WafProfileIterator) Next() bool {
	if it.err != nil {
		return false
	}
	if len(it.items) > 1 {
		it.items[0] = nil
		it.items = it.items[1:]
		return true
	}
	it.items = nil // consume last item, if any

	if it.started {
		return false
	}
	it.started = true

	response, err := it.client.List(it.ctx, it.request, it.opts...)
	it.err = err
	if err != nil {
		return false
	}

	it.items = response.WafProfiles
	return len(it.items) > 0
}

func (it *WafProfileIterator) Take(size int64) ([]*waf.WafProfile, error) {
	if it.err != nil {
		return nil, it.err
	}

	if size == 0 {
		size = 1 << 32 // something insanely large
	}
	it.requestedSize = size
	defer func() {
		// reset iterator for future calls.
		it.requestedSize = 0
	}()

	var result []*waf.WafProfile

	for it.requestedSize > 0 && it.Next() {
		it.requestedSize--
		result = append(result, it.Value())
	}

	if it.err != nil {
		return nil, it.err
	}

	return result, nil
}

func (it *WafProfileIterator) TakeAll() ([]*waf.WafProfile, error) {
	return it.Take(0)
}

func (it *WafProfileIterator) Value() *waf.WafProfile {
	if len(it.items) == 0 {
		panic("calling Value on empty iterator")
	}
	return it.items[0]
}

func (it *WafProfileIterator) Error() error {
	return it.err
}

// Update implements waf.WafProfileServiceClient
func (c *WafProfileServiceClient) Update(ctx context.Context, in *waf.UpdateWafProfileRequest, opts ...grpc.CallOption) (*operation.Operation, error) {
	conn, err := c.getConn(ctx)
	if err != nil {
		return nil, err
	}
	return waf.NewWafProfileServiceClient(conn).Update(ctx, in, opts...)
}
