# Release notes for Gluster 11.0

This is a major release that includes a range of features, code improvements and stability fixes as noted below.

A selection of the key features and changes are documented in this page.
A full list of bugs that have been addressed is included further below.

- [Announcements](#announcements)
- [Highlights](#highlights)
- [Bugs addressed in the release](#bugs-addressed)

## Announcements

1. Releases that receive maintenance updates post release 11 is 10
([reference](https://www.gluster.org/release-schedule/))
2. Release 11 will receive maintenance updates around the 15th of every three months, and the release 10 will recieve maintainance updates around 15th every six months. 




## Highlights
- Major performance impovement of ~36% with rmdir operations [#3685](https://github.com/gluster/glusterfs/issues/3685)
-  Extension of ZFS support for snapshots [#2855](https://github.com/gluster/glusterfs/pull/2855)
- Qouta implimentation based on namespace [#1750](https://github.com/gluster/glusterfs/pull/1750)
- Major cleanups and readdir/readdirp improvements [link1](https://github.com/gluster/glusterfs/issues/3023#issuecomment-1011924449) [link2](https://github.com/gluster/glusterfs/issues/3023#issuecomment-1011924449)


## Bugs addressed

Issues addressed since release-10 are listed below:

[#1831](https://github.com/gluster/glusterfs/issues/1831) virtual images in replicated volume are not healed
[#1459](https://github.com/gluster/glusterfs/issues/1459) gluster_shared_storage failed to automount on node reboot on rhel 8
[#1458](https://github.com/gluster/glusterfs/issues/1458) sharding: fanout mknod process into multi threads
[#1457](https://github.com/gluster/glusterfs/issues/1457) systemd unit files missing from Debian 8.1-1 package
[#1456](https://github.com/gluster/glusterfs/issues/1456) virtual images in replicated volume are not healed?
[#1455](https://github.com/gluster/glusterfs/issues/1455) docs.gluster.org is down
[#1454](https://github.com/gluster/glusterfs/issues/1454) Geo-replication gsyncd at 100% CPU
[#1453](https://github.com/gluster/glusterfs/issues/1453) Disperse shd heal activity should be observable
[#1452](https://github.com/gluster/glusterfs/issues/1452) all glusterfs-client crashed at the same time when running volume p
[#1451](https://github.com/gluster/glusterfs/issues/1451) Add details on ssl_setup_connection_params to help troubleshooting
[#1450](https://github.com/gluster/glusterfs/issues/1450) Please consider repackaging/providing dependency package (stubs) fo
[#145](https://github.com/gluster/glusterfs/issues/145)  Snapshot: improvements
[#1000](https://github.com/gluster/glusterfs/issues/1000) [bug:1193929] GlusterFS can be improved
[#1002](https://github.com/gluster/glusterfs/issues/1002) [bug:1679998] GlusterFS can be improved
[#1060](https://github.com/gluster/glusterfs/issues/1060) [bug:789278] Issues reported by Coverity static analysis tool
[#1686](https://github.com/gluster/glusterfs/issues/1686) mount-shared-storage.sh issue with systemd-automount
[#1757](https://github.com/gluster/glusterfs/issues/1757) RFE: improve namespace support in glusterfs
[#1774](https://github.com/gluster/glusterfs/issues/1774) RFE: simple-quota implementation
[#2123](https://github.com/gluster/glusterfs/issues/2123) Implement an I/O framework
[#2164](https://github.com/gluster/glusterfs/issues/2164) gf_proc_dump_call_stack() is not printing ctime correctly
[#2308](https://github.com/gluster/glusterfs/issues/2308) Developer sessions for glusterfs
[#2469](https://github.com/gluster/glusterfs/issues/2469) Python syntax error in syncdutils.py
[#2483](https://github.com/gluster/glusterfs/issues/2483) Place holder issue for fixing potential bugs in protocol/client/src
[#2491](https://github.com/gluster/glusterfs/issues/2491) Add s390x support to community CI
[#2664](https://github.com/gluster/glusterfs/issues/2664) Test suite produce uncompressed logs
[#2717](https://github.com/gluster/glusterfs/issues/2717) GlusterFS doesn't support O_PATH flag in open()
[#2735](https://github.com/gluster/glusterfs/issues/2735) Remove byte-order.h and use the normal byteorder functions
[#2793](https://github.com/gluster/glusterfs/issues/2793) cluster.rebal-throttle description doesn't seem to match the code
[#2832](https://github.com/gluster/glusterfs/issues/2832) selinux: make it possible to persist ganesha_use_fusefs from one up
[#2846](https://github.com/gluster/glusterfs/issues/2846) glusterd log filled with error messages.
[#2903](https://github.com/gluster/glusterfs/issues/2903) geo-rep restarts because of 'list' object has no attribute 'join' e
[#2910](https://github.com/gluster/glusterfs/issues/2910) glusterd: volume start doesn't fail with properly if the port range
[#2912](https://github.com/gluster/glusterfs/issues/2912) When glusterfs uses an untrusted domain name， it cannot update the
[#2913](https://github.com/gluster/glusterfs/issues/2913) gluster lib cannot be dlopened: /lib64/libtcmalloc.so.4: cannot all
[#2916](https://github.com/gluster/glusterfs/issues/2916) Replace SHA deprecated functions with newer ones
[#2936](https://github.com/gluster/glusterfs/issues/2936) Wrong value for `inodeSize` in Volume status xml output.
[#2939](https://github.com/gluster/glusterfs/issues/2939) Volume log commands 'filename' and 'locate' described in the man bu
[#2944](https://github.com/gluster/glusterfs/issues/2944) tests: valid ip to be used instead of localhost, 127.0.0.1 or loopb
[#2947](https://github.com/gluster/glusterfs/issues/2947) IO failure when shrinking distributed dispersed volume while perfor
[#2962](https://github.com/gluster/glusterfs/issues/2962) cli: volume create without disperse count fails with ip addresses
[#2963](https://github.com/gluster/glusterfs/issues/2963) Do not use an iobuf pool for the CLI
[#2964](https://github.com/gluster/glusterfs/issues/2964) Cleanup the stub pool
[#2967](https://github.com/gluster/glusterfs/issues/2967) Make relevant functions static
[#2971](https://github.com/gluster/glusterfs/issues/2971) core file from /tests/basic/fencing/afr-lock-heal-advanced.t
[#2973](https://github.com/gluster/glusterfs/issues/2973) Allocate socket ioq outside of the out_lock
[#2975](https://github.com/gluster/glusterfs/issues/2975) quick-read: remove unused 'sh-failed' dict_get() function
[#2986](https://github.com/gluster/glusterfs/issues/2986) AFR: reduce variable indirection
[#2989](https://github.com/gluster/glusterfs/issues/2989) GF_ASSERT_AND_GOTO_WITH_ERROR improvements
[#2997](https://github.com/gluster/glusterfs/issues/2997) HA status is in FAILOVER when configuring NFS ganesha with pacemake
[#2998](https://github.com/gluster/glusterfs/issues/2998) Remove old authentication schemes
[#3004](https://github.com/gluster/glusterfs/issues/3004) Use gf_strndup() instead of gf_strdup() when string length is known
[#3005](https://github.com/gluster/glusterfs/issues/3005) multiple files: improve gf_dirent_for_name() functionality
[#3012](https://github.com/gluster/glusterfs/issues/3012) Reduce the impact of Cloudsync on IO path
[#3054](https://github.com/gluster/glusterfs/issues/3054) Update the links in gluster test framework documentation
[#3066](https://github.com/gluster/glusterfs/issues/3066) Online upgrade - 9.x to 10.0
[#3071](https://github.com/gluster/glusterfs/issues/3071) Log spam with glusterfs 10.0
[#3076](https://github.com/gluster/glusterfs/issues/3076) __lease_ctx_set() is not checking correctly for the return code of
[#3103](https://github.com/gluster/glusterfs/issues/3103) glusterfs snapd crashes when snapshot is de-activated.
[#3130](https://github.com/gluster/glusterfs/issues/3130) Reduce the number of include statements and code
[#3137](https://github.com/gluster/glusterfs/issues/3137) Cleanup common include files
[#3166](https://github.com/gluster/glusterfs/issues/3166) bug: Incorrect Mac OS version assertion in configure.
[#3182](https://github.com/gluster/glusterfs/issues/3182) Some stale posix locks appear after a client disconnection
[#3187](https://github.com/gluster/glusterfs/issues/3187) Locks xlator leaks fd's in some cases
[#3191](https://github.com/gluster/glusterfs/issues/3191) dht: Fix double free issue in the cbk function dht_common_mark_mdsx
[#3194](https://github.com/gluster/glusterfs/issues/3194) Log message for RPC clients is misleading because it logs unsigned
[#3213](https://github.com/gluster/glusterfs/issues/3213) Configure geo rep SSH with AES128 encryption - to improve performan
[#3217](https://github.com/gluster/glusterfs/issues/3217) Disperse volume with more than 16 data bricks fails to mount
[#3228](https://github.com/gluster/glusterfs/issues/3228) event-epoll.c: table_idx will always be 0?
[#3229](https://github.com/gluster/glusterfs/issues/3229) handle 'option remote-port' properly in client protocol.
[#3232](https://github.com/gluster/glusterfs/issues/3232) The config for creating /var/run/gluster on boot is missing for glu
[#3234](https://github.com/gluster/glusterfs/issues/3234) SSL certificate wrong default path
[#3236](https://github.com/gluster/glusterfs/issues/3236) nfs: Optimize ctxcount value to reduce memory consumption for nfs-s
[#3240](https://github.com/gluster/glusterfs/issues/3240) dht_revalidate_cbk() needs to trigger directory heal with root perm
[#3248](https://github.com/gluster/glusterfs/issues/3248) fault in gluster command completion
[#3262](https://github.com/gluster/glusterfs/issues/3262) dht: Synchronize layout_(ref|unref) during layout_(get|set) in dht
[#3264](https://github.com/gluster/glusterfs/issues/3264) Posix private struct - reduce size
[#3288](https://github.com/gluster/glusterfs/issues/3288) GFID split brain resolution using favourite-child-policy leads to E
[#3294](https://github.com/gluster/glusterfs/issues/3294) Remove dht_nonblocking_inodelk() - it's not used
[#3304](https://github.com/gluster/glusterfs/issues/3304) CID 1476381: (OVERRUN) @ /rpc/rpc-lib/src/rpc-clnt.c: 249 in __save
[#3321](https://github.com/gluster/glusterfs/issues/3321) server: Optimize server_process_event_upcall code path during handl
[#3329](https://github.com/gluster/glusterfs/issues/3329) mounting with ipv6 hostname leads to failure
[#3334](https://github.com/gluster/glusterfs/issues/3334) Error messages and 20 seconds timeout when creating qcow2 file via
[#3347](https://github.com/gluster/glusterfs/issues/3347) Test Failure: tests/bitrot/bug-1207627-bitrot-scrub-status.t
[#3359](https://github.com/gluster/glusterfs/issues/3359) meta_lookup() and other small improvements to meta xlator
[#3373](https://github.com/gluster/glusterfs/issues/3373) DHT doesn't implement seek fop and causes failures
[#3375](https://github.com/gluster/glusterfs/issues/3375) glusterd: After node reboot not able to start all bricks successful
[#3382](https://github.com/gluster/glusterfs/issues/3382) Dictionary: remove all hash related code
[#3394](https://github.com/gluster/glusterfs/issues/3394) autoupdate - Update a configure.ac to a newer Autoconf
[#3417](https://github.com/gluster/glusterfs/issues/3417) Crash due to unaligned memory access
[#3426](https://github.com/gluster/glusterfs/issues/3426) logging.c small improvements
[#3469](https://github.com/gluster/glusterfs/issues/3469) Improve regression testing
[#3470](https://github.com/gluster/glusterfs/issues/3470) Spurious crash when "peer probing" a non existing host name
[#3507](https://github.com/gluster/glusterfs/issues/3507) thin-arbiter-volume.t execute failed
[#3521](https://github.com/gluster/glusterfs/issues/3521) changelog: A brick process is getting crash due to SIGSEGV in chang
[#3527](https://github.com/gluster/glusterfs/issues/3527) Brick process crashed when global thread pool is enabled
[#3604](https://github.com/gluster/glusterfs/issues/3604) is_nfs_export_available check and mount_nfs commands fail in RHEL 8
[#3745](https://github.com/gluster/glusterfs/pull/3745)   protocol/server: fix the server_getspec to serve the volfiles
[#3636](https://github.com/gluster/glusterfs/issues/3636) posix: In small storage environment posix xlator does not respects
[#3647](https://github.com/gluster/glusterfs/issues/3647) wrong debug log in upcall_cache_invalidate()
[#3662](https://github.com/gluster/glusterfs/issues/3662) Some times Gluster Volume info XML returns wrong `distCount`
[#3683](https://github.com/gluster/glusterfs/issues/3683) dht: Cleanup linkto file by rebalance daemon while (hashed|cached)
[#3685](https://github.com/gluster/glusterfs/issues/3685) dht: Introduce rmdir-optimize option
[#3688](https://github.com/gluster/glusterfs/issues/3688) Infinite loop in dht when lookup fails with ENODATA
[#3695](https://github.com/gluster/glusterfs/issues/3695) test: ./tests/bugs/posix/bug-1651445.t is continuous failing during
[#3708](https://github.com/gluster/glusterfs/issues/3708) ./tests/basic/afr/afr-no-fsync.t is failing on FSYNCDIR, not on FSY
[#3710](https://github.com/gluster/glusterfs/issues/3710) Brick crashes automatically when writing small files
[#3717](https://github.com/gluster/glusterfs/issues/3717) syncop functions: no need to copy iatt structs if you are not going
[#3729](https://github.com/gluster/glusterfs/issues/3729) gf_svc_releasedir() logic error
[#3750](https://github.com/gluster/glusterfs/issues/3750) Bash completion is loaded every time bash starts
[#3774](https://github.com/gluster/glusterfs/issues/3774) Dead Lock In Brick Process
[#3778](https://github.com/gluster/glusterfs/issues/3778) test: Increase timeout for ./tests/basic/distribute/spare_file_reba
[#3781](https://github.com/gluster/glusterfs/issues/3781) Prime time client-only access control
[#3793](https://github.com/gluster/glusterfs/issues/3793) tests/bugs/replicate/bug-1586020-mark-dirty-for-entry-txn-on-quorum
[#3797](https://github.com/gluster/glusterfs/issues/3797) cdc xlator improvements
[#3823](https://github.com/gluster/glusterfs/issues/3823) rfc.sh: cannot detect upstream remote for non english locale
[#3831](https://github.com/gluster/glusterfs/issues/3831) afr: posix lock behavior is not correct while received an interrupt
[#3836](https://github.com/gluster/glusterfs/issues/3836) tests/bugs/glusterd/daemon-log-level-option.t fails on regression
[#3845](https://github.com/gluster/glusterfs/issues/3845) fuse_readdirp_cbk() - minor modifications
[#3847](https://github.com/gluster/glusterfs/issues/3847) gftest build failure
[#3855](https://github.com/gluster/glusterfs/issues/3855) reduce work for memory account
[#3876](https://github.com/gluster/glusterfs/issues/3876) `fsetxattr()` failed with `EBADFD` on opened directories
[#3891](https://github.com/gluster/glusterfs/issues/3891) Possible trash can size overflow
[#3922](https://github.com/gluster/glusterfs/pull/3922)   mem-pool: fix memory corruption in debug builds
[#3960](https://github.com/gluster/glusterfs/issues/3960) Mount command fails with syntax error on Debian
[#3963](https://github.com/gluster/glusterfs/issues/3963) Fix incorrect handling of xlator-option mount option
