// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{ffi, PageSetup, PrintSettings, PrintSetup, Window};
use glib::{
    prelude::*,
    signal::{connect_raw, SignalHandlerId},
    translate::*,
};
use std::{boxed::Box as Box_, pin::Pin};

glib::wrapper! {
    #[doc(alias = "GtkPrintDialog")]
    pub struct PrintDialog(Object<ffi::GtkPrintDialog, ffi::GtkPrintDialogClass>);

    match fn {
        type_ => || ffi::gtk_print_dialog_get_type(),
    }
}

impl PrintDialog {
    #[doc(alias = "gtk_print_dialog_new")]
    pub fn new() -> PrintDialog {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::gtk_print_dialog_new()) }
    }

    // rustdoc-stripper-ignore-next
    /// Creates a new builder-pattern struct instance to construct [`PrintDialog`] objects.
    ///
    /// This method returns an instance of [`PrintDialogBuilder`](crate::builders::PrintDialogBuilder) which can be used to create [`PrintDialog`] objects.
    pub fn builder() -> PrintDialogBuilder {
        PrintDialogBuilder::new()
    }

    #[doc(alias = "gtk_print_dialog_get_accept_label")]
    #[doc(alias = "get_accept_label")]
    #[doc(alias = "accept-label")]
    pub fn accept_label(&self) -> glib::GString {
        unsafe {
            from_glib_none(ffi::gtk_print_dialog_get_accept_label(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_dialog_get_modal")]
    #[doc(alias = "get_modal")]
    #[doc(alias = "modal")]
    pub fn is_modal(&self) -> bool {
        unsafe { from_glib(ffi::gtk_print_dialog_get_modal(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_dialog_get_page_setup")]
    #[doc(alias = "get_page_setup")]
    #[doc(alias = "page-setup")]
    pub fn page_setup(&self) -> Option<PageSetup> {
        unsafe { from_glib_none(ffi::gtk_print_dialog_get_page_setup(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_dialog_get_print_settings")]
    #[doc(alias = "get_print_settings")]
    #[doc(alias = "print-settings")]
    pub fn print_settings(&self) -> Option<PrintSettings> {
        unsafe {
            from_glib_none(ffi::gtk_print_dialog_get_print_settings(
                self.to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "gtk_print_dialog_get_title")]
    #[doc(alias = "get_title")]
    pub fn title(&self) -> glib::GString {
        unsafe { from_glib_none(ffi::gtk_print_dialog_get_title(self.to_glib_none().0)) }
    }

    #[doc(alias = "gtk_print_dialog_print")]
    pub fn print<P: FnOnce(Result<gio::OutputStream, glib::Error>) + 'static>(
        &self,
        parent: Option<&impl IsA<Window>>,
        setup: Option<&PrintSetup>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn print_trampoline<
            P: FnOnce(Result<gio::OutputStream, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gtk_print_dialog_print_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = print_trampoline::<P>;
        unsafe {
            ffi::gtk_print_dialog_print(
                self.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
                setup.to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn print_future(
        &self,
        parent: Option<&(impl IsA<Window> + Clone + 'static)>,
        setup: Option<&PrintSetup>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<gio::OutputStream, glib::Error>> + 'static>>
    {
        let parent = parent.map(ToOwned::to_owned);
        let setup = setup.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.print(
                parent.as_ref().map(::std::borrow::Borrow::borrow),
                setup.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "gtk_print_dialog_print_file")]
    pub fn print_file<P: FnOnce(Result<(), glib::Error>) + 'static>(
        &self,
        parent: Option<&impl IsA<Window>>,
        setup: Option<&PrintSetup>,
        file: &impl IsA<gio::File>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn print_file_trampoline<P: FnOnce(Result<(), glib::Error>) + 'static>(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let _ =
                ffi::gtk_print_dialog_print_file_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(())
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = print_file_trampoline::<P>;
        unsafe {
            ffi::gtk_print_dialog_print_file(
                self.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
                setup.to_glib_none().0,
                file.as_ref().to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn print_file_future(
        &self,
        parent: Option<&(impl IsA<Window> + Clone + 'static)>,
        setup: Option<&PrintSetup>,
        file: &(impl IsA<gio::File> + Clone + 'static),
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<(), glib::Error>> + 'static>> {
        let parent = parent.map(ToOwned::to_owned);
        let setup = setup.map(ToOwned::to_owned);
        let file = file.clone();
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.print_file(
                parent.as_ref().map(::std::borrow::Borrow::borrow),
                setup.as_ref().map(::std::borrow::Borrow::borrow),
                &file,
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[doc(alias = "gtk_print_dialog_set_accept_label")]
    #[doc(alias = "accept-label")]
    pub fn set_accept_label(&self, accept_label: &str) {
        unsafe {
            ffi::gtk_print_dialog_set_accept_label(
                self.to_glib_none().0,
                accept_label.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_dialog_set_modal")]
    #[doc(alias = "modal")]
    pub fn set_modal(&self, modal: bool) {
        unsafe {
            ffi::gtk_print_dialog_set_modal(self.to_glib_none().0, modal.into_glib());
        }
    }

    #[doc(alias = "gtk_print_dialog_set_page_setup")]
    #[doc(alias = "page-setup")]
    pub fn set_page_setup(&self, page_setup: &PageSetup) {
        unsafe {
            ffi::gtk_print_dialog_set_page_setup(
                self.to_glib_none().0,
                page_setup.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_dialog_set_print_settings")]
    #[doc(alias = "print-settings")]
    pub fn set_print_settings(&self, print_settings: &PrintSettings) {
        unsafe {
            ffi::gtk_print_dialog_set_print_settings(
                self.to_glib_none().0,
                print_settings.to_glib_none().0,
            );
        }
    }

    #[doc(alias = "gtk_print_dialog_set_title")]
    #[doc(alias = "title")]
    pub fn set_title(&self, title: &str) {
        unsafe {
            ffi::gtk_print_dialog_set_title(self.to_glib_none().0, title.to_glib_none().0);
        }
    }

    #[doc(alias = "gtk_print_dialog_setup")]
    pub fn setup<P: FnOnce(Result<PrintSetup, glib::Error>) + 'static>(
        &self,
        parent: Option<&impl IsA<Window>>,
        cancellable: Option<&impl IsA<gio::Cancellable>>,
        callback: P,
    ) {
        let main_context = glib::MainContext::ref_thread_default();
        let is_main_context_owner = main_context.is_owner();
        let has_acquired_main_context = (!is_main_context_owner)
            .then(|| main_context.acquire().ok())
            .flatten();
        assert!(
            is_main_context_owner || has_acquired_main_context.is_some(),
            "Async operations only allowed if the thread is owning the MainContext"
        );

        let user_data: Box_<glib::thread_guard::ThreadGuard<P>> =
            Box_::new(glib::thread_guard::ThreadGuard::new(callback));
        unsafe extern "C" fn setup_trampoline<
            P: FnOnce(Result<PrintSetup, glib::Error>) + 'static,
        >(
            _source_object: *mut glib::gobject_ffi::GObject,
            res: *mut gio::ffi::GAsyncResult,
            user_data: glib::ffi::gpointer,
        ) {
            let mut error = std::ptr::null_mut();
            let ret = ffi::gtk_print_dialog_setup_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() {
                Ok(from_glib_full(ret))
            } else {
                Err(from_glib_full(error))
            };
            let callback: Box_<glib::thread_guard::ThreadGuard<P>> =
                Box_::from_raw(user_data as *mut _);
            let callback: P = callback.into_inner();
            callback(result);
        }
        let callback = setup_trampoline::<P>;
        unsafe {
            ffi::gtk_print_dialog_setup(
                self.to_glib_none().0,
                parent.map(|p| p.as_ref()).to_glib_none().0,
                cancellable.map(|p| p.as_ref()).to_glib_none().0,
                Some(callback),
                Box_::into_raw(user_data) as *mut _,
            );
        }
    }

    pub fn setup_future(
        &self,
        parent: Option<&(impl IsA<Window> + Clone + 'static)>,
    ) -> Pin<Box_<dyn std::future::Future<Output = Result<PrintSetup, glib::Error>> + 'static>>
    {
        let parent = parent.map(ToOwned::to_owned);
        Box_::pin(gio::GioFuture::new(self, move |obj, cancellable, send| {
            obj.setup(
                parent.as_ref().map(::std::borrow::Borrow::borrow),
                Some(cancellable),
                move |res| {
                    send.resolve(res);
                },
            );
        }))
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "accept-label")]
    pub fn connect_accept_label_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_accept_label_trampoline<F: Fn(&PrintDialog) + 'static>(
            this: *mut ffi::GtkPrintDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::accept-label\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_accept_label_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "modal")]
    pub fn connect_modal_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_modal_trampoline<F: Fn(&PrintDialog) + 'static>(
            this: *mut ffi::GtkPrintDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::modal\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_modal_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "page-setup")]
    pub fn connect_page_setup_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_page_setup_trampoline<F: Fn(&PrintDialog) + 'static>(
            this: *mut ffi::GtkPrintDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::page-setup\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_page_setup_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "print-settings")]
    pub fn connect_print_settings_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_print_settings_trampoline<F: Fn(&PrintDialog) + 'static>(
            this: *mut ffi::GtkPrintDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::print-settings\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_print_settings_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    #[doc(alias = "title")]
    pub fn connect_title_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_title_trampoline<F: Fn(&PrintDialog) + 'static>(
            this: *mut ffi::GtkPrintDialog,
            _param_spec: glib::ffi::gpointer,
            f: glib::ffi::gpointer,
        ) {
            let f: &F = &*(f as *const F);
            f(&from_glib_borrow(this))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(
                self.as_ptr() as *mut _,
                b"notify::title\0".as_ptr() as *const _,
                Some(std::mem::transmute::<*const (), unsafe extern "C" fn()>(
                    notify_title_trampoline::<F> as *const (),
                )),
                Box_::into_raw(f),
            )
        }
    }
}

#[cfg(feature = "v4_14")]
#[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
impl Default for PrintDialog {
    fn default() -> Self {
        Self::new()
    }
}

// rustdoc-stripper-ignore-next
/// A [builder-pattern] type to construct [`PrintDialog`] objects.
///
/// [builder-pattern]: https://doc.rust-lang.org/1.0.0/style/ownership/builders.html
#[must_use = "The builder must be built to be used"]
pub struct PrintDialogBuilder {
    builder: glib::object::ObjectBuilder<'static, PrintDialog>,
}

impl PrintDialogBuilder {
    fn new() -> Self {
        Self {
            builder: glib::object::Object::builder(),
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    pub fn accept_label(self, accept_label: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("accept-label", accept_label.into()),
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    pub fn modal(self, modal: bool) -> Self {
        Self {
            builder: self.builder.property("modal", modal),
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    pub fn page_setup(self, page_setup: &PageSetup) -> Self {
        Self {
            builder: self.builder.property("page-setup", page_setup.clone()),
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    pub fn print_settings(self, print_settings: &PrintSettings) -> Self {
        Self {
            builder: self
                .builder
                .property("print-settings", print_settings.clone()),
        }
    }

    #[cfg(feature = "v4_14")]
    #[cfg_attr(docsrs, doc(cfg(feature = "v4_14")))]
    pub fn title(self, title: impl Into<glib::GString>) -> Self {
        Self {
            builder: self.builder.property("title", title.into()),
        }
    }

    // rustdoc-stripper-ignore-next
    /// Build the [`PrintDialog`].
    #[must_use = "Building the object from the builder is usually expensive and is not expected to have side effects"]
    pub fn build(self) -> PrintDialog {
        assert_initialized_main_thread!();
        self.builder.build()
    }
}
