<img src="https://root-forum.cern.ch/uploads/default/original/2X/3/3fb82b650635bc6d61461f3c47f41786afad4548.png" align="right"  height="50"/>

## About

ROOT is a unified software package for the storage, processing, and analysis of 
scientific data: from its acquisition to the final visualization in form of highly 
customizable, publication-ready plots. It is reliable, performant and well supported,
easy to use and obtain, and strives to maximize the quantity and impact of scientific 
results obtained per unit cost, both of human effort and computing resources.

ROOT provides a very efficient storage system for data models, 
that demonstrated to scale at the Large Hadron Collider experiments: Exabytes 
of scientific data are written in columnar ROOT format.
ROOT comes with histogramming capabilities in an arbitrary number of 
dimensions, curve fitting, statistical modelling, minimization, to allow
the easy setup of a data analysis system that can query and process the data
interactively or in batch mode, as well as a general parallel processing
framework, RDataFrame, that can considerably speed up an analysis, taking 
full advantage of multi-core and distributed systems.

ROOT is performance critical software written in C++ and enables rapid prototyping 
powered by a unique C++ compliant interpreter called Cling. 
Cling also enables performant C++ type introspection which is a building block of automatic 
interoperability with Python. Thanks to PyROOT, leveraging the cppyy technology, 
ROOT offers efficient, on-demand C++/Python interoperability in a uniform cross-language 
execution environment.

ROOT fully embraces open-source, it's made with passion by its community,
for the benefit of its community.

[![License: LGPL v2.1+](https://img.shields.io/badge/License-LGPL%20v2.1+-blue.svg)](https://www.gnu.org/licenses/lgpl.html)
[![CII Best Practices](https://bestpractices.coreinfrastructure.org/projects/5060/badge)](https://bestpractices.coreinfrastructure.org/projects/5060)

## Contribution Guidelines
- [How to contribute](https://github.com/root-project/root/blob/master/CONTRIBUTING.md)
- [Coding conventions](https://root.cern/coding-conventions)
- [Meetings](https://root.cern/meetings)

## Cite
When citing ROOT, please use both the reference reported below and the DOI specific to your ROOT version available [on Zenodo](https://zenodo.org/badge/latestdoi/10994345) [![DOI](https://zenodo.org/badge/10994345.svg)](https://zenodo.org/badge/latestdoi/10994345). For example, you can copy-paste and fill in the following citation:

    Rene Brun and Fons Rademakers, ROOT - An Object Oriented Data Analysis Framework,
    Proceedings AIHENP'96 Workshop, Lausanne, Sep. 1996,
    Nucl. Inst. & Meth. in Phys. Res. A 389 (1997) 81-86.
    See also "ROOT" [software], Release vX.YY/ZZ, dd/mm/yyyy

## Live Demo for CERN Users
[![](https://img.shields.io/badge/Launch-SWAN-orange)](http://cern.ch/swanserver/cgi-bin/go?projurl=https://github.com/cernphsft/rootbinder.git)

See more screenshots on our [gallery](https://root.cern/gallery).

## Installation and Getting Started
See https://root.cern/install for installation instructions.
For instructions on how to build ROOT from these source files, see https://root.cern/install/build_from_source.

Our ["Getting started with ROOT"](https://root.cern/learn) page is then the perfect place to get familiar with ROOT.

## Help and Support
- [Forum](https://root.cern/forum/)
- [Issue tracker](https://github.com/root-project/root/issues)
  * [Previous now read-only Jira issue tracker](https://sft.its.cern.ch/jira/projects/ROOT/issues/ROOT-5820?filter=allopenissues)
- [Documentation](https://root.cern/guides/reference-guide)
- [Tutorials](https://root.cern/doc/master/group__Tutorials.html)