/*
 * Decompiled with CFR 0.152.
 */
package jlibs.core.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import jlibs.core.lang.NotImplementedException;

public final class LongTreeMap<V> {
    private transient Entry<V> root;
    private transient int size;
    private static final boolean RED = false;
    private static final boolean BLACK = true;
    private Values values;

    private static boolean valEquals(Object o1, Object o2) {
        return o1 == null ? o2 == null : o1.equals(o2);
    }

    private static <V> boolean colorOf(Entry<V> p) {
        return p == null ? true : p.color;
    }

    private static <V> void setColor(Entry<V> p, boolean c) {
        if (p != null) {
            p.color = c;
        }
    }

    private static <V> Entry<V> leftOf(Entry<V> p) {
        return p == null ? null : p.left;
    }

    private static <V> Entry<V> rightOf(Entry<V> p) {
        return p == null ? null : p.right;
    }

    public Entry<V> firstEntry() {
        Entry<V> p = this.root;
        if (p != null) {
            Entry q = p.left;
            while (q != null) {
                p = q;
                q = q.left;
            }
        }
        return p;
    }

    public Entry<V> lastEntry() {
        Entry<V> p = this.root;
        if (p != null) {
            Entry q = p.right;
            while (q != null) {
                p = q;
                q = q.right;
            }
        }
        return p;
    }

    private Entry<V> rotateLeft(Entry<V> p) {
        Entry pParent;
        Entry r = p.right;
        Entry rLeft = r.left;
        p.right = rLeft;
        if (rLeft != null) {
            rLeft.parent = p;
        }
        r.parent = pParent = p.parent;
        if (pParent == null) {
            this.root = r;
        } else if (pParent.left == p) {
            pParent.left = r;
        } else {
            pParent.right = r;
        }
        r.left = p;
        p.parent = r;
        return p.parent;
    }

    private Entry<V> rotateRight(Entry<V> p) {
        Entry pParent;
        Entry l = p.left;
        Entry lRight = l.right;
        p.left = lRight;
        if (lRight != null) {
            lRight.parent = p;
        }
        l.parent = pParent = p.parent;
        if (pParent == null) {
            this.root = l;
        } else if (pParent.right == p) {
            pParent.right = l;
        } else {
            pParent.left = l;
        }
        l.right = p;
        p.parent = l;
        return p.parent;
    }

    private void fixAfterInsertion(Entry<V> x) {
        do {
            Entry ppxLeft;
            Entry px = x.parent;
            Entry ppx = px.parent;
            Entry entry = ppxLeft = ppx != null ? ppx.left : null;
            if (px == ppxLeft) {
                if (ppx.right != null && !ppx.right.color) {
                    px.color = true;
                    ppx.color = false;
                    ppx.right.color = true;
                    x = ppx;
                    continue;
                }
                if (x == px.right) {
                    x = px;
                    px = this.rotateLeft(x);
                }
                px.color = true;
                ppx.color = false;
                this.rotateRight(ppx);
                continue;
            }
            if (ppxLeft != null && !ppxLeft.color) {
                px.color = true;
                ppx.color = false;
                ppxLeft.color = true;
                x = ppx;
                continue;
            }
            if (x == px.left) {
                x = px;
                px = this.rotateRight(x);
            }
            px.color = true;
            if (ppx == null) continue;
            ppx.color = false;
            this.rotateLeft(ppx);
        } while (x != this.root && !x.parent.color);
        this.root.color = true;
    }

    private void fixAfterDeletion(Entry<V> x) {
        while (x != this.root && x.color) {
            boolean sibLeftColor;
            Entry sibRight;
            Entry sibLeft;
            Entry sib;
            Entry px = x.parent;
            Entry pxLeft = px.left;
            if (x == pxLeft) {
                boolean sibRightColor;
                sib = px.right;
                if (sib != null && !sib.color) {
                    sib.color = true;
                    px.color = false;
                    this.rotateLeft(px);
                    sib = LongTreeMap.rightOf(x.parent);
                }
                sibLeft = sib != null ? sib.left : null;
                sibRight = sib != null ? sib.right : null;
                boolean bl = sibRightColor = sibRight == null || sibRight.color;
                if (LongTreeMap.colorOf(sibLeft) && sibRightColor) {
                    LongTreeMap.setColor(sib, false);
                    x = x.parent;
                    continue;
                }
                if (sibRightColor) {
                    if (sib != null) {
                        LongTreeMap.setColor(sibLeft, true);
                        sib.color = false;
                        this.rotateRight(sib);
                    }
                    sib = LongTreeMap.rightOf(x.parent);
                }
                px = x.parent;
                if (sib != null) {
                    sib.color = LongTreeMap.colorOf(px);
                    LongTreeMap.setColor(sib.right, true);
                }
                if (px != null) {
                    px.color = true;
                    this.rotateLeft(px);
                }
                x = this.root;
                continue;
            }
            sib = pxLeft;
            if (sib != null && !sib.color) {
                sib.color = true;
                px.color = false;
                this.rotateRight(px);
                sib = LongTreeMap.leftOf(x.parent);
            }
            sibLeft = sib != null ? sib.left : null;
            sibRight = sib != null ? sib.right : null;
            boolean bl = sibLeftColor = sibLeft == null || sibLeft.color;
            if (LongTreeMap.colorOf(sibRight) && sibLeftColor) {
                LongTreeMap.setColor(sib, false);
                x = x.parent;
                continue;
            }
            if (sibLeftColor) {
                if (sib != null) {
                    LongTreeMap.setColor(sibRight, true);
                    sib.color = false;
                    this.rotateLeft(sib);
                }
                sib = LongTreeMap.leftOf(x.parent);
            }
            px = x.parent;
            if (sib != null) {
                sib.color = LongTreeMap.colorOf(px);
                LongTreeMap.setColor(sib.left, true);
            }
            if (px != null) {
                px.color = true;
                this.rotateRight(px);
            }
            x = this.root;
        }
        if (x != null) {
            x.color = true;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public V put(long key, V value) {
        boolean cmp;
        Entry<V> parent;
        assert (value != null);
        Entry<V> t = this.root;
        if (t == null) {
            this.root = new Entry<V>(key, value, null);
            this.root.color = true;
            this.size = 1;
            return null;
        }
        do {
            parent = t;
            long tkey = t.key;
            if (key < tkey) {
                t = t.left;
                cmp = true;
                continue;
            }
            if (key > tkey) {
                t = t.right;
                cmp = false;
                continue;
            }
            Object oldValue = t.value;
            t.value = value;
            return oldValue;
        } while (t != null);
        Entry<V> e = new Entry<V>(key, value, parent);
        if (cmp) {
            parent.left = e;
        } else {
            parent.right = e;
        }
        if (!parent.color) {
            this.fixAfterInsertion(e);
        }
        ++this.size;
        return null;
    }

    public void deleteEntry(Entry<V> p) {
        --this.size;
        if (p.left != null && p.right != null) {
            Entry<V> s = p.next();
            p.key = s.key;
            p.value = s.value;
            p = s;
        }
        Entry replacement = p.left != null ? p.left : p.right;
        Entry pp = p.parent;
        if (replacement != null) {
            replacement.parent = pp;
            if (pp == null) {
                this.root = replacement;
            } else if (p == pp.left) {
                pp.left = replacement;
            } else {
                pp.right = replacement;
            }
            p.parent = null;
            p.right = null;
            p.left = null;
            if (p.color) {
                this.fixAfterDeletion(replacement);
            }
        } else if (pp == null) {
            this.root = null;
        } else {
            if (p.color) {
                this.fixAfterDeletion(p);
            }
            if ((pp = p.parent) != null) {
                if (p == pp.left) {
                    pp.left = null;
                } else if (p == pp.right) {
                    pp.right = null;
                }
                p.parent = null;
            }
        }
    }

    public V remove(long key) {
        Entry<V> p = this.getEntry(key);
        if (p == null) {
            return null;
        }
        Object oldValue = p.value;
        this.deleteEntry(p);
        return oldValue;
    }

    public void clear() {
        this.size = 0;
        this.root = null;
    }

    public void putAll(LongTreeMap<? extends V> map) {
        Entry<V> q = null;
        Entry<V> p = map.root;
        while (true) {
            if (p != null) {
                q = p;
                p = p.left;
                continue;
            }
            if (q != null) {
                this.put(q.key, q.value);
                p = q.right;
            }
            while (q != null && p == null) {
                do {
                    p = q;
                } while ((q = p.parent) != null && q.right == p);
                if (q == null) continue;
                this.put(q.key, q.value);
                p = q.right;
            }
            if (q == null) break;
        }
    }

    public Entry<V> getEntry(long key) {
        Entry<V> p = this.root;
        while (p != null) {
            if (key < p.key) {
                p = p.left;
                continue;
            }
            if (key > p.key) {
                p = p.right;
                continue;
            }
            return p;
        }
        return null;
    }

    public V get(long key) {
        Entry<V> entry = this.getEntry(key);
        return entry != null ? (V)entry.value : null;
    }

    public Collection<V> values() {
        if (this.values == null) {
            this.values = new Values();
            return this.values;
        }
        return this.values;
    }

    public static void main(String[] args) {
        LongTreeMap<String> map = new LongTreeMap<String>();
        for (int i = 0; i < 10; ++i) {
            map.put(1L, "value");
        }
        map.put(5L, "five");
        map.put(3L, "three");
        map.put(9L, "nine");
        System.out.println(map.firstEntry());
        System.out.println(map.lastEntry());
        for (Entry entry = map.firstEntry(); entry != null; entry = entry.next()) {
            System.out.println(entry);
        }
    }

    class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public Iterator<V> iterator() {
            return new ValuesIterator(LongTreeMap.this.firstEntry());
        }

        @Override
        public int size() {
            return LongTreeMap.this.size;
        }

        @Override
        public boolean contains(Object value) {
            assert (value != null);
            Entry q = null;
            Entry p = LongTreeMap.this.root;
            while (true) {
                if (p != null) {
                    q = p;
                    p = p.left;
                    continue;
                }
                if (q != null) {
                    if (q.value.equals(value)) {
                        return true;
                    }
                    p = q.right;
                }
                while (q != null && p == null) {
                    do {
                        p = q;
                    } while ((q = p.parent) != null && q.right == p);
                    if (q == null) continue;
                    if (q.value.equals(value)) {
                        return true;
                    }
                    p = q.right;
                }
                if (q == null) break;
            }
            return false;
        }

        @Override
        public Object[] toArray() {
            Object[] array = new Object[LongTreeMap.this.size];
            int i = 0;
            Entry q = null;
            Entry p = LongTreeMap.this.root;
            while (true) {
                if (p != null) {
                    q = p;
                    p = p.left;
                    continue;
                }
                if (q != null) {
                    array[i++] = q.value;
                    p = q.right;
                }
                while (q != null && p == null) {
                    do {
                        p = q;
                    } while ((q = p.parent) != null && q.right == p);
                    if (q == null) continue;
                    array[i++] = q.value;
                    p = q.right;
                }
                if (q == null) break;
            }
            return array;
        }

        @Override
        public void clear() {
            LongTreeMap.this.clear();
        }
    }

    static final class ValuesIterator<V>
    implements Iterator<V> {
        Entry<V> next;

        ValuesIterator(Entry<V> firstEntry) {
            this.next = firstEntry;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public V next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Object value = this.next.value;
            this.next = this.next.next();
            return value;
        }

        @Override
        public void remove() {
            throw new NotImplementedException();
        }
    }

    public static final class Entry<V> {
        long key;
        public V value;
        Entry<V> left;
        Entry<V> right;
        Entry<V> parent;
        boolean color;

        Entry(long key, V value, Entry<V> parent) {
            this.key = key;
            this.value = value;
            this.parent = parent;
        }

        public long getKey() {
            return this.key;
        }

        public Entry<V> next() {
            if (this.right != null) {
                Entry<V> p = this.right;
                Entry<V> q = p.left;
                while (q != null) {
                    p = q;
                    q = q.left;
                }
                return p;
            }
            Entry<V> p = this.parent;
            Entry<V> ch = this;
            while (p != null && ch == p.right) {
                ch = p;
                p = p.parent;
            }
            return p;
        }

        public boolean equals(Object o) {
            if (o instanceof Entry) {
                Entry e = (Entry)o;
                return LongTreeMap.valEquals(this.key, e.key) && LongTreeMap.valEquals(this.value, e.value);
            }
            return false;
        }

        public int hashCode() {
            int keyHash = (int)(this.key ^ this.key >>> 32);
            int valueHash = this.value == null ? 0 : this.value.hashCode();
            return keyHash ^ valueHash;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

