/// Polyfill for `Option::unwrap()` as a const fn; feature `const_option`.
/// https://github.com/rust-lang/rust/issues/67441.
/// TODO(MSRV): Replace this with `x.unwrap()`.
///
/// `T: Copy` avoids "constant functions cannot evaluate destructors."
pub const fn unwrap_const<T>(x: Option<T>) -> T
where
    T: Copy,
{
    if let Some(x) = x {
        x
    } else {
        panic!("unwrap_const on `None`");
    }
}
