## RabbitMQ 3.7.10

RabbitMQ `3.7.10` is a maintenance release. It focuses on bug fixes and minor usability improvements.

### Compatibility Notes

`rabbitmq-plugins` in this release will produce an extra leading line of output, as they did in `3.6.x` releases,
when `-q` is not provided. Tools that parse `rabbitmq-plugins` output should use `-q --no-table-headers` to suppress
all output meant for interactive use.

### Erlang/OTP Compatibility Notes

This is the [**last release to support Erlang/OTP 19.3**](https://groups.google.com/d/msg/rabbitmq-users/G4UJ9zbIYHs/qCeyjkjyCQAJ). Users are highly encouraged to
upgrade to a more recent [supported Erlang version](https://www.rabbitmq.com/which-erlang.html).

#### Upgrading to Erlang 21.x

When upgrading to this release **and upgrading Erlang to 21.x** at the same time, extra care has to be taken.
Since CLI tools from RabbitMQ releases older than 3.7.7 will fail on Erlang 21, RabbitMQ **must be upgraded before Erlang**.

#### Documentation Guides and Change Log

See [3.7.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.0) upgrade and
compatibility notes if upgrading from an earlier release.

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.


## Changes

### Core Server

#### Bug Fixes

 * Channel stats emission performed some operations without a timeout, so listing channels or running
   a node health check could block and potentially cause temporary process accumulation on the node.

   GitHub issue: [rabbitmq/rabbitmq-server#1783](https://github.com/rabbitmq/rabbitmq-server/issues/1783)

 * Virtual host process memory usage was higher than necessary.

   GitHub issue: [rabbitmq/rabbitmq-server#1770](https://github.com/rabbitmq/rabbitmq-server/pull/1770)

 * Node could run into a failed assertion after a partial partition.

   GitHub issue: [rabbitmq/rabbitmq-server#1682](https://github.com/rabbitmq/rabbitmq-server/issues/1682)

 * Topic authorisation could fail with an exception if connection terminated (cleanly or abruptly) concurrently.

   GitHub issues: [rabbitmq/rabbitmq-common#290](https://github.com/rabbitmq/rabbitmq-common/pull/290), [rabbitmq/rabbitmq-server#1538](https://github.com/rabbitmq/rabbitmq-server/issues/1538)

 * Pointing `RABBITMQ_SERVER_CODE_PATH` at a HiPE-precompiled code directory didn't result in HiPE-compiled
   modules being loaded.

   GitHub issue: [rabbitmq/rabbitmq-server#1777](https://github.com/rabbitmq/rabbitmq-server/issues/1777)

#### Enhancements

 * `kernel.inet_dist_listen_min` and `kernel.inet_dist_listen_max` could not be configured via new style config.

   GitHub issue: [rabbitmq/rabbitmq-server#1784](https://github.com/rabbitmq/rabbitmq-server/issues/1784)


### CLI Tools

#### Bug Fixes

 * `rabbitmqctl list_consumers` only listed consumers on queues that had leader replica hosted on
    the target node. Instead consumers of all queues in the virtual host should have been listed.

   GitHub issue: [rabbitmq/rabbitmq-cli#284](https://github.com/rabbitmq/rabbitmq-cli/issues/284)

 * A combination of `RABBITMQ_NODENAME` and `RABBITMQ_USE_LONGNAME` now works the same way for CLI
   tools as prior to 3.7.0.

   GitHub issue: [rabbitmq/rabbitmq-cli#278](https://github.com/rabbitmq/rabbitmq-cli/issues/278)

 * New command: `rabbitmq-diagnostics tls_versions`, that lists TLS versions available in the runtime
   on the target nodes.

   GitHub issue: [rabbitmq/rabbitmq-cli#289](https://github.com/rabbitmq/rabbitmq-cli/pull/289)

 * `rabbitmqadmin declare user` now supports providing a password hash and algorithm instead of a password.

   Contributed by John W. Higgings.

   GitHub issue: [rabbitmq/rabbitmq-management#641](https://github.com/rabbitmq/rabbitmq-management/pull/641)

 * `-q` was hardcoded for `rabbitmq-plugins`

   GitHub issue: [rabbitmq/rabbitmq-server#1781](https://github.com/rabbitmq/rabbitmq-server/issues/1781)

#### Enhancements

 * `rabbitmqctl set_log_level` is a new command that changes effective log level of a node at runtime.

   GitHub issue: [rabbitmq/rabbitmq-cli#276](https://github.com/rabbitmq/rabbitmq-cli/issues/276)

 * `rabbitmq-diagnostics runtime_thread_stats` is a new command that outputs runtime thread state stats.

   GitHub issue: [rabbitmq/rabbitmq-cli#282](https://github.com/rabbitmq/rabbitmq-cli/pull/282)

 * `rabbitmq-plugins directories` is a new command that outputs effective [plugin directories](https://www.rabbitmq.com/plugins.html#plugin-directories).

   GitHub issue: [rabbitmq/rabbitmq-cli#261](https://github.com/rabbitmq/rabbitmq-cli/issues/261)

 * `--silent` is a new flag that combines `--quiet` and `--no-table-headers` (where applicable).

   GitHub issue: [rabbitmq/rabbitmq-cli#274](https://github.com/rabbitmq/rabbitmq-cli/issues/274)

 * Improved error messages for several common issues that can make `rabbitmq-plugins` commands fail.

   GitHub issue: [rabbitmq/rabbitmq-cli#283](https://github.com/rabbitmq/rabbitmq-cli/pull/283)


### Management and Management Agent Plugins

#### Bug Fixes

 * Exported definitions for an individual virtual host were missing [runtime parameters](https://www.rabbitmq.com/parameters.html).

   GitHub issue: [rabbitmq/rabbitmq-management#628](https://github.com/rabbitmq/rabbitmq-management/issues/628)

 * Filter inputs now escape incomplete HTML tags from their values. Previously they only stripped complete and valid tags.
   Note that the inputs are not populated from request parameters and have to be manually populated by the user.

   GitHub issue: [rabbitmq/rabbitmq-management#646](https://github.com/rabbitmq/rabbitmq-management/issues/646)

 * Exclusive queue owner connection now again can be navigated to using a link on the queue page.

   GitHub issue: [rabbitmq/rabbitmq-management#467](https://github.com/rabbitmq/rabbitmq-management/issues/467)

#### Enhancements

 * More TLS options, including cipher suites, now can be configured using new style config format.

   GitHub issue: [rabbitmq/rabbitmq-management#643](https://github.com/rabbitmq/rabbitmq-management/issues/643)

 * Metric chart ranges now only list options for which enough data is [retained](https://www.rabbitmq.com/management.html#sample-retention).

   GitHub issue: [rabbitmq/rabbitmq-management#635](https://github.com/rabbitmq/rabbitmq-management/issues/635)


### STOMP Plugin

#### Enhancements

 * TCP listener options now can be configured using new style configuration format.

   GitHub issue: [rabbitmq/rabbitmq-stomp#129](https://github.com/rabbitmq/rabbitmq-stomp/issues/129)


### Shovel Plugin

#### Bug Fixes

 * Backported several stability improvements for interaction with AMQP 1.0 endpoints from the 3.8 development
   branch (master).

   Changes: [one](https://github.com/rabbitmq/rabbitmq-amqp1.0-client/commit/8f0f7df34904abdee67e9764406837a5a7ecc091), [two](https://github.com/rabbitmq/rabbitmq-amqp1.0-common/commit/43bf4486fe6b993e5bc000056e78767889a23bbe)

 * Shovels now can be created with blank publish properties.

   GitHub issue: [rabbitmq/rabbitmq-shovel#46](https://github.com/rabbitmq/rabbitmq-shovel/issues/46)


### Consistent Hash Exchange Plugin

#### Bug Fixes

 * The plugin relied on a non-deterministic ordering behavior when bindings were removed (e.g. because a queue was
   deleted). This could lead to inconsistent hash ring state and affect routing behavior.

   GitHub issue: [rabbitmq/rabbitmq-consistent-hash-exchange#40](http://github.com/rabbitmq/rabbitmq-consistent-hash-exchange/issues/40)


### Web STOMP Plugin

#### Bug Fixes

 * When `web_mqtt.ssl.listener` is set, TLS certificate, key and other TLS settings were ignored.

   GitHub: [rabbitmq/rabbitmq-web-stomp#104](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/104)

#### Enhancements

 * [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol) support.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#84](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/84)

 * TCP (as in, non-TLS) listener now can be disabled.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#100](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/100)

 * More TLS options, including cipher suites, now can be configured using new style config format.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#101](https://github.com/rabbitmq/rabbitmq-web-stomp/pull/101)

 * Proxy protocol now can be enabled via new style config format.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#99](https://github.com/rabbitmq/rabbitmq-web-stomp/pull/99)

 * Resource-driven flow control support.

   GitHub issue: [rabbitmq/rabbitmq-web-stomp#40](https://github.com/rabbitmq/rabbitmq-web-stomp/issues/40)


### Web MQTT Plugin

#### Bug Fixes

 * When `web_mqtt.ssl.listener` is set, TLS certificate, key and other TLS settings were ignored.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#48](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/48)

 * Last Will message was not sent when connection that had it configured was closed cleanly.

   Contributed by Karen Mae Bajador.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#52](https://github.com/rabbitmq/rabbitmq-web-mqtt/pull/52)

#### Enhancements

 * [Proxy protocol](https://www.rabbitmq.com/networking.html#proxy-protocol) support.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#29](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/29)

 * TCP (as in, non-TLS) listener now can be disabled.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#31](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/31)

 * More TLS options, including cipher suites, now can be configured using new style config format.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#45](https://github.com/rabbitmq/rabbitmq-web-mqtt/pull/45)

 * Proxy protocol now can be enabled via new style config format.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#46](https://github.com/rabbitmq/rabbitmq-web-mqtt/issues/46)

 * Resource-driven flow control support.

   GitHub issue: [rabbitmq/rabbitmq-web-mqtt#40](https://github.com/rabbitmq/rabbitmq-web-mqtt/pull/40)

## Source code archives

**Warning**: The source code archive provided by GitHub only contains the source of the broker,
not the plugins or the client libraries. Please download the archive named `rabbitmq-3.7.10.tar.gz`.
