/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.id;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.OpenHAB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class InstanceUUID {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceUUID.class);
    static final String UUID_FILE_NAME = "uuid";
    static @Nullable String uuid;

    public static synchronized @Nullable String get() {
        if (uuid == null) {
            try {
                File file = new File(OpenHAB.getUserDataFolder() + File.separator + UUID_FILE_NAME);
                if (!file.exists()) {
                    uuid = InstanceUUID.generateToFile(file);
                } else {
                    String valueInFile = InstanceUUID.readFirstLine(file);
                    if (!valueInFile.isEmpty()) {
                        uuid = valueInFile;
                        LOGGER.debug("UUID '{}' has been restored from file '{}'", (Object)file.getAbsolutePath(), (Object)uuid);
                    } else {
                        uuid = InstanceUUID.generateToFile(file);
                        LOGGER.warn("UUID file '{}' has no content, rewriting it now with '{}'", (Object)file.getAbsolutePath(), (Object)uuid);
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed writing the UUID file: {}", (Object)e.getMessage());
                return null;
            }
        }
        return uuid;
    }

    private static String generateToFile(File file) throws IOException {
        File file2 = file.getParentFile();
        if (file2 instanceof File) {
            File parentFile = file2;
            parentFile.mkdirs();
        }
        String newUuid = UUID.randomUUID().toString();
        Files.writeString(file.toPath(), (CharSequence)newUuid, StandardCharsets.UTF_8, new OpenOption[0]);
        return newUuid;
    }

    private static String readFirstLine(File file) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (BufferedReader reader = Files.newBufferedReader(file.toPath(), StandardCharsets.UTF_8);){
                String line;
                String string = reader.readLine();
                String string2 = string instanceof String ? (line = string) : "";
                return string2;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Failed reading the UUID file '{}': {}", (Object)file.getAbsolutePath(), (Object)ioe.getMessage());
            return "";
        }
    }
}

