/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.utils.version.VersionTable;
import org.osgi.framework.Version;

public final class Macro {
    static final String MASK_STRING = "[\\-+=~0123456789]{0,3}[=~]?";
    static final Pattern RANGE_MASK = Pattern.compile("(\\[|\\()([\\-+=~0123456789]{0,3}[=~]?),([\\-+=~0123456789]{0,3}[=~]?)(\\]|\\))");

    private Macro() {
    }

    public static String transform(String macro, String value) {
        if (macro.startsWith("${") && macro.endsWith("}")) {
            String[] args = macro.substring(2, macro.length() - 1).split(";");
            switch (args[0]) {
                case "version": {
                    if (args.length != 2) {
                        throw new IllegalArgumentException("Invalid syntax for macro: " + macro);
                    }
                    return Macro.version(args[1], VersionTable.getVersion(value));
                }
                case "range": {
                    if (args.length != 2) {
                        throw new IllegalArgumentException("Invalid syntax for macro: " + macro);
                    }
                    return Macro.range(args[1], VersionTable.getVersion(value));
                }
            }
            throw new IllegalArgumentException("Unknown macro: " + macro);
        }
        return value;
    }

    static String version(String mask, Version version) {
        StringBuilder sb = new StringBuilder();
        String del = "";
        for (int i = 0; i < mask.length(); ++i) {
            char c = mask.charAt(i);
            String result = null;
            if (c == '~') continue;
            if (i > 3) {
                throw new IllegalArgumentException("Version mask can only specify 3 digits");
            }
            if (i == 3) {
                result = version.getQualifier();
                if (result.isEmpty()) {
                    result = null;
                }
            } else if (Character.isDigit(c)) {
                result = String.valueOf(c);
            } else {
                int x = 0;
                switch (i) {
                    case 0: {
                        x = version.getMajor();
                        break;
                    }
                    case 1: {
                        x = version.getMinor();
                        break;
                    }
                    case 2: {
                        x = version.getMicro();
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                switch (c) {
                    case '+': {
                        ++x;
                        break;
                    }
                    case '-': {
                        --x;
                        break;
                    }
                    case '=': {
                        break;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                result = Integer.toString(x);
            }
            if (result == null) continue;
            sb.append(del);
            del = ".";
            sb.append(result);
        }
        return sb.toString();
    }

    static String range(String spec, Version version) {
        Matcher m = RANGE_MASK.matcher(spec);
        m.matches();
        String floor = m.group(1);
        String floorMask = m.group(2);
        String ceilingMask = m.group(3);
        String ceiling = m.group(4);
        String left = Macro.version(floorMask, version);
        String right = Macro.version(ceilingMask, version);
        return floor + left + "," + right + ceiling;
    }
}

