/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Quantity;
import javax.measure.Unit;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.items.GroupFunction;
import org.openhab.core.items.Item;
import org.openhab.core.items.dto.GroupFunctionDTO;
import org.openhab.core.library.items.NumberItem;
import org.openhab.core.library.types.ArithmeticGroupFunction;
import org.openhab.core.library.types.DateTimeGroupFunction;
import org.openhab.core.library.types.QuantityTypeArithmeticGroupFunction;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.State;
import org.openhab.core.types.TypeParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class GroupFunctionHelper {
    private final Logger logger = LoggerFactory.getLogger(GroupFunctionHelper.class);

    public GroupFunction createGroupFunction(GroupFunctionDTO function, @Nullable Item baseItem) {
        NumberItem baseNumberItem;
        if (baseItem instanceof NumberItem && (baseNumberItem = (NumberItem)baseItem).getDimension() != null) {
            return this.createDimensionGroupFunction(function, baseNumberItem);
        }
        return this.createDefaultGroupFunction(function, baseItem);
    }

    private List<State> parseStates(@Nullable Item baseItem, String @Nullable [] params) {
        if (params == null || baseItem == null) {
            return List.of();
        }
        ArrayList<State> states = new ArrayList<State>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            State state = TypeParser.parseState(baseItem.getAcceptedDataTypes(), param);
            if (state == null) {
                this.logger.warn("State '{}' is not valid for a group item with base type '{}'", (Object)param, (Object)baseItem.getType());
                states.clear();
                break;
            }
            states.add(state);
            ++n2;
        }
        return states;
    }

    private GroupFunction createDimensionGroupFunction(GroupFunctionDTO function, NumberItem baseItem) {
        block19: {
            String functionName = function.name;
            Unit<? extends Quantity<?>> baseItemUnit = baseItem.getUnit();
            if (baseItemUnit == null) break block19;
            switch (functionName.toUpperCase()) {
                case "AVG": {
                    return new QuantityTypeArithmeticGroupFunction.Avg(baseItemUnit);
                }
                case "MEDIAN": {
                    return new QuantityTypeArithmeticGroupFunction.Median(baseItemUnit);
                }
                case "SUM": {
                    return new QuantityTypeArithmeticGroupFunction.Sum(baseItemUnit);
                }
                case "MIN": {
                    return new QuantityTypeArithmeticGroupFunction.Min(baseItemUnit);
                }
                case "MAX": {
                    return new QuantityTypeArithmeticGroupFunction.Max(baseItemUnit);
                }
            }
        }
        return this.createDefaultGroupFunction(function, baseItem);
    }

    private GroupFunction createDefaultGroupFunction(GroupFunctionDTO function, @Nullable Item baseItem) {
        String functionName = function.name;
        switch (functionName.toUpperCase()) {
            case "AND": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.And(args.getFirst(), args.get(1));
                }
                this.logger.error("Group function 'AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "OR": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.Or(args.getFirst(), args.get(1));
                }
                this.logger.error("Group function 'OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "NAND": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.NAnd(args.getFirst(), args.get(1));
                }
                this.logger.error("Group function 'NOT AND' requires two arguments. Using Equality instead.");
                break;
            }
            case "NOR": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.NOr(args.getFirst(), args.get(1));
                }
                this.logger.error("Group function 'NOT OR' requires two arguments. Using Equality instead.");
                break;
            }
            case "XOR": {
                List<State> args = this.parseStates(baseItem, function.params);
                if (args.size() == 2) {
                    return new ArithmeticGroupFunction.Xor(args.getFirst(), args.get(1));
                }
                this.logger.error("Group function 'XOR' requires two arguments. Using Equality instead.");
                break;
            }
            case "COUNT": {
                if (function.params != null && function.params.length == 1) {
                    StringType countParam = new StringType(function.params[0]);
                    return new ArithmeticGroupFunction.Count(countParam);
                }
                this.logger.error("Group function 'COUNT' requires one argument. Using Equality instead.");
                break;
            }
            case "AVG": {
                return new ArithmeticGroupFunction.Avg();
            }
            case "MEDIAN": {
                return new ArithmeticGroupFunction.Median();
            }
            case "SUM": {
                return new ArithmeticGroupFunction.Sum();
            }
            case "MIN": {
                return new ArithmeticGroupFunction.Min();
            }
            case "MAX": {
                return new ArithmeticGroupFunction.Max();
            }
            case "LATEST": {
                return new DateTimeGroupFunction.Latest();
            }
            case "EARLIEST": {
                return new DateTimeGroupFunction.Earliest();
            }
            case "EQUALITY": {
                return new GroupFunction.Equality();
            }
            default: {
                this.logger.error("Unknown group function '{}'. Using Equality instead.", (Object)functionName);
            }
        }
        return new GroupFunction.Equality();
    }
}

