/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script.providersupport.shared;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.module.script.providersupport.internal.ProviderRegistry;
import org.openhab.core.automation.module.script.providersupport.shared.ScriptedItemChannelLinkProvider;
import org.openhab.core.common.registry.Identifiable;
import org.openhab.core.common.registry.Registry;
import org.openhab.core.common.registry.RegistryChangeListener;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.link.AbstractLink;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkRegistry;

@NonNullByDefault
public class ProviderItemChannelLinkRegistry
implements Registry<ItemChannelLink, String>,
ProviderRegistry {
    private final ItemChannelLinkRegistry itemChannelLinkRegistry;
    private final Set<String> uids = new HashSet<String>();
    private final ScriptedItemChannelLinkProvider scriptedProvider;

    public ProviderItemChannelLinkRegistry(ItemChannelLinkRegistry itemChannelLinkRegistry, ScriptedItemChannelLinkProvider scriptedProvider) {
        this.itemChannelLinkRegistry = itemChannelLinkRegistry;
        this.scriptedProvider = scriptedProvider;
    }

    public void addRegistryChangeListener(RegistryChangeListener<ItemChannelLink> listener) {
        this.itemChannelLinkRegistry.addRegistryChangeListener(listener);
    }

    public Collection<ItemChannelLink> getAll() {
        return this.itemChannelLinkRegistry.getAll();
    }

    public Stream<ItemChannelLink> stream() {
        return this.itemChannelLinkRegistry.stream();
    }

    public @Nullable ItemChannelLink get(String key) {
        return (ItemChannelLink)this.itemChannelLinkRegistry.get((Object)key);
    }

    public void removeRegistryChangeListener(RegistryChangeListener<ItemChannelLink> listener) {
        this.itemChannelLinkRegistry.removeRegistryChangeListener(listener);
    }

    public ItemChannelLink add(ItemChannelLink element) {
        String uid = element.getUID();
        if (this.get(uid) != null) {
            throw new IllegalArgumentException("Cannot add item->channel link, because an item->channel link with same UID (" + uid + ") already exists.");
        }
        this.scriptedProvider.add(element);
        this.uids.add(uid);
        return element;
    }

    public ItemChannelLink addPermanent(ItemChannelLink element) {
        return (ItemChannelLink)this.itemChannelLinkRegistry.add((Identifiable)element);
    }

    public @Nullable ItemChannelLink update(ItemChannelLink element) {
        if (this.uids.contains(element.getUID())) {
            return this.scriptedProvider.update(element);
        }
        return (ItemChannelLink)this.itemChannelLinkRegistry.update((Identifiable)element);
    }

    public @Nullable ItemChannelLink remove(String key) {
        if (this.uids.contains(key)) {
            return this.scriptedProvider.remove(key);
        }
        return (ItemChannelLink)this.itemChannelLinkRegistry.remove((Object)key);
    }

    public int removeLinksForThing(ThingUID thingUID) {
        int removedLinks = 0;
        Collection<ItemChannelLink> itemChannelLinks = this.getAll();
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            if (!itemChannelLink.getLinkedUID().getThingUID().equals((Object)thingUID)) continue;
            this.remove(itemChannelLink.getUID());
            ++removedLinks;
        }
        return removedLinks;
    }

    public int removeLinksForItem(String itemName) {
        int removedLinks = 0;
        Collection<ItemChannelLink> itemChannelLinks = this.getAll();
        for (ItemChannelLink itemChannelLink : itemChannelLinks) {
            if (!itemChannelLink.getItemName().equals(itemName)) continue;
            this.remove(itemChannelLink.getUID());
            ++removedLinks;
        }
        return removedLinks;
    }

    public int purge() {
        List<String> toRemove = this.itemChannelLinkRegistry.getOrphanLinks().keySet().stream().map(AbstractLink::getUID).filter(i -> this.scriptedProvider.get((String)i) != null).toList();
        toRemove.forEach(this::remove);
        return toRemove.size() + this.itemChannelLinkRegistry.purge();
    }

    @Override
    public void removeAllAddedByScript() {
        for (String uid : this.uids) {
            this.scriptedProvider.remove(uid);
        }
        this.uids.clear();
    }
}

