/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.service.internal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.ops4j.pax.web.service.spi.config.Configuration;
import org.ops4j.pax.web.service.spi.model.events.WebElementEvent;
import org.ops4j.pax.web.service.spi.model.events.WebElementEventListener;
import org.ops4j.pax.web.service.spi.util.NamedThreadFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebElementEventDispatcher
implements WebElementEventListener,
ServiceTrackerCustomizer<WebElementEventListener, WebElementEventListener>,
BundleListener {
    private static final Logger LOG = LoggerFactory.getLogger(WebElementEventDispatcher.class);
    private final BundleContext bundleContext;
    private final ExecutorService executor;
    private final ServiceTracker<WebElementEventListener, WebElementEventListener> webElementListenerTracker;
    private final Set<WebElementEventListener> listeners = new CopyOnWriteArraySet<WebElementEventListener>();

    public WebElementEventDispatcher(BundleContext bundleContext, Configuration configuration) {
        this.bundleContext = bundleContext;
        this.executor = Executors.newFixedThreadPool(configuration.server().getEventDispatcherThreadCount(), (ThreadFactory)new NamedThreadFactory("events"));
        this.webElementListenerTracker = new ServiceTracker(bundleContext, WebElementEventListener.class.getName(), (ServiceTrackerCustomizer)this);
        this.webElementListenerTracker.open();
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    public void bundleChanged(BundleEvent event) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebElementEventListener addingService(ServiceReference<WebElementEventListener> reference) {
        WebElementEventListener listener = (WebElementEventListener)this.bundleContext.getService(reference);
        if (listener != null) {
            LOG.debug("New WebElementEventListener added: {}", (Object)listener.getClass().getName());
            Set<WebElementEventListener> set = this.listeners;
            synchronized (set) {
                this.listeners.add(listener);
            }
        }
        return listener;
    }

    public void modifiedService(ServiceReference<WebElementEventListener> reference, WebElementEventListener service) {
    }

    public void removedService(ServiceReference<WebElementEventListener> reference, WebElementEventListener service) {
        this.listeners.remove(service);
        this.bundleContext.ungetService(reference);
        LOG.debug("WebElementEventListener is removed: {}", (Object)service.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registrationEvent(WebElementEvent event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sending web element event " + event + " for bundle " + event.getBundleName());
        }
        Set<WebElementEventListener> set = this.listeners;
        synchronized (set) {
            this.callListeners(event);
        }
    }

    void destroy() {
        this.bundleContext.removeBundleListener((BundleListener)this);
        this.webElementListenerTracker.close();
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void callListeners(WebElementEvent event) {
        for (WebElementEventListener listener : this.listeners) {
            try {
                this.callListener(listener, event);
            }
            catch (RejectedExecutionException ree) {
                LOG.warn("Executor shut down", (Throwable)ree);
                break;
            }
        }
    }

    private void callListener(WebElementEventListener listener, WebElementEvent event) {
        try {
            this.executor.invokeAny(Collections.singleton(() -> {
                listener.registrationEvent(event);
                return null;
            }), 60L, TimeUnit.SECONDS);
        }
        catch (InterruptedException ie) {
            LOG.warn("Thread interrupted", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException te) {
            LOG.warn("Listener timed out, will be ignored", (Throwable)te);
            this.listeners.remove(listener);
        }
        catch (ExecutionException ee) {
            LOG.warn("Listener caused an exception, will be ignored", (Throwable)ee);
            this.listeners.remove(listener);
        }
    }
}

