/*
 * Decompiled with CFR 0.152.
 */
package jnr.constants.platform.solaris;

import java.util.EnumMap;
import java.util.Map;
import jnr.constants.Constant;

public enum InterfaceInfo implements Constant
{
    IFF_ALLMULTI(512L),
    IFF_BROADCAST(2L),
    IFF_DEBUG(4L),
    IFF_LOOPBACK(8L),
    IFF_MULTICAST(2048L),
    IFF_NOARP(128L),
    IFF_NOTRAILERS(32L),
    IFF_POINTOPOINT(16L),
    IFF_PROMISC(256L),
    IFF_RUNNING(64L),
    IFF_UP(1L),
    IFF_CANTCHANGE(60413060332378L);

    private final long value;
    public static final long MIN_VALUE = 1L;
    public static final long MAX_VALUE = 60413060332378L;

    private InterfaceInfo(long value2) {
        this.value = value2;
    }

    public final String toString() {
        return StringTable.descriptions.get(this);
    }

    public final int value() {
        return (int)this.value;
    }

    @Override
    public final int intValue() {
        return (int)this.value;
    }

    @Override
    public final long longValue() {
        return this.value;
    }

    @Override
    public final boolean defined() {
        return true;
    }

    static final class StringTable {
        public static final Map<InterfaceInfo, String> descriptions = StringTable.generateTable();

        StringTable() {
        }

        public static final Map<InterfaceInfo, String> generateTable() {
            EnumMap<InterfaceInfo, String> map2 = new EnumMap<InterfaceInfo, String>(InterfaceInfo.class);
            map2.put(IFF_ALLMULTI, "IFF_ALLMULTI");
            map2.put(IFF_BROADCAST, "IFF_BROADCAST");
            map2.put(IFF_DEBUG, "IFF_DEBUG");
            map2.put(IFF_LOOPBACK, "IFF_LOOPBACK");
            map2.put(IFF_MULTICAST, "IFF_MULTICAST");
            map2.put(IFF_NOARP, "IFF_NOARP");
            map2.put(IFF_NOTRAILERS, "IFF_NOTRAILERS");
            map2.put(IFF_POINTOPOINT, "IFF_POINTOPOINT");
            map2.put(IFF_PROMISC, "IFF_PROMISC");
            map2.put(IFF_RUNNING, "IFF_RUNNING");
            map2.put(IFF_UP, "IFF_UP");
            map2.put(IFF_CANTCHANGE, "IFF_CANTCHANGE");
            return map2;
        }
    }
}

