/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.converter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.util.converter.ConvertingImpl;
import org.osgi.util.converter.MapDelegate;

abstract class DynamicMapLikeFacade<K, V>
implements Map<K, V> {
    protected final ConvertingImpl convertingImpl;

    protected DynamicMapLikeFacade(ConvertingImpl convertingImpl) {
        this.convertingImpl = convertingImpl;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keySet().contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (!(value == null ? entry.getValue() == null : value.equals(entry.getValue()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> res = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            res.add(entry.getValue());
        }
        return res;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set ks = this.keySet();
        LinkedHashSet<Map.Entry<K, V>> res = new LinkedHashSet<Map.Entry<K, V>>(ks.size());
        for (Object k : ks) {
            Object v = this.get(k);
            res.add(new MapDelegate.MapEntry(k, v));
        }
        return res;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        boolean first = true;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            sb.append(entry.getKey());
            sb.append('=');
            sb.append(entry.getValue());
        }
        sb.append('}');
        return sb.toString();
    }
}

