/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import gnu.io.rfc2217.AbstractComPortCommandSwitch;
import gnu.io.rfc2217.BaudRateCommand;
import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortOptionHandler;
import gnu.io.rfc2217.ControlCommand;
import gnu.io.rfc2217.DataSizeCommand;
import gnu.io.rfc2217.LineStateMaskCommand;
import gnu.io.rfc2217.ModemStateMaskCommand;
import gnu.io.rfc2217.NotifyLineStateCommand;
import gnu.io.rfc2217.NotifyModemStateCommand;
import gnu.io.rfc2217.ParityCommand;
import gnu.io.rfc2217.SignatureCommand;
import gnu.io.rfc2217.StopSizeCommand;
import gnu.io.rfc2217.TransmitBinaryOptionHandler;
import gnu.io.rfc2217.Version;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.TooManyListenersException;
import org.apache.commons.net.telnet.EchoOptionHandler;
import org.apache.commons.net.telnet.InvalidTelnetOptionException;
import org.apache.commons.net.telnet.SuppressGAOptionHandler;
import org.apache.commons.net.telnet.TelnetClient;
import org.apache.commons.net.telnet.TelnetInputListener;
import org.apache.commons.net.telnet.TelnetOptionHandler;
import org.apache.commons.net.telnet.TerminalTypeOptionHandler;

public class TelnetSerialPort
extends SerialPort {
    private static final int DEFAULT_BAUD_RATE = 9600;
    private static final String DEFAULT_TERMINAL_TYPE = "VT100";
    private static final int MODEMSTATE_ALWAYS_MONITOR = 240;
    private static final int LINESTATE_NEVER_MONITOR = 1;
    private final TelnetClient telnetClient;
    private String name;
    private String signature;
    private State state = State.INITIAL;
    private SerialPortEventListener listener;
    private int baudRate = 9600;
    private int dataSize = 8;
    private int flowControlInbound = 14;
    private int flowControlOutbound = 1;
    private int parity = 1;
    private int stopSize = 1;
    private boolean cd;
    private boolean cts;
    private boolean dsr;
    private boolean dtr;
    private boolean ri;
    private boolean rts;
    private int lineStateNotify;
    private int lineStateMask;
    private int lineStateLast;
    private int modemStateNotify;
    private int modemStateMask = 240;
    private int modemStateLast;

    public TelnetSerialPort() {
        this.name = this.getClass().getSimpleName();
        this.signature = "jvser v" + Version.JVSER_VERSION;
        this.telnetClient = this.createTelnetClient();
        this.telnetClient.registerInputListener(new TelnetInputListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void telnetInputAvailable() {
                boolean notify;
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    notify = (TelnetSerialPort.this.lineStateNotify & 1) != 0;
                }
                if (notify) {
                    TelnetSerialPort.this.sendEvent(1);
                }
            }
        });
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public TelnetClient getTelnetClient() {
        return this.telnetClient;
    }

    protected TelnetClient createTelnetClient() {
        TelnetClient tc = new TelnetClient(DEFAULT_TERMINAL_TYPE);
        tc.setReaderThread(true);
        try {
            tc.addOptionHandler((TelnetOptionHandler)new TerminalTypeOptionHandler(DEFAULT_TERMINAL_TYPE, false, false, true, false));
            tc.addOptionHandler((TelnetOptionHandler)new EchoOptionHandler(false, false, false, false));
            tc.addOptionHandler((TelnetOptionHandler)new SuppressGAOptionHandler(true, true, true, true));
            tc.addOptionHandler((TelnetOptionHandler)new TransmitBinaryOptionHandler(true, true, true, true));
            tc.addOptionHandler((TelnetOptionHandler)new ComPortOptionHandler(this));
        }
        catch (IOException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        catch (InvalidTelnetOptionException e) {
            throw new RuntimeException("unexpected exception", e);
        }
        return tc;
    }

    @Override
    public synchronized InputStream getInputStream() throws IOException {
        this.state.checkNotClosed();
        return this.telnetClient.getInputStream();
    }

    @Override
    public synchronized OutputStream getOutputStream() throws IOException {
        this.state.checkNotClosed();
        return this.telnetClient.getOutputStream();
    }

    @Override
    public synchronized void close() {
        if (this.state == State.CLOSED) {
            return;
        }
        this.state = State.CLOSED;
        try {
            this.telnetClient.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized int getBaudRate() {
        this.state.checkNotClosed();
        return this.baudRate;
    }

    @Override
    public synchronized int getDataBits() {
        this.state.checkNotClosed();
        switch (this.dataSize) {
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 7: {
                return 7;
            }
            case 8: {
                return 8;
            }
        }
        throw new RuntimeException("impossible case");
    }

    @Override
    public synchronized int getStopBits() {
        this.state.checkNotClosed();
        switch (this.stopSize) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        throw new RuntimeException("impossible case");
    }

    @Override
    public synchronized int getParity() {
        this.state.checkNotClosed();
        switch (this.parity) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: {
                return 3;
            }
            case 5: {
                return 4;
            }
        }
        throw new RuntimeException("impossible case");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendBreak(int millis) {
        CommandList commandList = new CommandList(2);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.state != State.ESTABLISHED) {
                return;
            }
            commandList.add(new ControlCommand(true, 5));
            commandList.add(new ControlCommand(true, 6));
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFlowControlMode(int flowControl) throws UnsupportedCommOperationException {
        if ((flowControl & 0xA) == 10 || (flowControl & 5) == 5) {
            throw new UnsupportedCommOperationException("invalid flow control value " + flowControl);
        }
        CommandList commandList = new CommandList(2);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            int previousFlowControlOutbound = this.flowControlOutbound;
            int previousFlowControlInbound = this.flowControlInbound;
            int n = (flowControl & 2) != 0 ? 3 : (this.flowControlOutbound = (flowControl & 8) != 0 ? 2 : 1);
            int n2 = (flowControl & 1) != 0 ? 16 : (this.flowControlInbound = (flowControl & 4) != 0 ? 15 : 14);
            if (this.flowControlOutbound != previousFlowControlOutbound && this.state.isEstablished()) {
                commandList.add(new ControlCommand(true, this.flowControlOutbound));
            }
            if (this.flowControlInbound != previousFlowControlInbound && this.state.isEstablished()) {
                commandList.add(new ControlCommand(true, this.flowControlInbound));
            }
        }
        commandList.send();
    }

    @Override
    public synchronized int getFlowControlMode() {
        this.state.checkNotClosed();
        int value = 0;
        switch (this.flowControlOutbound) {
            case 3: {
                value |= 2;
                break;
            }
            case 2: {
                value |= 8;
                break;
            }
        }
        switch (this.flowControlInbound) {
            case 16: {
                value |= 1;
                break;
            }
            case 15: {
                value |= 4;
                break;
            }
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSerialPortParams(int baudRate, int dataBits, int stopBits, int parity) throws UnsupportedCommOperationException {
        CommandList commandList = new CommandList(4);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (baudRate <= 0) {
                throw new UnsupportedCommOperationException("invalid baud rate " + baudRate);
            }
            switch (dataBits) {
                case 5: {
                    dataBits = 5;
                    break;
                }
                case 6: {
                    dataBits = 6;
                    break;
                }
                case 7: {
                    dataBits = 7;
                    break;
                }
                case 8: {
                    dataBits = 8;
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException("invalid data bits " + dataBits);
                }
            }
            switch (stopBits) {
                case 1: {
                    stopBits = 1;
                    break;
                }
                case 2: {
                    stopBits = 2;
                    break;
                }
                case 3: {
                    stopBits = 3;
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException("invalid stop bits " + stopBits);
                }
            }
            switch (parity) {
                case 0: {
                    parity = 1;
                    break;
                }
                case 1: {
                    parity = 2;
                    break;
                }
                case 2: {
                    parity = 3;
                    break;
                }
                case 3: {
                    parity = 4;
                    break;
                }
                case 4: {
                    parity = 5;
                    break;
                }
                default: {
                    throw new UnsupportedCommOperationException("invalid parity " + parity);
                }
            }
            boolean changed = false;
            if (this.baudRate != baudRate) {
                this.baudRate = baudRate;
                changed = true;
            }
            if (this.dataSize != dataBits) {
                this.dataSize = dataBits;
                changed = true;
            }
            if (this.stopSize != stopBits) {
                this.stopSize = stopBits;
                changed = true;
            }
            if (this.parity != parity) {
                this.parity = parity;
                changed = true;
            }
            if (changed && this.state.isEstablished()) {
                this.addSerialPortGeometry(commandList);
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDTR(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.dtr != value) {
                this.dtr = value;
                if (this.state.isEstablished()) {
                    commandList.add(new ControlCommand(true, this.dtr ? 8 : 9));
                }
            }
        }
        commandList.send();
    }

    @Override
    public synchronized boolean isDTR() {
        this.state.checkNotClosed();
        return this.dtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRTS(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.rts != value) {
                this.rts = value;
                if (this.state.isEstablished()) {
                    commandList.add(new ControlCommand(true, this.rts ? 11 : 12));
                }
            }
        }
        commandList.send();
    }

    @Override
    public synchronized boolean isRTS() {
        this.state.checkNotClosed();
        return this.rts;
    }

    @Override
    public synchronized boolean isCTS() {
        this.state.checkNotClosed();
        return this.cts;
    }

    @Override
    public synchronized boolean isDSR() {
        this.state.checkNotClosed();
        return this.dsr;
    }

    @Override
    public synchronized boolean isRI() {
        this.state.checkNotClosed();
        return this.ri;
    }

    @Override
    public synchronized boolean isCD() {
        this.state.checkNotClosed();
        return this.cd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startSubnegotiation() {
        CommandList commandList = new CommandList(12);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            this.state = State.ESTABLISHED;
            commandList.add(new SignatureCommand(true));
            if (this.signature != null && this.signature.length() > 0) {
                commandList.add(new SignatureCommand(true, this.signature));
            }
            this.addSerialPortGeometry(commandList);
            commandList.add(new LineStateMaskCommand(true, this.lineStateMask));
            commandList.add(new ModemStateMaskCommand(true, this.modemStateMask));
            commandList.add(new ControlCommand(true, this.flowControlInbound));
            commandList.add(new ControlCommand(true, this.flowControlOutbound));
            commandList.add(new ControlCommand(true, this.dtr ? 8 : 9));
            commandList.add(new ControlCommand(true, this.rts ? 11 : 12));
        }
        commandList.send();
    }

    private void addSerialPortGeometry(CommandList commandList) {
        commandList.add(new BaudRateCommand(true, this.baudRate));
        commandList.add(new DataSizeCommand(true, this.dataSize));
        commandList.add(new ParityCommand(true, this.parity));
        commandList.add(new StopSizeCommand(true, this.stopSize));
    }

    void handleCommand(ComPortCommand command) {
        if (!command.isServerCommand()) {
            return;
        }
        command.visit(new AbstractComPortCommandSwitch(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseBaudRate(BaudRateCommand command) {
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    TelnetSerialPort.this.baudRate = command.getBaudRate();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseDataSize(DataSizeCommand command) {
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    TelnetSerialPort.this.dataSize = command.getDataSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseParity(ParityCommand command) {
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    TelnetSerialPort.this.parity = command.getParity();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseStopSize(StopSizeCommand command) {
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    TelnetSerialPort.this.stopSize = command.getStopSize();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseControl(ControlCommand command) {
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    switch (command.getControl()) {
                        case 1: 
                        case 2: 
                        case 3: {
                            TelnetSerialPort.this.flowControlOutbound = command.getControl();
                            break;
                        }
                        case 14: 
                        case 15: 
                        case 16: {
                            TelnetSerialPort.this.flowControlInbound = command.getControl();
                            break;
                        }
                        case 8: {
                            TelnetSerialPort.this.dtr = true;
                            break;
                        }
                        case 9: {
                            TelnetSerialPort.this.dtr = false;
                            break;
                        }
                        case 11: {
                            TelnetSerialPort.this.rts = true;
                            break;
                        }
                        case 12: {
                            TelnetSerialPort.this.rts = false;
                            break;
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseNotifyLineState(NotifyLineStateCommand command) {
                int notify;
                int lineState = command.getLineState();
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    notify = TelnetSerialPort.this.lineStateNotify;
                    TelnetSerialPort.this.lineStateLast = lineState;
                }
                if (((notify &= lineState) & 0x40) != 0) {
                    TelnetSerialPort.this.sendEvent(2);
                }
                if ((notify & 0x10) != 0) {
                    TelnetSerialPort.this.sendEvent(10);
                }
                if ((notify & 8) != 0) {
                    TelnetSerialPort.this.sendEvent(9);
                }
                if ((notify & 4) != 0) {
                    TelnetSerialPort.this.sendEvent(8);
                }
                if ((notify & 2) != 0) {
                    TelnetSerialPort.this.sendEvent(7);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void caseNotifyModemState(NotifyModemStateCommand command) {
                int notify;
                int modemState = command.getModemState();
                TelnetSerialPort telnetSerialPort = TelnetSerialPort.this;
                synchronized (telnetSerialPort) {
                    notify = TelnetSerialPort.this.modemStateNotify;
                    TelnetSerialPort.this.modemStateLast = modemState;
                }
                if (((notify &= modemState ^ TelnetSerialPort.this.modemStateLast) & 0x80) != 0) {
                    TelnetSerialPort.this.sendEvent(6, (modemState & 0x80) != 0);
                }
                if ((notify & 0x40) != 0) {
                    TelnetSerialPort.this.sendEvent(5, (modemState & 0x40) != 0);
                }
                if ((notify & 0x20) != 0) {
                    TelnetSerialPort.this.sendEvent(4, (modemState & 0x20) != 0);
                }
                if ((notify & 0x10) != 0) {
                    TelnetSerialPort.this.sendEvent(3, (modemState & 0x10) != 0);
                }
            }

            @Override
            protected void caseDefault(ComPortCommand command) {
            }
        });
    }

    @Override
    public synchronized void addEventListener(SerialPortEventListener listener) throws TooManyListenersException {
        this.state.checkNotClosed();
        if (this.listener != null) {
            throw new TooManyListenersException("only one listener allowed");
        }
        this.listener = listener;
    }

    @Override
    public synchronized void removeEventListener() {
        this.listener = null;
    }

    @Override
    public synchronized void notifyOnDataAvailable(boolean value) {
        this.state.checkNotClosed();
        this.updateLineStateMask(1, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnOutputEmpty(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateLineStateMask(64, value) && this.state.isEstablished()) {
                commandList.add(new LineStateMaskCommand(true, this.lineStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnCTS(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateModemStateMask(16, value) && this.state.isEstablished()) {
                commandList.add(new ModemStateMaskCommand(true, this.modemStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnDSR(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateModemStateMask(32, value) && this.state.isEstablished()) {
                commandList.add(new ModemStateMaskCommand(true, this.modemStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnRingIndicator(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateModemStateMask(64, value) && this.state.isEstablished()) {
                commandList.add(new ModemStateMaskCommand(true, this.modemStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnCarrierDetect(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateModemStateMask(128, value) && this.state.isEstablished()) {
                commandList.add(new ModemStateMaskCommand(true, this.modemStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnOverrunError(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateLineStateMask(2, value) && this.state.isEstablished()) {
                commandList.add(new LineStateMaskCommand(true, this.lineStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnParityError(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateLineStateMask(4, value) && this.state.isEstablished()) {
                commandList.add(new LineStateMaskCommand(true, this.lineStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnFramingError(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateLineStateMask(8, value) && this.state.isEstablished()) {
                commandList.add(new LineStateMaskCommand(true, this.lineStateMask));
            }
        }
        commandList.send();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyOnBreakInterrupt(boolean value) {
        CommandList commandList = new CommandList(1);
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            this.state.checkNotClosed();
            if (this.updateLineStateMask(16, value) && this.state.isEstablished()) {
                commandList.add(new LineStateMaskCommand(true, this.lineStateMask));
            }
        }
        commandList.send();
    }

    private void sendEvent(int type) {
        this.sendEvent(type, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendEvent(int type, boolean newValue) {
        SerialPortEventListener currentListener;
        TelnetSerialPort telnetSerialPort = this;
        synchronized (telnetSerialPort) {
            currentListener = this.listener;
        }
        if (currentListener == null) {
            return;
        }
        SerialPortEvent event = new SerialPortEvent(this, type, !newValue, newValue);
        try {
            currentListener.serialEvent(event);
        }
        catch (Exception e) {
            System.err.println(this.name + ": exception from listener " + this.listener + ": " + e.getMessage());
        }
    }

    private void sendSubnegotiation(ComPortCommand command) {
        assert (!Thread.holdsLock(this));
        try {
            this.telnetClient.sendSubnegotiation(command.getBytes());
        }
        catch (IOException e) {
            System.err.println(this.name + ": exception sending subcommand: " + e.getMessage());
        }
    }

    private synchronized boolean updateLineStateMask(int bit, boolean value) {
        int previous = this.lineStateMask;
        if (value) {
            this.lineStateNotify |= bit;
            this.lineStateMask |= bit;
        } else {
            this.lineStateNotify &= ~bit;
            this.lineStateMask &= ~bit;
        }
        this.lineStateMask &= 0xFFFFFFFE;
        return this.lineStateMask != previous;
    }

    private synchronized boolean updateModemStateMask(int bit, boolean value) {
        int previous = this.modemStateMask;
        if (value) {
            this.modemStateNotify |= bit;
            this.modemStateMask |= bit;
        } else {
            this.modemStateNotify &= ~bit;
            this.modemStateMask &= ~bit;
        }
        this.modemStateMask |= 0xF0;
        return this.modemStateMask != previous;
    }

    @Override
    public synchronized void enableReceiveThreshold(int threshold) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public synchronized void disableReceiveThreshold() {
        this.state.checkNotClosed();
    }

    @Override
    public synchronized boolean isReceiveThresholdEnabled() {
        this.state.checkNotClosed();
        return false;
    }

    @Override
    public synchronized int getReceiveThreshold() {
        this.state.checkNotClosed();
        return 0;
    }

    @Override
    public synchronized void enableReceiveTimeout(int timeout) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public synchronized void disableReceiveTimeout() {
        this.state.checkNotClosed();
    }

    @Override
    public synchronized boolean isReceiveTimeoutEnabled() {
        this.state.checkNotClosed();
        return false;
    }

    @Override
    public synchronized int getReceiveTimeout() {
        this.state.checkNotClosed();
        return 0;
    }

    @Override
    public synchronized void enableReceiveFraming(int framingByte) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public synchronized void disableReceiveFraming() {
        this.state.checkNotClosed();
    }

    @Override
    public synchronized boolean isReceiveFramingEnabled() {
        this.state.checkNotClosed();
        return false;
    }

    @Override
    public synchronized int getReceiveFramingByte() {
        this.state.checkNotClosed();
        return 0;
    }

    @Override
    public synchronized void setInputBufferSize(int size) {
        this.state.checkNotClosed();
    }

    @Override
    public synchronized int getInputBufferSize() {
        this.state.checkNotClosed();
        return 0;
    }

    @Override
    public synchronized void setOutputBufferSize(int size) {
        this.state.checkNotClosed();
    }

    @Override
    public synchronized int getOutputBufferSize() {
        this.state.checkNotClosed();
        return 0;
    }

    @Override
    public int getBaudBase() throws UnsupportedCommOperationException, IOException {
        this.state.checkNotClosed();
        return this.baudRate;
    }

    @Override
    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public int getDivisor() throws UnsupportedCommOperationException, IOException {
        this.state.checkNotClosed();
        return 1;
    }

    @Override
    public byte getEndOfInputChar() throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        return 4;
    }

    @Override
    public boolean getLowLatency() throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public byte getParityErrorChar() throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public String getUARTType() throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public boolean setBaudBase(int arg0) throws UnsupportedCommOperationException, IOException {
        this.state.checkNotClosed();
        return true;
    }

    @Override
    public boolean setCallOutHangup(boolean arg0) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public boolean setDivisor(int arg0) throws UnsupportedCommOperationException, IOException {
        this.state.checkNotClosed();
        return true;
    }

    @Override
    public boolean setEndOfInputChar(byte arg0) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        return true;
    }

    @Override
    public boolean setLowLatency() throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public boolean setParityErrorChar(byte arg0) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    @Override
    public boolean setUARTType(String arg0, boolean arg1) throws UnsupportedCommOperationException {
        this.state.checkNotClosed();
        throw new UnsupportedCommOperationException();
    }

    private class CommandList
    extends ArrayList<ComPortCommand> {
        public CommandList(int size) {
            super(size);
        }

        public void send() {
            for (ComPortCommand command : this) {
                TelnetSerialPort.this.sendSubnegotiation(command);
            }
            this.clear();
        }
    }

    private static enum State {
        INITIAL(false, false),
        ESTABLISHED(true, false),
        CLOSED(false, true);

        private final boolean established;
        private final boolean closed;

        private State(boolean established, boolean closed) {
            this.established = established;
            this.closed = closed;
        }

        public void checkNotClosed() {
            if (this.closed) {
                throw new IllegalStateException("port is closed");
            }
        }

        public boolean isEstablished() {
            return this.established;
        }
    }
}

