/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.library.types;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.library.types.StringType;
import org.openhab.core.types.Command;
import org.openhab.core.types.State;

@NonNullByDefault
public class StringListType
implements Command,
State {
    protected final List<String> typeDetails;
    public static final String DELIMITER = ",";
    public static final String ESCAPED_DELIMITER = "\\,";
    public static final String REGEX_SPLITTER = "(?<!\\\\),";

    public StringListType() {
        this.typeDetails = List.of();
    }

    public StringListType(List<String> rows) {
        this.typeDetails = List.copyOf(rows);
    }

    public StringListType(StringType ... rows) {
        this.typeDetails = Arrays.stream(rows).map(StringType::toString).toList();
    }

    public StringListType(String ... rows) {
        this.typeDetails = List.of(rows);
    }

    public StringListType(String serialized) {
        this.typeDetails = Arrays.stream(serialized.split(REGEX_SPLITTER, -1)).map(s -> s.replace(ESCAPED_DELIMITER, DELIMITER)).toList();
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.typeDetails.size()) {
            throw new IllegalArgumentException("Index is out of range");
        }
        return this.typeDetails.get(index);
    }

    @Override
    public String format(String pattern) {
        return String.format(pattern, this.typeDetails.toArray());
    }

    public String toString() {
        return this.toFullString();
    }

    @Override
    public String toFullString() {
        return this.typeDetails.stream().map(s -> s.replace(DELIMITER, ESCAPED_DELIMITER)).collect(Collectors.joining(DELIMITER));
    }

    public static StringListType valueOf(String value) {
        return new StringListType(value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.typeDetails.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StringListType other = (StringListType)obj;
        return this.typeDetails.equals(other.typeDetails);
    }
}

