//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlpathstyle?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLPathStyle(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFURLPathStyle {
    #[doc(alias = "kCFURLPOSIXPathStyle")]
    pub const CFURLPOSIXPathStyle: Self = Self(0);
    #[deprecated = "Carbon File Manager is deprecated, use kCFURLPOSIXPathStyle where possible"]
    #[doc(alias = "kCFURLHFSPathStyle")]
    pub const CFURLHFSPathStyle: Self = Self(1);
    #[doc(alias = "kCFURLWindowsPathStyle")]
    pub const CFURLWindowsPathStyle: Self = Self(2);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFURLPathStyle {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFURLPathStyle {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurl?language=objc)
#[repr(C)]
pub struct CFURL {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    #[encoding_name = "__CFURL"]
    unsafe impl CFURL {}
);

#[cfg(feature = "CFBase")]
unsafe impl ConcreteType for CFURL {
    #[doc(alias = "CFURLGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFURLGetTypeID() -> CFTypeID;
        }
        unsafe { CFURLGetTypeID() }
    }
}

#[cfg(all(feature = "CFBase", feature = "CFString"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateWithBytes(
    allocator: Option<&CFAllocator>,
    url_bytes: *const u8,
    length: CFIndex,
    encoding: CFStringEncoding,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithBytes(
            allocator: Option<&CFAllocator>,
            url_bytes: *const u8,
            length: CFIndex,
            encoding: CFStringEncoding,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateWithBytes(allocator, url_bytes, length, encoding, base_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFData", feature = "CFString"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateData(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    encoding: CFStringEncoding,
    escape_whitespace: bool,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateData(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            encoding: CFStringEncoding,
            escape_whitespace: Boolean,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFURLCreateData(allocator, url, encoding, escape_whitespace as _) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateWithString(
    allocator: Option<&CFAllocator>,
    url_string: Option<&CFString>,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithString(
            allocator: Option<&CFAllocator>,
            url_string: Option<&CFString>,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateWithString(allocator, url_string, base_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFString"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateAbsoluteURLWithBytes(
    alloc: Option<&CFAllocator>,
    relative_url_bytes: *const u8,
    length: CFIndex,
    encoding: CFStringEncoding,
    base_url: Option<&CFURL>,
    use_compatibility_mode: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateAbsoluteURLWithBytes(
            alloc: Option<&CFAllocator>,
            relative_url_bytes: *const u8,
            length: CFIndex,
            encoding: CFStringEncoding,
            base_url: Option<&CFURL>,
            use_compatibility_mode: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateAbsoluteURLWithBytes(
            alloc,
            relative_url_bytes,
            length,
            encoding,
            base_url,
            use_compatibility_mode as _,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateWithFileSystemPath(
    allocator: Option<&CFAllocator>,
    file_path: Option<&CFString>,
    path_style: CFURLPathStyle,
    is_directory: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithFileSystemPath(
            allocator: Option<&CFAllocator>,
            file_path: Option<&CFString>,
            path_style: CFURLPathStyle,
            is_directory: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateWithFileSystemPath(allocator, file_path, path_style, is_directory as _)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFromFileSystemRepresentation(
    allocator: Option<&CFAllocator>,
    buffer: *const u8,
    buf_len: CFIndex,
    is_directory: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFromFileSystemRepresentation(
            allocator: Option<&CFAllocator>,
            buffer: *const u8,
            buf_len: CFIndex,
            is_directory: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateFromFileSystemRepresentation(allocator, buffer, buf_len, is_directory as _)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateWithFileSystemPathRelativeToBase(
    allocator: Option<&CFAllocator>,
    file_path: Option<&CFString>,
    path_style: CFURLPathStyle,
    is_directory: bool,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateWithFileSystemPathRelativeToBase(
            allocator: Option<&CFAllocator>,
            file_path: Option<&CFString>,
            path_style: CFURLPathStyle,
            is_directory: Boolean,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateWithFileSystemPathRelativeToBase(
            allocator,
            file_path,
            path_style,
            is_directory as _,
            base_url,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFromFileSystemRepresentationRelativeToBase(
    allocator: Option<&CFAllocator>,
    buffer: *const u8,
    buf_len: CFIndex,
    is_directory: bool,
    base_url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFromFileSystemRepresentationRelativeToBase(
            allocator: Option<&CFAllocator>,
            buffer: *const u8,
            buf_len: CFIndex,
            is_directory: Boolean,
            base_url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateFromFileSystemRepresentationRelativeToBase(
            allocator,
            buffer,
            buf_len,
            is_directory as _,
            base_url,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLGetFileSystemRepresentation(
    url: &CFURL,
    resolve_against_base: bool,
    buffer: *mut u8,
    max_buf_len: CFIndex,
) -> bool {
    extern "C-unwind" {
        fn CFURLGetFileSystemRepresentation(
            url: &CFURL,
            resolve_against_base: Boolean,
            buffer: *mut u8,
            max_buf_len: CFIndex,
        ) -> Boolean;
    }
    let ret = unsafe {
        CFURLGetFileSystemRepresentation(url, resolve_against_base as _, buffer, max_buf_len)
    };
    ret != 0
}

#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyAbsoluteURL(
    relative_url: &CFURL,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCopyAbsoluteURL(relative_url: &CFURL) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCopyAbsoluteURL(relative_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLGetString(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLGetString(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLGetString(an_url) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFURLGetBaseURL(an_url: &CFURL) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLGetBaseURL(an_url: &CFURL) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLGetBaseURL(an_url) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFURLCanBeDecomposed(an_url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLCanBeDecomposed(an_url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLCanBeDecomposed(an_url) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyScheme(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyScheme(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyScheme(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyNetLocation(
    an_url: &CFURL,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyNetLocation(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyNetLocation(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyPath(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyPath(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyPath(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyStrictPath(
    an_url: &CFURL,
    is_absolute: *mut Boolean,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyStrictPath(
            an_url: &CFURL,
            is_absolute: *mut Boolean,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyStrictPath(an_url, is_absolute) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyFileSystemPath(
    an_url: &CFURL,
    path_style: CFURLPathStyle,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyFileSystemPath(
            an_url: &CFURL,
            path_style: CFURLPathStyle,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyFileSystemPath(an_url, path_style) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFURLHasDirectoryPath(an_url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLHasDirectoryPath(an_url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLHasDirectoryPath(an_url) };
    ret != 0
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyResourceSpecifier(
    an_url: &CFURL,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyResourceSpecifier(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyResourceSpecifier(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyHostName(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyHostName(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyHostName(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    pub fn CFURLGetPortNumber(an_url: &CFURL) -> i32;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyUserName(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyUserName(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyUserName(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyPassword(an_url: &CFURL) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyPassword(an_url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyPassword(an_url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[deprecated = "The CFURLCopyParameterString function is deprecated. Post deprecation for applications linked with or after the macOS 10.15, and for all iOS, watchOS, and tvOS applications, CFURLCopyParameterString will always return NULL, and the CFURLCopyPath(), CFURLCopyStrictPath(), and CFURLCopyFileSystemPath() functions will return the complete path including the semicolon separator and params component if the URL string contains them."]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyParameterString(
    an_url: &CFURL,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyParameterString(
            an_url: &CFURL,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyParameterString(an_url, characters_to_leave_escaped) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyQueryString(
    an_url: &CFURL,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyQueryString(
            an_url: &CFURL,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyQueryString(an_url, characters_to_leave_escaped) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyFragment(
    an_url: &CFURL,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyFragment(
            an_url: &CFURL,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyFragment(an_url, characters_to_leave_escaped) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyLastPathComponent(
    url: &CFURL,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyLastPathComponent(url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyLastPathComponent(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyPathExtension(
    url: &CFURL,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCopyPathExtension(url: &CFURL) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe { CFURLCopyPathExtension(url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateCopyAppendingPathComponent(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    path_component: Option<&CFString>,
    is_directory: bool,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyAppendingPathComponent(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            path_component: Option<&CFString>,
            is_directory: Boolean,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateCopyAppendingPathComponent(allocator, url, path_component, is_directory as _)
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateCopyDeletingLastPathComponent(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyDeletingLastPathComponent(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateCopyDeletingLastPathComponent(allocator, url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateCopyAppendingPathExtension(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    extension: Option<&CFString>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyAppendingPathExtension(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            extension: Option<&CFString>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateCopyAppendingPathExtension(allocator, url, extension) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateCopyDeletingPathExtension(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateCopyDeletingPathExtension(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateCopyDeletingPathExtension(allocator, url) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFURLGetBytes(url: &CFURL, buffer: *mut u8, buffer_length: CFIndex) -> CFIndex;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlcomponenttype?language=objc)
// NS_ENUM
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLComponentType(pub CFIndex);
#[cfg(feature = "CFBase")]
impl CFURLComponentType {
    #[doc(alias = "kCFURLComponentScheme")]
    pub const Scheme: Self = Self(1);
    #[doc(alias = "kCFURLComponentNetLocation")]
    pub const NetLocation: Self = Self(2);
    #[doc(alias = "kCFURLComponentPath")]
    pub const Path: Self = Self(3);
    #[doc(alias = "kCFURLComponentResourceSpecifier")]
    pub const ResourceSpecifier: Self = Self(4);
    #[doc(alias = "kCFURLComponentUser")]
    pub const User: Self = Self(5);
    #[doc(alias = "kCFURLComponentPassword")]
    pub const Password: Self = Self(6);
    #[doc(alias = "kCFURLComponentUserInfo")]
    pub const UserInfo: Self = Self(7);
    #[doc(alias = "kCFURLComponentHost")]
    pub const Host: Self = Self(8);
    #[doc(alias = "kCFURLComponentPort")]
    pub const Port: Self = Self(9);
    #[doc(alias = "kCFURLComponentParameterString")]
    pub const ParameterString: Self = Self(10);
    #[doc(alias = "kCFURLComponentQuery")]
    pub const Query: Self = Self(11);
    #[doc(alias = "kCFURLComponentFragment")]
    pub const Fragment: Self = Self(12);
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFURLComponentType {
    const ENCODING: Encoding = CFIndex::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFURLComponentType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFURLGetByteRangeForComponent(
        url: &CFURL,
        component: CFURLComponentType,
        range_including_separators: *mut CFRange,
    ) -> CFRange;
}

#[cfg(feature = "CFBase")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateStringByReplacingPercentEscapes(
    allocator: Option<&CFAllocator>,
    original_string: Option<&CFString>,
    characters_to_leave_escaped: Option<&CFString>,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCreateStringByReplacingPercentEscapes(
            allocator: Option<&CFAllocator>,
            original_string: Option<&CFString>,
            characters_to_leave_escaped: Option<&CFString>,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFURLCreateStringByReplacingPercentEscapes(
            allocator,
            original_string,
            characters_to_leave_escaped,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFString"))]
#[deprecated = "Use [NSString stringByRemovingPercentEncoding] or CFURLCreateStringByReplacingPercentEscapes() instead, which always uses the recommended UTF-8 encoding."]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
    allocator: Option<&CFAllocator>,
    orig_string: Option<&CFString>,
    chars_to_leave_escaped: Option<&CFString>,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
            allocator: Option<&CFAllocator>,
            orig_string: Option<&CFString>,
            chars_to_leave_escaped: Option<&CFString>,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFURLCreateStringByReplacingPercentEscapesUsingEncoding(
            allocator,
            orig_string,
            chars_to_leave_escaped,
            encoding,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFString"))]
#[deprecated = "Use [NSString stringByAddingPercentEncodingWithAllowedCharacters:] instead, which always uses the recommended UTF-8 encoding, and which encodes for a specific URL component or subcomponent (since each URL component or subcomponent has different rules for what characters are valid)."]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateStringByAddingPercentEscapes(
    allocator: Option<&CFAllocator>,
    original_string: Option<&CFString>,
    characters_to_leave_unescaped: Option<&CFString>,
    legal_url_characters_to_be_escaped: Option<&CFString>,
    encoding: CFStringEncoding,
) -> Option<CFRetained<CFString>> {
    extern "C-unwind" {
        fn CFURLCreateStringByAddingPercentEscapes(
            allocator: Option<&CFAllocator>,
            original_string: Option<&CFString>,
            characters_to_leave_unescaped: Option<&CFString>,
            legal_url_characters_to_be_escaped: Option<&CFString>,
            encoding: CFStringEncoding,
        ) -> Option<NonNull<CFString>>;
    }
    let ret = unsafe {
        CFURLCreateStringByAddingPercentEscapes(
            allocator,
            original_string,
            characters_to_leave_unescaped,
            legal_url_characters_to_be_escaped,
            encoding,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFURLIsFileReferenceURL(url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLIsFileReferenceURL(url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLIsFileReferenceURL(url) };
    ret != 0
}

#[cfg(all(feature = "CFBase", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFileReferenceURL(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFileReferenceURL(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateFileReferenceURL(allocator, url, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateFilePathURL(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateFilePathURL(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe { CFURLCreateFilePathURL(allocator, url, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyResourcePropertyForKey(
    url: &CFURL,
    key: Option<&CFString>,
    property_value_type_ref_ptr: *mut c_void,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLCopyResourcePropertyForKey(
            url: &CFURL,
            key: Option<&CFString>,
            property_value_type_ref_ptr: *mut c_void,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret =
        unsafe { CFURLCopyResourcePropertyForKey(url, key, property_value_type_ref_ptr, error) };
    ret != 0
}

#[cfg(all(feature = "CFArray", feature = "CFDictionary", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCopyResourcePropertiesForKeys(
    url: &CFURL,
    keys: Option<&CFArray>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFURLCopyResourcePropertiesForKeys(
            url: &CFURL,
            keys: Option<&CFArray>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe { CFURLCopyResourcePropertiesForKeys(url, keys, error) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLSetResourcePropertyForKey(
    url: &CFURL,
    key: Option<&CFString>,
    property_value: Option<&CFType>,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLSetResourcePropertyForKey(
            url: &CFURL,
            key: Option<&CFString>,
            property_value: Option<&CFType>,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFURLSetResourcePropertyForKey(url, key, property_value, error) };
    ret != 0
}

#[cfg(all(feature = "CFDictionary", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLSetResourcePropertiesForKeys(
    url: &CFURL,
    keyed_property_values: Option<&CFDictionary>,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLSetResourcePropertiesForKeys(
            url: &CFURL,
            keyed_property_values: Option<&CFDictionary>,
            error: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFURLSetResourcePropertiesForKeys(url, keyed_property_values, error) };
    ret != 0
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlkeysofunsetvalueskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLKeysOfUnsetValuesKey: Option<&'static CFString>;
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFURLClearResourcePropertyCacheForKey(url: &CFURL, key: Option<&CFString>);
}

extern "C-unwind" {
    pub fn CFURLClearResourcePropertyCache(url: &CFURL);
}

extern "C-unwind" {
    #[cfg(feature = "CFBase")]
    pub fn CFURLSetTemporaryResourcePropertyForKey(
        url: &CFURL,
        key: Option<&CFString>,
        property_value: Option<&CFType>,
    );
}

#[cfg(feature = "CFError")]
#[inline]
pub unsafe extern "C-unwind" fn CFURLResourceIsReachable(
    url: &CFURL,
    error: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLResourceIsReachable(url: &CFURL, error: *mut *mut CFError) -> Boolean;
    }
    let ret = unsafe { CFURLResourceIsReachable(url, error) };
    ret != 0
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlnamekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllocalizednamekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLLocalizedNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisregularfilekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsRegularFileKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisdirectorykey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsDirectoryKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlissymboliclinkkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsSymbolicLinkKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisvolumekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsVolumeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlispackagekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsPackageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisapplicationkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsApplicationKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlapplicationisscriptablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLApplicationIsScriptableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlissystemimmutablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsSystemImmutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisuserimmutablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsUserImmutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlishiddenkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsHiddenKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlhashiddenextensionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLHasHiddenExtensionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcreationdatekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLCreationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcontentaccessdatekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLContentAccessDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcontentmodificationdatekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLContentModificationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlattributemodificationdatekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLAttributeModificationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfilecontentidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileContentIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlmaysharefilecontentkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLMayShareFileContentKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlmayhaveextendedattributeskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLMayHaveExtendedAttributesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlispurgeablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsPurgeableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlissparsekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsSparseKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllinkcountkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLLinkCountKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlparentdirectoryurlkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLParentDirectoryURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeurlkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeURLKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltypeidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLTypeIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllocalizedtypedescriptionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLLocalizedTypeDescriptionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllabelnumberkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLLabelNumberKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllabelcolorkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLLabelColorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurllocalizedlabelkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLLocalizedLabelKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurleffectiveiconkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLEffectiveIconKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcustomiconkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLCustomIconKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourceidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlpreferredioblocksizekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLPreferredIOBlockSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisreadablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsReadableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurliswritablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsWritableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisexecutablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsExecutableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfilesecuritykey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileSecurityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisexcludedfrombackupkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsExcludedFromBackupKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltagnameskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLTagNamesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlpathkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLPathKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlcanonicalpathkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLCanonicalPathKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlismounttriggerkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsMountTriggerKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlgenerationidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLGenerationIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurldocumentidentifierkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLDocumentIdentifierKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurladdedtodirectorydatekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLAddedToDirectoryDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlquarantinepropertieskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLQuarantinePropertiesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypenamedpipe?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeNamedPipe: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypecharacterspecial?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeCharacterSpecial: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypedirectory?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeDirectory: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypeblockspecial?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeBlockSpecial: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetyperegular?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeRegular: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypesymboliclink?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeSymbolicLink: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypesocket?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeSocket: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileresourcetypeunknown?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileResourceTypeUnknown: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfilesizekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileallocatedsizekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileAllocatedSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltotalfilesizekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLTotalFileSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurltotalfileallocatedsizekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLTotalFileAllocatedSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisaliasfilekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsAliasFileKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileProtectionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectionnone?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileProtectionNone: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncomplete?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileProtectionComplete: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncompleteunlessopen?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileProtectionCompleteUnlessOpen: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncompleteuntilfirstuserauthentication?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileProtectionCompleteUntilFirstUserAuthentication: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlfileprotectioncompletewhenuserinactive?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLFileProtectionCompleteWhenUserInactive: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurldirectoryentrycountkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLDirectoryEntryCountKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumelocalizedformatdescriptionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeLocalizedFormatDescriptionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumetotalcapacitykey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeTotalCapacityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeavailablecapacitykey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeAvailableCapacityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeavailablecapacityforimportantusagekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeAvailableCapacityForImportantUsageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeavailablecapacityforopportunisticusagekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeAvailableCapacityForOpportunisticUsageKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeresourcecountkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeResourceCountKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportspersistentidskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsPersistentIDsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportssymboliclinkskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsSymbolicLinksKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportshardlinkskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsHardLinksKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsjournalingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsJournalingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisjournalingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsJournalingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportssparsefileskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsSparseFilesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportszerorunskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsZeroRunsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportscasesensitivenameskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsCaseSensitiveNamesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportscasepreservednameskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsCasePreservedNamesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsrootdirectorydateskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsRootDirectoryDatesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsvolumesizeskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsVolumeSizesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsrenamingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsRenamingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsadvisoryfilelockingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsAdvisoryFileLockingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsextendedsecuritykey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsExtendedSecurityKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisbrowsablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsBrowsableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumemaximumfilesizekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeMaximumFileSizeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisejectablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsEjectableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisremovablekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsRemovableKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisinternalkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsInternalKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisautomountedkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsAutomountedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeislocalkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsLocalKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisreadonlykey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsReadOnlyKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumecreationdatekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeCreationDateKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeurlforremountingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeURLForRemountingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeuuidstringkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeUUIDStringKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumenamekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumelocalizednamekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeLocalizedNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisencryptedkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsEncryptedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumeisrootfilesystemkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeIsRootFileSystemKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportscompressionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsCompressionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsfilecloningkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsFileCloningKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsswaprenamingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsSwapRenamingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsexclusiverenamingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsExclusiveRenamingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsimmutablefileskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsImmutableFilesKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsaccesspermissionskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsAccessPermissionsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesupportsfileprotectionkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSupportsFileProtectionKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumetypenamekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeTypeNameKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumesubtypekey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeSubtypeKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlvolumemountfromlocationkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLVolumeMountFromLocationKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlisubiquitousitemkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLIsUbiquitousItemKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemhasunresolvedconflictskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemHasUnresolvedConflictsKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisdownloadedkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemIsDownloadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisdownloadingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemIsDownloadingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisuploadedkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemIsUploadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisuploadingkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemIsUploadingKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitempercentdownloadedkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemPercentDownloadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitempercentuploadedkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemPercentUploadedKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatuskey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemDownloadingStatusKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingerrorkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemDownloadingErrorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemuploadingerrorkey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemUploadingErrorKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemisexcludedfromsynckey?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemIsExcludedFromSyncKey: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatusnotdownloaded?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemDownloadingStatusNotDownloaded: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatusdownloaded?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemDownloadingStatusDownloaded: Option<&'static CFString>;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfurlubiquitousitemdownloadingstatuscurrent?language=objc)
    #[cfg(feature = "CFBase")]
    pub static kCFURLUbiquitousItemDownloadingStatusCurrent: Option<&'static CFString>;
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlbookmarkcreationoptions?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLBookmarkCreationOptions(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFURLBookmarkCreationOptions: CFOptionFlags {
        #[doc(alias = "kCFURLBookmarkCreationMinimalBookmarkMask")]
        const MinimalBookmarkMask = 1<<9;
        #[doc(alias = "kCFURLBookmarkCreationSuitableForBookmarkFile")]
        const SuitableForBookmarkFile = 1<<10;
        #[doc(alias = "kCFURLBookmarkCreationWithSecurityScope")]
        const WithSecurityScope = 1<<11;
        #[doc(alias = "kCFURLBookmarkCreationSecurityScopeAllowOnlyReadAccess")]
        const SecurityScopeAllowOnlyReadAccess = 1<<12;
        #[doc(alias = "kCFURLBookmarkCreationWithoutImplicitSecurityScope")]
        const WithoutImplicitSecurityScope = 1<<29;
#[deprecated = "kCFURLBookmarkCreationPreferFileIDResolutionMask does nothing and has no effect on bookmark resolution"]
        #[doc(alias = "kCFURLBookmarkCreationPreferFileIDResolutionMask")]
        const PreferFileIDResolutionMask = 1<<8;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFURLBookmarkCreationOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFURLBookmarkCreationOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlbookmarkresolutionoptions?language=objc)
// NS_OPTIONS
#[cfg(feature = "CFBase")]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFURLBookmarkResolutionOptions(pub CFOptionFlags);
#[cfg(feature = "CFBase")]
bitflags::bitflags! {
    impl CFURLBookmarkResolutionOptions: CFOptionFlags {
        #[doc(alias = "kCFURLBookmarkResolutionWithoutUIMask")]
        const CFURLBookmarkResolutionWithoutUIMask = 1<<8;
        #[doc(alias = "kCFURLBookmarkResolutionWithoutMountingMask")]
        const CFURLBookmarkResolutionWithoutMountingMask = 1<<9;
        #[doc(alias = "kCFURLBookmarkResolutionWithSecurityScope")]
        const CFURLBookmarkResolutionWithSecurityScope = 1<<10;
        #[doc(alias = "kCFURLBookmarkResolutionWithoutImplicitStartAccessing")]
        const CFURLBookmarkResolutionWithoutImplicitStartAccessing = 1<<15;
        #[doc(alias = "kCFBookmarkResolutionWithoutUIMask")]
        const CFBookmarkResolutionWithoutUIMask = CFURLBookmarkResolutionOptions::CFURLBookmarkResolutionWithoutUIMask.0;
        #[doc(alias = "kCFBookmarkResolutionWithoutMountingMask")]
        const CFBookmarkResolutionWithoutMountingMask = CFURLBookmarkResolutionOptions::CFURLBookmarkResolutionWithoutMountingMask.0;
    }
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl Encode for CFURLBookmarkResolutionOptions {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(all(feature = "CFBase", feature = "objc2"))]
unsafe impl RefEncode for CFURLBookmarkResolutionOptions {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfurlbookmarkfilecreationoptions?language=objc)
#[cfg(feature = "CFBase")]
pub type CFURLBookmarkFileCreationOptions = CFOptionFlags;

#[cfg(all(
    feature = "CFArray",
    feature = "CFBase",
    feature = "CFData",
    feature = "CFError"
))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateBookmarkData(
    allocator: Option<&CFAllocator>,
    url: Option<&CFURL>,
    options: CFURLBookmarkCreationOptions,
    resource_properties_to_include: Option<&CFArray>,
    relative_to_url: Option<&CFURL>,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateBookmarkData(
            allocator: Option<&CFAllocator>,
            url: Option<&CFURL>,
            options: CFURLBookmarkCreationOptions,
            resource_properties_to_include: Option<&CFArray>,
            relative_to_url: Option<&CFURL>,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe {
        CFURLCreateBookmarkData(
            allocator,
            url,
            options,
            resource_properties_to_include,
            relative_to_url,
            error,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(
    feature = "CFArray",
    feature = "CFBase",
    feature = "CFData",
    feature = "CFError"
))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateByResolvingBookmarkData(
    allocator: Option<&CFAllocator>,
    bookmark: Option<&CFData>,
    options: CFURLBookmarkResolutionOptions,
    relative_to_url: Option<&CFURL>,
    resource_properties_to_include: Option<&CFArray>,
    is_stale: *mut Boolean,
    error: *mut *mut CFError,
) -> Option<CFRetained<CFURL>> {
    extern "C-unwind" {
        fn CFURLCreateByResolvingBookmarkData(
            allocator: Option<&CFAllocator>,
            bookmark: Option<&CFData>,
            options: CFURLBookmarkResolutionOptions,
            relative_to_url: Option<&CFURL>,
            resource_properties_to_include: Option<&CFArray>,
            is_stale: *mut Boolean,
            error: *mut *mut CFError,
        ) -> Option<NonNull<CFURL>>;
    }
    let ret = unsafe {
        CFURLCreateByResolvingBookmarkData(
            allocator,
            bookmark,
            options,
            relative_to_url,
            resource_properties_to_include,
            is_stale,
            error,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(
    feature = "CFArray",
    feature = "CFBase",
    feature = "CFData",
    feature = "CFDictionary"
))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateResourcePropertiesForKeysFromBookmarkData(
    allocator: Option<&CFAllocator>,
    resource_properties_to_return: Option<&CFArray>,
    bookmark: Option<&CFData>,
) -> Option<CFRetained<CFDictionary>> {
    extern "C-unwind" {
        fn CFURLCreateResourcePropertiesForKeysFromBookmarkData(
            allocator: Option<&CFAllocator>,
            resource_properties_to_return: Option<&CFArray>,
            bookmark: Option<&CFData>,
        ) -> Option<NonNull<CFDictionary>>;
    }
    let ret = unsafe {
        CFURLCreateResourcePropertiesForKeysFromBookmarkData(
            allocator,
            resource_properties_to_return,
            bookmark,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFData"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateResourcePropertyForKeyFromBookmarkData(
    allocator: Option<&CFAllocator>,
    resource_property_key: Option<&CFString>,
    bookmark: Option<&CFData>,
) -> Option<CFRetained<CFType>> {
    extern "C-unwind" {
        fn CFURLCreateResourcePropertyForKeyFromBookmarkData(
            allocator: Option<&CFAllocator>,
            resource_property_key: Option<&CFString>,
            bookmark: Option<&CFData>,
        ) -> Option<NonNull<CFType>>;
    }
    let ret = unsafe {
        CFURLCreateResourcePropertyForKeyFromBookmarkData(
            allocator,
            resource_property_key,
            bookmark,
        )
    };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFData", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateBookmarkDataFromFile(
    allocator: Option<&CFAllocator>,
    file_url: Option<&CFURL>,
    error_ref: *mut *mut CFError,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateBookmarkDataFromFile(
            allocator: Option<&CFAllocator>,
            file_url: Option<&CFURL>,
            error_ref: *mut *mut CFError,
        ) -> Option<NonNull<CFData>>;
    }
    let ret = unsafe { CFURLCreateBookmarkDataFromFile(allocator, file_url, error_ref) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(all(feature = "CFBase", feature = "CFData", feature = "CFError"))]
#[inline]
pub unsafe extern "C-unwind" fn CFURLWriteBookmarkDataToFile(
    bookmark_ref: Option<&CFData>,
    file_url: Option<&CFURL>,
    options: CFURLBookmarkFileCreationOptions,
    error_ref: *mut *mut CFError,
) -> bool {
    extern "C-unwind" {
        fn CFURLWriteBookmarkDataToFile(
            bookmark_ref: Option<&CFData>,
            file_url: Option<&CFURL>,
            options: CFURLBookmarkFileCreationOptions,
            error_ref: *mut *mut CFError,
        ) -> Boolean;
    }
    let ret = unsafe { CFURLWriteBookmarkDataToFile(bookmark_ref, file_url, options, error_ref) };
    ret != 0
}

#[cfg(all(feature = "CFBase", feature = "CFData"))]
#[deprecated = "The Carbon Alias Manager is deprecated. This function should only be used to convert Carbon AliasRecords to bookmark data."]
#[inline]
pub unsafe extern "C-unwind" fn CFURLCreateBookmarkDataFromAliasRecord(
    allocator_ref: Option<&CFAllocator>,
    alias_record_data_ref: Option<&CFData>,
) -> Option<CFRetained<CFData>> {
    extern "C-unwind" {
        fn CFURLCreateBookmarkDataFromAliasRecord(
            allocator_ref: Option<&CFAllocator>,
            alias_record_data_ref: Option<&CFData>,
        ) -> Option<NonNull<CFData>>;
    }
    let ret =
        unsafe { CFURLCreateBookmarkDataFromAliasRecord(allocator_ref, alias_record_data_ref) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[inline]
pub unsafe extern "C-unwind" fn CFURLStartAccessingSecurityScopedResource(url: &CFURL) -> bool {
    extern "C-unwind" {
        fn CFURLStartAccessingSecurityScopedResource(url: &CFURL) -> Boolean;
    }
    let ret = unsafe { CFURLStartAccessingSecurityScopedResource(url) };
    ret != 0
}

extern "C-unwind" {
    pub fn CFURLStopAccessingSecurityScopedResource(url: &CFURL);
}
