/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.composite.internal;

import org.gradle.api.GradleException;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.composite.internal.BuildStateFactory;
import org.gradle.composite.internal.DefaultIncludedBuildRegistry;
import org.gradle.composite.internal.DynamicGraphCycleDetector;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.IncludedBuildFactory;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.event.ListenerManager;

public class AcyclicIncludedBuildRegistry
extends DefaultIncludedBuildRegistry {
    private final DynamicGraphCycleDetector<BuildState> cycleDetector = new DynamicGraphCycleDetector();

    public AcyclicIncludedBuildRegistry(IncludedBuildFactory includedBuildFactory, ListenerManager listenerManager, BuildStateFactory buildStateFactory) {
        super(includedBuildFactory, listenerManager, buildStateFactory);
    }

    public void onRootBuildInclude(RootBuildState rootBuild, BuildState referrer, boolean isPluginBuild) {
        this.addEdge((BuildState)rootBuild, referrer, isPluginBuild);
    }

    @Override
    public IncludedBuildState addIncludedBuild(BuildDefinition buildDefinition, BuildState referrer) {
        IncludedBuildState includedBuild = super.addIncludedBuild(buildDefinition, referrer);
        this.addEdge((BuildState)includedBuild, referrer, buildDefinition.isPluginBuild());
        return includedBuild;
    }

    private void addEdge(BuildState target, BuildState referrer, boolean isPluginBuild) {
        if (isPluginBuild) {
            this.cycleDetector.addAcyclicNode(target);
        }
        this.cycleDetector.addEdge(referrer, target);
        this.cycleDetector.findFirstInvalidCycle().ifPresent(AcyclicIncludedBuildRegistry::reportCycle);
    }

    private static void reportCycle(DynamicGraphCycleDetector.Cycle<BuildState> cycle) {
        String path = cycle.format(buildState -> buildState.getIdentityPath().getPath());
        throw new GradleException(String.format("A cycle has been detected in the definition of plugin builds: %s. This is not supported with Isolated Projects. Please update your build definition to remove one of the edges.", path));
    }
}

