/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.PostExecutionNodeAwareActionNode;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.resources.ResourceLock;

public class ActionNode
extends Node
implements SelfExecutingNode {
    private WorkNodeAction action;
    private List<Node> postExecutionNodes;
    private final ProjectInternal owningProject;
    private final ProjectInternal projectToLock;
    private boolean hasVisitedPreExecutionNode;

    public ActionNode(WorkNodeAction action) {
        this.action = action;
        this.owningProject = (ProjectInternal)action.getOwningProject();
        this.projectToLock = this.owningProject != null && action.usesMutableProjectState() ? this.owningProject : null;
    }

    @Override
    @Nullable
    public Throwable getNodeFailure() {
        return null;
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver) {
        TaskDependencyContainer dependencies = arg_0 -> ((WorkNodeAction)this.action).visitDependencies(arg_0);
        for (Node node : dependencyResolver.resolveDependenciesFor(null, dependencies)) {
            this.addDependencySuccessor(node);
        }
    }

    @Nullable
    public WorkNodeAction getAction() {
        return this.action;
    }

    @Override
    public String toString() {
        return "work action " + this.action;
    }

    @Override
    public boolean isPriority() {
        return this.getProjectToLock() != null;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.projectToLock != null) {
            return this.projectToLock.getOwner().getAccessLock();
        }
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    @Override
    public void execute(NodeExecutionContext context) {
        try {
            this.action.run(context);
            if (this.action instanceof PostExecutionNodeAwareActionNode) {
                this.postExecutionNodes = ImmutableList.copyOf(((PostExecutionNodeAwareActionNode)this.action).getPostExecutionNodes());
            }
        }
        finally {
            this.action = null;
        }
    }

    @Override
    public boolean hasPendingPreExecutionNodes() {
        return !this.hasVisitedPreExecutionNode && this.action.getPreExecutionNode() != null;
    }

    @Override
    public void visitPreExecutionNodes(Consumer<? super Node> visitor) {
        if (!this.hasVisitedPreExecutionNode) {
            WorkNodeAction preExecutionNode = this.action.getPreExecutionNode();
            if (preExecutionNode != null) {
                visitor.accept(new ActionNode(preExecutionNode));
            }
            this.hasVisitedPreExecutionNode = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitPostExecutionNodes(Consumer<? super Node> visitor) {
        if (this.postExecutionNodes != null) {
            try {
                for (Node node : this.postExecutionNodes) {
                    visitor.accept(node);
                }
            }
            finally {
                this.postExecutionNodes = null;
            }
        }
    }
}

