# Pwndbg in the wild

Here is a non-exhaustive list of Pwndbg mentions found in the wild. Feel free to open a PR to add more if you find them!

## Talks
+ [EuroPython 2025 - Pwndbg: Low level debugging and exploit development with Python](https://ep2025.europython.eu/session/pwndbg-low-level-debugging-and-exploit-development-with-python) ([slides](https://docs.google.com/presentation/d/1m9yYOeHxkKznseTakYeKixOUcCEjk7e-goirNE93ISs/), [video](https://www.youtube.com/watch?v=hRvjre7AH-o&t=7100s))
+ [OffensiveCon24 - How to Fuzz Your Way to Android Universal Root: Attacking Android Binder - by Eugene Rodionov, Zi Fan Tan and Gulshan Singh](https://www.youtube.com/watch?v=U-xSM159YLI&t=1859s)

## Blog posts
+ [Oops Safari, I think You Spilled Something! @ Exodus Intelligence](https://blog.exodusintel.com/2025/08/04/oops-safari-i-think-you-spilled-something/)
+ [“Unstripping” binaries: Restoring debugging information in GDB with Pwndbg by Jason An @ Trail of Bits](https://blog.trailofbits.com/2024/09/06/unstripping-binaries-restoring-debugging-information-in-gdb-with-pwndbg/)
+ [A Winter’s Tale: Improving messages and types in GDB’s Python API by Matheus Branco Borella @ Trail of Bits](https://blog.trailofbits.com/2023/04/18/a-winters-tale-improving-types-and-messages-in-gdbs-python-api/)
+ [Patch-gapping Google Chrome @ Exodus Intelligence](https://blog.exodusintel.com/2019/09/09/patch-gapping-chrome/)
+ [Inspecting rdtsc with pwndbg by John Shaughnessy](https://www.johnshaughnessy.com/blog/posts/rdtsc_and_pwndbg)

## Videos
+ [Intro to pwndbg - CTF Cookbook by SloppyJoePirates CTF Writeups](https://www.youtube.com/watch?v=5judobmDBKI)
+ [Intro to Binary Exploitation (Pwn) by CryptoCat](https://youtu.be/wa3sMSdLyHw?list=PLHUKi1UlEgOIc07Rfk2Jgb5fZbxDPec94&t=730)
+ [Bug A Day #8 - pwndbg #2 by Bug-A-Day](https://www.youtube.com/watch?v=mmkewHlDv9I)

## Scripts
+ [CVE-2022-24834 exploit by ptr-yudai](https://github.com/RICSecLab/exploit-poc-public/blob/main/CVE-2022-24834/exploit.py#L49)

## Magazine articles
+ ["Programista" polish programming magazine - Low level debugging with Pwndbg (in polish)](https://programistamag.pl/programista-42023-109-wrzesienpazdziernik-2023-debugowanie-niskopoziomowe-z-pwndbg/)
