/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// VerifyDataWithClassicKey struct for VerifyDataWithClassicKey
type VerifyDataWithClassicKey struct {
	// Data
	Data string `json:"data"`
	// The display id of the key to use in the verification process
	DisplayId *string `json:"display-id,omitempty"`
	// Defines whether the data should be hashed as part of the signing. If true, the data will not be hashed
	Hashed *bool `json:"hashed,omitempty"`
	// HashingMethod
	HashingMethod *string `json:"hashing-method,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// The name of the key to use in the verification process
	Name string `json:"name"`
	// The data's signature in a Base64 format.
	Signature string `json:"signature"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
	// classic key version
	Version int32 `json:"version"`
}

// NewVerifyDataWithClassicKey instantiates a new VerifyDataWithClassicKey object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewVerifyDataWithClassicKey(data string, name string, signature string, version int32, ) *VerifyDataWithClassicKey {
	this := VerifyDataWithClassicKey{}
	this.Data = data
	var hashed bool = false
	this.Hashed = &hashed
	var hashingMethod string = "SHA256"
	this.HashingMethod = &hashingMethod
	var json bool = false
	this.Json = &json
	this.Name = name
	this.Signature = signature
	this.Version = version
	return &this
}

// NewVerifyDataWithClassicKeyWithDefaults instantiates a new VerifyDataWithClassicKey object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewVerifyDataWithClassicKeyWithDefaults() *VerifyDataWithClassicKey {
	this := VerifyDataWithClassicKey{}
	var hashed bool = false
	this.Hashed = &hashed
	var hashingMethod string = "SHA256"
	this.HashingMethod = &hashingMethod
	var json bool = false
	this.Json = &json
	return &this
}

// GetData returns the Data field value
func (o *VerifyDataWithClassicKey) GetData() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Data
}

// GetDataOk returns a tuple with the Data field value
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetDataOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Data, true
}

// SetData sets field value
func (o *VerifyDataWithClassicKey) SetData(v string) {
	o.Data = v
}

// GetDisplayId returns the DisplayId field value if set, zero value otherwise.
func (o *VerifyDataWithClassicKey) GetDisplayId() string {
	if o == nil || o.DisplayId == nil {
		var ret string
		return ret
	}
	return *o.DisplayId
}

// GetDisplayIdOk returns a tuple with the DisplayId field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetDisplayIdOk() (*string, bool) {
	if o == nil || o.DisplayId == nil {
		return nil, false
	}
	return o.DisplayId, true
}

// HasDisplayId returns a boolean if a field has been set.
func (o *VerifyDataWithClassicKey) HasDisplayId() bool {
	if o != nil && o.DisplayId != nil {
		return true
	}

	return false
}

// SetDisplayId gets a reference to the given string and assigns it to the DisplayId field.
func (o *VerifyDataWithClassicKey) SetDisplayId(v string) {
	o.DisplayId = &v
}

// GetHashed returns the Hashed field value if set, zero value otherwise.
func (o *VerifyDataWithClassicKey) GetHashed() bool {
	if o == nil || o.Hashed == nil {
		var ret bool
		return ret
	}
	return *o.Hashed
}

// GetHashedOk returns a tuple with the Hashed field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetHashedOk() (*bool, bool) {
	if o == nil || o.Hashed == nil {
		return nil, false
	}
	return o.Hashed, true
}

// HasHashed returns a boolean if a field has been set.
func (o *VerifyDataWithClassicKey) HasHashed() bool {
	if o != nil && o.Hashed != nil {
		return true
	}

	return false
}

// SetHashed gets a reference to the given bool and assigns it to the Hashed field.
func (o *VerifyDataWithClassicKey) SetHashed(v bool) {
	o.Hashed = &v
}

// GetHashingMethod returns the HashingMethod field value if set, zero value otherwise.
func (o *VerifyDataWithClassicKey) GetHashingMethod() string {
	if o == nil || o.HashingMethod == nil {
		var ret string
		return ret
	}
	return *o.HashingMethod
}

// GetHashingMethodOk returns a tuple with the HashingMethod field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetHashingMethodOk() (*string, bool) {
	if o == nil || o.HashingMethod == nil {
		return nil, false
	}
	return o.HashingMethod, true
}

// HasHashingMethod returns a boolean if a field has been set.
func (o *VerifyDataWithClassicKey) HasHashingMethod() bool {
	if o != nil && o.HashingMethod != nil {
		return true
	}

	return false
}

// SetHashingMethod gets a reference to the given string and assigns it to the HashingMethod field.
func (o *VerifyDataWithClassicKey) SetHashingMethod(v string) {
	o.HashingMethod = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *VerifyDataWithClassicKey) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *VerifyDataWithClassicKey) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *VerifyDataWithClassicKey) SetJson(v bool) {
	o.Json = &v
}

// GetName returns the Name field value
func (o *VerifyDataWithClassicKey) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *VerifyDataWithClassicKey) SetName(v string) {
	o.Name = v
}

// GetSignature returns the Signature field value
func (o *VerifyDataWithClassicKey) GetSignature() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Signature
}

// GetSignatureOk returns a tuple with the Signature field value
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetSignatureOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Signature, true
}

// SetSignature sets field value
func (o *VerifyDataWithClassicKey) SetSignature(v string) {
	o.Signature = v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *VerifyDataWithClassicKey) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *VerifyDataWithClassicKey) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *VerifyDataWithClassicKey) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *VerifyDataWithClassicKey) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *VerifyDataWithClassicKey) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *VerifyDataWithClassicKey) SetUidToken(v string) {
	o.UidToken = &v
}

// GetVersion returns the Version field value
func (o *VerifyDataWithClassicKey) GetVersion() int32 {
	if o == nil  {
		var ret int32
		return ret
	}

	return o.Version
}

// GetVersionOk returns a tuple with the Version field value
// and a boolean to check if the value has been set.
func (o *VerifyDataWithClassicKey) GetVersionOk() (*int32, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Version, true
}

// SetVersion sets field value
func (o *VerifyDataWithClassicKey) SetVersion(v int32) {
	o.Version = v
}

func (o VerifyDataWithClassicKey) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if true {
		toSerialize["data"] = o.Data
	}
	if o.DisplayId != nil {
		toSerialize["display-id"] = o.DisplayId
	}
	if o.Hashed != nil {
		toSerialize["hashed"] = o.Hashed
	}
	if o.HashingMethod != nil {
		toSerialize["hashing-method"] = o.HashingMethod
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if true {
		toSerialize["signature"] = o.Signature
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	if true {
		toSerialize["version"] = o.Version
	}
	return json.Marshal(toSerialize)
}

type NullableVerifyDataWithClassicKey struct {
	value *VerifyDataWithClassicKey
	isSet bool
}

func (v NullableVerifyDataWithClassicKey) Get() *VerifyDataWithClassicKey {
	return v.value
}

func (v *NullableVerifyDataWithClassicKey) Set(val *VerifyDataWithClassicKey) {
	v.value = val
	v.isSet = true
}

func (v NullableVerifyDataWithClassicKey) IsSet() bool {
	return v.isSet
}

func (v *NullableVerifyDataWithClassicKey) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableVerifyDataWithClassicKey(val *VerifyDataWithClassicKey) *NullableVerifyDataWithClassicKey {
	return &NullableVerifyDataWithClassicKey{value: val, isSet: true}
}

func (v NullableVerifyDataWithClassicKey) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableVerifyDataWithClassicKey) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


