/*
 * Akeyless API
 *
 * The purpose of this application is to provide access to Akeyless API.
 *
 * API version: 2.0
 * Contact: support@akeyless.io
 */

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package akeyless

import (
	"encoding/json"
)

// CreateAuthMethodK8S createAuthMethodK8S is a command that creates a new auth method that will be able to authenticate using K8S. [Deprecated: Use auth-method-create-k8s command]
type CreateAuthMethodK8S struct {
	// Access expiration date in Unix timestamp (select 0 for access without expiry date)
	AccessExpires *int64 `json:"access-expires,omitempty"`
	// The audience in the Kubernetes JWT that the access is restricted to
	Audience *string `json:"audience,omitempty"`
	// Subclaims to include in audit logs, e.g \"--audit-logs-claims email --audit-logs-claims username\"
	AuditLogsClaims *[]string `json:"audit-logs-claims,omitempty"`
	// A CIDR whitelist with the IPs that the access is restricted to
	BoundIps *[]string `json:"bound-ips,omitempty"`
	// A list of namespaces that the access is restricted to
	BoundNamespaces *[]string `json:"bound-namespaces,omitempty"`
	// A list of pod names that the access is restricted to
	BoundPodNames *[]string `json:"bound-pod-names,omitempty"`
	// A list of service account names that the access is restricted to
	BoundSaNames *[]string `json:"bound-sa-names,omitempty"`
	// Protection from accidental deletion of this object [true/false]
	DeleteProtection *string `json:"delete_protection,omitempty"`
	// Auth Method description
	Description *string `json:"description,omitempty"`
	// if true: enforce role-association must include sub claims
	ForceSubClaims *bool `json:"force-sub-claims,omitempty"`
	// Automatically generate key-pair for K8S configuration. If set to false, a public key needs to be provided [true/false]
	GenKey *string `json:"gen-key,omitempty"`
	// A CIDR whitelist with the GW IPs that the access is restricted to
	GwBoundIps *[]string `json:"gw-bound-ips,omitempty"`
	// Set output format to JSON
	Json *bool `json:"json,omitempty"`
	// Jwt TTL
	JwtTtl *int64 `json:"jwt-ttl,omitempty"`
	// Auth Method name
	Name string `json:"name"`
	// Choose the relevant product type for the auth method [sm, sra, pm, dp, ca]
	ProductType *[]string `json:"product-type,omitempty"`
	// Base64-encoded or PEM formatted public key data for K8S authentication method is required [RSA2048]
	PublicKey *string `json:"public-key,omitempty"`
	// Authentication token (see `/auth` and `/configure`)
	Token *string `json:"token,omitempty"`
	// The universal identity token, Required only for universal_identity authentication
	UidToken *string `json:"uid-token,omitempty"`
}

// NewCreateAuthMethodK8S instantiates a new CreateAuthMethodK8S object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateAuthMethodK8S(name string, ) *CreateAuthMethodK8S {
	this := CreateAuthMethodK8S{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var genKey string = "true"
	this.GenKey = &genKey
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	this.Name = name
	return &this
}

// NewCreateAuthMethodK8SWithDefaults instantiates a new CreateAuthMethodK8S object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateAuthMethodK8SWithDefaults() *CreateAuthMethodK8S {
	this := CreateAuthMethodK8S{}
	var accessExpires int64 = 0
	this.AccessExpires = &accessExpires
	var genKey string = "true"
	this.GenKey = &genKey
	var json bool = false
	this.Json = &json
	var jwtTtl int64 = 0
	this.JwtTtl = &jwtTtl
	return &this
}

// GetAccessExpires returns the AccessExpires field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetAccessExpires() int64 {
	if o == nil || o.AccessExpires == nil {
		var ret int64
		return ret
	}
	return *o.AccessExpires
}

// GetAccessExpiresOk returns a tuple with the AccessExpires field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetAccessExpiresOk() (*int64, bool) {
	if o == nil || o.AccessExpires == nil {
		return nil, false
	}
	return o.AccessExpires, true
}

// HasAccessExpires returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasAccessExpires() bool {
	if o != nil && o.AccessExpires != nil {
		return true
	}

	return false
}

// SetAccessExpires gets a reference to the given int64 and assigns it to the AccessExpires field.
func (o *CreateAuthMethodK8S) SetAccessExpires(v int64) {
	o.AccessExpires = &v
}

// GetAudience returns the Audience field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetAudience() string {
	if o == nil || o.Audience == nil {
		var ret string
		return ret
	}
	return *o.Audience
}

// GetAudienceOk returns a tuple with the Audience field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetAudienceOk() (*string, bool) {
	if o == nil || o.Audience == nil {
		return nil, false
	}
	return o.Audience, true
}

// HasAudience returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasAudience() bool {
	if o != nil && o.Audience != nil {
		return true
	}

	return false
}

// SetAudience gets a reference to the given string and assigns it to the Audience field.
func (o *CreateAuthMethodK8S) SetAudience(v string) {
	o.Audience = &v
}

// GetAuditLogsClaims returns the AuditLogsClaims field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetAuditLogsClaims() []string {
	if o == nil || o.AuditLogsClaims == nil {
		var ret []string
		return ret
	}
	return *o.AuditLogsClaims
}

// GetAuditLogsClaimsOk returns a tuple with the AuditLogsClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetAuditLogsClaimsOk() (*[]string, bool) {
	if o == nil || o.AuditLogsClaims == nil {
		return nil, false
	}
	return o.AuditLogsClaims, true
}

// HasAuditLogsClaims returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasAuditLogsClaims() bool {
	if o != nil && o.AuditLogsClaims != nil {
		return true
	}

	return false
}

// SetAuditLogsClaims gets a reference to the given []string and assigns it to the AuditLogsClaims field.
func (o *CreateAuthMethodK8S) SetAuditLogsClaims(v []string) {
	o.AuditLogsClaims = &v
}

// GetBoundIps returns the BoundIps field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetBoundIps() []string {
	if o == nil || o.BoundIps == nil {
		var ret []string
		return ret
	}
	return *o.BoundIps
}

// GetBoundIpsOk returns a tuple with the BoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetBoundIpsOk() (*[]string, bool) {
	if o == nil || o.BoundIps == nil {
		return nil, false
	}
	return o.BoundIps, true
}

// HasBoundIps returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasBoundIps() bool {
	if o != nil && o.BoundIps != nil {
		return true
	}

	return false
}

// SetBoundIps gets a reference to the given []string and assigns it to the BoundIps field.
func (o *CreateAuthMethodK8S) SetBoundIps(v []string) {
	o.BoundIps = &v
}

// GetBoundNamespaces returns the BoundNamespaces field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetBoundNamespaces() []string {
	if o == nil || o.BoundNamespaces == nil {
		var ret []string
		return ret
	}
	return *o.BoundNamespaces
}

// GetBoundNamespacesOk returns a tuple with the BoundNamespaces field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetBoundNamespacesOk() (*[]string, bool) {
	if o == nil || o.BoundNamespaces == nil {
		return nil, false
	}
	return o.BoundNamespaces, true
}

// HasBoundNamespaces returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasBoundNamespaces() bool {
	if o != nil && o.BoundNamespaces != nil {
		return true
	}

	return false
}

// SetBoundNamespaces gets a reference to the given []string and assigns it to the BoundNamespaces field.
func (o *CreateAuthMethodK8S) SetBoundNamespaces(v []string) {
	o.BoundNamespaces = &v
}

// GetBoundPodNames returns the BoundPodNames field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetBoundPodNames() []string {
	if o == nil || o.BoundPodNames == nil {
		var ret []string
		return ret
	}
	return *o.BoundPodNames
}

// GetBoundPodNamesOk returns a tuple with the BoundPodNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetBoundPodNamesOk() (*[]string, bool) {
	if o == nil || o.BoundPodNames == nil {
		return nil, false
	}
	return o.BoundPodNames, true
}

// HasBoundPodNames returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasBoundPodNames() bool {
	if o != nil && o.BoundPodNames != nil {
		return true
	}

	return false
}

// SetBoundPodNames gets a reference to the given []string and assigns it to the BoundPodNames field.
func (o *CreateAuthMethodK8S) SetBoundPodNames(v []string) {
	o.BoundPodNames = &v
}

// GetBoundSaNames returns the BoundSaNames field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetBoundSaNames() []string {
	if o == nil || o.BoundSaNames == nil {
		var ret []string
		return ret
	}
	return *o.BoundSaNames
}

// GetBoundSaNamesOk returns a tuple with the BoundSaNames field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetBoundSaNamesOk() (*[]string, bool) {
	if o == nil || o.BoundSaNames == nil {
		return nil, false
	}
	return o.BoundSaNames, true
}

// HasBoundSaNames returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasBoundSaNames() bool {
	if o != nil && o.BoundSaNames != nil {
		return true
	}

	return false
}

// SetBoundSaNames gets a reference to the given []string and assigns it to the BoundSaNames field.
func (o *CreateAuthMethodK8S) SetBoundSaNames(v []string) {
	o.BoundSaNames = &v
}

// GetDeleteProtection returns the DeleteProtection field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetDeleteProtection() string {
	if o == nil || o.DeleteProtection == nil {
		var ret string
		return ret
	}
	return *o.DeleteProtection
}

// GetDeleteProtectionOk returns a tuple with the DeleteProtection field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetDeleteProtectionOk() (*string, bool) {
	if o == nil || o.DeleteProtection == nil {
		return nil, false
	}
	return o.DeleteProtection, true
}

// HasDeleteProtection returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasDeleteProtection() bool {
	if o != nil && o.DeleteProtection != nil {
		return true
	}

	return false
}

// SetDeleteProtection gets a reference to the given string and assigns it to the DeleteProtection field.
func (o *CreateAuthMethodK8S) SetDeleteProtection(v string) {
	o.DeleteProtection = &v
}

// GetDescription returns the Description field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetDescription() string {
	if o == nil || o.Description == nil {
		var ret string
		return ret
	}
	return *o.Description
}

// GetDescriptionOk returns a tuple with the Description field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetDescriptionOk() (*string, bool) {
	if o == nil || o.Description == nil {
		return nil, false
	}
	return o.Description, true
}

// HasDescription returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasDescription() bool {
	if o != nil && o.Description != nil {
		return true
	}

	return false
}

// SetDescription gets a reference to the given string and assigns it to the Description field.
func (o *CreateAuthMethodK8S) SetDescription(v string) {
	o.Description = &v
}

// GetForceSubClaims returns the ForceSubClaims field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetForceSubClaims() bool {
	if o == nil || o.ForceSubClaims == nil {
		var ret bool
		return ret
	}
	return *o.ForceSubClaims
}

// GetForceSubClaimsOk returns a tuple with the ForceSubClaims field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetForceSubClaimsOk() (*bool, bool) {
	if o == nil || o.ForceSubClaims == nil {
		return nil, false
	}
	return o.ForceSubClaims, true
}

// HasForceSubClaims returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasForceSubClaims() bool {
	if o != nil && o.ForceSubClaims != nil {
		return true
	}

	return false
}

// SetForceSubClaims gets a reference to the given bool and assigns it to the ForceSubClaims field.
func (o *CreateAuthMethodK8S) SetForceSubClaims(v bool) {
	o.ForceSubClaims = &v
}

// GetGenKey returns the GenKey field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetGenKey() string {
	if o == nil || o.GenKey == nil {
		var ret string
		return ret
	}
	return *o.GenKey
}

// GetGenKeyOk returns a tuple with the GenKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetGenKeyOk() (*string, bool) {
	if o == nil || o.GenKey == nil {
		return nil, false
	}
	return o.GenKey, true
}

// HasGenKey returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasGenKey() bool {
	if o != nil && o.GenKey != nil {
		return true
	}

	return false
}

// SetGenKey gets a reference to the given string and assigns it to the GenKey field.
func (o *CreateAuthMethodK8S) SetGenKey(v string) {
	o.GenKey = &v
}

// GetGwBoundIps returns the GwBoundIps field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetGwBoundIps() []string {
	if o == nil || o.GwBoundIps == nil {
		var ret []string
		return ret
	}
	return *o.GwBoundIps
}

// GetGwBoundIpsOk returns a tuple with the GwBoundIps field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetGwBoundIpsOk() (*[]string, bool) {
	if o == nil || o.GwBoundIps == nil {
		return nil, false
	}
	return o.GwBoundIps, true
}

// HasGwBoundIps returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasGwBoundIps() bool {
	if o != nil && o.GwBoundIps != nil {
		return true
	}

	return false
}

// SetGwBoundIps gets a reference to the given []string and assigns it to the GwBoundIps field.
func (o *CreateAuthMethodK8S) SetGwBoundIps(v []string) {
	o.GwBoundIps = &v
}

// GetJson returns the Json field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetJson() bool {
	if o == nil || o.Json == nil {
		var ret bool
		return ret
	}
	return *o.Json
}

// GetJsonOk returns a tuple with the Json field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetJsonOk() (*bool, bool) {
	if o == nil || o.Json == nil {
		return nil, false
	}
	return o.Json, true
}

// HasJson returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasJson() bool {
	if o != nil && o.Json != nil {
		return true
	}

	return false
}

// SetJson gets a reference to the given bool and assigns it to the Json field.
func (o *CreateAuthMethodK8S) SetJson(v bool) {
	o.Json = &v
}

// GetJwtTtl returns the JwtTtl field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetJwtTtl() int64 {
	if o == nil || o.JwtTtl == nil {
		var ret int64
		return ret
	}
	return *o.JwtTtl
}

// GetJwtTtlOk returns a tuple with the JwtTtl field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetJwtTtlOk() (*int64, bool) {
	if o == nil || o.JwtTtl == nil {
		return nil, false
	}
	return o.JwtTtl, true
}

// HasJwtTtl returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasJwtTtl() bool {
	if o != nil && o.JwtTtl != nil {
		return true
	}

	return false
}

// SetJwtTtl gets a reference to the given int64 and assigns it to the JwtTtl field.
func (o *CreateAuthMethodK8S) SetJwtTtl(v int64) {
	o.JwtTtl = &v
}

// GetName returns the Name field value
func (o *CreateAuthMethodK8S) GetName() string {
	if o == nil  {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetNameOk() (*string, bool) {
	if o == nil  {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateAuthMethodK8S) SetName(v string) {
	o.Name = v
}

// GetProductType returns the ProductType field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetProductType() []string {
	if o == nil || o.ProductType == nil {
		var ret []string
		return ret
	}
	return *o.ProductType
}

// GetProductTypeOk returns a tuple with the ProductType field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetProductTypeOk() (*[]string, bool) {
	if o == nil || o.ProductType == nil {
		return nil, false
	}
	return o.ProductType, true
}

// HasProductType returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasProductType() bool {
	if o != nil && o.ProductType != nil {
		return true
	}

	return false
}

// SetProductType gets a reference to the given []string and assigns it to the ProductType field.
func (o *CreateAuthMethodK8S) SetProductType(v []string) {
	o.ProductType = &v
}

// GetPublicKey returns the PublicKey field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetPublicKey() string {
	if o == nil || o.PublicKey == nil {
		var ret string
		return ret
	}
	return *o.PublicKey
}

// GetPublicKeyOk returns a tuple with the PublicKey field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetPublicKeyOk() (*string, bool) {
	if o == nil || o.PublicKey == nil {
		return nil, false
	}
	return o.PublicKey, true
}

// HasPublicKey returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasPublicKey() bool {
	if o != nil && o.PublicKey != nil {
		return true
	}

	return false
}

// SetPublicKey gets a reference to the given string and assigns it to the PublicKey field.
func (o *CreateAuthMethodK8S) SetPublicKey(v string) {
	o.PublicKey = &v
}

// GetToken returns the Token field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetToken() string {
	if o == nil || o.Token == nil {
		var ret string
		return ret
	}
	return *o.Token
}

// GetTokenOk returns a tuple with the Token field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetTokenOk() (*string, bool) {
	if o == nil || o.Token == nil {
		return nil, false
	}
	return o.Token, true
}

// HasToken returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasToken() bool {
	if o != nil && o.Token != nil {
		return true
	}

	return false
}

// SetToken gets a reference to the given string and assigns it to the Token field.
func (o *CreateAuthMethodK8S) SetToken(v string) {
	o.Token = &v
}

// GetUidToken returns the UidToken field value if set, zero value otherwise.
func (o *CreateAuthMethodK8S) GetUidToken() string {
	if o == nil || o.UidToken == nil {
		var ret string
		return ret
	}
	return *o.UidToken
}

// GetUidTokenOk returns a tuple with the UidToken field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CreateAuthMethodK8S) GetUidTokenOk() (*string, bool) {
	if o == nil || o.UidToken == nil {
		return nil, false
	}
	return o.UidToken, true
}

// HasUidToken returns a boolean if a field has been set.
func (o *CreateAuthMethodK8S) HasUidToken() bool {
	if o != nil && o.UidToken != nil {
		return true
	}

	return false
}

// SetUidToken gets a reference to the given string and assigns it to the UidToken field.
func (o *CreateAuthMethodK8S) SetUidToken(v string) {
	o.UidToken = &v
}

func (o CreateAuthMethodK8S) MarshalJSON() ([]byte, error) {
	toSerialize := map[string]interface{}{}
	if o.AccessExpires != nil {
		toSerialize["access-expires"] = o.AccessExpires
	}
	if o.Audience != nil {
		toSerialize["audience"] = o.Audience
	}
	if o.AuditLogsClaims != nil {
		toSerialize["audit-logs-claims"] = o.AuditLogsClaims
	}
	if o.BoundIps != nil {
		toSerialize["bound-ips"] = o.BoundIps
	}
	if o.BoundNamespaces != nil {
		toSerialize["bound-namespaces"] = o.BoundNamespaces
	}
	if o.BoundPodNames != nil {
		toSerialize["bound-pod-names"] = o.BoundPodNames
	}
	if o.BoundSaNames != nil {
		toSerialize["bound-sa-names"] = o.BoundSaNames
	}
	if o.DeleteProtection != nil {
		toSerialize["delete_protection"] = o.DeleteProtection
	}
	if o.Description != nil {
		toSerialize["description"] = o.Description
	}
	if o.ForceSubClaims != nil {
		toSerialize["force-sub-claims"] = o.ForceSubClaims
	}
	if o.GenKey != nil {
		toSerialize["gen-key"] = o.GenKey
	}
	if o.GwBoundIps != nil {
		toSerialize["gw-bound-ips"] = o.GwBoundIps
	}
	if o.Json != nil {
		toSerialize["json"] = o.Json
	}
	if o.JwtTtl != nil {
		toSerialize["jwt-ttl"] = o.JwtTtl
	}
	if true {
		toSerialize["name"] = o.Name
	}
	if o.ProductType != nil {
		toSerialize["product-type"] = o.ProductType
	}
	if o.PublicKey != nil {
		toSerialize["public-key"] = o.PublicKey
	}
	if o.Token != nil {
		toSerialize["token"] = o.Token
	}
	if o.UidToken != nil {
		toSerialize["uid-token"] = o.UidToken
	}
	return json.Marshal(toSerialize)
}

type NullableCreateAuthMethodK8S struct {
	value *CreateAuthMethodK8S
	isSet bool
}

func (v NullableCreateAuthMethodK8S) Get() *CreateAuthMethodK8S {
	return v.value
}

func (v *NullableCreateAuthMethodK8S) Set(val *CreateAuthMethodK8S) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateAuthMethodK8S) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateAuthMethodK8S) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateAuthMethodK8S(val *CreateAuthMethodK8S) *NullableCreateAuthMethodK8S {
	return &NullableCreateAuthMethodK8S{value: val, isSet: true}
}

func (v NullableCreateAuthMethodK8S) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateAuthMethodK8S) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}


