/**
 * Go SDK for OpenFGA
 *
 * API version: 1.x
 * Website: https://openfga.dev
 * Documentation: https://openfga.dev/docs
 * Support: https://openfga.dev/community
 * License: [Apache-2.0](https://github.com/openfga/go-sdk/blob/main/LICENSE)
 *
 * NOTE: This file was auto generated by OpenAPI Generator (https://openapi-generator.tech). DO NOT EDIT.
 */

package openfga

import (
	"encoding/json"
	"fmt"
)

// TypeName the model 'TypeName'
type TypeName string

// List of TypeName
const (
	TYPENAME_UNSPECIFIED TypeName = "TYPE_NAME_UNSPECIFIED"
	TYPENAME_ANY         TypeName = "TYPE_NAME_ANY"
	TYPENAME_BOOL        TypeName = "TYPE_NAME_BOOL"
	TYPENAME_STRING      TypeName = "TYPE_NAME_STRING"
	TYPENAME_INT         TypeName = "TYPE_NAME_INT"
	TYPENAME_UINT        TypeName = "TYPE_NAME_UINT"
	TYPENAME_DOUBLE      TypeName = "TYPE_NAME_DOUBLE"
	TYPENAME_DURATION    TypeName = "TYPE_NAME_DURATION"
	TYPENAME_TIMESTAMP   TypeName = "TYPE_NAME_TIMESTAMP"
	TYPENAME_MAP         TypeName = "TYPE_NAME_MAP"
	TYPENAME_LIST        TypeName = "TYPE_NAME_LIST"
	TYPENAME_IPADDRESS   TypeName = "TYPE_NAME_IPADDRESS"
)

var allowedTypeNameEnumValues = []TypeName{
	"TYPE_NAME_UNSPECIFIED",
	"TYPE_NAME_ANY",
	"TYPE_NAME_BOOL",
	"TYPE_NAME_STRING",
	"TYPE_NAME_INT",
	"TYPE_NAME_UINT",
	"TYPE_NAME_DOUBLE",
	"TYPE_NAME_DURATION",
	"TYPE_NAME_TIMESTAMP",
	"TYPE_NAME_MAP",
	"TYPE_NAME_LIST",
	"TYPE_NAME_IPADDRESS",
}

func (v *TypeName) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := TypeName(value)
	for _, existing := range allowedTypeNameEnumValues {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid TypeName", value)
}

// NewTypeNameFromValue returns a pointer to a valid TypeName
// for the value passed as argument, or an error if the value passed is not allowed by the enum
func NewTypeNameFromValue(v string) (*TypeName, error) {
	ev := TypeName(v)
	if ev.IsValid() {
		return &ev, nil
	} else {
		return nil, fmt.Errorf("invalid value '%v' for TypeName: valid values are %v", v, allowedTypeNameEnumValues)
	}
}

// IsValid return true if the value is valid for the enum, false otherwise
func (v TypeName) IsValid() bool {
	for _, existing := range allowedTypeNameEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to TypeName value
func (v TypeName) Ptr() *TypeName {
	return &v
}

type NullableTypeName struct {
	value *TypeName
	isSet bool
}

func (v NullableTypeName) Get() *TypeName {
	return v.value
}

func (v *NullableTypeName) Set(val *TypeName) {
	v.value = val
	v.isSet = true
}

func (v NullableTypeName) IsSet() bool {
	return v.isSet
}

func (v *NullableTypeName) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableTypeName(val *TypeName) *NullableTypeName {
	return &NullableTypeName{value: val, isSet: true}
}

func (v NullableTypeName) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableTypeName) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
