/*
 * This program source code file is part of KiCad, a free EDA CAD application.
 *
 * Copyright (C) 2022 Mikolaj Wielgus
 * Copyright The KiCad Developers, see AUTHORS.TXT for contributors.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, you may find one here:
 * http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 * or you may search the http://www.gnu.org website for the version 2 license,
 * or you may write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 */

#include <sim/sim_model_ngspice.h>


void NGSPICE_MODEL_INFO_MAP::addB4SOI()
{
    modelInfos[MODEL_TYPE::B4SOI] = { "B4SOI", "NMOS", "PMOS", { "D", "G", "S", "B" }, "Berkeley SOI MOSFET model version 4.4.0", {}, {} };
    // Model parameters
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mtrlmod",  100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for non-silicon substrate or metal gate selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgstcvmod",  1224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Improved VgsteffCV selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gidlmod",  77, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for GIDL selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "iiimod",  4000, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "parameter for III selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "eot",  97, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Effective SiO2 thickness" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "epsrox",  98, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "3.9", "3.9", "Dielectric constant of the gate oxide relative to vacuum" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "epsrsub",  99, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of substrate relative to vacuum" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ni0sub",  87, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.45e+10", "1.45e+10", "Intrinsic carrier concentration of substrate at Tnom" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bg0sub",  86, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.16", "1.16", "Band-gap of substrate at T=0K" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tbgasub",  85, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0.000702", "0.000702", "First parameter of band-gap change due to temperature" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tbgbsub",  84, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1108", "1108", "Second parameter of band-gap change due to temperature" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "phig",  82, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Work function of gate" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "easub",  83, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "4.05", "4.05", "Electron affinity of substrate" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "leffeot",  91, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Effective length for extraction of EOT" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "weffeot",  92, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Effective width for extraction of EOT" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vddeot",  93, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1.5", "-1.5", "Voltage for extraction of EOT" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tempeot",  94, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Temperature for extraction of EOT" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ados",  89, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bdos",  90, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Charge centroid parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "epsrgate",  88, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "11.7", "11.7", "Dielectric constant of gate relative to vacuum" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "capmod",  101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2", "2", "Capacitance model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mobmod",  103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Mobility model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paramchk",  192, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Model parameter checking selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "binunit",  125, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Bin  unit  selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "version",  193, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "4.4", "4.4", "parameter for model version" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tox",  107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxp",  95, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Physical gate oxide thickness" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxm",  962, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Gate oxide thickness used in extraction" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dtoxcv",  847, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta oxide thickness in meters in CapMod3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdsc",  108, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.00024", "0.00024", "Drain/Source and channel coupling capacitance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdscb",  109, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdscd",  181, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain-bias dependence of cdsc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cit",  110, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Interface state capacitance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nfactor",  111, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Subthreshold swing Coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsat",  113, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "80000", "80000", "Saturation velocity at tnom" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "at",  114, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "33000", "33000", "Temperature coefficient of vsat" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "a0",  115, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-uniform depletion width effect coefficient." );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ags",  182, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate bias  coefficient of Abulk." );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "a1",  116, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "a2",  117, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Non-saturation effect coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "keta",  118, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.6", "-0.6", "Body-bias coefficient of non-uniform depletion width effect." );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nsub",  119, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/cm³", SIM_MODEL::PARAM::CATEGORY::DC, "6e+16", "6e+16", "Substrate doping concentration with polarity" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nch",  120, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.7e+17", "1.7e+17", "Channel doping concentration" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ngate",  121, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Poly-gate doping concentration" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nsd",  81, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+20", "1e+20", "S/D doping concentration" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gamma1",  122, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gamma2",  123, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth body coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbx",  124, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vth transition body Voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbm",  126, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-3", "-3", "Maximum body voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xt",  127, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.55e-07", "1.55e-07", "Doping depth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1",  129, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "sqrt V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kt1",  130, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.11", "-0.11", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kt1l",  131, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Vth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kt2",  133, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.022", "0.022", "Body-coefficient of kt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k2",  132, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bulk effect coefficient 2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k3",  134, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow width effect coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k3b",  135, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body effect coefficient of k3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "w0",  136, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-06", "2.5e-06", "Narrow width effect parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpe0",  137, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.74e-07", "1.74e-07", "Lateral non-uniform doping effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpeb",  604, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Lateral non-uniform doping effect for body bias" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt0",  138, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.2", "2.2", "Short channel effect coeff. 0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt1",  139, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.53", "0.53", "Short channel effect coeff. 1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt2",  140, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Short channel effect coeff. 2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt0w",  141, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Narrow Width coeff. 0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt1w",  142, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "5.3e+06", "5.3e+06", "Narrow Width effect coeff. 1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvt2w",  143, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "-0.032", "-0.032", "Narrow Width effect coeff. 2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "drout",  144, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient of output resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dsub",  145, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.56", "0.56", "DIBL coefficient in the subthreshold region" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vth0",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.7", "-0.7", "Threshold voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vtho",  146, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0.7", "-0.7", "n.a." );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vfb",  1201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-1", "-1", "Flat Band Voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ua",  147, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.25e-09", "2.25e-09", "Linear gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ua1",  148, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "4.31e-09", "4.31e-09", "Temperature coefficient of ua" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ub",  149, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "5.87e-19", "5.87e-19", "Quadratic gate dependence of mobility" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ub1",  150, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-7.61e-18", "-7.61e-18", "Temperature coefficient of ub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "uc",  151, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-4.65e-11", "-4.65e-11", "Body-bias dependence of mobility" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "uc1",  152, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-5.6e-11", "-5.6e-11", "Temperature coefficient of uc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "u0",  153, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.067", "0.025", "Low-field mobility at Tnom" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "eu",  3500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Mobility exponent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ute",  154, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-1.5", "-1.5", "Temperature coefficient of mobility" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ucs",  3504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.67", "1", "Mobility exponent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ucste",  3508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "-0.004775", "-0.004775", "Temperature coefficient of UCS" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ud",  3400, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Coulomb scattering factor of mobility" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ud1",  3404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of ud" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "voff",  155, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "-0.08", "-0.08", "Threshold voltage offset" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnom",  701, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "300.15", "300.15", "Parameter measurement temperature" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgso",  702, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-source overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgdo",  703, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "2.07188e-10", "2.07188e-10", "Gate-drain overlap capacitance per width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xpart",  705, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel charge partitioning" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "delta",  156, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.01", "0.01", "Effective Vds parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rsh",  706, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source-drain sheet resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdsw",  157, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "100", "100", "Source-drain resistance per width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rsw",  677, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Source resistance per width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdw",  673, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Drain resistance per width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rswmin",  682, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Source resistance per width at high Vg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdwmin",  681, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Drain resistance per width at hight Vg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prwg",  179, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate-bias effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prwb",  180, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on parasitic resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prt",  158, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of parasitic resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "eta0",  161, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.08", "0.08", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "etab",  162, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "-0.07", "-0.07", "Subthreshold region DIBL coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pclm",  163, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "1/V", SIM_MODEL::PARAM::CATEGORY::DC, "1.3", "1.3", "Channel length modulation Coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdiblc1",  164, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.39", "0.39", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdiblc2",  165, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.0086", "0.0086", "Drain-induced barrier lowering coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdiblcb",  178, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body-effect on drain-induced barrier lowering" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvag",  168, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate dependence of output resistance parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "shmod",  105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Self heating mode selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tbox",  195, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "3e-07", "3e-07", "Back gate oxide thickness in meters" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tsi",  196, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Silicon-on-insulator thickness in meters" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "etsi",  96, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-07", "1e-07", "Effective Silicon-on-insulator thickness in meters" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xj",  112, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Junction Depth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rth0_",  208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Self-heating thermal resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cth0_",  209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Self-heating thermal capacitance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cfrcoeff",  394, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Fringe Cap parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "egidl",  215, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "GIDL first parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "agidl",  216, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL second parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bgidl",  217, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "GIDL third parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgidl",  600, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "GIDL vb parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rgidl",  76, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GIDL vg parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kgidl",  72, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL vb parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fgidl",  68, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GIDL vb parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "egisl",  2500, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "GISL first parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "agisl",  2501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL second parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bgisl",  2502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2.3e+09", "2.3e+09", "GISL third parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgisl",  2503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "GISL vb parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rgisl",  2504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "GISL vg parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kgisl",  2505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL vb parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fgisl",  2506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "GISL vb parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ndiode",  218, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ndioded",  633, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Diode non-ideality factor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xbjt",  226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xdif",  870, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrec",  871, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Isrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xtun",  872, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Istun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xdifd",  873, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Iddif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrecd",  874, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "1", "1", "Temperature coefficient for Idrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xtund",  875, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Idtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbswg",  860, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Source(gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbswgd",  991, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.7", "0.7", "Drain(gate side) sidewall junction capacitance built in potential" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mjswg",  861, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Source (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mjswgd",  989, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.5", "0.5", "Drain (gate side) sidewall junction capacitance grading coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cjswg",  862, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Source(gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cjswgd",  990, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-10", "1e-10", "Drain (gate side) sidewall junction capacitance per unit width" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lint",  819, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ll",  820, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llc",  842, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lln",  821, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lw",  822, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwc",  843, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwn",  823, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwl",  824, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwlc",  841, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wr",  169, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width dependence of rds" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wint",  827, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwg",  170, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwb",  171, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wl",  828, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlc",  845, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wln",  829, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ww",  830, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwc",  846, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwn",  831, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwl",  832, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwlc",  844, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width reduction parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "b0",  172, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "b1",  173, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Abulk narrow width parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgsl",  186, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgdl",  187, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ckappa",  188, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.6", "0.6", "New C-V model parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cf",  189, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "8.16367e-11", "8.16367e-11", "Fringe capacitance parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "clc",  190, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cle",  191, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vdsat parameter for C-V model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwc",  848, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta W for C-V model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlc",  849, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for C-V model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "alpha0",  174, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "substrate current model parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noia",  816, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "6.25e+41", "6.188e+40", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noib",  817, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "3.125e+26", "1.5e+25", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noic",  818, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "8.75e+09", "8.75e+09", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fnoimod",  956, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnoimod",  957, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Thermal noise model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnoia",  951, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1.5", "1.5", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tnoib",  952, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "3.5", "3.5", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rnoia",  953, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.577", "0.577", "Thermal noise coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rnoib",  954, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0.37", "0.37", "Thermal noise coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntnoi",  955, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Thermal noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "saref",  965, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance between OD edge to poly of one side" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sbref",  966, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "Reference distance between OD edge to poly of the other side" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlod",  981, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for stress effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ku0",  967, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Mobility degradation/enhancement coefficient for LOD" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kvsat",  968, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m/s", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Saturation velocity degradation/enhancement parameter for LOD" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kvth0",  977, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold degradation/enhancement parameter for LOD" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tku0",  969, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of KU0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llodku0",  970, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length parameter for u0 LOD effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlodku0",  971, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for u0 LOD effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llodvth",  972, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length parameter for vth LOD effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlodvth",  973, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width parameter for vth LOD effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lku0",  974, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ku0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wku0",  975, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ku0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pku0",  976, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ku0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkvth0",  978, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kvth0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkvth0",  979, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kvth0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkvth0",  980, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kvth0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "stk2",  982, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "K2 shift factor related to stress effect on vth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lodk2",  983, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "K2 shift modification factor for stress effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "steta0",  984, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "eta0 shift factor related to stress effect on vth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lodeta0",  985, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "eta0 shift modification factor for stress effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "gbmin",  986, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-12", "1e-12", "Minimum body conductance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbdb_",  987, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and dbNode" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbsb_",  988, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::DC, "50", "50", "Resistance between bNode and sbNode" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bf",  597, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "2", "2", "Flicker noise length dependence exponent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "w0flk",  598, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::NOISE, "1e-05", "1e-05", "Flicker noise width dependence" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "frbody_",  599, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Layout dependent rbody multiplier" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp0",  608, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp0",  609, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp0",  610, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp0",  611, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp1",  612, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp1",  613, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp1",  614, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp1",  615, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp2",  687, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp2",  688, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp2",  689, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp2",  690, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp3",  691, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp3",  692, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp3",  693, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp3",  694, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvtp4",  695, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Forth parameter for Vth shift due to pocket" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvtp4",  696, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvtp4" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvtp4",  697, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvtp4" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvtp4",  698, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvtp4" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "minv",  616, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "For moderate invversion in Vgsteff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lminv",  617, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wminv",  618, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "width dependence of minv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pminv",  619, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of minv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdits",  624, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e-20", "1e-20", "Coefficient for drain-induced Vth shifts" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pditsl",  632, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drain-induced Vth shifts" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pditsd",  628, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependence of drain-induced Vth shifts" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fprout",  620, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Rout degradation coefficient for pocket devices" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfprout",  621, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdits",  625, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdits" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpditsd",  629, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pditsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfprout",  622, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdits",  626, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdits" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpditsd",  630, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pditsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfprout",  623, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdits",  627, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdits" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppditsd",  631, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pditsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "em",  592, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "4.1e+07", "4.1e+07", "Flicker noise parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ef",  593, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise frequency exponent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "af",  594, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Flicker noise exponent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kf",  595, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "0", "0", "Flicker noise coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noif",  596, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::NOISE, "1", "1", "Floating body excess noise ideality factor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1w1",  239, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First Body effect width dependent parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1w2",  240, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second Boby effect width dependent parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ketas",  241, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Surface potential adjustment for bulk charge effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dwbc",  242, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width offset for body contact isolation edge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "beta0",  243, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "First Vds dependent parameter of impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "beta1",  244, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Second Vds dependent parameter of impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "beta2",  245, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Third Vds dependent parameter of impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vdsatii0",  246, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.9", "0.9", "Nominal drain saturation voltage at threshold for impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tii",  247, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature dependent parameter for impact ionizition" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lii",  248, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length dependent parameter at threshold for impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sii0",  249, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "First Vgs dependent parameter for impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sii1",  250, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Second Vgs dependent parameter for impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "sii2",  251, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Third Vgs dependent parameter for impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "siid",  252, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vds dependent parameter of drain saturation voltage for impact ionizition current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fbjtii",  253, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Fraction of bipolar current affecting the impact ionization" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ebjtii",  4002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Impact ionization parameter for BJT part" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cbjtii",  4003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length scaling parameter for II BJT part" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbci",  4004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Internal B-C built-in potential" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "abjtii",  4005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Exponent factor for avalanche current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "mbjtii",  4006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.4", "0.4", "Internal B-C grading coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tvbci",  4001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for VBCI" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "esatii",  238, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1e+07", "1e+07", "Saturation electric field for impact ionization" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntun",  221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntund",  669, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Reverse tunneling non-ideality factor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecf0",  255, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Recombination non-ideality factor at forward bias" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecf0d",  653, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "2", "2", "Recombination non-ideality factor at forward bias" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecr0",  256, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Recombination non-ideality factor at reversed bias" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nrecr0d",  657, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Recombination non-ideality factor at reversed bias" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "isbjt",  222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT injection saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "idbjt",  641, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-06", "1e-06", "BJT injection saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "isdif",  223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to source/drain injection saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "iddif",  637, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body to source/drain injection saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "isrec",  224, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "idrec",  645, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1e-05", "1e-05", "Recombination in depletion saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "istun",  225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse tunneling saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "idtun",  649, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Reverse tunneling saturation current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ln",  257, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-06", "2e-06", "Electron/hole diffusion length" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vrec0",  258, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for recombination current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vrec0d",  661, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for recombination current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vtun0",  259, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for tunneling current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vtun0d",  665, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Voltage dependent parameter for tunneling current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nbjt",  260, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Power coefficient of channel length dependency for bipolar current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbjt0",  261, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2e-07", "2e-07", "Refferenc channel length for bipolar cuurent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldif0",  276, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Channel-length dependency coefficient of diffusion cap" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vabjt",  262, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "10", "10", "Early voltage for bipolar current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aely",  263, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Channel length dependency of early voltage for bipolar cuurent" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ahli",  264, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High level injection parameter for bipolar current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ahlid",  683, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "High level injection parameter for bipolar current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbody",  204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Intrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbsh",  237, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Extrinsic body contact sheet resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cgeo",  704, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Gate substrate overlap capacitance per unit channel length" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tt",  232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "1e-12", "1e-12", "Diffusion capacitance transit time coefficient" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ndif",  269, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "-1", "-1", "Power coefficient of channel length dependency for diffusion capacitance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsdfb",  234, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain bottom diffusion capacitance flatband voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsdth",  233, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain bottom diffusion capacitance threshold voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "csdmin",  236, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0.000100544", "0.000100544", "Source/drain bottom diffusion minimum capacitance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "asd",  235, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.3", "0.3", "Source/drain bottom diffusion smoothing parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "csdesw",  863, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F/m", SIM_MODEL::PARAM::CATEGORY::CAPACITANCE, "0", "0", "Source/drain sidewall fringing capacitance per unit length" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntrecf",  265, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Nrecf" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntrecr",  266, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient for Nrecr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlcb",  267, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length offset fitting parameter for body charge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fbody",  268, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Scaling factor for body charge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tcjswg",  894, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Cjswgs" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tpbswg",  895, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Pbswgs" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tcjswgd",  896, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Cjswgd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "tpbswgd",  897, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "°C", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Temperature coefficient of Pbswgd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "acde",  272, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Exponential coefficient for charge thickness in capMod=3 for accumulation and depletion regions" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "moin",  273, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "15", "15", "Coefficient for the gate-bias dependent surface potential" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "noff",  958, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "C-V turn-on/off parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "delvt",  274, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Threshold voltage adjust for CV" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "kb1",  197, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Scaling factor for backgate charge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlbg",  275, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length offset fitting parameter for backgate charge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "igmod",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate-body tunneling current model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "igbmod",  291, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "n.a." );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "igcmod",  294, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "gate-channel tunneling current model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxqm",  290, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "1e-08", "1e-08", "effective oxide thickness considering quantum effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wth0",  277, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::TEMPERATURE, "0", "0", "Minimum width for thermal resistance calculation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rhalo",  278, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "1e+15", "1e+15", "body halo sheet resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ntox",  279, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "power term of gate current" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "toxref",  280, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "2.5e-09", "2.5e-09", "target oxide thickness" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ebg",  281, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "1.2", "1.2", "effective bandgap in gate current calcula." );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vevb",  282, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.075", "Vaux parameter for valence-band electron tunneling" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "alphagb1",  283, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.35", "0.35", "First Vox dependent parameter for gate current in inversion" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "betagb1",  284, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.03", "0.03", "Second Vox dependent parameter for gate current in inversion" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgb1",  285, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "300", "300", "Third Vox dependent parameter for gate current in inversion" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vecb",  286, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.026", "0.026", "Vaux parameter for conduction-band electron tunneling" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "alphagb2",  287, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.43", "First Vox dependent parameter for gate current in accumulation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "betagb2",  288, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.05", "0.05", "Second Vox dependent parameter for gate current in accumulation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgb2",  289, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "17", "17", "Third Vox dependent parameter for gate current in accumulation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aigbcp2",  10001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.043", "0.043", "First Vgp dependent parameter for gate current in accumulation in AGBCP2 region" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bigbcp2",  10005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.0054", "0.0054", "Second Vgp dependent parameter for gate current in accumulation in AGBCP2 region" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cigbcp2",  10009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "0.0075", "0.0075", "Third Vgp dependent parameter for gate current in accumulation in AGBCP2 region" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "voxh",  292, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "A", SIM_MODEL::PARAM::CATEGORY::DC, "5", "5", "the limit of Vox in gate current calculation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "deltavox",  293, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.005", "0.005", "the smoothing parameter in the Vox smoothing function" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aigc",  1021, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.31", "Parameter for Igc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bigc",  1022, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.054", "0.024", "Parameter for Igc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cigc",  1023, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "aigsd",  1024, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.43", "0.31", "Parameter for Igs,d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "bigsd",  1025, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.054", "0.024", "Parameter for Igs,d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cigsd",  1026, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0.075", "0.03", "Parameter for Igs,d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nigc",  1027, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc slope" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pigcd",  1028, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Parameter for Igc partition" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "poxedge",  1029, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Factor for the gate edge Tox" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dlcig",  1030, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Delta L for Ig model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "soimod_",  1001, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "model selector for SOI technology" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbs0pd",  963, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Upper bound of built-in potential lowering for PD operation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbs0fd",  964, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0.5", "0.5", "Lower bound of built-in potential lowering for FD operation" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbsa",  1002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Vbs0t offset voltage" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nofffd",  1003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "smoothing parameter in FD module" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vofffd",  1004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "smoothing parameter in FD module" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k1b",  1005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "first backgate body effect parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "k2b",  1006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "second backgate body effect parameter for short channel effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dk2b",  1007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "third backgate body effect parameter for short channel effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvbd0",  1008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "first short-channel effect parameter in FD module" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "dvbd1",  1009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "second short-channel effect parameter in FD module" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "moinfd",  1010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "1000", "1000", "Coefficient for the gate-bias dependent surface potential in FD" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rgatemod_",  295, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Gate R model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrcrg1",  296, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "12", "12", "First fitting parameter the bias-dependent Rg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xrcrg2",  297, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Second fitting parameter the bias-dependent Rg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rshg",  298, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω/m", SIM_MODEL::PARAM::CATEGORY::DC, "0.1", "0.1", "Gate sheet resistance" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ngcon",  299, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "1", "1", "Number of gate contacts" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xgw",  392, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Distance from gate contact center to device edge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "xgl",  393, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Variation in Ldrawn" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rbodymod_",  300, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Body R model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "rdsmod",  104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Bias-dependent S/D resistance model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "fdmod",  1221, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Improved dVbi model selector" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vsce",  1222, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "SCE parameter for improved dVbi model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "cdsbs",  1223, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "coupling from Vd to Vbs for improved dVbi model" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "minvcv",  1225, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "For moderate invversion in VgsteffCV" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lminvcv",  1226, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of minvcv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wminvcv",  1227, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "width dependence of minvcv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pminvcv",  1228, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of minvcv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "voffcv",  1229, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "CV Threshold voltage offset" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvoffcv",  1230, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voffcv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvoffcv",  1231, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voffcv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvoffcv",  1232, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voffcv" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxj",  1061, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xj" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lalphagb1",  1062, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alphagb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbetagb1",  1064, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of betagb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lalphagb2",  1063, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alphagb2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbetagb2",  1065, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of betagb2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laigbcp2",  10002, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbigbcp2",  10006, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcigbcp2",  10010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgsl",  1074, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgsl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgdl",  1073, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgdl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lckappa",  1075, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ckappa" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lndif",  1066, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lute",  1078, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ute" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkt1",  1079, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkt1l",  1081, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt1l" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkt2",  1080, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kt2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lua1",  1082, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lub1",  1083, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "luc1",  1084, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lat",  1085, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of at" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lprt",  1086, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntrecf",  1067, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntrecf" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntrecr",  1068, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntrecr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxbjt",  1069, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxdif",  876, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrec",  877, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxtun",  878, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxdifd",  879, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xdifd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrecd",  880, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xrecd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxtund",  881, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of xtund" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laigc",  1031, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbigc",  1032, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcigc",  1033, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laigsd",  1034, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbigsd",  1035, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcigsd",  1036, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnigc",  1037, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpigcd",  1038, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for pigcd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpoxedge",  1039, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence for poxedge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnch",  301, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnsub",  302, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lngate",  303, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ngate" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnsd",  80, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvth0",  304, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vth0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvfb",  1202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vfb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk1",  305, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk1w1",  306, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1w1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk1w2",  307, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k1w2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk2",  308, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk3",  309, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lk3b",  310, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of k3b" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkb1",  311, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lw0",  312, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of w0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llpe0",  313, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpe0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llpeb",  605, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lpeb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt0",  314, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt1",  315, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt2",  316, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt0w",  317, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt1w",  318, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldvt2w",  319, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lu0",  320, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of u0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "leu",  3501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eu" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lua",  321, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ua" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lub",  322, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "luc",  323, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of uc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lud",  3401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lud1",  3405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ud1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lucste",  3509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ucste" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lucs",  3505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lucs" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvsat",  324, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsat" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "la0",  325, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lags",  326, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ags" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lb0",  327, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lb1",  328, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of b1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lketa",  329, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of keta" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lketas",  330, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ketas" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "la1",  331, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "la2",  332, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of a2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrdsw",  333, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdsw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrsw",  678, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rsw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrdw",  674, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rdw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lprwb",  334, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lprwg",  335, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of prwg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lwr",  336, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of wr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnfactor",  337, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nfactor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldwg",  338, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldwb",  339, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dwb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvoff",  340, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of voff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "leta0",  341, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of eta0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "letab",  342, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of etab" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldsub",  343, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of dsub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcit",  344, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cit" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcdsc",  345, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdsc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcdscb",  346, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcdscd",  347, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cdscd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpclm",  348, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pclm" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdiblc1",  349, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdiblc2",  350, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpdiblcb",  351, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldrout",  352, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of drout" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lpvag",  353, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of pvag" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldelta",  354, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delta" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lalpha0",  355, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of alpha0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfbjtii",  356, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "labjtii",  4010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of abjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcbjtii",  4008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lebjtii",  4007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ebjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lmbjtii",  4011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of mbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvbci",  4009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vbci" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbeta0",  357, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbeta1",  358, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbeta2",  359, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of beta2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvdsatii0",  360, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vdsatii0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llii",  361, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lesatii",  362, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of esatii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsii0",  363, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsii1",  364, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsii2",  365, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of sii2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lsiid",  366, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of siid" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lagidl",  367, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbgidl",  368, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgidl",  601, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "legidl",  369, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrgidl",  75, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkgidl",  71, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfgidl",  67, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lagisl",  2510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of agisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lbgisl",  2513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of bgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lcgisl",  2516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of cgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "legisl",  2507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of egisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lrgisl",  2519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of rgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lkgisl",  2522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of kgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lfgisl",  2525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of fgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntun",  370, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lntund",  670, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ntund" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lndiode",  371, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndiode" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lndioded",  634, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ndioded" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecf0",  372, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecf0d",  654, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecf0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecr0",  373, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnrecr0d",  658, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nrecr0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lisbjt",  374, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lidbjt",  642, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of idbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lisdif",  375, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "liddif",  638, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of iddif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lisrec",  376, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of isrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lidrec",  646, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of idrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "listun",  377, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of istun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lidtun",  650, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of idtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvrec0",  378, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vrec0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvrec0d",  662, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vrec0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvtun0",  379, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtun0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvtun0d",  666, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vtun0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnbjt",  380, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of nbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "llbjt0",  381, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of lbjt0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvabjt",  382, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vabjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "laely",  383, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of aely" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lahli",  384, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ahli" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lahlid",  684, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of ahlid" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvsdfb",  385, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lvsdth",  386, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of vsdth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ldelvt",  387, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of delvt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lacde",  388, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of acde" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lmoin",  389, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of moin" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnoff",  959, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Length dependence of noff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrcrg1",  390, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of xrcrg1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lxrcrg2",  391, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of xrcrg2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxj",  1091, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xj" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "walphagb1",  1092, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alphagb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbetagb1",  1094, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of betagb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "walphagb2",  1093, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alphagb2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbetagb2",  1095, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of betagb2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waigbcp2",  10003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbigbcp2",  10007, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcigbcp2",  10011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgsl",  2004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgsl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgdl",  2003, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgdl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wckappa",  2005, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ckappa" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wndif",  1096, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wute",  2008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ute" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkt1",  2009, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkt1l",  2011, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt1l" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkt2",  2010, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kt2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wua1",  2012, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wub1",  2013, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wuc1",  2014, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wat",  2015, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of at" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wprt",  2016, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntrecf",  1097, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntrecf" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntrecr",  1098, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntrecr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxbjt",  1099, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxdif",  882, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrec",  883, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxtun",  884, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxdifd",  885, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xdifd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrecd",  886, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xrecd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxtund",  887, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of xtund" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waigc",  1041, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbigc",  1042, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcigc",  1043, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waigsd",  1044, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbigsd",  1045, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcigsd",  1046, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnigc",  1047, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpigcd",  1048, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for pigcd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpoxedge",  1049, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence for poxedge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnch",  401, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnsub",  402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wngate",  403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ngate" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnsd",  79, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvth0",  404, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vth0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvfb",  1203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vfb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk1",  405, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk1w1",  406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1w1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk1w2",  407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k1w2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk2",  408, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk3",  409, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wk3b",  410, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of k3b" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkb1",  411, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ww0",  412, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of w0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlpe0",  413, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpe0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlpeb",  606, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lpeb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt0",  414, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt1",  415, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt2",  416, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt0w",  417, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt1w",  418, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdvt2w",  419, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wu0",  420, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of u0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "weu",  3502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eu" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wua",  421, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ua" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wub",  422, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wuc",  423, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of uc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wud",  3402, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wud1",  3406, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ud1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wucste",  3510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucste" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wucs",  3506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ucs" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvsat",  424, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsat" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wa0",  425, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wags",  426, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ags" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wb0",  427, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wb1",  428, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of b1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wketa",  429, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of keta" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wketas",  430, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ketas" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wa1",  431, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wa2",  432, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of a2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrdsw",  433, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdsw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrsw",  679, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rsw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrdw",  675, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rdw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wprwb",  434, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wprwg",  435, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of prwg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wwr",  436, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of wr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnfactor",  437, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nfactor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdwg",  438, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdwb",  439, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dwb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvoff",  440, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of voff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "weta0",  441, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of eta0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wetab",  442, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of etab" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdsub",  443, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of dsub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcit",  444, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cit" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcdsc",  445, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdsc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcdscb",  446, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcdscd",  447, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cdscd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpclm",  448, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pclm" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdiblc1",  449, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdiblc2",  450, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpdiblcb",  451, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdrout",  452, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of drout" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wpvag",  453, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of pvag" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdelta",  454, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delta" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "walpha0",  455, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of alpha0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfbjtii",  456, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wabjtii",  4015, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of abjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcbjtii",  4013, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "webjtii",  4012, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ebjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wmbjtii",  4016, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of mbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvbci",  4014, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vbci" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbeta0",  457, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbeta1",  458, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbeta2",  459, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of beta2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvdsatii0",  460, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vdsatii0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlii",  461, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wesatii",  462, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of esatii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsii0",  463, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsii1",  464, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsii2",  465, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of sii2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wsiid",  466, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of siid" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wagidl",  467, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbgidl",  468, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgidl",  602, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wegidl",  469, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of egidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrgidl",  74, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkgidl",  70, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfgidl",  66, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wagisl",  2511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of agisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wbgisl",  2514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of bgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wcgisl",  2517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of cgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wegisl",  2508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of egisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wrgisl",  2520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of rgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wkgisl",  2523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of kgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wfgisl",  2526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of fgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntun",  470, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wntund",  671, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ntund" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wndiode",  471, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndiode" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wndioded",  635, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ndioded" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecf0",  472, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecf0d",  655, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecf0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecr0",  473, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnrecr0d",  659, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nrecr0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wisbjt",  474, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widbjt",  643, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of idbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wisdif",  475, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widdif",  639, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of iddif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wisrec",  476, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of isrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widrec",  647, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of idrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wistun",  477, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of istun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "widtun",  651, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of idtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvrec0",  478, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vrec0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvrec0d",  663, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vrec0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvtun0",  479, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtun0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvtun0d",  667, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vtun0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnbjt",  480, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of nbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wlbjt0",  481, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of lbjt0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvabjt",  482, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vabjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "waely",  483, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of aely" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wahli",  484, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ahli" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wahlid",  685, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of ahlid" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvsdfb",  485, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wvsdth",  486, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of vsdth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wdelvt",  487, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of delvt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wacde",  488, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of acde" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wmoin",  489, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of moin" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnoff",  960, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Width dependence of noff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrcrg1",  490, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of xrcrg1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wxrcrg2",  491, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of xrcrg2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxj",  2021, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xj" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "palphagb1",  2022, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alphagb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbetagb1",  2024, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of betagb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "palphagb2",  2023, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alphagb2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbetagb2",  2025, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of betagb2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paigbcp2",  10004, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbigbcp2",  10008, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcigbcp2",  10012, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigbcp2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgsl",  2034, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgsl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgdl",  2033, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgdl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pckappa",  2035, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ckappa" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pndif",  2026, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pute",  2038, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ute" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkt1",  2039, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkt1l",  2041, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt1l" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkt2",  2040, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kt2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pua1",  2042, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pub1",  2043, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "puc1",  2044, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pat",  2045, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of at" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pprt",  2046, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntrecf",  2027, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntrecf" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntrecr",  2028, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntrecr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxbjt",  2029, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxdif",  888, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrec",  889, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxtun",  890, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxdifd",  891, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xdifd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrecd",  892, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xrecd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxtund",  893, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of xtund" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paigc",  1051, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbigc",  1052, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcigc",  1053, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paigsd",  1054, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbigsd",  1055, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcigsd",  1056, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cigsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnigc",  1057, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nigc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppigcd",  1058, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for pigcd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppoxedge",  1059, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence for poxedge" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnch",  501, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnsub",  502, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnsd",  78, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nsd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pngate",  503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ngate" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvth0",  504, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vth0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvfb",  1204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vfb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk1",  505, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk1w1",  506, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1w1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk1w2",  507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k1w2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk2",  508, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk3",  509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pk3b",  510, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of k3b" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkb1",  511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kb1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pw0",  512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of w0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plpe0",  513, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lpe0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plpeb",  607, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lpeb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt0",  514, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt1",  515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt2",  516, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt0w",  517, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt0w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt1w",  518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt1w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdvt2w",  519, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dvt2w" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pu0",  520, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of u0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "peu",  3503, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eu" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pua",  521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ua" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pub",  522, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "puc",  523, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of uc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pud",  3403, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ud" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pud1",  3407, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ud1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pucste",  3511, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ucste" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pucs",  3507, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ucs" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvsat",  524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsat" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pa0",  525, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pags",  526, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ags" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pb0",  527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pb1",  528, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of b1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pketa",  529, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of keta" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pketas",  530, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ketas" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pa1",  531, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pa2",  532, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of a2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prdsw",  533, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdsw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prsw",  680, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rsw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prdw",  676, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rdw" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pprwb",  534, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pprwg",  535, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of prwg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pwr",  536, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of wr" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnfactor",  537, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nfactor" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdwg",  538, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwg" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdwb",  539, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dwb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvoff",  540, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of voff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "peta0",  541, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of eta0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "petab",  542, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of etab" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdsub",  543, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of dsub" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcit",  544, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cit" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcdsc",  545, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdsc" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcdscb",  546, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcdscd",  547, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cdscd" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppclm",  548, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pclm" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdiblc1",  549, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdiblc2",  550, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblc2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppdiblcb",  551, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pdiblcb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdrout",  552, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of drout" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ppvag",  553, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of pvag" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdelta",  554, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delta" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "palpha0",  555, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of alpha0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfbjtii",  556, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pabjtii",  4020, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of abjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcbjtii",  4018, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pebjtii",  4017, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ebjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pmbjtii",  4021, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of mbjtii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvbci",  4019, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vbci" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbeta0",  557, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbeta1",  558, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbeta2",  559, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of beta2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvdsatii0",  560, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vdsatii0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plii",  561, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pesatii",  562, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of esatii" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psii0",  563, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psii1",  564, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psii2",  565, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of sii2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "psiid",  566, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of siid" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pagidl",  567, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbgidl",  568, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgidl",  603, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pegidl",  569, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of egidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prgidl",  73, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkgidl",  69, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfgidl",  65, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fgidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pagisl",  2512, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of agisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pbgisl",  2515, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of bgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pcgisl",  2518, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of cgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pegisl",  2509, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of egisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "prgisl",  2521, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of rgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pkgisl",  2524, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of kgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pfgisl",  2527, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of fgisl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntun",  570, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pntund",  672, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ntund" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pndiode",  571, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pndioded",  636, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of ndiode" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecf0",  572, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecf0d",  656, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecf0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecr0",  573, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnrecr0d",  660, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nrecr0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pisbjt",  574, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pidbjt",  644, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of idbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pisdif",  575, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isdif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "piddif",  640, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of iddif" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pisrec",  576, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of isrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pidrec",  648, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of idrec" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pistun",  577, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of istun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pidtun",  652, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of idtun" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvrec0",  578, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vrec0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvrec0d",  664, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vrec0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvtun0",  579, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtun0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvtun0d",  668, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vtun0d" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnbjt",  580, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of nbjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "plbjt0",  581, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of lbjt0" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvabjt",  582, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vabjt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "paely",  583, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of aely" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pahli",  584, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "X-term dependence of ahli" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pahlid",  686, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "X-term dependence of ahlid" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvsdfb",  585, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdfb" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pvsdth",  586, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of vsdth" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pdelvt",  587, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of delvt" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pacde",  588, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of acde" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pmoin",  589, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of moin" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnoff",  961, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "0", "0", "Cross-term dependence of noff" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrcrg1",  590, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of xrcrg1" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pxrcrg2",  591, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of xrcrg2" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nlx",  2104, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Lateral non-uniform doping effect" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lnlx",  2105, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of nlx" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wnlx",  2106, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of nlx" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pnlx",  2107, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of nlx" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "ngidl",  2100, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "GIDL first parameter" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "lngidl",  2101, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Length dependence of ngidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "wngidl",  2102, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Width dependence of ngidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pngidl",  2103, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::DC, "NaN", "NaN", "Cross-term dependence of ngidl" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgs_max",  2201, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgd_max",  2202, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgb_max",  2203, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vds_max",  2204, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage D-S branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbs_max",  2205, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbd_max",  2206, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgsr_max",  2207, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-S branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgdr_max",  2208, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-D branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vgbr_max",  2209, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage G-B branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbsr_max",  2210, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-S branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "vbdr_max",  2211, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::LIMITING_VALUES, "1e+99", "1e+99", "maximum voltage B-D branch" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "nmos",  814, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate NMOS" );
    modelInfos[MODEL_TYPE::B4SOI].modelParams.emplace_back( "pmos",  815, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag to indicate PMOS" );
    // Instance parameters
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "l",  2, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Length", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "w",  1, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Width", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "m",  47, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Parallel Multiplier", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nf",  33, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of fingers", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "sa",  41, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between  OD edge to poly of one side", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "sb",  42, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between  OD edge to poly of the other side", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "sd",  43, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "distance between neighbour fingers", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ad",  4, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain area", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "as",  3, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source area", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "pd",  6, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Drain perimeter", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ps",  5, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Source perimeter", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nrd",  8, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in drain", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nrs",  7, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::GEOMETRY, "", "", "Number of squares in source", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "off",  9, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Device is initially off", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ic",  19, SIM_MODEL::PARAM::DIR_IN, SIM_VALUE::TYPE_FLOAT_VECTOR, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vector of DS,GS,BS initial voltages", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gmbs",  918, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gmb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gm",  916, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gmids",  946, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gm/Ids", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "gds",  917, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gds", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vdsat",  939, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vdsat", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vth",  938, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vth", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ids",  913, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ids", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vbs",  909, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vgs",  910, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vgs", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vds",  912, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vds", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ves",  911, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ves", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ibd",  3003, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibd", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "ibs",  3002, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Ibs", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "isub",  3004, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Isub", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igidl",  3005, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igidl", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igisl",  3001, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igisl", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igs",  3006, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igs", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igd",  3007, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igd", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igb",  3008, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igcs",  3009, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igcs", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "igcd",  3010, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Igcd", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cgg",  927, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cggb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cgs",  929, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgsb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cgd",  928, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cgdb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cbg",  930, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbgb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cbd",  915, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbdb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cbs",  914, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cbsb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cdg",  935, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdgb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cdd",  936, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cddb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cds",  937, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Cdsb", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "capbd",  931, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbd", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "capbs",  933, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Capbs", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qg",  923, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qgate", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qb",  921, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qbulk", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qd",  925, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qdrain", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "qs",  955, SIM_MODEL::PARAM::DIR_OUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Qsource", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "bjtoff",  15, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "BJT on/off flag", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "debug",  21, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "DEBUG on/off flag", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rth0",  16, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance Thermal Resistance", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "cth0",  17, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "F", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1e-05", "1e-05", "Instance Thermal Capacitance", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nrb",  18, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of squares in body", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "frbody",  30, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "1", "1", "layout dependent body-resistance coefficient", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rbdb",  35, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rbsb",  36, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "Ω", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "50", "50", "Body resistance", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "delvto",  44, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "V", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Zero bias threshold voltage variation", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "delvt0",  44, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "n.a.", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "soimod",  32, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Instance model selector for PD/FD operation", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nbc",  22, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number of body contact isolation edge", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "nseg",  23, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Number segments for width partitioning", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "pdbcp",  24, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Perimeter length for bc parasitics at drain side", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "psbcp",  25, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "m", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Perimeter length for bc parasitics at source side", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "agbcp",  26, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate to body overlap area for bc parasitics", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "agbcp2",  46, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Parasitic Gate to body overlap area for bc parasitics", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "agbcpd",  45, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Gate to body overlap area for bc parasitics in DC", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "aebcp",  27, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Substrate to body overlap area for bc prasitics", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "vbsusr",  28, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_FLOAT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Vbs specified by user", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "tnodeout",  29, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_BOOL, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "", "", "Flag indicating external temp node", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rgatemod",  31, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Gate resistance model selector", true );
    modelInfos[MODEL_TYPE::B4SOI].instanceParams.emplace_back( "rbodymod",  34, SIM_MODEL::PARAM::DIR_INOUT, SIM_VALUE::TYPE_INT, "", SIM_MODEL::PARAM::CATEGORY::SUPERFLUOUS, "0", "0", "Body R model selector", true );
}