/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// To regenerate api.pb.go run `hack/update-codegen.sh protobindings`

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.4
// 	protoc        v4.23.4
// source: staging/src/k8s.io/kubelet/pkg/apis/deviceplugin/v1alpha/api.proto

package v1alpha

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type RegisterRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Version of the API the Device Plugin was built against
	Version string `protobuf:"bytes,1,opt,name=version,proto3" json:"version,omitempty"`
	// Name of the unix socket the device plugin is listening on
	// PATH = path.Join(DevicePluginPath, endpoint)
	Endpoint string `protobuf:"bytes,2,opt,name=endpoint,proto3" json:"endpoint,omitempty"`
	// Schedulable resource name. As of now it's expected to be a DNS Label
	ResourceName  string `protobuf:"bytes,3,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *RegisterRequest) Reset() {
	*x = RegisterRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RegisterRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RegisterRequest) ProtoMessage() {}

func (x *RegisterRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RegisterRequest.ProtoReflect.Descriptor instead.
func (*RegisterRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{0}
}

func (x *RegisterRequest) GetVersion() string {
	if x != nil {
		return x.Version
	}
	return ""
}

func (x *RegisterRequest) GetEndpoint() string {
	if x != nil {
		return x.Endpoint
	}
	return ""
}

func (x *RegisterRequest) GetResourceName() string {
	if x != nil {
		return x.ResourceName
	}
	return ""
}

type Empty struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Empty) Reset() {
	*x = Empty{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Empty) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Empty) ProtoMessage() {}

func (x *Empty) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Empty.ProtoReflect.Descriptor instead.
func (*Empty) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{1}
}

// ListAndWatch returns a stream of List of Devices
// Whenever a Device state changes or a Device disappears, ListAndWatch
// returns the new list
type ListAndWatchResponse struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Devices       []*Device              `protobuf:"bytes,1,rep,name=devices,proto3" json:"devices,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *ListAndWatchResponse) Reset() {
	*x = ListAndWatchResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListAndWatchResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListAndWatchResponse) ProtoMessage() {}

func (x *ListAndWatchResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListAndWatchResponse.ProtoReflect.Descriptor instead.
func (*ListAndWatchResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{2}
}

func (x *ListAndWatchResponse) GetDevices() []*Device {
	if x != nil {
		return x.Devices
	}
	return nil
}

// E.g:
//
//	struct Device {
//	   ID: "GPU-fef8089b-4820-abfc-e83e-94318197576e",
//	   Health: "Healthy",
//	}
type Device struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// A unique ID assigned by the device plugin used
	// to identify devices during the communication
	// Max length of this field is 63 characters
	ID string `protobuf:"bytes,1,opt,name=ID,proto3" json:"ID,omitempty"`
	// Health of the device, can be healthy or unhealthy, see constants.go
	Health        string `protobuf:"bytes,2,opt,name=health,proto3" json:"health,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Device) Reset() {
	*x = Device{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Device) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Device) ProtoMessage() {}

func (x *Device) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Device.ProtoReflect.Descriptor instead.
func (*Device) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{3}
}

func (x *Device) GetID() string {
	if x != nil {
		return x.ID
	}
	return ""
}

func (x *Device) GetHealth() string {
	if x != nil {
		return x.Health
	}
	return ""
}

//   - Allocate is expected to be called during pod creation since allocation
//     failures for any container would result in pod startup failure.
//   - Allocate allows kubelet to exposes additional artifacts in a pod's
//     environment as directed by the plugin.
//   - Allocate allows Device Plugin to run device specific operations on
//     the Devices requested
type AllocateRequest struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	DevicesIDs    []string               `protobuf:"bytes,1,rep,name=devicesIDs,proto3" json:"devicesIDs,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AllocateRequest) Reset() {
	*x = AllocateRequest{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocateRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateRequest) ProtoMessage() {}

func (x *AllocateRequest) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateRequest.ProtoReflect.Descriptor instead.
func (*AllocateRequest) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{4}
}

func (x *AllocateRequest) GetDevicesIDs() []string {
	if x != nil {
		return x.DevicesIDs
	}
	return nil
}

// AllocateResponse includes the artifacts that needs to be injected into
// a container for accessing 'deviceIDs' that were mentioned as part of
// 'AllocateRequest'.
// Failure Handling:
// if Kubelet sends an allocation request for dev1 and dev2.
// Allocation on dev1 succeeds but allocation on dev2 fails.
// The Device plugin should send a ListAndWatch update and fail the
// Allocation request
type AllocateResponse struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// List of environment variable to be set in the container to access one of more devices.
	Envs map[string]string `protobuf:"bytes,1,rep,name=envs,proto3" json:"envs,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	// Mounts for the container.
	Mounts []*Mount `protobuf:"bytes,2,rep,name=mounts,proto3" json:"mounts,omitempty"`
	// Devices for the container.
	Devices []*DeviceSpec `protobuf:"bytes,3,rep,name=devices,proto3" json:"devices,omitempty"`
	// Container annotations to pass to the container runtime
	Annotations   map[string]string `protobuf:"bytes,4,rep,name=annotations,proto3" json:"annotations,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *AllocateResponse) Reset() {
	*x = AllocateResponse{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AllocateResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AllocateResponse) ProtoMessage() {}

func (x *AllocateResponse) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AllocateResponse.ProtoReflect.Descriptor instead.
func (*AllocateResponse) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{5}
}

func (x *AllocateResponse) GetEnvs() map[string]string {
	if x != nil {
		return x.Envs
	}
	return nil
}

func (x *AllocateResponse) GetMounts() []*Mount {
	if x != nil {
		return x.Mounts
	}
	return nil
}

func (x *AllocateResponse) GetDevices() []*DeviceSpec {
	if x != nil {
		return x.Devices
	}
	return nil
}

func (x *AllocateResponse) GetAnnotations() map[string]string {
	if x != nil {
		return x.Annotations
	}
	return nil
}

// Mount specifies a host volume to mount into a container.
// where device library or tools are installed on host and container
type Mount struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path of the mount within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the mount on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// If set, the mount is read-only.
	ReadOnly      bool `protobuf:"varint,3,opt,name=read_only,json=readOnly,proto3" json:"read_only,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Mount) Reset() {
	*x = Mount{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Mount) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Mount) ProtoMessage() {}

func (x *Mount) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Mount.ProtoReflect.Descriptor instead.
func (*Mount) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{6}
}

func (x *Mount) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *Mount) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *Mount) GetReadOnly() bool {
	if x != nil {
		return x.ReadOnly
	}
	return false
}

// DeviceSpec specifies a host device to mount into a container.
type DeviceSpec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Path of the device within the container.
	ContainerPath string `protobuf:"bytes,1,opt,name=container_path,json=containerPath,proto3" json:"container_path,omitempty"`
	// Path of the device on the host.
	HostPath string `protobuf:"bytes,2,opt,name=host_path,json=hostPath,proto3" json:"host_path,omitempty"`
	// Cgroups permissions of the device, candidates are one or more of
	// * r - allows container to read from the specified device.
	// * w - allows container to write to the specified device.
	// * m - allows container to create device files that do not yet exist.
	Permissions   string `protobuf:"bytes,3,opt,name=permissions,proto3" json:"permissions,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DeviceSpec) Reset() {
	*x = DeviceSpec{}
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeviceSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeviceSpec) ProtoMessage() {}

func (x *DeviceSpec) ProtoReflect() protoreflect.Message {
	mi := &file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeviceSpec.ProtoReflect.Descriptor instead.
func (*DeviceSpec) Descriptor() ([]byte, []int) {
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP(), []int{7}
}

func (x *DeviceSpec) GetContainerPath() string {
	if x != nil {
		return x.ContainerPath
	}
	return ""
}

func (x *DeviceSpec) GetHostPath() string {
	if x != nil {
		return x.HostPath
	}
	return ""
}

func (x *DeviceSpec) GetPermissions() string {
	if x != nil {
		return x.Permissions
	}
	return ""
}

var File_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto protoreflect.FileDescriptor

var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDesc = string([]byte{
	0x0a, 0x42, 0x73, 0x74, 0x61, 0x67, 0x69, 0x6e, 0x67, 0x2f, 0x73, 0x72, 0x63, 0x2f, 0x6b, 0x38,
	0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65, 0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67,
	0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68, 0x61, 0x2f, 0x61, 0x70, 0x69, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0c, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67,
	0x69, 0x6e, 0x22, 0x6c, 0x0a, 0x0f, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x12,
	0x1a, 0x0a, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x08, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x12, 0x23, 0x0a, 0x0d, 0x72,
	0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65,
	0x22, 0x07, 0x0a, 0x05, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x46, 0x0a, 0x14, 0x4c, 0x69, 0x73,
	0x74, 0x41, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x12, 0x2e, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x14, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69,
	0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x22, 0x30, 0x0a, 0x06, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x49,
	0x44, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x49, 0x44, 0x12, 0x16, 0x0a, 0x06, 0x68,
	0x65, 0x61, 0x6c, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x68, 0x65, 0x61,
	0x6c, 0x74, 0x68, 0x22, 0x31, 0x0a, 0x0f, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x0a, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x49, 0x44, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x73, 0x49, 0x44, 0x73, 0x22, 0xfd, 0x02, 0x0a, 0x10, 0x41, 0x6c, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x3c, 0x0a, 0x04, 0x65,
	0x6e, 0x76, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x45, 0x6e, 0x76, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x52, 0x04, 0x65, 0x6e, 0x76, 0x73, 0x12, 0x2b, 0x0a, 0x06, 0x6d, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x13, 0x2e, 0x64, 0x65, 0x76, 0x69,
	0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x06,
	0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x32, 0x0a, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65,
	0x63, 0x52, 0x07, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x12, 0x51, 0x0a, 0x0b, 0x61, 0x6e,
	0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2f, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0b, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x37, 0x0a,
	0x09, 0x45, 0x6e, 0x76, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x3e, 0x0a, 0x10, 0x41, 0x6e, 0x6e, 0x6f, 0x74, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65,
	0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x68, 0x0a, 0x05, 0x4d, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x25, 0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74,
	0x68, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e,
	0x65, 0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70,
	0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50,
	0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x72, 0x65, 0x61, 0x64, 0x5f, 0x6f, 0x6e, 0x6c, 0x79,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x08, 0x72, 0x65, 0x61, 0x64, 0x4f, 0x6e, 0x6c, 0x79,
	0x22, 0x72, 0x0a, 0x0a, 0x44, 0x65, 0x76, 0x69, 0x63, 0x65, 0x53, 0x70, 0x65, 0x63, 0x12, 0x25,
	0x0a, 0x0e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x5f, 0x70, 0x61, 0x74, 0x68,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
	0x72, 0x50, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x09, 0x68, 0x6f, 0x73, 0x74, 0x5f, 0x70, 0x61,
	0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x68, 0x6f, 0x73, 0x74, 0x50, 0x61,
	0x74, 0x68, 0x12, 0x20, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x32, 0x50, 0x0a, 0x0c, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x40, 0x0a, 0x08, 0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72,
	0x12, 0x1d, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e,
	0x52, 0x65, 0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x13, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x00, 0x32, 0xa8, 0x01, 0x0a, 0x0c, 0x44, 0x65, 0x76, 0x69, 0x63,
	0x65, 0x50, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x12, 0x4b, 0x0a, 0x0c, 0x4c, 0x69, 0x73, 0x74, 0x41,
	0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x12, 0x13, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65,
	0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x1a, 0x22, 0x2e, 0x64,
	0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x41, 0x6e, 0x64, 0x57, 0x61, 0x74, 0x63, 0x68, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0x00, 0x30, 0x01, 0x12, 0x4b, 0x0a, 0x08, 0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
	0x12, 0x1d, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e,
	0x41, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1e, 0x2e, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2e, 0x41,
	0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22,
	0x00, 0x42, 0x2e, 0x5a, 0x2c, 0x6b, 0x38, 0x73, 0x2e, 0x69, 0x6f, 0x2f, 0x6b, 0x75, 0x62, 0x65,
	0x6c, 0x65, 0x74, 0x2f, 0x70, 0x6b, 0x67, 0x2f, 0x61, 0x70, 0x69, 0x73, 0x2f, 0x64, 0x65, 0x76,
	0x69, 0x63, 0x65, 0x70, 0x6c, 0x75, 0x67, 0x69, 0x6e, 0x2f, 0x76, 0x31, 0x61, 0x6c, 0x70, 0x68,
	0x61, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var (
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescOnce sync.Once
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescData []byte
)

func file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescGZIP() []byte {
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescOnce.Do(func() {
		file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDesc)))
	})
	return file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDescData
}

var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_goTypes = []any{
	(*RegisterRequest)(nil),      // 0: deviceplugin.RegisterRequest
	(*Empty)(nil),                // 1: deviceplugin.Empty
	(*ListAndWatchResponse)(nil), // 2: deviceplugin.ListAndWatchResponse
	(*Device)(nil),               // 3: deviceplugin.Device
	(*AllocateRequest)(nil),      // 4: deviceplugin.AllocateRequest
	(*AllocateResponse)(nil),     // 5: deviceplugin.AllocateResponse
	(*Mount)(nil),                // 6: deviceplugin.Mount
	(*DeviceSpec)(nil),           // 7: deviceplugin.DeviceSpec
	nil,                          // 8: deviceplugin.AllocateResponse.EnvsEntry
	nil,                          // 9: deviceplugin.AllocateResponse.AnnotationsEntry
}
var file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_depIdxs = []int32{
	3, // 0: deviceplugin.ListAndWatchResponse.devices:type_name -> deviceplugin.Device
	8, // 1: deviceplugin.AllocateResponse.envs:type_name -> deviceplugin.AllocateResponse.EnvsEntry
	6, // 2: deviceplugin.AllocateResponse.mounts:type_name -> deviceplugin.Mount
	7, // 3: deviceplugin.AllocateResponse.devices:type_name -> deviceplugin.DeviceSpec
	9, // 4: deviceplugin.AllocateResponse.annotations:type_name -> deviceplugin.AllocateResponse.AnnotationsEntry
	0, // 5: deviceplugin.Registration.Register:input_type -> deviceplugin.RegisterRequest
	1, // 6: deviceplugin.DevicePlugin.ListAndWatch:input_type -> deviceplugin.Empty
	4, // 7: deviceplugin.DevicePlugin.Allocate:input_type -> deviceplugin.AllocateRequest
	1, // 8: deviceplugin.Registration.Register:output_type -> deviceplugin.Empty
	2, // 9: deviceplugin.DevicePlugin.ListAndWatch:output_type -> deviceplugin.ListAndWatchResponse
	5, // 10: deviceplugin.DevicePlugin.Allocate:output_type -> deviceplugin.AllocateResponse
	8, // [8:11] is the sub-list for method output_type
	5, // [5:8] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_init() }
func file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_init() {
	if File_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDesc), len(file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_goTypes,
		DependencyIndexes: file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_depIdxs,
		MessageInfos:      file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_msgTypes,
	}.Build()
	File_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto = out.File
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_goTypes = nil
	file_staging_src_k8s_io_kubelet_pkg_apis_deviceplugin_v1alpha_api_proto_depIdxs = nil
}
