//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::cell::UnsafeCell;
use core::ffi::*;
use core::marker::{PhantomData, PhantomPinned};
use core::ptr::NonNull;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcalendar?language=objc)
///
/// This is toll-free bridged with `NSCalendar`.
#[doc(alias = "CFCalendarRef")]
#[repr(C)]
pub struct CFCalendar {
    inner: [u8; 0],
    _p: UnsafeCell<PhantomData<(*const UnsafeCell<()>, PhantomPinned)>>,
}

cf_type!(
    unsafe impl CFCalendar {}
);
#[cfg(feature = "objc2")]
cf_objc2_type!(
    unsafe impl RefEncode<"__CFCalendar"> for CFCalendar {}
);

unsafe impl ConcreteType for CFCalendar {
    #[doc(alias = "CFCalendarGetTypeID")]
    #[inline]
    fn type_id() -> CFTypeID {
        extern "C-unwind" {
            fn CFCalendarGetTypeID() -> CFTypeID;
        }
        unsafe { CFCalendarGetTypeID() }
    }
}

impl CFCalendar {
    #[doc(alias = "CFCalendarCopyCurrent")]
    #[inline]
    pub fn current() -> Option<CFRetained<CFCalendar>> {
        extern "C-unwind" {
            fn CFCalendarCopyCurrent() -> Option<NonNull<CFCalendar>>;
        }
        let ret = unsafe { CFCalendarCopyCurrent() };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Creates a calendar.  The identifiers are the `kCF*Calendar` constants in CFLocale.h.
    #[doc(alias = "CFCalendarCreateWithIdentifier")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub fn with_identifier(
        allocator: Option<&CFAllocator>,
        identifier: Option<&CFCalendarIdentifier>,
    ) -> Option<CFRetained<CFCalendar>> {
        extern "C-unwind" {
            fn CFCalendarCreateWithIdentifier(
                allocator: Option<&CFAllocator>,
                identifier: Option<&CFCalendarIdentifier>,
            ) -> Option<NonNull<CFCalendar>>;
        }
        let ret = unsafe { CFCalendarCreateWithIdentifier(allocator, identifier) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// Returns the calendar's identifier.
    #[doc(alias = "CFCalendarGetIdentifier")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub fn identifier(&self) -> Option<CFRetained<CFCalendarIdentifier>> {
        extern "C-unwind" {
            fn CFCalendarGetIdentifier(
                calendar: &CFCalendar,
            ) -> Option<NonNull<CFCalendarIdentifier>>;
        }
        let ret = unsafe { CFCalendarGetIdentifier(self) };
        ret.map(|ret| unsafe { CFRetained::retain(ret) })
    }

    #[doc(alias = "CFCalendarCopyLocale")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub fn locale(&self) -> Option<CFRetained<CFLocale>> {
        extern "C-unwind" {
            fn CFCalendarCopyLocale(calendar: &CFCalendar) -> Option<NonNull<CFLocale>>;
        }
        let ret = unsafe { CFCalendarCopyLocale(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    /// # Safety
    ///
    /// `locale` might not allow `None`.
    #[doc(alias = "CFCalendarSetLocale")]
    #[cfg(feature = "CFLocale")]
    #[inline]
    pub unsafe fn set_locale(&self, locale: Option<&CFLocale>) {
        extern "C-unwind" {
            fn CFCalendarSetLocale(calendar: &CFCalendar, locale: Option<&CFLocale>);
        }
        unsafe { CFCalendarSetLocale(self, locale) }
    }

    #[doc(alias = "CFCalendarCopyTimeZone")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn time_zone(&self) -> Option<CFRetained<CFTimeZone>> {
        extern "C-unwind" {
            fn CFCalendarCopyTimeZone(calendar: &CFCalendar) -> Option<NonNull<CFTimeZone>>;
        }
        let ret = unsafe { CFCalendarCopyTimeZone(self) };
        ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
    }

    #[doc(alias = "CFCalendarSetTimeZone")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn set_time_zone(&self, tz: Option<&CFTimeZone>) {
        extern "C-unwind" {
            fn CFCalendarSetTimeZone(calendar: &CFCalendar, tz: Option<&CFTimeZone>);
        }
        unsafe { CFCalendarSetTimeZone(self, tz) }
    }

    #[doc(alias = "CFCalendarGetFirstWeekday")]
    #[inline]
    pub fn first_weekday(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFCalendarGetFirstWeekday(calendar: &CFCalendar) -> CFIndex;
        }
        unsafe { CFCalendarGetFirstWeekday(self) }
    }

    #[doc(alias = "CFCalendarSetFirstWeekday")]
    #[inline]
    pub fn set_first_weekday(&self, wkdy: CFIndex) {
        extern "C-unwind" {
            fn CFCalendarSetFirstWeekday(calendar: &CFCalendar, wkdy: CFIndex);
        }
        unsafe { CFCalendarSetFirstWeekday(self, wkdy) }
    }

    #[doc(alias = "CFCalendarGetMinimumDaysInFirstWeek")]
    #[inline]
    pub fn minimum_days_in_first_week(&self) -> CFIndex {
        extern "C-unwind" {
            fn CFCalendarGetMinimumDaysInFirstWeek(calendar: &CFCalendar) -> CFIndex;
        }
        unsafe { CFCalendarGetMinimumDaysInFirstWeek(self) }
    }

    #[doc(alias = "CFCalendarSetMinimumDaysInFirstWeek")]
    #[inline]
    pub fn set_minimum_days_in_first_week(&self, mwd: CFIndex) {
        extern "C-unwind" {
            fn CFCalendarSetMinimumDaysInFirstWeek(calendar: &CFCalendar, mwd: CFIndex);
        }
        unsafe { CFCalendarSetMinimumDaysInFirstWeek(self, mwd) }
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/cfcalendarunit?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CFCalendarUnit(pub CFOptionFlags);
bitflags::bitflags! {
    impl CFCalendarUnit: CFOptionFlags {
        #[doc(alias = "kCFCalendarUnitEra")]
        const Era = 1<<1;
        #[doc(alias = "kCFCalendarUnitYear")]
        const Year = 1<<2;
        #[doc(alias = "kCFCalendarUnitMonth")]
        const Month = 1<<3;
        #[doc(alias = "kCFCalendarUnitDay")]
        const Day = 1<<4;
        #[doc(alias = "kCFCalendarUnitHour")]
        const Hour = 1<<5;
        #[doc(alias = "kCFCalendarUnitMinute")]
        const Minute = 1<<6;
        #[doc(alias = "kCFCalendarUnitSecond")]
        const Second = 1<<7;
        #[doc(alias = "kCFCalendarUnitWeek")]
#[deprecated = "Use kCFCalendarUnitWeekOfYear or kCFCalendarUnitWeekOfMonth instead"]
        const Week = 1<<8;
        #[doc(alias = "kCFCalendarUnitWeekday")]
        const Weekday = 1<<9;
        #[doc(alias = "kCFCalendarUnitWeekdayOrdinal")]
        const WeekdayOrdinal = 1<<10;
        #[doc(alias = "kCFCalendarUnitQuarter")]
        const Quarter = 1<<11;
        #[doc(alias = "kCFCalendarUnitWeekOfMonth")]
        const WeekOfMonth = 1<<12;
        #[doc(alias = "kCFCalendarUnitWeekOfYear")]
        const WeekOfYear = 1<<13;
        #[doc(alias = "kCFCalendarUnitYearForWeekOfYear")]
        const YearForWeekOfYear = 1<<14;
        #[doc(alias = "kCFCalendarUnitDayOfYear")]
        const DayOfYear = 1<<16;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CFCalendarUnit {
    const ENCODING: Encoding = CFOptionFlags::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CFCalendarUnit {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

impl CFCalendar {
    #[doc(alias = "CFCalendarGetMinimumRangeOfUnit")]
    #[inline]
    pub fn minimum_range_of_unit(&self, unit: CFCalendarUnit) -> CFRange {
        extern "C-unwind" {
            fn CFCalendarGetMinimumRangeOfUnit(
                calendar: &CFCalendar,
                unit: CFCalendarUnit,
            ) -> CFRange;
        }
        unsafe { CFCalendarGetMinimumRangeOfUnit(self, unit) }
    }

    #[doc(alias = "CFCalendarGetMaximumRangeOfUnit")]
    #[inline]
    pub fn maximum_range_of_unit(&self, unit: CFCalendarUnit) -> CFRange {
        extern "C-unwind" {
            fn CFCalendarGetMaximumRangeOfUnit(
                calendar: &CFCalendar,
                unit: CFCalendarUnit,
            ) -> CFRange;
        }
        unsafe { CFCalendarGetMaximumRangeOfUnit(self, unit) }
    }

    #[doc(alias = "CFCalendarGetRangeOfUnit")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn range_of_unit(
        &self,
        smaller_unit: CFCalendarUnit,
        bigger_unit: CFCalendarUnit,
        at: CFAbsoluteTime,
    ) -> CFRange {
        extern "C-unwind" {
            fn CFCalendarGetRangeOfUnit(
                calendar: &CFCalendar,
                smaller_unit: CFCalendarUnit,
                bigger_unit: CFCalendarUnit,
                at: CFAbsoluteTime,
            ) -> CFRange;
        }
        unsafe { CFCalendarGetRangeOfUnit(self, smaller_unit, bigger_unit, at) }
    }

    #[doc(alias = "CFCalendarGetOrdinalityOfUnit")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub fn ordinality_of_unit(
        &self,
        smaller_unit: CFCalendarUnit,
        bigger_unit: CFCalendarUnit,
        at: CFAbsoluteTime,
    ) -> CFIndex {
        extern "C-unwind" {
            fn CFCalendarGetOrdinalityOfUnit(
                calendar: &CFCalendar,
                smaller_unit: CFCalendarUnit,
                bigger_unit: CFCalendarUnit,
                at: CFAbsoluteTime,
            ) -> CFIndex;
        }
        unsafe { CFCalendarGetOrdinalityOfUnit(self, smaller_unit, bigger_unit, at) }
    }

    /// # Safety
    ///
    /// - `startp` must be a valid pointer.
    /// - `tip` must be a valid pointer.
    #[doc(alias = "CFCalendarGetTimeRangeOfUnit")]
    #[cfg(feature = "CFDate")]
    #[inline]
    pub unsafe fn time_range_of_unit(
        &self,
        unit: CFCalendarUnit,
        at: CFAbsoluteTime,
        startp: *mut CFAbsoluteTime,
        tip: *mut CFTimeInterval,
    ) -> bool {
        extern "C-unwind" {
            fn CFCalendarGetTimeRangeOfUnit(
                calendar: &CFCalendar,
                unit: CFCalendarUnit,
                at: CFAbsoluteTime,
                startp: *mut CFAbsoluteTime,
                tip: *mut CFTimeInterval,
            ) -> Boolean;
        }
        let ret = unsafe { CFCalendarGetTimeRangeOfUnit(self, unit, at, startp, tip) };
        ret != 0
    }
}

/// [Apple's documentation](https://developer.apple.com/documentation/corefoundation/kcfcalendarcomponentswrap?language=objc)
pub const kCFCalendarComponentsWrap: CFOptionFlags = 1 << 0;

#[deprecated = "renamed to `CFCalendar::current`"]
#[inline]
pub extern "C-unwind" fn CFCalendarCopyCurrent() -> Option<CFRetained<CFCalendar>> {
    extern "C-unwind" {
        fn CFCalendarCopyCurrent() -> Option<NonNull<CFCalendar>>;
    }
    let ret = unsafe { CFCalendarCopyCurrent() };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFCalendar::with_identifier`"]
#[inline]
pub extern "C-unwind" fn CFCalendarCreateWithIdentifier(
    allocator: Option<&CFAllocator>,
    identifier: Option<&CFCalendarIdentifier>,
) -> Option<CFRetained<CFCalendar>> {
    extern "C-unwind" {
        fn CFCalendarCreateWithIdentifier(
            allocator: Option<&CFAllocator>,
            identifier: Option<&CFCalendarIdentifier>,
        ) -> Option<NonNull<CFCalendar>>;
    }
    let ret = unsafe { CFCalendarCreateWithIdentifier(allocator, identifier) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFCalendar::identifier`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetIdentifier(
    calendar: &CFCalendar,
) -> Option<CFRetained<CFCalendarIdentifier>> {
    extern "C-unwind" {
        fn CFCalendarGetIdentifier(calendar: &CFCalendar) -> Option<NonNull<CFCalendarIdentifier>>;
    }
    let ret = unsafe { CFCalendarGetIdentifier(calendar) };
    ret.map(|ret| unsafe { CFRetained::retain(ret) })
}

#[cfg(feature = "CFLocale")]
#[deprecated = "renamed to `CFCalendar::locale`"]
#[inline]
pub extern "C-unwind" fn CFCalendarCopyLocale(
    calendar: &CFCalendar,
) -> Option<CFRetained<CFLocale>> {
    extern "C-unwind" {
        fn CFCalendarCopyLocale(calendar: &CFCalendar) -> Option<NonNull<CFLocale>>;
    }
    let ret = unsafe { CFCalendarCopyLocale(calendar) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

extern "C-unwind" {
    #[cfg(feature = "CFLocale")]
    #[deprecated = "renamed to `CFCalendar::set_locale`"]
    pub fn CFCalendarSetLocale(calendar: &CFCalendar, locale: Option<&CFLocale>);
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFCalendar::time_zone`"]
#[inline]
pub extern "C-unwind" fn CFCalendarCopyTimeZone(
    calendar: &CFCalendar,
) -> Option<CFRetained<CFTimeZone>> {
    extern "C-unwind" {
        fn CFCalendarCopyTimeZone(calendar: &CFCalendar) -> Option<NonNull<CFTimeZone>>;
    }
    let ret = unsafe { CFCalendarCopyTimeZone(calendar) };
    ret.map(|ret| unsafe { CFRetained::from_raw(ret) })
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFCalendar::set_time_zone`"]
#[inline]
pub extern "C-unwind" fn CFCalendarSetTimeZone(calendar: &CFCalendar, tz: Option<&CFTimeZone>) {
    extern "C-unwind" {
        fn CFCalendarSetTimeZone(calendar: &CFCalendar, tz: Option<&CFTimeZone>);
    }
    unsafe { CFCalendarSetTimeZone(calendar, tz) }
}

#[deprecated = "renamed to `CFCalendar::first_weekday`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetFirstWeekday(calendar: &CFCalendar) -> CFIndex {
    extern "C-unwind" {
        fn CFCalendarGetFirstWeekday(calendar: &CFCalendar) -> CFIndex;
    }
    unsafe { CFCalendarGetFirstWeekday(calendar) }
}

#[deprecated = "renamed to `CFCalendar::set_first_weekday`"]
#[inline]
pub extern "C-unwind" fn CFCalendarSetFirstWeekday(calendar: &CFCalendar, wkdy: CFIndex) {
    extern "C-unwind" {
        fn CFCalendarSetFirstWeekday(calendar: &CFCalendar, wkdy: CFIndex);
    }
    unsafe { CFCalendarSetFirstWeekday(calendar, wkdy) }
}

#[deprecated = "renamed to `CFCalendar::minimum_days_in_first_week`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetMinimumDaysInFirstWeek(calendar: &CFCalendar) -> CFIndex {
    extern "C-unwind" {
        fn CFCalendarGetMinimumDaysInFirstWeek(calendar: &CFCalendar) -> CFIndex;
    }
    unsafe { CFCalendarGetMinimumDaysInFirstWeek(calendar) }
}

#[deprecated = "renamed to `CFCalendar::set_minimum_days_in_first_week`"]
#[inline]
pub extern "C-unwind" fn CFCalendarSetMinimumDaysInFirstWeek(calendar: &CFCalendar, mwd: CFIndex) {
    extern "C-unwind" {
        fn CFCalendarSetMinimumDaysInFirstWeek(calendar: &CFCalendar, mwd: CFIndex);
    }
    unsafe { CFCalendarSetMinimumDaysInFirstWeek(calendar, mwd) }
}

#[deprecated = "renamed to `CFCalendar::minimum_range_of_unit`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetMinimumRangeOfUnit(
    calendar: &CFCalendar,
    unit: CFCalendarUnit,
) -> CFRange {
    extern "C-unwind" {
        fn CFCalendarGetMinimumRangeOfUnit(calendar: &CFCalendar, unit: CFCalendarUnit) -> CFRange;
    }
    unsafe { CFCalendarGetMinimumRangeOfUnit(calendar, unit) }
}

#[deprecated = "renamed to `CFCalendar::maximum_range_of_unit`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetMaximumRangeOfUnit(
    calendar: &CFCalendar,
    unit: CFCalendarUnit,
) -> CFRange {
    extern "C-unwind" {
        fn CFCalendarGetMaximumRangeOfUnit(calendar: &CFCalendar, unit: CFCalendarUnit) -> CFRange;
    }
    unsafe { CFCalendarGetMaximumRangeOfUnit(calendar, unit) }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFCalendar::range_of_unit`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetRangeOfUnit(
    calendar: &CFCalendar,
    smaller_unit: CFCalendarUnit,
    bigger_unit: CFCalendarUnit,
    at: CFAbsoluteTime,
) -> CFRange {
    extern "C-unwind" {
        fn CFCalendarGetRangeOfUnit(
            calendar: &CFCalendar,
            smaller_unit: CFCalendarUnit,
            bigger_unit: CFCalendarUnit,
            at: CFAbsoluteTime,
        ) -> CFRange;
    }
    unsafe { CFCalendarGetRangeOfUnit(calendar, smaller_unit, bigger_unit, at) }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFCalendar::ordinality_of_unit`"]
#[inline]
pub extern "C-unwind" fn CFCalendarGetOrdinalityOfUnit(
    calendar: &CFCalendar,
    smaller_unit: CFCalendarUnit,
    bigger_unit: CFCalendarUnit,
    at: CFAbsoluteTime,
) -> CFIndex {
    extern "C-unwind" {
        fn CFCalendarGetOrdinalityOfUnit(
            calendar: &CFCalendar,
            smaller_unit: CFCalendarUnit,
            bigger_unit: CFCalendarUnit,
            at: CFAbsoluteTime,
        ) -> CFIndex;
    }
    unsafe { CFCalendarGetOrdinalityOfUnit(calendar, smaller_unit, bigger_unit, at) }
}

#[cfg(feature = "CFDate")]
#[deprecated = "renamed to `CFCalendar::time_range_of_unit`"]
#[inline]
pub unsafe extern "C-unwind" fn CFCalendarGetTimeRangeOfUnit(
    calendar: &CFCalendar,
    unit: CFCalendarUnit,
    at: CFAbsoluteTime,
    startp: *mut CFAbsoluteTime,
    tip: *mut CFTimeInterval,
) -> bool {
    extern "C-unwind" {
        fn CFCalendarGetTimeRangeOfUnit(
            calendar: &CFCalendar,
            unit: CFCalendarUnit,
            at: CFAbsoluteTime,
            startp: *mut CFAbsoluteTime,
            tip: *mut CFTimeInterval,
        ) -> Boolean;
    }
    let ret = unsafe { CFCalendarGetTimeRangeOfUnit(calendar, unit, at, startp, tip) };
    ret != 0
}
