/*************************************************
*      Perl-Compatible Regular Expressions       *
*************************************************/

/* PCRE is a library of functions to support regular expressions whose syntax
and semantics are as close as possible to those of the Perl 5 language.

                       Written by Philip Hazel
     Original API code Copyright (c) 1997-2012 University of Cambridge
          New API code Copyright (c) 2016-2022 University of Cambridge

This module is auto-generated from Unicode data files. DO NOT EDIT MANUALLY!
Instead, modify the maint/GenerateUcd.py script and run it to generate
a new version of this code.

-----------------------------------------------------------------------------
Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

    * Redistributions of source code must retain the above copyright notice,
      this list of conditions and the following disclaimer.

    * Redistributions in binary form must reproduce the above copyright
      notice, this list of conditions and the following disclaimer in the
      documentation and/or other materials provided with the distribution.

    * Neither the name of the University of Cambridge nor the names of its
      contributors may be used to endorse or promote products derived from
      this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
POSSIBILITY OF SUCH DAMAGE.
-----------------------------------------------------------------------------
*/

/* This file contains tables of Unicode properties that are extracted from
Unicode data files. See the comments at the start of maint/GenerateUcd.py for
details.

As well as being part of the PCRE2 library, this file is #included by the
pcre2test program, which redefines the PRIV macro to change table names from
_pcre2_xxx to xxxx, thereby avoiding name clashes with the library. At present,
just one of these tables is actually needed. When compiling the library, some
headers are needed. */

#ifndef PCRE2_PCRE2TEST
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include "pcre2_internal.h"
#endif /* PCRE2_PCRE2TEST */

/* The tables herein are needed only when UCP support is built, and in PCRE2
that happens automatically with UTF support. This module should not be
referenced otherwise, so it should not matter whether it is compiled or not.
However a comment was received about space saving - maybe the guy linked all
the modules rather than using a library - so we include a condition to cut out
the tables when not needed. But don't leave a totally empty module because some
compilers barf at that. Instead, just supply some small dummy tables. */

#ifndef SUPPORT_UNICODE
const ucd_record PRIV(ucd_records)[] = {{0,0,0,0,0,0,0}};
const uint16_t PRIV(ucd_stage1)[] = {0};
const uint16_t PRIV(ucd_stage2)[] = {0};
const uint32_t PRIV(ucd_caseless_sets)[] = {0};
const uint32_t PRIV(ucd_nocase_ranges)[] = {0};
const uint32_t PRIV(ucd_nocase_ranges_size) = 0;
#else

/* Total size: 116564 bytes, block size: 128. */

const char *PRIV(unicode_version) = "16.0.0";

/* When recompiling tables with a new Unicode version, please check the types
in this structure definition with those in pcre2_internal.h (the actual field
names will be different).

typedef struct {
uint8_t property_0;
uint8_t property_1;
uint8_t property_2;
uint8_t property_3;
int32_t property_4;
uint16_t property_5;
uint16_t property_6;
} ucd_record;
*/

/* If the 32-bit library is run in non-32-bit mode, character values greater
than 0x10ffff may be encountered. For these we set up a special record. */

#if PCRE2_CODE_UNIT_WIDTH == 32
const ucd_record PRIV(dummy_ucd_record)[] = {{
  ucp_Unknown,    /* script */
  ucp_Cn,         /* type unassigned */
  ucp_gbOther,    /* grapheme break property */
  0,              /* case set */
  0,              /* other case */
  0 | (ucp_bidiL << UCD_BIDICLASS_SHIFT), /* script extension and bidi class */
  0,              /* bool properties offset */
  }};
#endif

/* This table contains lists of characters that are caseless sets of
more than one character. Each list is terminated by NOTACHAR. */

const uint32_t PRIV(ucd_caseless_sets)[] = {
  NOTACHAR,
  0x0053,  0x0073,  0x017f,  NOTACHAR,
  0x01c4,  0x01c5,  0x01c6,  NOTACHAR,
  0x01c7,  0x01c8,  0x01c9,  NOTACHAR,
  0x01ca,  0x01cb,  0x01cc,  NOTACHAR,
  0x01f1,  0x01f2,  0x01f3,  NOTACHAR,
  0x0345,  0x0399,  0x03b9,  0x1fbe,  NOTACHAR,
  0x00b5,  0x039c,  0x03bc,  NOTACHAR,
  0x03a3,  0x03c2,  0x03c3,  NOTACHAR,
  0x0392,  0x03b2,  0x03d0,  NOTACHAR,
  0x0398,  0x03b8,  0x03d1,  0x03f4,  NOTACHAR,
  0x03a6,  0x03c6,  0x03d5,  NOTACHAR,
  0x03a0,  0x03c0,  0x03d6,  NOTACHAR,
  0x039a,  0x03ba,  0x03f0,  NOTACHAR,
  0x03a1,  0x03c1,  0x03f1,  NOTACHAR,
  0x0395,  0x03b5,  0x03f5,  NOTACHAR,
  0x0412,  0x0432,  0x1c80,  NOTACHAR,
  0x0414,  0x0434,  0x1c81,  NOTACHAR,
  0x041e,  0x043e,  0x1c82,  NOTACHAR,
  0x0421,  0x0441,  0x1c83,  NOTACHAR,
  0x0422,  0x0442,  0x1c84,  0x1c85,  NOTACHAR,
  0x042a,  0x044a,  0x1c86,  NOTACHAR,
  0x0462,  0x0463,  0x1c87,  NOTACHAR,
  0x1e60,  0x1e61,  0x1e9b,  NOTACHAR,
  0x03a9,  0x03c9,  0x2126,  NOTACHAR,
  0x004b,  0x006b,  0x212a,  NOTACHAR,
  0x00c5,  0x00e5,  0x212b,  NOTACHAR,
  0x1c88,  0xa64a,  0xa64b,  NOTACHAR,
  0x0069,  0x0130,  NOTACHAR,
  0x0049,  0x0131,  NOTACHAR,
};

/* This is the index, within ucd_caseless_sets, of the additional
Turkish case-equivalences. The dotted I ones are this offset; the
dotless I are +3 from here. */

const uint32_t PRIV(ucd_turkish_dotted_i_caseset) = 112;

/* When #included in pcre2test, we don't need the table of digit sets, nor the
the large main UCD tables. */

#ifndef PCRE2_PCRE2TEST

/* This table contains character ranges, where the characters in the range have
no other case. Both start and end values are excluded from the range. */

const uint32_t PRIV(ucd_nocase_ranges)[] = {
  0x0000, 0x0041, /* 64 */
  0x007a, 0x00b5, /* 58 */
  0x00b5, 0x00c0, /* 10 */
  0x0292, 0x029d, /* 10 */
  0x029e, 0x0345, /* 166 */
  0x0345, 0x0370, /* 42 */
  0x0481, 0x048a, /* 8 */
  0x0556, 0x0561, /* 10 */
  0x0586, 0x10a0, /* 2841 */
  0x10ff, 0x13a0, /* 672 */
  0x13fd, 0x1c80, /* 2178 */
  0x1cbf, 0x1d79, /* 185 */
  0x1d7d, 0x1d8e, /* 16 */
  0x1d8e, 0x1e00, /* 113 */
  0x1ffc, 0x2126, /* 297 */
  0x2132, 0x214e, /* 27 */
  0x214e, 0x2160, /* 17 */
  0x2184, 0x24b6, /* 817 */
  0x24e9, 0x2c00, /* 1814 */
  0x2cf3, 0x2d00, /* 12 */
  0x2d2d, 0xa640, /* 30994 */
  0xa66d, 0xa680, /* 18 */
  0xa69b, 0xa722, /* 134 */
  0xa76f, 0xa779, /* 9 */
  0xa7dc, 0xa7f5, /* 24 */
  0xa7f6, 0xab53, /* 860 */
  0xab53, 0xab70, /* 28 */
  0xabbf, 0xfb05, /* 20293 */
  0xfb06, 0xff21, /* 1050 */
  0xff5a, 0x10400, /* 1189 */
  0x1044f, 0x104b0, /* 96 */
  0x104fb, 0x10570, /* 116 */
  0x105bc, 0x10c80, /* 1731 */
  0x10cb2, 0x10cc0, /* 13 */
  0x10cf2, 0x10d50, /* 93 */
  0x10d65, 0x10d70, /* 10 */
  0x10d85, 0x118a0, /* 2842 */
  0x118df, 0x16e40, /* 21856 */
  0x16e7f, 0x1e900, /* 31360 */
  0x1e943, 0x110000, /* 988860 */
  0xffffffff, 0xffffffff /* terminator */
};

/* Total: 1110933 characters. */
const uint32_t PRIV(ucd_nocase_ranges_size) = 80;

/* This table lists the code points for the '9' characters in each set of
decimal digits. It is used to ensure that all the digits in a script run come
from the same set. */

const uint32_t PRIV(ucd_digit_sets)[] = {
  76,  /* Number of subsequent values */
  0x00039, 0x00669, 0x006f9, 0x007c9, 0x0096f, 0x009ef, 0x00a6f, 0x00aef,
  0x00b6f, 0x00bef, 0x00c6f, 0x00cef, 0x00d6f, 0x00def, 0x00e59, 0x00ed9,
  0x00f29, 0x01049, 0x01099, 0x017e9, 0x01819, 0x0194f, 0x019d9, 0x01a89,
  0x01a99, 0x01b59, 0x01bb9, 0x01c49, 0x01c59, 0x0a629, 0x0a8d9, 0x0a909,
  0x0a9d9, 0x0a9f9, 0x0aa59, 0x0abf9, 0x0ff19, 0x104a9, 0x10d39, 0x10d49,
  0x1106f, 0x110f9, 0x1113f, 0x111d9, 0x112f9, 0x11459, 0x114d9, 0x11659,
  0x116c9, 0x116d9, 0x116e3, 0x11739, 0x118e9, 0x11959, 0x11bf9, 0x11c59,
  0x11d59, 0x11da9, 0x11f59, 0x16139, 0x16a69, 0x16ac9, 0x16b59, 0x16d79,
  0x1ccf9, 0x1d7d7, 0x1d7e1, 0x1d7eb, 0x1d7f5, 0x1d7ff, 0x1e149, 0x1e2f9,
  0x1e4f9, 0x1e5fa, 0x1e959, 0x1fbf9,
};

/* This vector is a list of script bitsets for the Script Extension property.
The number of 32-bit words in each bitset is #defined in pcre2_ucp.h as
ucd_script_sets_item_size. */

const uint32_t PRIV(ucd_script_sets)[] = {
 0x00000000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x40200003u, 0x00381901u, 0x00100246u, 0x00000000u,
 0x00040305u, 0x00800000u, 0x08000000u, 0x00000000u,
 0x20000001u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000001u, 0x00800000u, 0x00000000u, 0x00000000u,
 0x00040001u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x01000007u, 0x00000840u, 0x80000200u, 0x00000000u,
 0x01000007u, 0x00000040u, 0x80010000u, 0x00000001u,
 0x01000005u, 0x00002000u, 0x00000000u, 0x00000000u,
 0x00040041u, 0x00001000u, 0x80000000u, 0x00000000u,
 0x01000047u, 0x00002801u, 0x00010001u, 0x00000001u,
 0x10000001u, 0x00001801u, 0x00000004u, 0x00000000u,
 0x00000007u, 0x00000000u, 0x00000200u, 0x00000000u,
 0x00000051u, 0x00002840u, 0x00000202u, 0x00000001u,
 0x0000005fu, 0x00000041u, 0x00000202u, 0x00000000u,
 0x00000001u, 0x00002000u, 0x00000000u, 0x00000000u,
 0x00000041u, 0x00000000u, 0x00000002u, 0x00000000u,
 0x01000005u, 0x00000000u, 0x00010000u, 0x00000000u,
 0x01000001u, 0x00000040u, 0x00000000u, 0x00000000u,
 0x00000001u, 0x00000000u, 0x80000000u, 0x00000000u,
 0x00800001u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000005u, 0x00000000u, 0x00000000u, 0x00000001u,
 0x00000003u, 0x00000000u, 0x00000200u, 0x00000001u,
 0x00000041u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x11000041u, 0x00000000u, 0x00000002u, 0x00000000u,
 0x01000041u, 0x00000000u, 0x00000002u, 0x00000000u,
 0x00000041u, 0x00000000u, 0x80000000u, 0x00000000u,
 0x01000041u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x01040001u, 0x00000001u, 0x80000001u, 0x00000000u,
 0x00000002u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000001u, 0x00000000u, 0x00010000u, 0x00000000u,
 0x00000001u, 0x00000000u, 0x00000001u, 0x00000001u,
 0x00000001u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000002u, 0x00000800u, 0x00000000u, 0x00000000u,
 0x00000004u, 0x00000000u, 0x00000200u, 0x00000000u,
 0x00000004u, 0x00001000u, 0x00000000u, 0x00000000u,
 0x00000005u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00200008u, 0x00001000u, 0x00000000u, 0x00000000u,
 0x000000e0u, 0x00010000u, 0x11200000u, 0x00000000u,
 0x000000e0u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x000000e0u, 0x00010000u, 0x11208000u, 0x00000000u,
 0x00000060u, 0x08000000u, 0x04608480u, 0x00000000u,
 0x00000060u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x000000a0u, 0x00000000u, 0x01000000u, 0x00000000u,
 0x00000020u, 0x00000000u, 0x00200000u, 0x00000000u,
 0x0001ff01u, 0x40000000u, 0x00001008u, 0x00000000u,
 0x0001ff01u, 0x00000000u, 0x00001008u, 0x00000000u,
 0x0003ff00u, 0x80004000u, 0x409c1848u, 0x00000000u,
 0x0003ff00u, 0x80004020u, 0x609c1848u, 0x00000000u,
 0x00000100u, 0x04000000u, 0x00080040u, 0x00000000u,
 0x00000200u, 0x10004000u, 0x00000000u, 0x00000000u,
 0x00000400u, 0x00000000u, 0x00002000u, 0x00000000u,
 0x00000800u, 0x00000000u, 0x00000010u, 0x00000000u,
 0x00002000u, 0x00000000u, 0x00000008u, 0x00000000u,
 0x00008000u, 0x00000000u, 0x00800000u, 0x00000002u,
 0x00100000u, 0x10000040u, 0x00000000u, 0x00000000u,
 0x00200001u, 0x00001000u, 0x00000000u, 0x00000000u,
 0x02000000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x0000001eu, 0x00000000u, 0x00000000u,
 0x04000000u, 0x00008000u, 0x00000000u, 0x00000000u,
 0x00008300u, 0x00000000u, 0x00000008u, 0x00000000u,
 0x00000100u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00008100u, 0x00000000u, 0x00000008u, 0x00000000u,
 0x00000300u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000100u, 0x40000000u, 0x00000000u, 0x00000000u,
 0x0001f100u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000100u, 0x00000000u, 0x00800000u, 0x00000000u,
 0x0003d300u, 0x00000000u, 0x00801008u, 0x00000002u,
 0x00000100u, 0x00000000u, 0x00000008u, 0x00000000u,
 0x00008100u, 0x00000000u, 0x00000008u, 0x00000002u,
 0x00000200u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x00000000u, 0x00800000u, 0x00000000u,
 0x00000045u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000040u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x04000001u, 0x00008000u, 0x00000000u, 0x00000000u,
 0x00000020u, 0x00000000u, 0x00008000u, 0x00000000u,
 0x00200000u, 0x020c1000u, 0x00004000u, 0x00000000u,
 0x00000002u, 0x20080000u, 0x00004000u, 0x00000000u,
 0x00000101u, 0x00000000u, 0x00000008u, 0x00000000u,
 0x00000001u, 0x00000800u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x02200000u, 0x00000000u, 0x00000000u,
 0x00200000u, 0x04780000u, 0x00004000u, 0x00000000u,
 0x00000000u, 0x00000000u, 0x00000002u, 0x00000000u,
 0x00000020u, 0x00000000u, 0x0000c000u, 0x00000000u,
 0x40000000u, 0x00000000u, 0x00020000u, 0x00000000u,
 0xfc400000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0xfc400000u, 0x00008000u, 0x00000000u, 0x00000000u,
 0x78400000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x40000000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0xfc480000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0xfc480000u, 0x00800000u, 0x00000000u, 0x00000000u,
 0xf8400000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x60000000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x18000000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x58000000u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x40000001u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00018d00u, 0xc4000000u, 0x00881950u, 0x00000002u,
 0x00008d00u, 0xc4000000u, 0x00881950u, 0x00000002u,
 0x00000d00u, 0x84000000u, 0x00081950u, 0x00000000u,
 0x00000d00u, 0xc4000000u, 0x00081950u, 0x00000000u,
 0x00000300u, 0x00000000u, 0x00000000u, 0x00000002u,
 0x00002100u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00100001u, 0x00020000u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x01000400u, 0x00000000u, 0x00000000u,
 0x00000020u, 0x00010000u, 0x00000000u, 0x00000000u,
 0x000000a0u, 0x00000000u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x00000280u, 0x02000000u, 0x00000000u,
 0x00000000u, 0x00000280u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x00000280u, 0x00000020u, 0x00000000u,
 0x00000020u, 0x00000800u, 0x00000000u, 0x00000000u,
 0x00000000u, 0x00000000u, 0x04000080u, 0x00000000u,
};

/* This vector is a list of bitsets for Boolean properties. The number of
32_bit words in each bitset is #defined as ucd_boolprop_sets_item_size in
pcre2_ucp.h. */

const uint32_t PRIV(ucd_boolprop_sets)[] = {
 0x00000000u, 0x00000000u,
 0x00000001u, 0x00000000u,
 0x00000001u, 0x00400800u,
 0x00800001u, 0x00400800u,
 0x00800001u, 0x00050400u,
 0x00800001u, 0x00002400u,
 0x00830001u, 0x00000400u,
 0x00800001u, 0x00000400u,
 0x00800021u, 0x00002400u,
 0x00800011u, 0x00000400u,
 0x00800001u, 0x00000480u,
 0x00800001u, 0x00040400u,
 0x00801001u, 0x00000400u,
 0x00800021u, 0x00050400u,
 0x04830003u, 0x00800001u,
 0x00800021u, 0x00040400u,
 0x00800011u, 0x00000480u,
 0x048003c7u, 0x01900003u,
 0x008003c5u, 0x01900003u,
 0x00808021u, 0x00000480u,
 0x00800001u, 0x00800001u,
 0x00808021u, 0x00000400u,
 0x04800d47u, 0x01800043u,
 0x00800d45u, 0x01800043u,
 0x00800d45u, 0x01820043u,
 0x00000000u, 0x00400800u,
 0x00800000u, 0x00400000u,
 0x00800000u, 0x00000400u,
 0x00808020u, 0x00000000u,
 0x00a10000u, 0x00000400u,
 0x00800044u, 0x01800043u,
 0x00800010u, 0x00002400u,
 0x00800000u, 0x00000480u,
 0x00002020u, 0x00000000u,
 0x40800000u, 0x00000000u,
 0x00800dc4u, 0x01800043u,
 0x00c08020u, 0x00800001u,
 0x00800000u, 0x00000000u,
 0x008003c4u, 0x01900003u,
 0x00800d44u, 0x01800043u,
 0x00800d44u, 0x01820043u,
 0x00804dc4u, 0x01800043u,
 0x00800004u, 0x01800003u,
 0x008007c4u, 0x01900003u,
 0x00800bc4u, 0x01800003u,
 0x00808064u, 0x01800043u,
 0x00808064u, 0x01820043u,
 0x00808024u, 0x01800003u,
 0x00c08024u, 0x01800003u,
 0x01008020u, 0x00800009u,
 0x01008de4u, 0x00800049u,
 0x01002020u, 0x00800009u,
 0x01000020u, 0x00800009u,
 0x01000024u, 0x00800009u,
 0x00808064u, 0x00000043u,
 0x00800000u, 0x00040000u,
 0x00800020u, 0x00840001u,
 0x00800dc4u, 0x018000c3u,
 0x00800044u, 0x01900083u,
 0x00800044u, 0x01900003u,
 0x008003c4u, 0x01900083u,
 0x00800000u, 0x00000080u,
 0x01000020u, 0x00000008u,
 0x00800020u, 0x00000000u,
 0x00800000u, 0x00050000u,
 0x00801000u, 0x00000000u,
 0x01008024u, 0x00800009u,
 0x00000020u, 0x00001000u,
 0x00002028u, 0x00000000u,
 0x00c00024u, 0x01800003u,
 0x01000024u, 0x00800109u,
 0x01008020u, 0x00800109u,
 0x00800000u, 0x00800001u,
 0x00804004u, 0x01800003u,
 0x00800024u, 0x01800003u,
 0x01000020u, 0x00800109u,
 0x01008024u, 0x00800109u,
 0x00800004u, 0x00800001u,
 0x00800004u, 0x0180000bu,
 0x03008020u, 0x00800009u,
 0x01000004u, 0x00800009u,
 0x01400024u, 0x00800009u,
 0x01408020u, 0x00800009u,
 0x00800004u, 0x00800003u,
 0x03008024u, 0x00800009u,
 0x00800004u, 0x01800023u,
 0x00800010u, 0x00000000u,
 0x00808000u, 0x00800001u,
 0x01004024u, 0x00800009u,
 0x00808004u, 0x00800001u,
 0x00800944u, 0x01800043u,
 0x00800064u, 0x01800043u,
 0x00802004u, 0x01800003u,
 0x00800344u, 0x01900003u,
 0x03008000u, 0x00800009u,
 0x00c00000u, 0x00000000u,
 0x01002020u, 0x00a00009u,
 0x01000024u, 0x0180000bu,
 0x01008020u, 0x00000008u,
 0x01408024u, 0x00800009u,
 0x00808000u, 0x00000000u,
 0x00800044u, 0x01820043u,
 0x00800064u, 0x01820043u,
 0x01002020u, 0x00800011u,
 0x00022020u, 0x00800019u,
 0x00002028u, 0x00000800u,
 0x00801000u, 0x00000400u,
 0x00800020u, 0x00002400u,
 0x00800000u, 0x00002400u,
 0x00800020u, 0x00050400u,
 0x00800020u, 0x00000400u,
 0x00a10000u, 0x00050400u,
 0x00800000u, 0x00050400u,
 0x00800000u, 0x00800081u,
 0x00800010u, 0x00000400u,
 0x00002020u, 0x00000080u,
 0x00002000u, 0x00000000u,
 0x00006020u, 0x00000000u,
 0x40800000u, 0x00000080u,
 0x40801000u, 0x00000080u,
 0x40800010u, 0x00000080u,
 0x01000020u, 0x00800089u,
 0x01020020u, 0x00000008u,
 0x00800044u, 0x018000c3u,
 0x00800000u, 0x01800083u,
 0x00a10000u, 0x00000000u,
 0x00800000u, 0x01800003u,
 0x00800004u, 0x01800083u,
 0x00a10044u, 0x01800043u,
 0x00800044u, 0x018200c3u,
 0x00a10000u, 0x00000480u,
 0xc0800000u, 0x00000480u,
 0x00800010u, 0x00000480u,
 0x00801000u, 0x00000480u,
 0x00b10000u, 0x00000400u,
 0x00804010u, 0x00000400u,
 0x00a00000u, 0x00000400u,
 0x00000000u, 0x00000400u,
 0x008003c4u, 0x00100000u,
 0x00a103c4u, 0x00100000u,
 0x00800d44u, 0x00000040u,
 0x00b10000u, 0x00000480u,
 0x00a00000u, 0x00000480u,
 0x00a90000u, 0x00000400u,
 0x00b90000u, 0x00000400u,
 0x03000020u, 0x00800009u,
 0x00808024u, 0x00000400u,
 0x00800000u, 0x00040400u,
 0x00800000u, 0x00004000u,
 0x08800000u, 0x00000000u,
 0x10800000u, 0x00000000u,
 0x20800000u, 0x00000000u,
 0x00800004u, 0x01800007u,
 0x01008000u, 0x00800009u,
 0x00a11000u, 0x00000400u,
 0x00808020u, 0x00000003u,
 0x00800004u, 0x01880007u,
 0x00808004u, 0x01800003u,
 0x00800004u, 0x00000003u,
 0x00000000u, 0x00000200u,
 0x01022020u, 0x00a00009u,
 0x00800000u, 0x00002000u,
 0x00800020u, 0x00050000u,
 0x00800020u, 0x00040000u,
 0x00801000u, 0x00000080u,
 0x00800010u, 0x00000080u,
 0x00800020u, 0x00002000u,
 0x04800000u, 0x00800001u,
 0x048003c4u, 0x01900003u,
 0x00808020u, 0x00000080u,
 0x04800d44u, 0x01800043u,
 0x00800010u, 0x00002000u,
 0x01008024u, 0x0080000bu,
 0x00000020u, 0x00000000u,
 0x00c00004u, 0x01800003u,
 0x00c08004u, 0x01800003u,
 0x01400020u, 0x00800009u,
 0x01000020u, 0x0080000du,
 0x01008004u, 0x00800009u,
 0x01000000u, 0x00800009u,
 0xc0800000u, 0x00000080u,
 0x00a00000u, 0x00000000u,
 0x00b10000u, 0x00000000u,
 0x00200000u, 0x00000000u,
 0x00800044u, 0x00100000u,
 0x00a10044u, 0x00100000u,
 0x00930000u, 0x00008000u,
 0x00b90000u, 0x00000000u,
 0x00a90000u, 0x00000000u,
 0x00970020u, 0x00000008u,
 0x00b30000u, 0x00000000u,
 0x01022020u, 0x00000008u,
};

/* These are the main two-stage UCD tables. The fields in each record are:
script (8 bits), character type (8 bits), grapheme break property (8 bits),
offset to multichar other cases or zero (8 bits), offset to other case or zero
(32 bits, signed), bidi class (5 bits) and script extension (11 bits) packed
into a 16-bit field, and offset in binary properties table (16 bits). */

const ucd_record PRIV(ucd_records)[] = { /* 18516 bytes, record size 12 */
  {    99,      0,      2,      0,      0,   6144,      2, }, /*   0 */
  {    99,      0,      2,      0,      0,  43008,      4, }, /*   1 */
  {    99,      0,      1,      0,      0,   4096,      4, }, /*   2 */
  {    99,      0,      2,      0,      0,  45056,      4, }, /*   3 */
  {    99,      0,      0,      0,      0,   4096,      4, }, /*   4 */
  {    99,      0,      2,      0,      0,   4096,      2, }, /*   5 */
  {    99,      0,      2,      0,      0,  43008,      2, }, /*   6 */
  {    99,     29,     12,      0,      0,  45056,      6, }, /*   7 */
  {    99,     21,     12,      0,      0,  28672,      8, }, /*   8 */
  {    99,     21,     12,      0,      0,  28672,     10, }, /*   9 */
  {    99,     21,     12,      0,      0,  14336,     12, }, /*  10 */
  {    99,     23,     12,      0,      0,  14336,     14, }, /*  11 */
  {    99,     21,     12,      0,      0,  14336,     14, }, /*  12 */
  {    99,     21,     12,      0,      0,  28672,     14, }, /*  13 */
  {    99,     21,     12,      0,      0,  28672,     16, }, /*  14 */
  {    99,     22,     12,      0,      0,  28672,     18, }, /*  15 */
  {    99,     18,     12,      0,      0,  28672,     18, }, /*  16 */
  {    99,     21,     12,      0,      0,  28672,     12, }, /*  17 */
  {    99,     25,     12,      0,      0,  12288,     20, }, /*  18 */
  {    99,     21,     12,      0,      0,   8192,     22, }, /*  19 */
  {    99,     17,     12,      0,      0,  12288,     24, }, /*  20 */
  {    99,     21,     12,      0,      0,   8192,     26, }, /*  21 */
  {    99,     21,     12,      0,      0,   8192,     14, }, /*  22 */
  {    99,     13,     12,      0,      0,  10240,     28, }, /*  23 */
  {    99,     21,     12,      0,      0,   8192,     30, }, /*  24 */
  {    99,     21,     12,      0,      0,  28672,     22, }, /*  25 */
  {    99,     25,     12,      0,      0,  28672,     32, }, /*  26 */
  {    99,     25,     12,      0,      0,  28672,     20, }, /*  27 */
  {     0,      9,     12,      0,     32,  18432,     34, }, /*  28 */
  {     0,      9,     12,      0,     32,  18432,     36, }, /*  29 */
  {     0,      9,     12,    100,     32,  18432,     36, }, /*  30 */
  {     0,      9,     12,      1,     32,  18432,     36, }, /*  31 */
  {    99,     24,     12,      0,      0,  28672,     38, }, /*  32 */
  {    99,     16,     12,      0,      0,  28672,     40, }, /*  33 */
  {    99,     24,     12,      0,      0,  28672,     42, }, /*  34 */
  {     0,      5,     12,      0,    -32,  18432,     44, }, /*  35 */
  {     0,      5,     12,      0,    -32,  18432,     46, }, /*  36 */
  {     0,      5,     12,      0,    -32,  18432,     48, }, /*  37 */
  {     0,      5,     12,    100,    -32,  18432,     46, }, /*  38 */
  {     0,      5,     12,      1,    -32,  18432,     46, }, /*  39 */
  {    99,      0,      2,      0,      0,   6144,      0, }, /*  40 */
  {    99,      0,      2,      0,      0,   4096,     50, }, /*  41 */
  {    99,     29,     12,      0,      0,   8192,     52, }, /*  42 */
  {    99,     21,     12,      0,      0,  28672,     54, }, /*  43 */
  {    99,     23,     12,      0,      0,  14336,     54, }, /*  44 */
  {    99,     26,     12,      0,      0,  28672,     54, }, /*  45 */
  {    99,     24,     12,      0,      0,  28672,     56, }, /*  46 */
  {    99,     26,     14,      0,      0,  28672,     58, }, /*  47 */
  {     0,      7,     12,      0,      0,  18432,     60, }, /*  48 */
  {    99,     20,     12,      0,      0,  28672,     62, }, /*  49 */
  {    99,     25,     12,      0,      0,  28672,     64, }, /*  50 */
  {    99,      1,      2,      0,      0,   6144,     66, }, /*  51 */
  {    99,     26,     12,      0,      0,  14336,     54, }, /*  52 */
  {    99,     25,     12,      0,      0,  14336,     64, }, /*  53 */
  {    99,     15,     12,      0,      0,  10240,     68, }, /*  54 */
  {    99,      5,     12,     26,    775,  18432,     70, }, /*  55 */
  {    99,     21,     12,      0,      0,  28676,     72, }, /*  56 */
  {    99,     19,     12,      0,      0,  28672,     62, }, /*  57 */
  {    99,     15,     12,      0,      0,  28672,     74, }, /*  58 */
  {     0,      9,     12,      0,     32,  18432,     76, }, /*  59 */
  {     0,      9,     12,    104,     32,  18432,     76, }, /*  60 */
  {     0,      5,     12,      0,   7615,  18432,     70, }, /*  61 */
  {     0,      5,     12,      0,    -32,  18432,     78, }, /*  62 */
  {     0,      5,     12,    104,    -32,  18432,     78, }, /*  63 */
  {     0,      5,     12,      0,    121,  18432,     78, }, /*  64 */
  {     0,      9,     12,      0,      1,  18432,     76, }, /*  65 */
  {     0,      5,     12,      0,     -1,  18432,     78, }, /*  66 */
  {     0,      5,     12,      0,     -1,  18432,     80, }, /*  67 */
  {     0,      9,     12,      0,      0,  18432,     76, }, /*  68 */
  {     0,      5,     12,      0,      0,  18432,     78, }, /*  69 */
  {     0,      5,     12,      0,      0,  18432,     60, }, /*  70 */
  {     0,      5,     12,      0,      0,  18432,     82, }, /*  71 */
  {     0,      9,     12,      0,   -121,  18432,     76, }, /*  72 */
  {     0,      5,     12,      1,      0,  18432,     70, }, /*  73 */
  {     0,      5,     12,      0,    195,  18432,     78, }, /*  74 */
  {     0,      9,     12,      0,    210,  18432,     76, }, /*  75 */
  {     0,      9,     12,      0,    206,  18432,     76, }, /*  76 */
  {     0,      9,     12,      0,    205,  18432,     76, }, /*  77 */
  {     0,      9,     12,      0,     79,  18432,     76, }, /*  78 */
  {     0,      9,     12,      0,    202,  18432,     76, }, /*  79 */
  {     0,      9,     12,      0,    203,  18432,     76, }, /*  80 */
  {     0,      9,     12,      0,    207,  18432,     76, }, /*  81 */
  {     0,      5,     12,      0,     97,  18432,     78, }, /*  82 */
  {     0,      9,     12,      0,    211,  18432,     76, }, /*  83 */
  {     0,      9,     12,      0,    209,  18432,     76, }, /*  84 */
  {     0,      5,     12,      0,    163,  18432,     78, }, /*  85 */
  {     0,      5,     12,      0,  42561,  18432,     78, }, /*  86 */
  {     0,      9,     12,      0,    213,  18432,     76, }, /*  87 */
  {     0,      5,     12,      0,    130,  18432,     78, }, /*  88 */
  {     0,      9,     12,      0,    214,  18432,     76, }, /*  89 */
  {     0,      9,     12,      0,    218,  18432,     76, }, /*  90 */
  {     0,      9,     12,      0,    217,  18432,     76, }, /*  91 */
  {     0,      9,     12,      0,    219,  18432,     76, }, /*  92 */
  {     0,      7,     12,      0,      0,  18432,     84, }, /*  93 */
  {     0,      5,     12,      0,     56,  18432,     78, }, /*  94 */
  {     0,      9,     12,      5,      2,  18432,     86, }, /*  95 */
  {     0,      8,     12,      5,      1,  18432,     88, }, /*  96 */
  {     0,      5,     12,      5,     -2,  18432,     78, }, /*  97 */
  {     0,      9,     12,      9,      2,  18432,     86, }, /*  98 */
  {     0,      8,     12,      9,      1,  18432,     88, }, /*  99 */
  {     0,      5,     12,      9,     -2,  18432,     78, }, /* 100 */
  {     0,      9,     12,     13,      2,  18432,     86, }, /* 101 */
  {     0,      8,     12,     13,      1,  18432,     88, }, /* 102 */
  {     0,      5,     12,     13,     -2,  18432,     78, }, /* 103 */
  {     0,      5,     12,      0,    -79,  18432,     78, }, /* 104 */
  {     0,      9,     12,     17,      2,  18432,     86, }, /* 105 */
  {     0,      8,     12,     17,      1,  18432,     88, }, /* 106 */
  {     0,      5,     12,     17,     -2,  18432,     78, }, /* 107 */
  {     0,      9,     12,      0,    -97,  18432,     76, }, /* 108 */
  {     0,      9,     12,      0,    -56,  18432,     76, }, /* 109 */
  {     0,      9,     12,      0,   -130,  18432,     76, }, /* 110 */
  {     0,      9,     12,      0,  10795,  18432,     76, }, /* 111 */
  {     0,      9,     12,      0,   -163,  18432,     76, }, /* 112 */
  {     0,      9,     12,      0,  10792,  18432,     76, }, /* 113 */
  {     0,      5,     12,      0,  10815,  18432,     78, }, /* 114 */
  {     0,      9,     12,      0,   -195,  18432,     76, }, /* 115 */
  {     0,      9,     12,      0,     69,  18432,     76, }, /* 116 */
  {     0,      9,     12,      0,     71,  18432,     76, }, /* 117 */
  {     0,      5,     12,      0,  10783,  18432,     78, }, /* 118 */
  {     0,      5,     12,      0,  10780,  18432,     78, }, /* 119 */
  {     0,      5,     12,      0,  10782,  18432,     78, }, /* 120 */
  {     0,      5,     12,      0,   -210,  18432,     78, }, /* 121 */
  {     0,      5,     12,      0,   -206,  18432,     78, }, /* 122 */
  {     0,      5,     12,      0,   -205,  18432,     78, }, /* 123 */
  {     0,      5,     12,      0,   -202,  18432,     78, }, /* 124 */
  {     0,      5,     12,      0,   -203,  18432,     78, }, /* 125 */
  {     0,      5,     12,      0,  42319,  18432,     78, }, /* 126 */
  {     0,      5,     12,      0,  42315,  18432,     78, }, /* 127 */
  {     0,      5,     12,      0,   -207,  18432,     78, }, /* 128 */
  {     0,      5,     12,      0,  42343,  18432,     78, }, /* 129 */
  {     0,      5,     12,      0,  42280,  18432,     78, }, /* 130 */
  {     0,      5,     12,      0,  42308,  18432,     78, }, /* 131 */
  {     0,      5,     12,      0,   -209,  18432,     80, }, /* 132 */
  {     0,      5,     12,      0,   -211,  18432,     78, }, /* 133 */
  {     0,      5,     12,      0,  10743,  18432,     78, }, /* 134 */
  {     0,      5,     12,      0,  42305,  18432,     78, }, /* 135 */
  {     0,      5,     12,      0,  10749,  18432,     78, }, /* 136 */
  {     0,      5,     12,      0,   -213,  18432,     78, }, /* 137 */
  {     0,      5,     12,      0,   -214,  18432,     78, }, /* 138 */
  {     0,      5,     12,      0,  10727,  18432,     78, }, /* 139 */
  {     0,      5,     12,      0,   -218,  18432,     78, }, /* 140 */
  {     0,      5,     12,      0,  42307,  18432,     78, }, /* 141 */
  {     0,      5,     12,      0,  42282,  18432,     78, }, /* 142 */
  {     0,      5,     12,      0,    -69,  18432,     78, }, /* 143 */
  {     0,      5,     12,      0,   -217,  18432,     78, }, /* 144 */
  {     0,      5,     12,      0,    -71,  18432,     78, }, /* 145 */
  {     0,      5,     12,      0,   -219,  18432,     78, }, /* 146 */
  {     0,      5,     12,      0,  42261,  18432,     80, }, /* 147 */
  {     0,      5,     12,      0,  42258,  18432,     78, }, /* 148 */
  {     0,      6,     12,      0,      0,  18432,     90, }, /* 149 */
  {     0,      6,     12,      0,      0,  18432,     92, }, /* 150 */
  {    99,      6,     12,      0,      0,  28672,     94, }, /* 151 */
  {    99,      6,     12,      0,      0,  18432,     94, }, /* 152 */
  {    99,      6,     12,      0,      0,  18440,     94, }, /* 153 */
  {    99,      6,     12,      0,      0,  18432,     90, }, /* 154 */
  {    99,      6,     12,      0,      0,  28684,     94, }, /* 155 */
  {    99,      6,     12,      0,      0,  28688,     94, }, /* 156 */
  {    99,      6,     12,      0,      0,  18432,     96, }, /* 157 */
  {    99,     24,     12,      0,      0,  28692,     56, }, /* 158 */
  {    99,     24,     12,      0,      0,  28684,     56, }, /* 159 */
  {    29,     24,     12,      0,      0,  28672,     56, }, /* 160 */
  {   106,     12,      3,      0,      0,  26648,     98, }, /* 161 */
  {   106,     12,      3,      0,      0,  26652,     98, }, /* 162 */
  {   106,     12,      3,      0,      0,  26656,     98, }, /* 163 */
  {   106,     12,      3,      0,      0,  26660,     98, }, /* 164 */
  {   106,     12,      3,      0,      0,  26664,     98, }, /* 165 */
  {   106,     12,      3,      0,      0,  26668,     98, }, /* 166 */
  {   106,     12,      3,      0,      0,  26672,     98, }, /* 167 */
  {   106,     12,      3,      0,      0,  26676,     98, }, /* 168 */
  {   106,     12,      3,      0,      0,  26680,     98, }, /* 169 */
  {   106,     12,      3,      0,      0,  26684,     98, }, /* 170 */
  {   106,     12,      3,      0,      0,  26688,     98, }, /* 171 */
  {   106,     12,      3,      0,      0,  26692,     98, }, /* 172 */
  {   106,     12,      3,      0,      0,  26696,     98, }, /* 173 */
  {   106,     12,      3,      0,      0,  26700,     98, }, /* 174 */
  {   106,     12,      3,      0,      0,  26704,     98, }, /* 175 */
  {   106,     12,      3,      0,      0,  26624,     98, }, /* 176 */
  {   106,     12,      3,      0,      0,  26708,     98, }, /* 177 */
  {   106,     12,      3,      0,      0,  26712,     98, }, /* 178 */
  {   106,     12,      3,      0,      0,  26716,     98, }, /* 179 */
  {   106,     12,      3,      0,      0,  26720,     98, }, /* 180 */
  {   106,     12,      3,      0,      0,  26724,     98, }, /* 181 */
  {   106,     12,      3,      0,      0,  26728,     98, }, /* 182 */
  {   106,     12,      3,      0,      0,  26732,     98, }, /* 183 */
  {   106,     12,      3,      0,      0,  26736,     98, }, /* 184 */
  {   106,     12,      3,      0,      0,  26740,     98, }, /* 185 */
  {   106,     12,      3,     21,    116,  26740,    100, }, /* 186 */
  {   106,     12,      3,      0,      0,  26624,    102, }, /* 187 */
  {   106,     12,      3,      0,      0,  26744,    104, }, /* 188 */
  {   106,     12,      3,      0,      0,  26624,    104, }, /* 189 */
  {   106,     12,      3,      0,      0,  26748,     98, }, /* 190 */
  {   106,     12,      3,      0,      0,  26752,    106, }, /* 191 */
  {     1,      9,     12,      0,      1,  18432,     76, }, /* 192 */
  {     1,      5,     12,      0,     -1,  18432,     78, }, /* 193 */
  {    99,      6,     12,      0,      0,  28804,     94, }, /* 194 */
  {     1,     24,     12,      0,      0,  28804,     56, }, /* 195 */
  {    98,      2,     12,      0,      0,  18432,      0, }, /* 196 */
  {     1,      6,     12,      0,      0,  18432,    108, }, /* 197 */
  {     1,      5,     12,      0,    130,  18432,     78, }, /* 198 */
  {    99,     21,     12,      0,      0,  28672,    110, }, /* 199 */
  {     1,      9,     12,      0,    116,  18432,     76, }, /* 200 */
  {     1,     24,     12,      0,      0,  28672,     56, }, /* 201 */
  {     1,      9,     12,      0,     38,  18432,     76, }, /* 202 */
  {    99,     21,     12,      0,      0,  28672,    112, }, /* 203 */
  {     1,      9,     12,      0,     37,  18432,     76, }, /* 204 */
  {     1,      9,     12,      0,     64,  18432,     76, }, /* 205 */
  {     1,      9,     12,      0,     63,  18432,     76, }, /* 206 */
  {     1,      5,     12,      0,   7235,  18432,     78, }, /* 207 */
  {     1,      9,     12,      0,     32,  18432,     76, }, /* 208 */
  {     1,      9,     12,     34,     32,  18432,     76, }, /* 209 */
  {     1,      9,     12,     59,     32,  18432,     76, }, /* 210 */
  {     1,      9,     12,     38,     32,  18432,     76, }, /* 211 */
  {     1,      9,     12,     21,     32,  18432,     76, }, /* 212 */
  {     1,      9,     12,     51,     32,  18432,     76, }, /* 213 */
  {     1,      9,     12,     26,     32,  18432,     76, }, /* 214 */
  {     1,      9,     12,     47,     32,  18432,     76, }, /* 215 */
  {     1,      9,     12,     55,     32,  18432,     76, }, /* 216 */
  {     1,      9,     12,     30,     32,  18432,     76, }, /* 217 */
  {     1,      9,     12,     43,     32,  18432,     76, }, /* 218 */
  {     1,      9,     12,     96,     32,  18432,     76, }, /* 219 */
  {     1,      5,     12,      0,    -38,  18432,     78, }, /* 220 */
  {     1,      5,     12,      0,    -37,  18432,     78, }, /* 221 */
  {     1,      5,     12,      0,   7219,  18432,     78, }, /* 222 */
  {     1,      5,     12,      0,    -32,  18432,     78, }, /* 223 */
  {     1,      5,     12,     34,    -32,  18432,     78, }, /* 224 */
  {     1,      5,     12,     59,    -32,  18432,     78, }, /* 225 */
  {     1,      5,     12,     38,    -32,  18432,     78, }, /* 226 */
  {     1,      5,     12,     21,   -116,  18432,     78, }, /* 227 */
  {     1,      5,     12,     51,    -32,  18432,     78, }, /* 228 */
  {     1,      5,     12,     26,   -775,  18432,     78, }, /* 229 */
  {     1,      5,     12,     47,    -32,  18432,     78, }, /* 230 */
  {     1,      5,     12,     55,    -32,  18432,     78, }, /* 231 */
  {     1,      5,     12,     30,      1,  18432,     70, }, /* 232 */
  {     1,      5,     12,     30,    -32,  18432,     78, }, /* 233 */
  {     1,      5,     12,     43,    -32,  18432,     78, }, /* 234 */
  {     1,      5,     12,     96,    -32,  18432,     78, }, /* 235 */
  {     1,      5,     12,      0,    -64,  18432,     78, }, /* 236 */
  {     1,      5,     12,      0,    -63,  18432,     78, }, /* 237 */
  {     1,      9,     12,      0,      8,  18432,     76, }, /* 238 */
  {     1,      5,     12,     34,    -30,  18432,    114, }, /* 239 */
  {     1,      5,     12,     38,    -25,  18432,    114, }, /* 240 */
  {     1,      9,     12,      0,      0,  18432,    116, }, /* 241 */
  {     1,      9,     12,      0,      0,  18432,    118, }, /* 242 */
  {     1,      5,     12,     43,    -15,  18432,    114, }, /* 243 */
  {     1,      5,     12,     47,    -22,  18432,     70, }, /* 244 */
  {     1,      5,     12,      0,     -8,  18432,     78, }, /* 245 */
  {    43,      9,     12,      0,      1,  18432,     76, }, /* 246 */
  {    43,      5,     12,      0,     -1,  18432,     78, }, /* 247 */
  {     1,      5,     12,     51,    -54,  18432,    114, }, /* 248 */
  {     1,      5,     12,     55,    -48,  18432,    114, }, /* 249 */
  {     1,      5,     12,      0,      7,  18432,     78, }, /* 250 */
  {     1,      5,     12,      0,   -116,  18432,     80, }, /* 251 */
  {     1,      9,     12,     38,    -60,  18432,    120, }, /* 252 */
  {     1,      5,     12,     59,    -64,  18432,    114, }, /* 253 */
  {     1,     25,     12,      0,      0,  28672,    122, }, /* 254 */
  {     1,      9,     12,      0,     -7,  18432,     76, }, /* 255 */
  {     1,      5,     12,      0,      0,  18432,     60, }, /* 256 */
  {     1,      9,     12,      0,   -130,  18432,     76, }, /* 257 */
  {     2,      9,     12,      0,     80,  18432,     76, }, /* 258 */
  {     2,      9,     12,      0,     32,  18432,     76, }, /* 259 */
  {     2,      9,     12,     63,     32,  18432,     76, }, /* 260 */
  {     2,      9,     12,     67,     32,  18432,     76, }, /* 261 */
  {     2,      9,     12,     71,     32,  18432,     76, }, /* 262 */
  {     2,      9,     12,     75,     32,  18432,     76, }, /* 263 */
  {     2,      9,     12,     79,     32,  18432,     76, }, /* 264 */
  {     2,      9,     12,     84,     32,  18432,     76, }, /* 265 */
  {     2,      5,     12,      0,    -32,  18432,     78, }, /* 266 */
  {     2,      5,     12,     63,    -32,  18432,     78, }, /* 267 */
  {     2,      5,     12,     67,    -32,  18432,     78, }, /* 268 */
  {     2,      5,     12,     71,    -32,  18432,     78, }, /* 269 */
  {     2,      5,     12,     75,    -32,  18432,     78, }, /* 270 */
  {     2,      5,     12,     79,    -32,  18432,     78, }, /* 271 */
  {     2,      5,     12,     84,    -32,  18432,     78, }, /* 272 */
  {     2,      5,     12,      0,    -80,  18432,     78, }, /* 273 */
  {     2,      5,     12,      0,    -80,  18432,     80, }, /* 274 */
  {     2,      9,     12,      0,      1,  18432,     76, }, /* 275 */
  {     2,      5,     12,      0,     -1,  18432,     78, }, /* 276 */
  {     2,      9,     12,     88,      1,  18432,     76, }, /* 277 */
  {     2,      5,     12,     88,     -1,  18432,     78, }, /* 278 */
  {     2,     26,     12,      0,      0,  18432,     74, }, /* 279 */
  {     2,     12,      3,      0,      0,  26760,     98, }, /* 280 */
  {     2,     12,      3,      0,      0,  26764,     98, }, /* 281 */
  {   106,     12,      3,      0,      0,  26768,     98, }, /* 282 */
  {     2,     11,      3,      0,      0,  26624,    124, }, /* 283 */
  {     2,      9,     12,      0,     15,  18432,     76, }, /* 284 */
  {     2,      5,     12,      0,    -15,  18432,     78, }, /* 285 */
  {     3,      9,     12,      0,     48,  18432,     76, }, /* 286 */
  {     3,      6,     12,      0,      0,  18432,     94, }, /* 287 */
  {     3,     21,     12,      0,      0,  18432,     74, }, /* 288 */
  {     3,     21,     12,      0,      0,  18432,    126, }, /* 289 */
  {     3,      5,     12,      0,      0,  18432,     60, }, /* 290 */
  {     3,      5,     12,      0,    -48,  18432,     78, }, /* 291 */
  {     3,      5,     12,      0,      0,  18432,     70, }, /* 292 */
  {     3,     21,     12,      0,      0,  18580,    128, }, /* 293 */
  {     3,     17,     12,      0,      0,  28672,    130, }, /* 294 */
  {     3,     26,     12,      0,      0,  28672,     74, }, /* 295 */
  {     3,     23,     12,      0,      0,  14336,     74, }, /* 296 */
  {    98,      2,     12,      0,      0,  34816,      0, }, /* 297 */
  {     4,     12,      3,      0,      0,  26624,     98, }, /* 298 */
  {     4,     12,      3,      0,      0,  26624,    104, }, /* 299 */
  {     4,     12,      3,      0,      0,  26624,    132, }, /* 300 */
  {     4,     17,     12,      0,      0,  34816,    130, }, /* 301 */
  {     4,     21,     12,      0,      0,  34816,     74, }, /* 302 */
  {     4,     21,     12,      0,      0,  34816,    110, }, /* 303 */
  {     4,     12,      3,      0,      0,  26624,    106, }, /* 304 */
  {     4,      7,     12,      0,      0,  34816,     84, }, /* 305 */
  {     4,     21,     12,      0,      0,  34816,    126, }, /* 306 */
  {     5,      1,      4,      0,      0,   2048,    134, }, /* 307 */
  {    99,      1,      4,      0,      0,   2048,    134, }, /* 308 */
  {     5,     25,     12,      0,      0,  28672,    122, }, /* 309 */
  {     5,     25,     12,      0,      0,      0,    122, }, /* 310 */
  {     5,     21,     12,      0,      0,  14336,     74, }, /* 311 */
  {     5,     23,     12,      0,      0,      0,     74, }, /* 312 */
  {    99,     21,     12,      0,      0,   8344,    110, }, /* 313 */
  {     5,     21,     12,      0,      0,      0,     74, }, /* 314 */
  {     5,     26,     12,      0,      0,  28672,     74, }, /* 315 */
  {     5,     12,      3,      0,      0,  26624,    106, }, /* 316 */
  {    99,     21,     12,      0,      0,    152,    110, }, /* 317 */
  {     5,      1,      2,      0,      0,    156,    136, }, /* 318 */
  {     5,     21,     12,      0,      0,      0,    128, }, /* 319 */
  {    99,     21,     12,      0,      0,    160,    128, }, /* 320 */
  {     5,      7,     12,      0,      0,      0,     84, }, /* 321 */
  {    99,      6,     12,      0,      0,    164,    138, }, /* 322 */
  {   106,     12,      3,      0,      0,  26792,    132, }, /* 323 */
  {   106,     12,      3,      0,      0,  26792,    106, }, /* 324 */
  {   106,     12,      3,      0,      0,  26792,    140, }, /* 325 */
  {     5,     12,      3,      0,      0,  26624,    132, }, /* 326 */
  {     5,     12,      3,      0,      0,  26624,    142, }, /* 327 */
  {     5,     13,     12,      0,      0,   2220,    144, }, /* 328 */
  {     5,     21,     12,      0,      0,   2048,     74, }, /* 329 */
  {     5,      7,     12,      0,      0,      0,    146, }, /* 330 */
  {     5,     21,     12,      0,      0,    176,    128, }, /* 331 */
  {     5,     12,      3,      0,      0,  26624,    140, }, /* 332 */
  {     5,     12,      3,      0,      0,  26624,     98, }, /* 333 */
  {     5,      6,     12,      0,      0,      0,     94, }, /* 334 */
  {     5,     13,     12,      0,      0,  10240,    144, }, /* 335 */
  {     5,     26,     12,      0,      0,      0,     74, }, /* 336 */
  {     6,     21,     12,      0,      0,      0,    128, }, /* 337 */
  {     6,     21,     12,      0,      0,      0,    110, }, /* 338 */
  {     6,     21,     12,      0,      0,      0,     74, }, /* 339 */
  {    98,      2,     12,      0,      0,      0,      0, }, /* 340 */
  {     6,      1,      4,      0,      0,      0,    134, }, /* 341 */
  {     6,      7,     12,      0,      0,      0,     84, }, /* 342 */
  {     6,     12,      3,      0,      0,  26624,    106, }, /* 343 */
  {     6,     12,      3,      0,      0,  26624,    132, }, /* 344 */
  {     6,     12,      3,      0,      0,  26624,     98, }, /* 345 */
  {     7,      7,     12,      0,      0,      0,     84, }, /* 346 */
  {     7,     12,      3,      0,      0,  26624,    132, }, /* 347 */
  {    48,     13,     12,      0,      0,  34816,    144, }, /* 348 */
  {    48,      7,     12,      0,      0,  34816,     84, }, /* 349 */
  {    48,     12,      3,      0,      0,  26624,     98, }, /* 350 */
  {    48,      6,     12,      0,      0,  34816,     94, }, /* 351 */
  {    48,     26,     12,      0,      0,  28672,     74, }, /* 352 */
  {    48,     21,     12,      0,      0,  28672,     74, }, /* 353 */
  {    48,     21,     12,      0,      0,  28672,    110, }, /* 354 */
  {    48,     21,     12,      0,      0,  28672,    128, }, /* 355 */
  {    48,      6,     12,      0,      0,  34816,    138, }, /* 356 */
  {    48,     12,      3,      0,      0,  26624,    104, }, /* 357 */
  {    48,     23,     12,      0,      0,  34816,     74, }, /* 358 */
  {    54,      7,     12,      0,      0,  34816,     84, }, /* 359 */
  {    54,     12,      3,      0,      0,  26624,    106, }, /* 360 */
  {    54,     12,      3,      0,      0,  26624,     98, }, /* 361 */
  {    54,      6,     12,      0,      0,  34816,    148, }, /* 362 */
  {    54,     12,      3,      0,      0,  26624,    104, }, /* 363 */
  {    54,     21,     12,      0,      0,  34816,    110, }, /* 364 */
  {    54,     21,     12,      0,      0,  34816,     74, }, /* 365 */
  {    54,     21,     12,      0,      0,  34816,    128, }, /* 366 */
  {    59,      7,     12,      0,      0,  34816,     84, }, /* 367 */
  {    59,     12,      3,      0,      0,  26624,    104, }, /* 368 */
  {    59,     21,     12,      0,      0,  34816,    110, }, /* 369 */
  {     5,     24,     12,      0,      0,      0,    126, }, /* 370 */
  {     5,     12,      3,      0,      0,  26624,    150, }, /* 371 */
  {     5,     12,      3,      0,      0,  26624,    104, }, /* 372 */
  {     5,     12,      3,      0,      0,  26624,    152, }, /* 373 */
  {     8,     12,      3,      0,      0,  26624,    106, }, /* 374 */
  {     8,     10,      5,      0,      0,  18432,    154, }, /* 375 */
  {     8,      7,     12,      0,      0,  18432,     84, }, /* 376 */
  {     8,      7,     12,      0,      0,  18432,    156, }, /* 377 */
  {     8,     12,      3,      0,      0,  26624,     98, }, /* 378 */
  {     8,     12,      3,      0,      0,  26624,    158, }, /* 379 */
  {   106,     12,      3,      0,      0,  26804,     98, }, /* 380 */
  {   106,     12,      3,      0,      0,  26808,     98, }, /* 381 */
  {    99,     21,     12,      0,      0,  18620,    128, }, /* 382 */
  {    99,     21,     12,      0,      0,  18624,    128, }, /* 383 */
  {     8,     13,     12,      0,      0,  18628,    144, }, /* 384 */
  {     8,     21,     12,      0,      0,  18432,     74, }, /* 385 */
  {     8,      6,     12,      0,      0,  18432,     94, }, /* 386 */
  {     9,      7,     12,      0,      0,  18432,     84, }, /* 387 */
  {     9,     12,      3,      0,      0,  26624,    106, }, /* 388 */
  {     9,     10,      5,      0,      0,  18432,    154, }, /* 389 */
  {     9,      7,     12,      0,      0,  18432,    156, }, /* 390 */
  {     9,     12,      3,      0,      0,  26624,     98, }, /* 391 */
  {     9,     10,      3,      0,      0,  18432,    160, }, /* 392 */
  {     9,     12,      3,      0,      0,  26624,    158, }, /* 393 */
  {     9,     13,     12,      0,      0,  18632,    144, }, /* 394 */
  {     9,     23,     12,      0,      0,  14336,     74, }, /* 395 */
  {     9,     15,     12,      0,      0,  18432,     74, }, /* 396 */
  {     9,     26,     12,      0,      0,  18432,     74, }, /* 397 */
  {     9,     21,     12,      0,      0,  18432,     74, }, /* 398 */
  {     9,     12,      3,      0,      0,  26624,    104, }, /* 399 */
  {    10,     12,      3,      0,      0,  26624,    106, }, /* 400 */
  {    10,     10,      5,      0,      0,  18432,    154, }, /* 401 */
  {    10,      7,     12,      0,      0,  18432,     84, }, /* 402 */
  {    10,     12,      3,      0,      0,  26624,     98, }, /* 403 */
  {    10,     12,      3,      0,      0,  26624,    158, }, /* 404 */
  {    10,     13,     12,      0,      0,  18636,    144, }, /* 405 */
  {    10,     12,      3,      0,      0,  26624,    162, }, /* 406 */
  {    10,     21,     12,      0,      0,  18432,     74, }, /* 407 */
  {    11,     12,      3,      0,      0,  26624,    106, }, /* 408 */
  {    11,     10,      5,      0,      0,  18432,    154, }, /* 409 */
  {    11,      7,     12,      0,      0,  18432,     84, }, /* 410 */
  {    11,      7,     12,      0,      0,  18432,    156, }, /* 411 */
  {    11,     12,      3,      0,      0,  26624,     98, }, /* 412 */
  {    11,     12,      3,      0,      0,  26624,    158, }, /* 413 */
  {    11,     13,     12,      0,      0,  18640,    144, }, /* 414 */
  {    11,     21,     12,      0,      0,  18432,     74, }, /* 415 */
  {    11,     23,     12,      0,      0,  14336,     74, }, /* 416 */
  {    11,     12,      3,      0,      0,  26624,    162, }, /* 417 */
  {    12,     12,      3,      0,      0,  26624,    106, }, /* 418 */
  {    12,     10,      5,      0,      0,  18432,    154, }, /* 419 */
  {    12,      7,     12,      0,      0,  18432,     84, }, /* 420 */
  {    12,      7,     12,      0,      0,  18432,    156, }, /* 421 */
  {    12,     12,      3,      0,      0,  26624,     98, }, /* 422 */
  {    12,     10,      3,      0,      0,  18432,    160, }, /* 423 */
  {    12,     12,      3,      0,      0,  26624,    158, }, /* 424 */
  {    12,     12,      3,      0,      0,  26624,    164, }, /* 425 */
  {    12,     13,     12,      0,      0,  18432,    144, }, /* 426 */
  {    12,     26,     12,      0,      0,  18432,     74, }, /* 427 */
  {    12,     15,     12,      0,      0,  18432,     74, }, /* 428 */
  {    13,     12,      3,      0,      0,  26624,    106, }, /* 429 */
  {    13,      7,     12,      0,      0,  18432,     84, }, /* 430 */
  {    13,     10,      3,      0,      0,  18432,    160, }, /* 431 */
  {    13,     10,      5,      0,      0,  18432,    154, }, /* 432 */
  {    13,     12,      3,      0,      0,  26624,    158, }, /* 433 */
  {    13,     13,     12,      0,      0,  18644,    144, }, /* 434 */
  {    13,     15,     12,      0,      0,  18644,     74, }, /* 435 */
  {    13,     26,     12,      0,      0,  28884,     74, }, /* 436 */
  {    13,     26,     12,      0,      0,  28672,     74, }, /* 437 */
  {    13,     23,     12,      0,      0,  14336,     74, }, /* 438 */
  {    14,     12,      3,      0,      0,  26624,    106, }, /* 439 */
  {    14,     10,      5,      0,      0,  18432,    154, }, /* 440 */
  {    14,      7,     12,      0,      0,  18432,     84, }, /* 441 */
  {    14,      7,     12,      0,      0,  18432,    156, }, /* 442 */
  {    14,     12,      3,      0,      0,  26624,     98, }, /* 443 */
  {    14,     12,      3,      0,      0,  26624,    158, }, /* 444 */
  {    14,     13,     12,      0,      0,  18432,    144, }, /* 445 */
  {    14,     21,     12,      0,      0,  18432,     74, }, /* 446 */
  {    14,     15,     12,      0,      0,  28672,     74, }, /* 447 */
  {    14,     26,     12,      0,      0,  18432,     74, }, /* 448 */
  {    15,      7,     12,      0,      0,  18432,     84, }, /* 449 */
  {    15,     12,      3,      0,      0,  26624,    106, }, /* 450 */
  {    15,     10,      5,      0,      0,  18432,    154, }, /* 451 */
  {    15,     21,     12,      0,      0,  18432,     74, }, /* 452 */
  {    15,     12,      3,      0,      0,  26624,     98, }, /* 453 */
  {    15,     12,      3,      0,      0,  18432,    106, }, /* 454 */
  {    15,     10,      3,      0,      0,  18432,    160, }, /* 455 */
  {    15,     12,      3,      0,      0,  26624,    158, }, /* 456 */
  {    15,     13,     12,      0,      0,  18648,    144, }, /* 457 */
  {    16,     12,      3,      0,      0,  26624,    106, }, /* 458 */
  {    16,     10,      5,      0,      0,  18432,    154, }, /* 459 */
  {    16,      7,     12,      0,      0,  18432,     84, }, /* 460 */
  {    16,      7,     12,      0,      0,  18432,    156, }, /* 461 */
  {    16,     12,      3,      0,      0,  26624,    158, }, /* 462 */
  {    16,     10,      3,      0,      0,  18432,    160, }, /* 463 */
  {    16,      7,      4,      0,      0,  18432,     84, }, /* 464 */
  {    16,     26,     12,      0,      0,  18432,     74, }, /* 465 */
  {    16,     15,     12,      0,      0,  18432,     74, }, /* 466 */
  {    16,     13,     12,      0,      0,  18432,    144, }, /* 467 */
  {    17,     12,      3,      0,      0,  26624,    106, }, /* 468 */
  {    17,     10,      5,      0,      0,  18432,    154, }, /* 469 */
  {    17,      7,     12,      0,      0,  18432,     84, }, /* 470 */
  {    17,     12,      3,      0,      0,  26624,    158, }, /* 471 */
  {    17,     10,      3,      0,      0,  18432,    160, }, /* 472 */
  {    17,     13,     12,      0,      0,  18432,    144, }, /* 473 */
  {    17,     21,     12,      0,      0,  18432,     74, }, /* 474 */
  {    18,      7,     12,      0,      0,  18432,     84, }, /* 475 */
  {    18,     12,      3,      0,      0,  26624,    106, }, /* 476 */
  {    18,      7,      5,      0,      0,  18432,    166, }, /* 477 */
  {    18,     12,      3,      0,      0,  26624,    168, }, /* 478 */
  {    99,     23,     12,      0,      0,  14336,     74, }, /* 479 */
  {    18,      7,     12,      0,      0,  18432,    170, }, /* 480 */
  {    18,      6,     12,      0,      0,  18432,    138, }, /* 481 */
  {    18,     12,      3,      0,      0,  26624,     98, }, /* 482 */
  {    18,     21,     12,      0,      0,  18432,     74, }, /* 483 */
  {    18,     13,     12,      0,      0,  18432,    144, }, /* 484 */
  {    18,     21,     12,      0,      0,  18432,    110, }, /* 485 */
  {   100,      7,     12,      0,      0,  18432,     84, }, /* 486 */
  {   100,     12,      3,      0,      0,  26624,    106, }, /* 487 */
  {   100,      7,      5,      0,      0,  18432,    166, }, /* 488 */
  {   100,     12,      3,      0,      0,  26624,    158, }, /* 489 */
  {   100,      7,     12,      0,      0,  18432,    170, }, /* 490 */
  {   100,      6,     12,      0,      0,  18432,    138, }, /* 491 */
  {   100,     12,      3,      0,      0,  26624,     98, }, /* 492 */
  {   100,     12,      3,      0,      0,  26624,    104, }, /* 493 */
  {   100,     13,     12,      0,      0,  18432,    144, }, /* 494 */
  {    19,      7,     12,      0,      0,  18432,     84, }, /* 495 */
  {    19,     26,     12,      0,      0,  18432,     74, }, /* 496 */
  {    19,     21,     12,      0,      0,  18432,     74, }, /* 497 */
  {    19,     21,     12,      0,      0,  18432,    110, }, /* 498 */
  {    19,     12,      3,      0,      0,  26624,     98, }, /* 499 */
  {    19,     13,     12,      0,      0,  18432,    144, }, /* 500 */
  {    19,     15,     12,      0,      0,  18432,     74, }, /* 501 */
  {    19,     22,     12,      0,      0,  28672,    172, }, /* 502 */
  {    19,     18,     12,      0,      0,  28672,    172, }, /* 503 */
  {    19,     10,      5,      0,      0,  18432,    174, }, /* 504 */
  {    19,     12,      3,      0,      0,  26624,    106, }, /* 505 */
  {    19,     12,      3,      0,      0,  26624,    176, }, /* 506 */
  {    19,     10,      5,      0,      0,  18432,    154, }, /* 507 */
  {    19,     12,      3,      0,      0,  26624,    132, }, /* 508 */
  {    19,     12,      3,      0,      0,  26624,    158, }, /* 509 */
  {    99,     26,     12,      0,      0,  18432,     74, }, /* 510 */
  {    20,      7,     12,      0,      0,  18432,     84, }, /* 511 */
  {    20,     10,     12,      0,      0,  18432,    154, }, /* 512 */
  {    20,     12,      3,      0,      0,  26624,    106, }, /* 513 */
  {    20,     10,      5,      0,      0,  18432,    154, }, /* 514 */
  {    20,     12,      3,      0,      0,  26624,     98, }, /* 515 */
  {    20,     12,      3,      0,      0,  26624,    158, }, /* 516 */
  {    20,     13,     12,      0,      0,  18652,    144, }, /* 517 */
  {    20,     21,     12,      0,      0,  18432,    128, }, /* 518 */
  {    20,     21,     12,      0,      0,  18432,     74, }, /* 519 */
  {    20,     10,     12,      0,      0,  18432,    178, }, /* 520 */
  {    20,     12,      3,      0,      0,  26624,    132, }, /* 521 */
  {    20,     13,     12,      0,      0,  18432,    144, }, /* 522 */
  {    20,     26,     12,      0,      0,  18432,     74, }, /* 523 */
  {    21,      9,     12,      0,   7264,  18432,     76, }, /* 524 */
  {    21,      5,     12,      0,   3008,  18432,    180, }, /* 525 */
  {    99,     21,     12,      0,      0,  18656,     74, }, /* 526 */
  {    21,      6,     12,      0,      0,  18432,    182, }, /* 527 */
  {    22,      7,      6,      0,      0,  18432,     84, }, /* 528 */
  {    22,      7,      6,      0,      0,  18432,    184, }, /* 529 */
  {    22,      7,      7,      0,      0,  18432,    184, }, /* 530 */
  {    22,      7,      7,      0,      0,  18432,     84, }, /* 531 */
  {    22,      7,      8,      0,      0,  18432,     84, }, /* 532 */
  {    23,      7,     12,      0,      0,  18432,     84, }, /* 533 */
  {    23,     12,      3,      0,      0,  26624,     98, }, /* 534 */
  {    23,     21,     12,      0,      0,  18432,     74, }, /* 535 */
  {    23,     21,     12,      0,      0,  18432,    110, }, /* 536 */
  {    23,     21,     12,      0,      0,  18432,    128, }, /* 537 */
  {    23,     15,     12,      0,      0,  18432,    144, }, /* 538 */
  {    23,     15,     12,      0,      0,  18432,     74, }, /* 539 */
  {    23,     26,     12,      0,      0,  28672,     74, }, /* 540 */
  {    24,      9,     12,      0,  38864,  18432,    186, }, /* 541 */
  {    24,      9,     12,      0,      8,  18432,    186, }, /* 542 */
  {    24,      5,     12,      0,     -8,  18432,     70, }, /* 543 */
  {   101,     17,     12,      0,      0,  28672,    130, }, /* 544 */
  {   101,      7,     12,      0,      0,  18432,     84, }, /* 545 */
  {   101,     26,     12,      0,      0,  18432,     74, }, /* 546 */
  {   101,     21,     12,      0,      0,  18432,    128, }, /* 547 */
  {   102,     29,     12,      0,      0,  45056,     52, }, /* 548 */
  {   102,      7,     12,      0,      0,  18432,     84, }, /* 549 */
  {   102,     22,     12,      0,      0,  28672,    172, }, /* 550 */
  {   102,     18,     12,      0,      0,  28672,    172, }, /* 551 */
  {    25,      7,     12,      0,      0,  18432,     84, }, /* 552 */
  {    99,     21,     12,      0,      0,  18660,    110, }, /* 553 */
  {    25,     14,     12,      0,      0,  18432,     84, }, /* 554 */
  {    33,      7,     12,      0,      0,  18432,     84, }, /* 555 */
  {    33,     12,      3,      0,      0,  26624,    106, }, /* 556 */
  {    33,     12,      3,      0,      0,  26624,    158, }, /* 557 */
  {    33,     10,      3,      0,      0,  18432,    188, }, /* 558 */
  {    34,      7,     12,      0,      0,  18432,     84, }, /* 559 */
  {    34,     12,      3,      0,      0,  26624,    106, }, /* 560 */
  {    34,     10,      3,      0,      0,  18432,    188, }, /* 561 */
  {    99,     21,     12,      0,      0,  18664,    128, }, /* 562 */
  {    35,      7,     12,      0,      0,  18432,     84, }, /* 563 */
  {    35,     12,      3,      0,      0,  26624,    106, }, /* 564 */
  {    36,      7,     12,      0,      0,  18432,     84, }, /* 565 */
  {    36,     12,      3,      0,      0,  26624,    106, }, /* 566 */
  {   103,      7,     12,      0,      0,  18432,     84, }, /* 567 */
  {   103,      7,     12,      0,      0,  18432,    146, }, /* 568 */
  {   103,     12,      3,      0,      0,  26624,    102, }, /* 569 */
  {   103,     10,      5,      0,      0,  18432,    154, }, /* 570 */
  {   103,     12,      3,      0,      0,  26624,    106, }, /* 571 */
  {   103,     12,      3,      0,      0,  26624,     98, }, /* 572 */
  {   103,     12,      3,      0,      0,  26624,    158, }, /* 573 */
  {   103,     21,     12,      0,      0,  18432,    128, }, /* 574 */
  {   103,     21,     12,      0,      0,  18432,    110, }, /* 575 */
  {   103,      6,     12,      0,      0,  18432,    148, }, /* 576 */
  {   103,     21,     12,      0,      0,  18432,     74, }, /* 577 */
  {   103,     23,     12,      0,      0,  14336,     74, }, /* 578 */
  {   103,     13,     12,      0,      0,  18432,    144, }, /* 579 */
  {   103,     15,     12,      0,      0,  28672,     74, }, /* 580 */
  {    26,     21,     12,      0,      0,  28672,     74, }, /* 581 */
  {    99,     21,     12,      0,      0,  28908,    110, }, /* 582 */
  {    99,     21,     12,      0,      0,  28908,    128, }, /* 583 */
  {    26,     21,     12,      0,      0,  28672,    110, }, /* 584 */
  {    26,     17,     12,      0,      0,  28672,    130, }, /* 585 */
  {    26,     21,     12,      0,      0,  28672,    128, }, /* 586 */
  {    26,     21,     12,      0,      0,  28672,    190, }, /* 587 */
  {    26,     12,      3,      0,      0,  26624,    192, }, /* 588 */
  {    26,      1,      2,      0,      0,   6144,     66, }, /* 589 */
  {    26,     13,     12,      0,      0,  18432,    144, }, /* 590 */
  {    26,      7,     12,      0,      0,  18432,     84, }, /* 591 */
  {    26,      6,     12,      0,      0,  18432,    138, }, /* 592 */
  {    26,     12,      3,      0,      0,  26624,    194, }, /* 593 */
  {    26,     12,      3,      0,      0,  26624,    106, }, /* 594 */
  {    37,      7,     12,      0,      0,  18432,     84, }, /* 595 */
  {    37,     12,      3,      0,      0,  26624,    106, }, /* 596 */
  {    37,     10,      5,      0,      0,  18432,    154, }, /* 597 */
  {    37,     12,      3,      0,      0,  26624,     98, }, /* 598 */
  {    37,     26,     12,      0,      0,  28672,     74, }, /* 599 */
  {    37,     21,     12,      0,      0,  28672,    128, }, /* 600 */
  {    37,     13,     12,      0,      0,  18432,    144, }, /* 601 */
  {    38,      7,     12,      0,      0,  18432,     84, }, /* 602 */
  {   110,      7,     12,      0,      0,  18432,     84, }, /* 603 */
  {   110,      7,     12,      0,      0,  18432,    170, }, /* 604 */
  {   110,     13,     12,      0,      0,  18432,    144, }, /* 605 */
  {   110,     15,     12,      0,      0,  18432,    144, }, /* 606 */
  {   110,     26,     12,      0,      0,  28672,     74, }, /* 607 */
  {   103,     26,     12,      0,      0,  28672,     74, }, /* 608 */
  {    42,      7,     12,      0,      0,  18432,     84, }, /* 609 */
  {    42,     12,      3,      0,      0,  26624,    106, }, /* 610 */
  {    42,     10,      5,      0,      0,  18432,    154, }, /* 611 */
  {    42,     21,     12,      0,      0,  18432,     74, }, /* 612 */
  {   123,      7,     12,      0,      0,  18432,     84, }, /* 613 */
  {   123,     10,      5,      0,      0,  18432,    154, }, /* 614 */
  {   123,     12,      3,      0,      0,  26624,    106, }, /* 615 */
  {   123,     12,      3,      0,      0,  26624,    158, }, /* 616 */
  {   123,     10,     12,      0,      0,  18432,    154, }, /* 617 */
  {   123,     12,      3,      0,      0,  26624,     98, }, /* 618 */
  {   123,     13,     12,      0,      0,  18432,    144, }, /* 619 */
  {   123,     21,     12,      0,      0,  18432,     74, }, /* 620 */
  {   123,      6,     12,      0,      0,  18432,    138, }, /* 621 */
  {   123,     21,     12,      0,      0,  18432,    128, }, /* 622 */
  {   106,     11,      3,      0,      0,  26624,    196, }, /* 623 */
  {   106,     12,      3,      0,      0,  26624,    106, }, /* 624 */
  {   113,     12,      3,      0,      0,  26624,    106, }, /* 625 */
  {   113,     10,      5,      0,      0,  18432,    154, }, /* 626 */
  {   113,      7,     12,      0,      0,  18432,     84, }, /* 627 */
  {   113,     12,      3,      0,      0,  26624,     98, }, /* 628 */
  {   113,     10,      3,      0,      0,  18432,    160, }, /* 629 */
  {   113,     10,      3,      0,      0,  18432,    188, }, /* 630 */
  {   113,     21,     12,      0,      0,  18432,    128, }, /* 631 */
  {   113,     13,     12,      0,      0,  18432,    144, }, /* 632 */
  {   113,     21,     12,      0,      0,  18432,     74, }, /* 633 */
  {   113,     21,     12,      0,      0,  18432,    110, }, /* 634 */
  {   113,     26,     12,      0,      0,  18432,     74, }, /* 635 */
  {   116,     12,      3,      0,      0,  26624,    106, }, /* 636 */
  {   116,     10,      5,      0,      0,  18432,    154, }, /* 637 */
  {   116,      7,     12,      0,      0,  18432,     84, }, /* 638 */
  {   116,     10,      3,      0,      0,  18432,    188, }, /* 639 */
  {   116,     12,      3,      0,      0,  26624,    158, }, /* 640 */
  {   116,     13,     12,      0,      0,  18432,    144, }, /* 641 */
  {   132,      7,     12,      0,      0,  18432,     84, }, /* 642 */
  {   132,     12,      3,      0,      0,  26624,     98, }, /* 643 */
  {   132,     10,      5,      0,      0,  18432,    154, }, /* 644 */
  {   132,     12,      3,      0,      0,  26624,    106, }, /* 645 */
  {   132,     10,      3,      0,      0,  18432,    188, }, /* 646 */
  {   132,     21,     12,      0,      0,  18432,     74, }, /* 647 */
  {   117,      7,     12,      0,      0,  18432,     84, }, /* 648 */
  {   117,     10,      5,      0,      0,  18432,    154, }, /* 649 */
  {   117,     12,      3,      0,      0,  26624,    106, }, /* 650 */
  {   117,     12,      3,      0,      0,  26624,    198, }, /* 651 */
  {   117,     12,      3,      0,      0,  26624,     98, }, /* 652 */
  {   117,     21,     12,      0,      0,  18432,    128, }, /* 653 */
  {   117,     21,     12,      0,      0,  18432,    110, }, /* 654 */
  {   117,     13,     12,      0,      0,  18432,    144, }, /* 655 */
  {   118,     13,     12,      0,      0,  18432,    144, }, /* 656 */
  {   118,      7,     12,      0,      0,  18432,     84, }, /* 657 */
  {   118,      6,     12,      0,      0,  18432,     94, }, /* 658 */
  {   118,      6,     12,      0,      0,  18432,     96, }, /* 659 */
  {   118,     21,     12,      0,      0,  18432,    128, }, /* 660 */
  {     2,      5,     12,     63,  -6222,  18432,     70, }, /* 661 */
  {     2,      5,     12,     67,  -6221,  18432,     70, }, /* 662 */
  {     2,      5,     12,     71,  -6212,  18432,     70, }, /* 663 */
  {     2,      5,     12,     75,  -6210,  18432,     70, }, /* 664 */
  {     2,      5,     12,     79,  -6210,  18432,     70, }, /* 665 */
  {     2,      5,     12,     79,  -6211,  18432,     70, }, /* 666 */
  {     2,      5,     12,     84,  -6204,  18432,     70, }, /* 667 */
  {     2,      5,     12,     88,  -6180,  18432,     70, }, /* 668 */
  {     2,      5,     12,    108,  35267,  18432,     70, }, /* 669 */
  {    21,      9,     12,      0,  -3008,  18432,     76, }, /* 670 */
  {   116,     21,     12,      0,      0,  18432,     74, }, /* 671 */
  {   106,     12,      3,      0,      0,  26864,     98, }, /* 672 */
  {   106,     12,      3,      0,      0,  26868,     98, }, /* 673 */
  {    99,     21,     12,      0,      0,  18680,    200, }, /* 674 */
  {   106,     12,      3,      0,      0,  26876,     98, }, /* 675 */
  {   106,     12,      3,      0,      0,  26880,     98, }, /* 676 */
  {   106,     12,      3,      0,      0,  26884,     98, }, /* 677 */
  {    99,     10,      5,      0,      0,  18684,    174, }, /* 678 */
  {    99,      7,     12,      0,      0,  18696,     84, }, /* 679 */
  {    99,      7,     12,      0,      0,  18684,     84, }, /* 680 */
  {    99,      7,     12,      0,      0,  18676,     84, }, /* 681 */
  {    99,      7,     12,      0,      0,  18700,     84, }, /* 682 */
  {    99,      7,     12,      0,      0,  18704,     84, }, /* 683 */
  {   106,     12,      3,      0,      0,  26900,     98, }, /* 684 */
  {    99,     10,      5,      0,      0,  18712,    174, }, /* 685 */
  {   106,     12,      3,      0,      0,  26896,     98, }, /* 686 */
  {    99,      7,     12,      0,      0,  18716,     84, }, /* 687 */
  {     2,      5,     12,      0,      0,  18432,     60, }, /* 688 */
  {     1,      6,     12,      0,      0,  18432,     90, }, /* 689 */
  {     2,      6,     12,      0,      0,  18432,    182, }, /* 690 */
  {     0,      5,     12,      0,  35332,  18432,     78, }, /* 691 */
  {     0,      5,     12,      0,   3814,  18432,     78, }, /* 692 */
  {     0,      5,     12,      0,  35384,  18432,     78, }, /* 693 */
  {     0,      5,     12,      0,      0,  18432,    202, }, /* 694 */
  {     0,      6,     12,      0,      0,  18432,    182, }, /* 695 */
  {     0,      6,     12,      0,      0,  18432,    204, }, /* 696 */
  {     1,      6,     12,      0,      0,  18432,    182, }, /* 697 */
  {   106,     12,      3,      0,      0,  26740,    104, }, /* 698 */
  {   106,     12,      3,      0,      0,  26912,     98, }, /* 699 */
  {   106,     12,      3,      0,      0,  26916,     98, }, /* 700 */
  {     0,      9,     12,     92,      1,  18432,     76, }, /* 701 */
  {     0,      5,     12,     92,     -1,  18432,     78, }, /* 702 */
  {     0,      5,     12,      0,      0,  18432,     70, }, /* 703 */
  {     0,      5,     12,     92,    -58,  18432,     70, }, /* 704 */
  {     0,      9,     12,      0,  -7615,  18432,     76, }, /* 705 */
  {     1,      5,     12,      0,      8,  18432,     78, }, /* 706 */
  {     1,      9,     12,      0,     -8,  18432,     76, }, /* 707 */
  {     1,      5,     12,      0,      0,  18432,     78, }, /* 708 */
  {     1,      5,     12,      0,     74,  18432,     78, }, /* 709 */
  {     1,      5,     12,      0,     86,  18432,     78, }, /* 710 */
  {     1,      5,     12,      0,    100,  18432,     78, }, /* 711 */
  {     1,      5,     12,      0,    128,  18432,     78, }, /* 712 */
  {     1,      5,     12,      0,    112,  18432,     78, }, /* 713 */
  {     1,      5,     12,      0,    126,  18432,     78, }, /* 714 */
  {     1,      5,     12,      0,      8,  18432,     70, }, /* 715 */
  {     1,      8,     12,      0,     -8,  18432,     88, }, /* 716 */
  {     1,      5,     12,      0,      0,  18432,     70, }, /* 717 */
  {     1,      5,     12,      0,      9,  18432,     70, }, /* 718 */
  {     1,      9,     12,      0,    -74,  18432,     76, }, /* 719 */
  {     1,      8,     12,      0,     -9,  18432,     88, }, /* 720 */
  {     1,      5,     12,     21,  -7173,  18432,     78, }, /* 721 */
  {     1,      9,     12,      0,    -86,  18432,     76, }, /* 722 */
  {     1,      5,     12,      0,  -7235,  18432,     78, }, /* 723 */
  {     1,      9,     12,      0,   -100,  18432,     76, }, /* 724 */
  {     1,      5,     12,      0,  -7219,  18432,     78, }, /* 725 */
  {     1,      9,     12,      0,   -112,  18432,     76, }, /* 726 */
  {     1,      9,     12,      0,   -128,  18432,     76, }, /* 727 */
  {     1,      9,     12,      0,   -126,  18432,     76, }, /* 728 */
  {    99,     29,     12,      0,      0,  45056,     52, }, /* 729 */
  {   106,      1,      3,      0,      0,   6144,    206, }, /* 730 */
  {   106,      1,     13,      0,      0,   6144,    208, }, /* 731 */
  {    99,      1,      2,      0,      0,  18432,    210, }, /* 732 */
  {    99,      1,      2,      0,      0,  34816,    210, }, /* 733 */
  {    99,     17,     12,      0,      0,  28672,    212, }, /* 734 */
  {    99,     21,     12,      0,      0,  28672,     64, }, /* 735 */
  {    99,     20,     12,      0,      0,  28672,    214, }, /* 736 */
  {    99,     19,     12,      0,      0,  28672,    214, }, /* 737 */
  {    99,     22,     12,      0,      0,  28672,    216, }, /* 738 */
  {    99,     20,     12,      0,      0,  28672,    216, }, /* 739 */
  {    99,     19,     12,      0,      0,  28672,    216, }, /* 740 */
  {    99,     21,     12,      0,      0,  28672,    218, }, /* 741 */
  {    99,     21,     12,      0,      0,  28672,    220, }, /* 742 */
  {    99,     27,      2,      0,      0,  45056,     50, }, /* 743 */
  {    99,     28,      2,      0,      0,   4096,     50, }, /* 744 */
  {    99,      1,      2,      0,      0,  20480,    136, }, /* 745 */
  {    99,      1,      2,      0,      0,  36864,    136, }, /* 746 */
  {    99,      1,      2,      0,      0,  30720,    136, }, /* 747 */
  {    99,      1,      2,      0,      0,  24576,    136, }, /* 748 */
  {    99,      1,      2,      0,      0,  40960,    136, }, /* 749 */
  {    99,     29,     12,      0,      0,   8488,     52, }, /* 750 */
  {    99,     21,     12,      0,      0,  14336,     54, }, /* 751 */
  {    99,     21,     12,      0,      0,  14336,     64, }, /* 752 */
  {    99,     21,     14,      0,      0,  28672,    222, }, /* 753 */
  {    99,     21,     12,      0,      0,  28672,    224, }, /* 754 */
  {    99,     16,     12,      0,      0,  28672,    144, }, /* 755 */
  {    99,     16,     12,      0,      0,  28672,    226, }, /* 756 */
  {    99,     25,     12,      0,      0,   8192,     64, }, /* 757 */
  {    99,     22,     12,      0,      0,  28672,    228, }, /* 758 */
  {    99,     18,     12,      0,      0,  28672,    228, }, /* 759 */
  {    99,     21,     12,      0,      0,  28972,     54, }, /* 760 */
  {    99,     21,     12,      0,      0,  28672,    212, }, /* 761 */
  {    99,     21,     12,      0,      0,  28976,     54, }, /* 762 */
  {    99,     21,     12,      0,      0,  28980,     54, }, /* 763 */
  {    99,      1,      2,      0,      0,   6144,    230, }, /* 764 */
  {    98,      2,      2,      0,      0,   6144,    232, }, /* 765 */
  {    99,      1,      2,      0,      0,  22528,    136, }, /* 766 */
  {    99,      1,      2,      0,      0,  38912,    136, }, /* 767 */
  {    99,      1,      2,      0,      0,  16384,    136, }, /* 768 */
  {    99,      1,      2,      0,      0,  32768,    136, }, /* 769 */
  {    99,      1,      2,      0,      0,   6144,    234, }, /* 770 */
  {    99,     25,     12,      0,      0,  12288,    236, }, /* 771 */
  {    99,     25,     12,      0,      0,  12288,    238, }, /* 772 */
  {    99,     25,     12,      0,      0,  28672,    236, }, /* 773 */
  {    99,     22,     12,      0,      0,  28672,    240, }, /* 774 */
  {    99,     18,     12,      0,      0,  28672,    240, }, /* 775 */
  {    98,      2,     12,      0,      0,  14336,      0, }, /* 776 */
  {   106,     12,      3,      0,      0,  26624,    242, }, /* 777 */
  {   106,     11,      3,      0,      0,  26624,    124, }, /* 778 */
  {   106,     11,      3,      0,      0,  26624,    244, }, /* 779 */
  {   106,     12,      3,      0,      0,  26936,    104, }, /* 780 */
  {    99,     26,     12,      0,      0,  28672,     74, }, /* 781 */
  {    99,      9,     12,      0,      0,  18432,    116, }, /* 782 */
  {    99,      5,     12,      0,      0,  18432,    246, }, /* 783 */
  {    99,     25,     12,      0,      0,  28672,    248, }, /* 784 */
  {    99,     26,     14,      0,      0,  28672,    250, }, /* 785 */
  {     1,      9,     12,     96,  -7517,  18432,     76, }, /* 786 */
  {    99,     26,     12,      0,      0,  28672,    122, }, /* 787 */
  {     0,      9,     12,    100,      0,  18432,     76, }, /* 788 */
  {     0,      9,     12,    104,  -8262,  18432,     76, }, /* 789 */
  {    99,     26,     12,      0,      0,  14336,    252, }, /* 790 */
  {     0,      9,     12,      0,     28,  18432,     76, }, /* 791 */
  {    99,      7,     12,      0,      0,  18432,    254, }, /* 792 */
  {    99,      5,     14,      0,      0,  18432,    256, }, /* 793 */
  {    99,     25,     12,      0,      0,  28672,    122, }, /* 794 */
  {    99,      5,     12,      0,      0,  18432,    258, }, /* 795 */
  {     0,      5,     12,      0,    -28,  18432,     78, }, /* 796 */
  {     0,     14,     12,      0,     16,  18432,     76, }, /* 797 */
  {     0,     14,     12,      0,    -16,  18432,     78, }, /* 798 */
  {     0,     14,     12,      0,      0,  18432,     84, }, /* 799 */
  {    99,     25,     14,      0,      0,  28672,    260, }, /* 800 */
  {    99,     26,     14,      0,      0,  28672,    260, }, /* 801 */
  {    99,     26,     12,      0,      0,  28672,     64, }, /* 802 */
  {    99,     25,     12,      0,      0,  28672,    262, }, /* 803 */
  {    99,     25,     12,      0,      0,  28672,    264, }, /* 804 */
  {    99,     25,     12,      0,      0,  12288,    266, }, /* 805 */
  {    99,     22,     12,      0,      0,  28672,    264, }, /* 806 */
  {    99,     18,     12,      0,      0,  28672,    264, }, /* 807 */
  {    99,     26,     14,      0,      0,  28672,    268, }, /* 808 */
  {    99,     22,     12,      0,      0,  28672,    270, }, /* 809 */
  {    99,     18,     12,      0,      0,  28672,    270, }, /* 810 */
  {    99,     26,     12,      0,      0,  18432,     54, }, /* 811 */
  {    99,     26,     14,      0,      0,  28672,    272, }, /* 812 */
  {    98,      2,     12,      0,      0,  18432,    274, }, /* 813 */
  {    99,     15,     12,      0,      0,  10240,     74, }, /* 814 */
  {    99,     26,     12,      0,     26,  18432,    276, }, /* 815 */
  {    99,     26,     14,      0,     26,  18432,    278, }, /* 816 */
  {    99,     26,     12,      0,    -26,  18432,    280, }, /* 817 */
  {    99,     25,     14,      0,      0,  28672,    282, }, /* 818 */
  {    99,     26,     14,      0,      0,  28672,    284, }, /* 819 */
  {    99,     26,     14,      0,      0,  28672,    286, }, /* 820 */
  {    99,     25,     14,      0,      0,  28672,    284, }, /* 821 */
  {    99,     26,     14,      0,      0,  18432,    272, }, /* 822 */
  {    99,     26,     14,      0,      0,  28672,    288, }, /* 823 */
  {   109,     26,     12,      0,      0,  18432,     54, }, /* 824 */
  {    99,     26,     12,      0,      0,  28672,    228, }, /* 825 */
  {    44,      9,     12,      0,     48,  18432,     76, }, /* 826 */
  {    44,      5,     12,      0,    -48,  18432,     78, }, /* 827 */
  {     0,      9,     12,      0, -10743,  18432,     76, }, /* 828 */
  {     0,      9,     12,      0,  -3814,  18432,     76, }, /* 829 */
  {     0,      9,     12,      0, -10727,  18432,     76, }, /* 830 */
  {     0,      5,     12,      0, -10795,  18432,     78, }, /* 831 */
  {     0,      5,     12,      0, -10792,  18432,     78, }, /* 832 */
  {     0,      9,     12,      0, -10780,  18432,     76, }, /* 833 */
  {     0,      9,     12,      0, -10749,  18432,     76, }, /* 834 */
  {     0,      9,     12,      0, -10783,  18432,     76, }, /* 835 */
  {     0,      9,     12,      0, -10782,  18432,     76, }, /* 836 */
  {     0,      9,     12,      0, -10815,  18432,     76, }, /* 837 */
  {    43,      5,     12,      0,      0,  18432,     60, }, /* 838 */
  {    43,     26,     12,      0,      0,  28672,     74, }, /* 839 */
  {    43,     12,      3,      0,      0,  26624,     98, }, /* 840 */
  {    43,     21,     12,      0,      0,  28672,    128, }, /* 841 */
  {    43,     21,     12,      0,      0,  28672,     74, }, /* 842 */
  {    43,     15,     12,      0,      0,  28672,     74, }, /* 843 */
  {    21,      5,     12,      0,  -7264,  18432,     78, }, /* 844 */
  {    45,      7,     12,      0,      0,  18432,     84, }, /* 845 */
  {    45,      6,     12,      0,      0,  18432,    148, }, /* 846 */
  {    45,     21,     12,      0,      0,  18432,     74, }, /* 847 */
  {    45,     12,      3,      0,      0,  26624,    290, }, /* 848 */
  {     2,     12,      3,      0,      0,  26624,    106, }, /* 849 */
  {    99,     20,     12,      0,      0,  28672,    228, }, /* 850 */
  {    99,     19,     12,      0,      0,  28672,    228, }, /* 851 */
  {    99,     17,     12,      0,      0,  28988,    212, }, /* 852 */
  {    99,      6,     12,      0,      0,  28672,    292, }, /* 853 */
  {    99,     21,     12,      0,      0,  28992,     54, }, /* 854 */
  {    99,     21,     12,      0,      0,  28996,     54, }, /* 855 */
  {    99,     21,     12,      0,      0,  29000,    224, }, /* 856 */
  {    99,     21,     12,      0,      0,  29004,    294, }, /* 857 */
  {    99,     21,     12,      0,      0,  28812,     54, }, /* 858 */
  {    99,     21,     12,      0,      0,  28672,    294, }, /* 859 */
  {    30,     26,     12,      0,      0,  28672,    296, }, /* 860 */
  {    99,     26,     12,      0,      0,  29008,    298, }, /* 861 */
  {    99,     26,     12,      0,      0,  29008,    300, }, /* 862 */
  {    99,     26,     12,      0,      0,  29008,    302, }, /* 863 */
  {    99,     21,     12,      0,      0,  29012,    294, }, /* 864 */
  {    99,     21,     12,      0,      0,  29016,    224, }, /* 865 */
  {    99,     21,     12,      0,      0,  29020,     54, }, /* 866 */
  {    30,      6,     12,      0,      0,  18432,    138, }, /* 867 */
  {    99,      7,     12,      0,      0,  18784,    304, }, /* 868 */
  {    30,     14,     12,      0,      0,  18432,    304, }, /* 869 */
  {    99,     22,     12,      0,      0,  29028,    228, }, /* 870 */
  {    99,     18,     12,      0,      0,  29028,    228, }, /* 871 */
  {    99,     22,     12,      0,      0,  29032,    228, }, /* 872 */
  {    99,     18,     12,      0,      0,  29032,    228, }, /* 873 */
  {    99,     22,     12,      0,      0,  29036,     62, }, /* 874 */
  {    99,     18,     12,      0,      0,  29036,     62, }, /* 875 */
  {    99,     22,     12,      0,      0,  29036,    228, }, /* 876 */
  {    99,     18,     12,      0,      0,  29036,    228, }, /* 877 */
  {    99,     26,     12,      0,      0,  29020,     54, }, /* 878 */
  {    99,     17,     12,      0,      0,  29020,    212, }, /* 879 */
  {    99,     22,     12,      0,      0,  29020,    216, }, /* 880 */
  {    99,     18,     12,      0,      0,  29020,    216, }, /* 881 */
  {   106,     12,      3,      0,      0,  26992,     98, }, /* 882 */
  {    22,     10,      3,      0,      0,  18432,    306, }, /* 883 */
  {    99,     17,     14,      0,      0,  29020,    308, }, /* 884 */
  {    99,      6,     12,      0,      0,  18804,    138, }, /* 885 */
  {    99,     26,     12,      0,      0,  29020,     74, }, /* 886 */
  {    30,      6,     12,      0,      0,  18432,    148, }, /* 887 */
  {    99,      7,     12,      0,      0,  18808,     84, }, /* 888 */
  {    99,     21,     14,      0,      0,  29048,    250, }, /* 889 */
  {    99,     26,     12,      0,      0,  29024,     74, }, /* 890 */
  {    27,      7,     12,      0,      0,  18432,     84, }, /* 891 */
  {   106,     12,      3,      0,      0,  26996,     98, }, /* 892 */
  {    99,     24,     12,      0,      0,  29044,    310, }, /* 893 */
  {    27,      6,     12,      0,      0,  18432,    138, }, /* 894 */
  {    99,     17,     12,      0,      0,  29044,    130, }, /* 895 */
  {    28,      7,     12,      0,      0,  18432,     84, }, /* 896 */
  {    99,     21,     12,      0,      0,  29036,    144, }, /* 897 */
  {    99,      6,     12,      0,      0,  18804,     96, }, /* 898 */
  {    28,      6,     12,      0,      0,  18432,    138, }, /* 899 */
  {    29,      7,     12,      0,      0,  18432,     84, }, /* 900 */
  {    22,      7,     12,      0,      0,  18432,     84, }, /* 901 */
  {    22,      7,     12,      0,      0,  18432,    184, }, /* 902 */
  {    99,     26,     12,      0,      0,  18784,     74, }, /* 903 */
  {    99,     15,     12,      0,      0,  18784,     74, }, /* 904 */
  {    22,     26,     12,      0,      0,  18432,     74, }, /* 905 */
  {    22,     26,     12,      0,      0,  28672,     74, }, /* 906 */
  {    99,     15,     12,      0,      0,  18432,     74, }, /* 907 */
  {    99,     26,     14,      0,      0,  18784,    250, }, /* 908 */
  {    28,     26,     12,      0,      0,  18432,     74, }, /* 909 */
  {    30,      7,     12,      0,      0,  18432,    312, }, /* 910 */
  {    31,      7,     12,      0,      0,  18432,     84, }, /* 911 */
  {    31,      6,     12,      0,      0,  18432,    138, }, /* 912 */
  {    31,     26,     12,      0,      0,  28672,     74, }, /* 913 */
  {    55,      7,     12,      0,      0,  18432,     84, }, /* 914 */
  {    55,      6,     12,      0,      0,  18432,    148, }, /* 915 */
  {    55,     21,     12,      0,      0,  18432,    110, }, /* 916 */
  {    55,     21,     12,      0,      0,  18432,    128, }, /* 917 */
  {   119,      7,     12,      0,      0,  18432,     84, }, /* 918 */
  {   119,      6,     12,      0,      0,  18432,    138, }, /* 919 */
  {   119,     21,     12,      0,      0,  28672,    110, }, /* 920 */
  {   119,     21,     12,      0,      0,  28672,    128, }, /* 921 */
  {   119,     13,     12,      0,      0,  18432,    144, }, /* 922 */
  {     2,      9,     12,    108,      1,  18432,     76, }, /* 923 */
  {     2,      5,     12,    108, -35267,  18432,     78, }, /* 924 */
  {     2,      7,     12,      0,      0,  18432,     84, }, /* 925 */
  {     2,     21,     12,      0,      0,  28672,     74, }, /* 926 */
  {     2,     12,      3,      0,      0,  26624,     98, }, /* 927 */
  {     2,      6,     12,      0,      0,  28672,     94, }, /* 928 */
  {     2,      6,     12,      0,      0,  18432,     90, }, /* 929 */
  {   126,      7,     12,      0,      0,  18432,     84, }, /* 930 */
  {   126,     14,     12,      0,      0,  18432,     84, }, /* 931 */
  {   126,     12,      3,      0,      0,  26624,     98, }, /* 932 */
  {   126,     21,     12,      0,      0,  18432,     74, }, /* 933 */
  {   126,     21,     12,      0,      0,  18432,    128, }, /* 934 */
  {   126,     21,     12,      0,      0,  18432,    110, }, /* 935 */
  {    99,     24,     12,      0,      0,  29052,     56, }, /* 936 */
  {     0,      9,     12,      0, -35332,  18432,     76, }, /* 937 */
  {    99,     24,     12,      0,      0,  18432,     56, }, /* 938 */
  {     0,      9,     12,      0, -42280,  18432,     76, }, /* 939 */
  {     0,      5,     12,      0,     48,  18432,     78, }, /* 940 */
  {     0,      9,     12,      0, -42308,  18432,     76, }, /* 941 */
  {     0,      9,     12,      0, -42319,  18432,     76, }, /* 942 */
  {     0,      9,     12,      0, -42315,  18432,     76, }, /* 943 */
  {     0,      9,     12,      0, -42305,  18432,     76, }, /* 944 */
  {     0,      9,     12,      0, -42258,  18432,     76, }, /* 945 */
  {     0,      9,     12,      0, -42282,  18432,     76, }, /* 946 */
  {     0,      9,     12,      0, -42261,  18432,     76, }, /* 947 */
  {     0,      9,     12,      0,    928,  18432,     76, }, /* 948 */
  {     0,      9,     12,      0,    -48,  18432,     76, }, /* 949 */
  {     0,      9,     12,      0, -42307,  18432,     76, }, /* 950 */
  {     0,      9,     12,      0, -35384,  18432,     76, }, /* 951 */
  {     0,      9,     12,      0, -42343,  18432,     76, }, /* 952 */
  {     0,      9,     12,      0, -42561,  18432,     76, }, /* 953 */
  {    46,      7,     12,      0,      0,  18432,     84, }, /* 954 */
  {    46,     12,      3,      0,      0,  26624,    106, }, /* 955 */
  {    46,     12,      3,      0,      0,  26624,    158, }, /* 956 */
  {    46,     10,      5,      0,      0,  18432,    154, }, /* 957 */
  {    46,     26,     12,      0,      0,  28672,     74, }, /* 958 */
  {    99,     15,     12,      0,      0,  18816,     74, }, /* 959 */
  {    99,     15,     12,      0,      0,  18820,     74, }, /* 960 */
  {    99,     26,     12,      0,      0,  18824,     74, }, /* 961 */
  {    99,     23,     12,      0,      0,  14732,     74, }, /* 962 */
  {    99,     26,     12,      0,      0,  14728,     74, }, /* 963 */
  {    47,      7,     12,      0,      0,  18432,     84, }, /* 964 */
  {    47,     21,     12,      0,      0,  28672,     74, }, /* 965 */
  {    47,     21,     12,      0,      0,  28672,    128, }, /* 966 */
  {   120,     10,      5,      0,      0,  18432,    154, }, /* 967 */
  {   120,      7,     12,      0,      0,  18432,     84, }, /* 968 */
  {   120,     12,      3,      0,      0,  26624,    158, }, /* 969 */
  {   120,     12,      3,      0,      0,  26624,    106, }, /* 970 */
  {   120,     21,     12,      0,      0,  18432,    128, }, /* 971 */
  {   120,     13,     12,      0,      0,  18432,    144, }, /* 972 */
  {     8,     12,      3,      0,      0,  27024,     98, }, /* 973 */
  {     8,      7,     12,      0,      0,  18836,     84, }, /* 974 */
  {    49,     13,     12,      0,      0,  18432,    144, }, /* 975 */
  {    49,      7,     12,      0,      0,  18432,     84, }, /* 976 */
  {    49,     12,      3,      0,      0,  26624,    106, }, /* 977 */
  {    49,     12,      3,      0,      0,  26624,     98, }, /* 978 */
  {    99,     21,     12,      0,      0,  18840,    200, }, /* 979 */
  {    49,     21,     12,      0,      0,  18432,    128, }, /* 980 */
  {   121,      7,     12,      0,      0,  18432,     84, }, /* 981 */
  {   121,     12,      3,      0,      0,  26624,    106, }, /* 982 */
  {   121,     10,      5,      0,      0,  18432,    154, }, /* 983 */
  {   121,     10,      3,      0,      0,  18432,    188, }, /* 984 */
  {   121,     21,     12,      0,      0,  18432,     74, }, /* 985 */
  {    56,     12,      3,      0,      0,  26624,    106, }, /* 986 */
  {    56,     10,      5,      0,      0,  18432,    154, }, /* 987 */
  {    56,      7,     12,      0,      0,  18432,     84, }, /* 988 */
  {    56,     12,      3,      0,      0,  26624,     98, }, /* 989 */
  {    56,     10,      3,      0,      0,  18432,    188, }, /* 990 */
  {    56,     21,     12,      0,      0,  18432,     74, }, /* 991 */
  {    56,     21,     12,      0,      0,  18432,    110, }, /* 992 */
  {    56,     21,     12,      0,      0,  18432,    128, }, /* 993 */
  {    99,      6,     12,      0,      0,  18844,    138, }, /* 994 */
  {    56,     13,     12,      0,      0,  18432,    144, }, /* 995 */
  {    20,      6,     12,      0,      0,  18432,    138, }, /* 996 */
  {   122,      7,     12,      0,      0,  18432,     84, }, /* 997 */
  {   122,     12,      3,      0,      0,  26624,    106, }, /* 998 */
  {   122,     10,      5,      0,      0,  18432,    154, }, /* 999 */
  {   122,     13,     12,      0,      0,  18432,    144, }, /* 1000 */
  {   122,     21,     12,      0,      0,  18432,     74, }, /* 1001 */
  {   122,     21,     12,      0,      0,  18432,    128, }, /* 1002 */
  {   124,      7,     12,      0,      0,  18432,     84, }, /* 1003 */
  {   124,     12,      3,      0,      0,  26624,    106, }, /* 1004 */
  {   124,      7,     12,      0,      0,  18432,    170, }, /* 1005 */
  {   124,     12,      3,      0,      0,  26624,     98, }, /* 1006 */
  {   124,      7,     12,      0,      0,  18432,    314, }, /* 1007 */
  {   124,      6,     12,      0,      0,  18432,    138, }, /* 1008 */
  {   124,     21,     12,      0,      0,  18432,     74, }, /* 1009 */
  {   124,     21,     12,      0,      0,  18432,    110, }, /* 1010 */
  {   127,      7,     12,      0,      0,  18432,     84, }, /* 1011 */
  {   127,     10,      5,      0,      0,  18432,    154, }, /* 1012 */
  {   127,     12,      3,      0,      0,  26624,    106, }, /* 1013 */
  {   127,     21,     12,      0,      0,  18432,    128, }, /* 1014 */
  {   127,      6,     12,      0,      0,  18432,    138, }, /* 1015 */
  {   127,     12,      3,      0,      0,  26624,    158, }, /* 1016 */
  {     0,      5,     12,      0,   -928,  18432,     78, }, /* 1017 */
  {    24,      5,     12,      0, -38864,  18432,     70, }, /* 1018 */
  {   127,     10,      5,      0,      0,  18432,    174, }, /* 1019 */
  {   127,     13,     12,      0,      0,  18432,    144, }, /* 1020 */
  {    22,      7,      9,      0,      0,  18432,     84, }, /* 1021 */
  {    22,      7,     10,      0,      0,  18432,     84, }, /* 1022 */
  {    98,      4,     12,      0,      0,  18432,      0, }, /* 1023 */
  {    98,      3,     12,      0,      0,  18432,      0, }, /* 1024 */
  {    30,      7,     12,      0,      0,  18432,    304, }, /* 1025 */
  {     0,      5,     12,      0,      1,  18432,     70, }, /* 1026 */
  {     0,      5,     12,      0,     -1,  18432,     70, }, /* 1027 */
  {     4,     25,     12,      0,      0,  12288,    122, }, /* 1028 */
  {     5,      7,     12,      0,      0,      0,    316, }, /* 1029 */
  {    99,     18,     12,      0,      0,  29088,     54, }, /* 1030 */
  {    99,     22,     12,      0,      0,  29088,     54, }, /* 1031 */
  {    98,      2,     12,      0,      0,   6144,    318, }, /* 1032 */
  {     5,      7,     12,      0,      0,    420,     84, }, /* 1033 */
  {     5,     26,     12,      0,      0,  29092,     74, }, /* 1034 */
  {   106,     12,      3,      0,      0,  26624,    192, }, /* 1035 */
  {   106,     12,      3,      0,      0,  26624,    320, }, /* 1036 */
  {    99,     21,     12,      0,      0,  28672,     74, }, /* 1037 */
  {    99,     21,     12,      0,      0,  28672,    128, }, /* 1038 */
  {    99,     21,     12,      0,      0,  28672,    126, }, /* 1039 */
  {    99,     22,     12,      0,      0,  28672,     74, }, /* 1040 */
  {    99,     18,     12,      0,      0,  28672,     74, }, /* 1041 */
  {    99,     17,     12,      0,      0,  28672,    130, }, /* 1042 */
  {    99,     22,     12,      0,      0,  28672,    322, }, /* 1043 */
  {    99,     18,     12,      0,      0,  28672,    322, }, /* 1044 */
  {    99,     21,     12,      0,      0,   8192,    110, }, /* 1045 */
  {    99,     21,     12,      0,      0,   8192,    324, }, /* 1046 */
  {    99,     21,     12,      0,      0,   8192,    326, }, /* 1047 */
  {    99,     22,     12,      0,      0,  28672,    172, }, /* 1048 */
  {    99,     18,     12,      0,      0,  28672,    172, }, /* 1049 */
  {    99,     21,     12,      0,      0,  14336,     74, }, /* 1050 */
  {    99,     21,     12,      0,      0,  28672,    122, }, /* 1051 */
  {    99,     25,     12,      0,      0,  12288,    122, }, /* 1052 */
  {    99,     17,     12,      0,      0,  12288,    328, }, /* 1053 */
  {    99,     25,     12,      0,      0,  28672,    330, }, /* 1054 */
  {    99,     21,     12,      0,      0,  28672,    322, }, /* 1055 */
  {    99,     21,     12,      0,      0,  28672,    332, }, /* 1056 */
  {    99,     17,     12,      0,      0,  12288,    130, }, /* 1057 */
  {    99,     21,     12,      0,      0,   8192,     74, }, /* 1058 */
  {    99,     13,     12,      0,      0,  10240,    334, }, /* 1059 */
  {     0,      9,     12,      0,     32,  18432,    336, }, /* 1060 */
  {    99,     24,     12,      0,      0,  28672,    338, }, /* 1061 */
  {     0,      5,     12,      0,    -32,  18432,    340, }, /* 1062 */
  {    99,     21,     12,      0,      0,  29036,    128, }, /* 1063 */
  {    99,     22,     12,      0,      0,  29036,    342, }, /* 1064 */
  {    99,     18,     12,      0,      0,  29036,    342, }, /* 1065 */
  {    99,     21,     12,      0,      0,  29036,    110, }, /* 1066 */
  {    99,      6,      3,      0,      0,  18804,    344, }, /* 1067 */
  {    99,      1,      2,      0,      0,  28672,    346, }, /* 1068 */
  {    39,      7,     12,      0,      0,  18432,     84, }, /* 1069 */
  {    99,     21,     12,      0,      0,  18856,     74, }, /* 1070 */
  {    99,     21,     12,      0,      0,  29096,     74, }, /* 1071 */
  {    99,     21,     12,      0,      0,  18860,     74, }, /* 1072 */
  {    99,     15,     12,      0,      0,  18864,     74, }, /* 1073 */
  {    99,     26,     12,      0,      0,  18860,     74, }, /* 1074 */
  {     1,     14,     12,      0,      0,  28672,     84, }, /* 1075 */
  {     1,     15,     12,      0,      0,  28672,     74, }, /* 1076 */
  {     1,     26,     12,      0,      0,  28672,     74, }, /* 1077 */
  {     1,     26,     12,      0,      0,  18432,     74, }, /* 1078 */
  {    50,      7,     12,      0,      0,  18432,     84, }, /* 1079 */
  {    51,      7,     12,      0,      0,  18432,     84, }, /* 1080 */
  {   106,     12,      3,      0,      0,  27060,     98, }, /* 1081 */
  {    99,     15,     12,      0,      0,  10676,     74, }, /* 1082 */
  {   104,      7,     12,      0,      0,  18432,     84, }, /* 1083 */
  {   104,     15,     12,      0,      0,  18432,     74, }, /* 1084 */
  {    32,      7,     12,      0,      0,  18432,     84, }, /* 1085 */
  {    32,     14,     12,      0,      0,  18432,     84, }, /* 1086 */
  {    73,      7,     12,      0,      0,  18432,     84, }, /* 1087 */
  {    73,     12,      3,      0,      0,  26624,    106, }, /* 1088 */
  {   107,      7,     12,      0,      0,  18432,     84, }, /* 1089 */
  {   107,     21,     12,      0,      0,  18432,    110, }, /* 1090 */
  {   111,      7,     12,      0,      0,  18432,     84, }, /* 1091 */
  {   111,     21,     12,      0,      0,  18432,    110, }, /* 1092 */
  {   111,     14,     12,      0,      0,  18432,     84, }, /* 1093 */
  {   105,      9,     12,      0,     40,  18432,     76, }, /* 1094 */
  {   105,      5,     12,      0,    -40,  18432,     78, }, /* 1095 */
  {    40,      7,     12,      0,      0,  18432,     84, }, /* 1096 */
  {   108,      7,     12,      0,      0,  18432,     84, }, /* 1097 */
  {   108,     13,     12,      0,      0,  18432,    144, }, /* 1098 */
  {    80,      9,     12,      0,     40,  18432,     76, }, /* 1099 */
  {    80,      5,     12,      0,    -40,  18432,     78, }, /* 1100 */
  {    66,      7,     12,      0,      0,  18432,     84, }, /* 1101 */
  {    64,      7,     12,      0,      0,  18432,     84, }, /* 1102 */
  {    64,     21,     12,      0,      0,  18432,     74, }, /* 1103 */
  {   167,      9,     12,      0,     39,  18432,     76, }, /* 1104 */
  {   167,      5,     12,      0,    -39,  18432,     78, }, /* 1105 */
  {    96,      7,     12,      0,      0,  18432,     84, }, /* 1106 */
  {    69,      7,     12,      0,      0,  18432,     84, }, /* 1107 */
  {     0,      6,     12,      0,      0,  18432,     96, }, /* 1108 */
  {    41,      7,     12,      0,      0,  34816,     84, }, /* 1109 */
  {   128,      7,     12,      0,      0,  34816,     84, }, /* 1110 */
  {   128,     21,     12,      0,      0,  34816,    110, }, /* 1111 */
  {   128,     15,     12,      0,      0,  34816,     74, }, /* 1112 */
  {   143,      7,     12,      0,      0,  34816,     84, }, /* 1113 */
  {   143,     26,     12,      0,      0,  34816,     74, }, /* 1114 */
  {   143,     15,     12,      0,      0,  34816,     74, }, /* 1115 */
  {   142,      7,     12,      0,      0,  34816,     84, }, /* 1116 */
  {   142,     15,     12,      0,      0,  34816,     74, }, /* 1117 */
  {   149,      7,     12,      0,      0,  34816,     84, }, /* 1118 */
  {   149,     15,     12,      0,      0,  34816,     74, }, /* 1119 */
  {   115,      7,     12,      0,      0,  34816,     84, }, /* 1120 */
  {   115,     15,     12,      0,      0,  34816,     74, }, /* 1121 */
  {   115,     21,     12,      0,      0,  28672,    110, }, /* 1122 */
  {    52,      7,     12,      0,      0,  34816,     84, }, /* 1123 */
  {    52,     21,     12,      0,      0,  34816,     74, }, /* 1124 */
  {    61,      7,     12,      0,      0,  34816,     84, }, /* 1125 */
  {   134,      7,     12,      0,      0,  34816,     84, }, /* 1126 */
  {   134,     15,     12,      0,      0,  34816,     74, }, /* 1127 */
  {   112,      7,     12,      0,      0,  34816,     84, }, /* 1128 */
  {   112,     12,      3,      0,      0,  26624,    106, }, /* 1129 */
  {   112,     12,      3,      0,      0,  26624,     98, }, /* 1130 */
  {   112,     12,      3,      0,      0,  26624,    158, }, /* 1131 */
  {   112,     15,     12,      0,      0,  34816,     74, }, /* 1132 */
  {   112,     21,     12,      0,      0,  34816,     74, }, /* 1133 */
  {   112,     21,     12,      0,      0,  34816,    128, }, /* 1134 */
  {   129,      7,     12,      0,      0,  34816,     84, }, /* 1135 */
  {   129,     15,     12,      0,      0,  34816,     74, }, /* 1136 */
  {   129,     21,     12,      0,      0,  34816,     74, }, /* 1137 */
  {   141,      7,     12,      0,      0,  34816,     84, }, /* 1138 */
  {   141,     15,     12,      0,      0,  34816,     74, }, /* 1139 */
  {    71,      7,     12,      0,      0,  34816,     84, }, /* 1140 */
  {    71,     26,     12,      0,      0,  34816,     74, }, /* 1141 */
  {    71,     12,      3,      0,      0,  26624,     98, }, /* 1142 */
  {    71,     15,     12,      0,      0,  34816,     74, }, /* 1143 */
  {    71,     21,     12,      0,      0,  34816,    110, }, /* 1144 */
  {    71,     21,     12,      0,      0,  35256,    110, }, /* 1145 */
  {    71,     21,     12,      0,      0,  34816,     74, }, /* 1146 */
  {    53,      7,     12,      0,      0,  34816,     84, }, /* 1147 */
  {    53,     21,     12,      0,      0,  28672,     74, }, /* 1148 */
  {    53,     21,     12,      0,      0,  28672,    110, }, /* 1149 */
  {   130,      7,     12,      0,      0,  34816,     84, }, /* 1150 */
  {   130,     15,     12,      0,      0,  34816,     74, }, /* 1151 */
  {   131,      7,     12,      0,      0,  34816,     84, }, /* 1152 */
  {   131,     15,     12,      0,      0,  34816,     74, }, /* 1153 */
  {    74,      7,     12,      0,      0,  34816,     84, }, /* 1154 */
  {    74,     21,     12,      0,      0,  34816,    110, }, /* 1155 */
  {    74,     15,     12,      0,      0,  34816,     74, }, /* 1156 */
  {    57,      7,     12,      0,      0,  34816,     84, }, /* 1157 */
  {    78,      9,     12,      0,     64,  34816,     76, }, /* 1158 */
  {    78,      5,     12,      0,    -64,  34816,     78, }, /* 1159 */
  {    78,     15,     12,      0,      0,  34816,     74, }, /* 1160 */
  {    85,      7,     12,      0,      0,      0,     84, }, /* 1161 */
  {    85,      7,     12,      0,      0,      0,    314, }, /* 1162 */
  {    85,     12,      3,      0,      0,  26624,    132, }, /* 1163 */
  {    85,     13,     12,      0,      0,   2048,    144, }, /* 1164 */
  {    92,     13,     12,      0,      0,   2048,    144, }, /* 1165 */
  {    92,      7,     12,      0,      0,  34816,     84, }, /* 1166 */
  {    92,      6,     12,      0,      0,  34816,     96, }, /* 1167 */
  {    92,      9,     12,      0,     32,  34816,     76, }, /* 1168 */
  {    92,     12,      3,      0,      0,  26624,    132, }, /* 1169 */
  {    92,     12,      3,      0,      0,  26624,    164, }, /* 1170 */
  {    92,     12,      3,      0,      0,  26624,     98, }, /* 1171 */
  {    92,     17,     12,      0,      0,  28672,    130, }, /* 1172 */
  {    92,      6,     12,      0,      0,  34816,    138, }, /* 1173 */
  {    92,      5,     12,      0,    -32,  34816,     78, }, /* 1174 */
  {    92,     25,     12,      0,      0,  34816,    122, }, /* 1175 */
  {     5,     15,     12,      0,      0,   2048,     74, }, /* 1176 */
  {    88,      7,     12,      0,      0,  34816,     84, }, /* 1177 */
  {    88,     12,      3,      0,      0,  26624,    106, }, /* 1178 */
  {    88,     17,     12,      0,      0,  34816,    130, }, /* 1179 */
  {   159,      7,     12,      0,      0,  34816,     84, }, /* 1180 */
  {   159,     15,     12,      0,      0,  34816,     74, }, /* 1181 */
  {    86,      7,     12,      0,      0,      0,     84, }, /* 1182 */
  {    86,     12,      3,      0,      0,  26624,     98, }, /* 1183 */
  {    86,     15,     12,      0,      0,      0,     74, }, /* 1184 */
  {    86,     21,     12,      0,      0,      0,    128, }, /* 1185 */
  {    90,      7,     12,      0,      0,  34816,     84, }, /* 1186 */
  {    90,     12,      3,      0,      0,  26624,     98, }, /* 1187 */
  {    90,     21,     12,      0,      0,  34816,    128, }, /* 1188 */
  {   163,      7,     12,      0,      0,  34816,     84, }, /* 1189 */
  {   163,     15,     12,      0,      0,  34816,     74, }, /* 1190 */
  {   160,      7,     12,      0,      0,  34816,     84, }, /* 1191 */
  {   133,     10,      5,      0,      0,  18432,    154, }, /* 1192 */
  {   133,     12,      3,      0,      0,  26624,    106, }, /* 1193 */
  {   133,      7,     12,      0,      0,  18432,     84, }, /* 1194 */
  {   133,     12,      3,      0,      0,  26624,    158, }, /* 1195 */
  {   133,     21,     12,      0,      0,  18432,    128, }, /* 1196 */
  {   133,     21,     12,      0,      0,  18432,    110, }, /* 1197 */
  {   133,     15,     12,      0,      0,  28672,     74, }, /* 1198 */
  {   133,     13,     12,      0,      0,  18432,    144, }, /* 1199 */
  {   133,     12,      3,      0,      0,  26624,    290, }, /* 1200 */
  {    58,     12,      3,      0,      0,  26624,    106, }, /* 1201 */
  {    58,     10,      5,      0,      0,  18432,    154, }, /* 1202 */
  {    58,      7,     12,      0,      0,  18432,     84, }, /* 1203 */
  {    58,     12,      3,      0,      0,  26624,    158, }, /* 1204 */
  {    58,     12,      3,      0,      0,  26624,     98, }, /* 1205 */
  {    58,     21,     12,      0,      0,  18432,     74, }, /* 1206 */
  {    58,      1,      4,      0,      0,  18432,    134, }, /* 1207 */
  {    58,     21,     12,      0,      0,  18432,    128, }, /* 1208 */
  {   136,      7,     12,      0,      0,  18432,     84, }, /* 1209 */
  {   136,     13,     12,      0,      0,  18432,    144, }, /* 1210 */
  {    60,     12,      3,      0,      0,  26624,    106, }, /* 1211 */
  {    60,      7,     12,      0,      0,  18432,     84, }, /* 1212 */
  {    60,     10,      5,      0,      0,  18432,    154, }, /* 1213 */
  {    60,     12,      3,      0,      0,  26624,    158, }, /* 1214 */
  {    60,     13,     12,      0,      0,  18432,    144, }, /* 1215 */
  {    60,     21,     12,      0,      0,  18432,     74, }, /* 1216 */
  {    60,     21,     12,      0,      0,  18432,    128, }, /* 1217 */
  {    70,      7,     12,      0,      0,  18432,     84, }, /* 1218 */
  {    70,     12,      3,      0,      0,  26624,     98, }, /* 1219 */
  {    70,     21,     12,      0,      0,  18432,     74, }, /* 1220 */
  {    62,     12,      3,      0,      0,  26624,    106, }, /* 1221 */
  {    62,     10,      5,      0,      0,  18432,    154, }, /* 1222 */
  {    62,      7,     12,      0,      0,  18432,     84, }, /* 1223 */
  {    62,     10,      3,      0,      0,  18432,    188, }, /* 1224 */
  {    62,      7,      4,      0,      0,  18432,     84, }, /* 1225 */
  {    62,     21,     12,      0,      0,  18432,    128, }, /* 1226 */
  {    62,     21,     12,      0,      0,  18432,     74, }, /* 1227 */
  {    62,     12,      3,      0,      0,  26624,    104, }, /* 1228 */
  {    62,     12,      3,      0,      0,  26624,     98, }, /* 1229 */
  {    62,     13,     12,      0,      0,  18432,    144, }, /* 1230 */
  {    17,     15,     12,      0,      0,  18432,     74, }, /* 1231 */
  {    68,      7,     12,      0,      0,  18432,     84, }, /* 1232 */
  {    68,     10,      5,      0,      0,  18432,    154, }, /* 1233 */
  {    68,     12,      3,      0,      0,  26624,    106, }, /* 1234 */
  {    68,     10,      3,      0,      0,  18432,    188, }, /* 1235 */
  {    68,     12,      3,      0,      0,  26624,     98, }, /* 1236 */
  {    68,     12,      3,      0,      0,  26624,    162, }, /* 1237 */
  {    68,     21,     12,      0,      0,  18432,    128, }, /* 1238 */
  {    68,     21,     12,      0,      0,  18432,    110, }, /* 1239 */
  {    68,     21,     12,      0,      0,  18432,     74, }, /* 1240 */
  {    77,      7,     12,      0,      0,  18432,     84, }, /* 1241 */
  {    77,     21,     12,      0,      0,  18432,    128, }, /* 1242 */
  {    75,      7,     12,      0,      0,  18432,     84, }, /* 1243 */
  {    75,     12,      3,      0,      0,  26624,    106, }, /* 1244 */
  {    75,     10,      5,      0,      0,  18432,    154, }, /* 1245 */
  {    75,     12,      3,      0,      0,  26624,     98, }, /* 1246 */
  {    75,     12,      3,      0,      0,  26624,    158, }, /* 1247 */
  {    75,     13,     12,      0,      0,  18432,    144, }, /* 1248 */
  {    67,     12,      3,      0,      0,  26624,    106, }, /* 1249 */
  {    67,     12,      3,      0,      0,  26836,    106, }, /* 1250 */
  {    67,     10,      5,      0,      0,  18432,    154, }, /* 1251 */
  {    67,     10,      5,      0,      0,  18644,    154, }, /* 1252 */
  {    67,      7,     12,      0,      0,  18432,     84, }, /* 1253 */
  {   106,     12,      3,      0,      0,  26836,     98, }, /* 1254 */
  {    67,     12,      3,      0,      0,  26836,     98, }, /* 1255 */
  {    67,     10,      3,      0,      0,  18432,    160, }, /* 1256 */
  {    67,     10,      3,      0,      0,  18432,    188, }, /* 1257 */
  {    67,      7,     12,      0,      0,  18432,    348, }, /* 1258 */
  {    67,     12,      3,      0,      0,  26624,     98, }, /* 1259 */
  {    97,      7,     12,      0,      0,  18432,     84, }, /* 1260 */
  {    97,     10,      3,      0,      0,  18432,    160, }, /* 1261 */
  {    97,     10,      5,      0,      0,  18432,    154, }, /* 1262 */
  {    97,     12,      3,      0,      0,  26624,    106, }, /* 1263 */
  {    97,     12,      3,      0,      0,  26624,    158, }, /* 1264 */
  {    97,     10,      3,      0,      0,  18432,    188, }, /* 1265 */
  {    97,      7,      4,      0,      0,  18432,     84, }, /* 1266 */
  {    97,     12,      3,      0,      0,  26624,    164, }, /* 1267 */
  {    97,      7,     12,      0,      0,  18432,    350, }, /* 1268 */
  {    97,     21,     12,      0,      0,  18432,    128, }, /* 1269 */
  {    97,     21,     12,      0,      0,  18432,     74, }, /* 1270 */
  {    97,     12,      3,      0,      0,  26624,     98, }, /* 1271 */
  {   153,      7,     12,      0,      0,  18432,     84, }, /* 1272 */
  {   153,     10,      5,      0,      0,  18432,    154, }, /* 1273 */
  {   153,     12,      3,      0,      0,  26624,    106, }, /* 1274 */
  {   153,     12,      3,      0,      0,  26624,    158, }, /* 1275 */
  {   153,     12,      3,      0,      0,  26624,     98, }, /* 1276 */
  {   153,     21,     12,      0,      0,  18432,    128, }, /* 1277 */
  {   153,     21,     12,      0,      0,  18432,    110, }, /* 1278 */
  {   153,     21,     12,      0,      0,  18432,     74, }, /* 1279 */
  {   153,     13,     12,      0,      0,  18432,    144, }, /* 1280 */
  {   153,     12,      3,      0,      0,  26624,    104, }, /* 1281 */
  {    76,      7,     12,      0,      0,  18432,     84, }, /* 1282 */
  {    76,     10,      3,      0,      0,  18432,    160, }, /* 1283 */
  {    76,     10,      5,      0,      0,  18432,    154, }, /* 1284 */
  {    76,     12,      3,      0,      0,  26624,    106, }, /* 1285 */
  {    76,     12,      3,      0,      0,  26624,    158, }, /* 1286 */
  {    76,     12,      3,      0,      0,  26624,     98, }, /* 1287 */
  {    76,     21,     12,      0,      0,  18432,     74, }, /* 1288 */
  {    76,     13,     12,      0,      0,  18432,    144, }, /* 1289 */
  {   145,      7,     12,      0,      0,  18432,     84, }, /* 1290 */
  {   145,     10,      3,      0,      0,  18432,    160, }, /* 1291 */
  {   145,     10,      5,      0,      0,  18432,    154, }, /* 1292 */
  {   145,     12,      3,      0,      0,  26624,    106, }, /* 1293 */
  {   145,     12,      3,      0,      0,  26624,    158, }, /* 1294 */
  {   145,     12,      3,      0,      0,  26624,     98, }, /* 1295 */
  {   145,     21,     12,      0,      0,  18432,     74, }, /* 1296 */
  {   145,     21,     12,      0,      0,  18432,    128, }, /* 1297 */
  {   145,     21,     12,      0,      0,  18432,    110, }, /* 1298 */
  {   145,     21,     12,      0,      0,  18432,    190, }, /* 1299 */
  {    72,      7,     12,      0,      0,  18432,     84, }, /* 1300 */
  {    72,     10,      5,      0,      0,  18432,    154, }, /* 1301 */
  {    72,     12,      3,      0,      0,  26624,    106, }, /* 1302 */
  {    72,     12,      3,      0,      0,  26624,    158, }, /* 1303 */
  {    72,     21,     12,      0,      0,  18432,    128, }, /* 1304 */
  {    72,     21,     12,      0,      0,  18432,     74, }, /* 1305 */
  {    72,     13,     12,      0,      0,  18432,    144, }, /* 1306 */
  {    63,      7,     12,      0,      0,  18432,     84, }, /* 1307 */
  {    63,     12,      3,      0,      0,  26624,    106, }, /* 1308 */
  {    63,     10,      5,      0,      0,  18432,    154, }, /* 1309 */
  {    63,     10,      3,      0,      0,  18432,    188, }, /* 1310 */
  {    63,     12,      3,      0,      0,  26624,     98, }, /* 1311 */
  {    63,     21,     12,      0,      0,  18432,     74, }, /* 1312 */
  {    63,     13,     12,      0,      0,  18432,    144, }, /* 1313 */
  {   147,      7,     12,      0,      0,  18432,     84, }, /* 1314 */
  {   147,     12,      3,      0,      0,  26624,    106, }, /* 1315 */
  {   147,     10,      5,      0,      0,  18432,    154, }, /* 1316 */
  {   147,     10,     12,      0,      0,  18432,    154, }, /* 1317 */
  {   147,     12,      3,      0,      0,  26624,    158, }, /* 1318 */
  {   147,     13,     12,      0,      0,  18432,    144, }, /* 1319 */
  {   147,     15,     12,      0,      0,  18432,     74, }, /* 1320 */
  {   147,     21,     12,      0,      0,  18432,    128, }, /* 1321 */
  {   147,     26,     12,      0,      0,  18432,     74, }, /* 1322 */
  {    83,      7,     12,      0,      0,  18432,     84, }, /* 1323 */
  {    83,     10,      5,      0,      0,  18432,    154, }, /* 1324 */
  {    83,     12,      3,      0,      0,  26624,    106, }, /* 1325 */
  {    83,     12,      3,      0,      0,  26624,    158, }, /* 1326 */
  {    83,     12,      3,      0,      0,  26624,     98, }, /* 1327 */
  {    83,     21,     12,      0,      0,  18432,     74, }, /* 1328 */
  {   146,      9,     12,      0,     32,  18432,     76, }, /* 1329 */
  {   146,      5,     12,      0,    -32,  18432,     78, }, /* 1330 */
  {   146,     13,     12,      0,      0,  18432,    144, }, /* 1331 */
  {   146,     15,     12,      0,      0,  18432,     74, }, /* 1332 */
  {   146,      7,     12,      0,      0,  18432,     84, }, /* 1333 */
  {   164,      7,     12,      0,      0,  18432,     84, }, /* 1334 */
  {   164,     10,      3,      0,      0,  18432,    160, }, /* 1335 */
  {   164,     10,      5,      0,      0,  18432,    154, }, /* 1336 */
  {   164,     12,      3,      0,      0,  26624,    106, }, /* 1337 */
  {   164,     10,      3,      0,      0,  18432,    188, }, /* 1338 */
  {   164,     12,      3,      0,      0,  26624,    158, }, /* 1339 */
  {   164,      7,      4,      0,      0,  18432,     84, }, /* 1340 */
  {   164,     12,      3,      0,      0,  26624,     98, }, /* 1341 */
  {   164,     21,     12,      0,      0,  18432,    128, }, /* 1342 */
  {   164,     21,     12,      0,      0,  18432,     74, }, /* 1343 */
  {   164,     13,     12,      0,      0,  18432,    144, }, /* 1344 */
  {    87,      7,     12,      0,      0,  18432,     84, }, /* 1345 */
  {    87,     10,      5,      0,      0,  18432,    154, }, /* 1346 */
  {    87,     12,      3,      0,      0,  26624,    106, }, /* 1347 */
  {    87,     12,      3,      0,      0,  26624,    158, }, /* 1348 */
  {    87,     21,     12,      0,      0,  18432,     74, }, /* 1349 */
  {   156,      7,     12,      0,      0,  18432,     84, }, /* 1350 */
  {   156,     12,      3,      0,      0,  26624,    106, }, /* 1351 */
  {   156,     12,      3,      0,      0,  18432,    106, }, /* 1352 */
  {   156,     12,      3,      0,      0,  26624,    104, }, /* 1353 */
  {   156,     12,      3,      0,      0,  26624,    158, }, /* 1354 */
  {   156,     10,      5,      0,      0,  18432,    154, }, /* 1355 */
  {   156,      7,      4,      0,      0,  18432,     84, }, /* 1356 */
  {   156,     21,     12,      0,      0,  18432,     74, }, /* 1357 */
  {   156,     21,     12,      0,      0,  18432,    128, }, /* 1358 */
  {   155,      7,     12,      0,      0,  18432,     84, }, /* 1359 */
  {   155,     12,      3,      0,      0,  26624,    106, }, /* 1360 */
  {   155,     10,      5,      0,      0,  18432,    154, }, /* 1361 */
  {   155,      7,      4,      0,      0,  18432,     84, }, /* 1362 */
  {   155,     12,      3,      0,      0,  26624,    352, }, /* 1363 */
  {   155,     12,      3,      0,      0,  26624,    158, }, /* 1364 */
  {   155,     21,     12,      0,      0,  18432,     74, }, /* 1365 */
  {   155,     21,     12,      0,      0,  18432,    128, }, /* 1366 */
  {   155,     21,     12,      0,      0,  18432,    110, }, /* 1367 */
  {   144,      7,     12,      0,      0,  18432,     84, }, /* 1368 */
  {    95,      7,     12,      0,      0,  18432,     84, }, /* 1369 */
  {    95,     21,     12,      0,      0,  18432,     74, }, /* 1370 */
  {    95,     13,     12,      0,      0,  18432,    144, }, /* 1371 */
  {   151,      7,     12,      0,      0,  18432,     84, }, /* 1372 */
  {   151,     10,      5,      0,      0,  18432,    154, }, /* 1373 */
  {   151,     12,      3,      0,      0,  26624,    106, }, /* 1374 */
  {   151,     12,      3,      0,      0,  18432,    158, }, /* 1375 */
  {   151,     21,     12,      0,      0,  18432,    128, }, /* 1376 */
  {   151,     21,     12,      0,      0,  18432,    110, }, /* 1377 */
  {   151,     21,     12,      0,      0,  18432,     74, }, /* 1378 */
  {   151,     13,     12,      0,      0,  18432,    144, }, /* 1379 */
  {   151,     15,     12,      0,      0,  18432,     74, }, /* 1380 */
  {   152,     21,     12,      0,      0,  18432,     74, }, /* 1381 */
  {   152,     21,     12,      0,      0,  18432,    110, }, /* 1382 */
  {   152,      7,     12,      0,      0,  18432,     84, }, /* 1383 */
  {   152,     12,      3,      0,      0,  26624,    106, }, /* 1384 */
  {   152,     10,      5,      0,      0,  18432,    154, }, /* 1385 */
  {    82,      7,     12,      0,      0,  18432,     84, }, /* 1386 */
  {    82,     12,      3,      0,      0,  26624,    106, }, /* 1387 */
  {    82,     12,      3,      0,      0,  26624,     98, }, /* 1388 */
  {    82,     12,      3,      0,      0,  26624,    158, }, /* 1389 */
  {    82,      7,      4,      0,      0,  18432,     84, }, /* 1390 */
  {    82,     13,     12,      0,      0,  18432,    144, }, /* 1391 */
  {    84,      7,     12,      0,      0,  18432,     84, }, /* 1392 */
  {    84,     10,      5,      0,      0,  18432,    154, }, /* 1393 */
  {    84,     12,      3,      0,      0,  26624,    106, }, /* 1394 */
  {    84,     12,      3,      0,      0,  26624,    158, }, /* 1395 */
  {    84,     13,     12,      0,      0,  18432,    144, }, /* 1396 */
  {   157,      7,     12,      0,      0,  18432,     84, }, /* 1397 */
  {   157,     12,      3,      0,      0,  26624,    106, }, /* 1398 */
  {   157,     10,      5,      0,      0,  18432,    154, }, /* 1399 */
  {   157,     21,     12,      0,      0,  18432,    128, }, /* 1400 */
  {   168,     12,      3,      0,      0,  26624,    106, }, /* 1401 */
  {   168,      7,      4,      0,      0,  18432,     84, }, /* 1402 */
  {   168,     10,      5,      0,      0,  18432,    154, }, /* 1403 */
  {   168,      7,     12,      0,      0,  18432,     84, }, /* 1404 */
  {   168,     10,      3,      0,      0,  18432,    188, }, /* 1405 */
  {   168,     12,      3,      0,      0,  26624,    158, }, /* 1406 */
  {   168,     21,     12,      0,      0,  18432,    128, }, /* 1407 */
  {   168,     21,     12,      0,      0,  18432,     74, }, /* 1408 */
  {   168,     13,     12,      0,      0,  18432,    144, }, /* 1409 */
  {   168,     12,      3,      0,      0,  26624,     98, }, /* 1410 */
  {    13,     15,     12,      0,      0,  18432,     74, }, /* 1411 */
  {    13,     21,     12,      0,      0,  18432,     74, }, /* 1412 */
  {   114,      7,     12,      0,      0,  18432,     84, }, /* 1413 */
  {   114,     14,     12,      0,      0,  18432,     84, }, /* 1414 */
  {   114,     21,     12,      0,      0,  18432,    110, }, /* 1415 */
  {    89,      7,     12,      0,      0,  18432,     84, }, /* 1416 */
  {    89,     21,     12,      0,      0,  18432,     74, }, /* 1417 */
  {   125,      7,     12,      0,      0,  18432,     84, }, /* 1418 */
  {   125,      1,      2,      0,      0,  18432,    346, }, /* 1419 */
  {   125,     12,      3,      0,      0,  26624,    104, }, /* 1420 */
  {   125,     12,      3,      0,      0,  26624,     98, }, /* 1421 */
  {   148,      7,     12,      0,      0,  18432,     84, }, /* 1422 */
  {    93,      7,     12,      0,      0,  18432,     84, }, /* 1423 */
  {    93,     12,      3,      0,      0,  26624,    106, }, /* 1424 */
  {    93,     10,      5,      0,      0,  18432,    154, }, /* 1425 */
  {    93,     12,      3,      0,      0,  26624,    158, }, /* 1426 */
  {    93,     13,     12,      0,      0,  18432,    144, }, /* 1427 */
  {   140,      7,     12,      0,      0,  18432,     84, }, /* 1428 */
  {   140,     13,     12,      0,      0,  18432,    144, }, /* 1429 */
  {   140,     21,     12,      0,      0,  18432,    128, }, /* 1430 */
  {   166,      7,     12,      0,      0,  18432,     84, }, /* 1431 */
  {   166,     13,     12,      0,      0,  18432,    144, }, /* 1432 */
  {   137,      7,     12,      0,      0,  18432,     84, }, /* 1433 */
  {   137,     12,      3,      0,      0,  26624,     98, }, /* 1434 */
  {   137,     21,     12,      0,      0,  18432,    128, }, /* 1435 */
  {   138,      7,     12,      0,      0,  18432,     84, }, /* 1436 */
  {   138,     12,      3,      0,      0,  26624,     98, }, /* 1437 */
  {   138,     21,     12,      0,      0,  18432,    128, }, /* 1438 */
  {   138,     21,     12,      0,      0,  18432,    110, }, /* 1439 */
  {   138,     21,     12,      0,      0,  18432,     74, }, /* 1440 */
  {   138,     26,     12,      0,      0,  18432,     74, }, /* 1441 */
  {   138,      6,     12,      0,      0,  18432,    148, }, /* 1442 */
  {   138,      6,     12,      0,      0,  18432,    138, }, /* 1443 */
  {   138,     13,     12,      0,      0,  18432,    144, }, /* 1444 */
  {   138,     15,     12,      0,      0,  18432,     74, }, /* 1445 */
  {   170,      6,     12,      0,      0,  18432,    148, }, /* 1446 */
  {   170,      7,     12,      0,      0,  18432,     84, }, /* 1447 */
  {   170,      7,      7,      0,      0,  18432,     84, }, /* 1448 */
  {   170,      6,     12,      0,      0,  18432,     94, }, /* 1449 */
  {   170,     21,     12,      0,      0,  18432,     74, }, /* 1450 */
  {   170,     21,     12,      0,      0,  18432,    128, }, /* 1451 */
  {   170,     13,     12,      0,      0,  18432,    144, }, /* 1452 */
  {   158,      9,     12,      0,     32,  18432,     76, }, /* 1453 */
  {   158,      5,     12,      0,    -32,  18432,     78, }, /* 1454 */
  {   158,     15,     12,      0,      0,  18432,     74, }, /* 1455 */
  {   158,     21,     12,      0,      0,  18432,    110, }, /* 1456 */
  {   158,     21,     12,      0,      0,  18432,    128, }, /* 1457 */
  {   158,     21,     12,      0,      0,  18432,     74, }, /* 1458 */
  {   135,      7,     12,      0,      0,  18432,     84, }, /* 1459 */
  {   135,     12,      3,      0,      0,  26624,    106, }, /* 1460 */
  {   135,     10,      5,      0,      0,  18432,    154, }, /* 1461 */
  {   135,     12,      3,      0,      0,  26624,    132, }, /* 1462 */
  {   135,      6,     12,      0,      0,  18432,     94, }, /* 1463 */
  {    81,      6,     12,      0,      0,  18432,    138, }, /* 1464 */
  {   154,      6,     12,      0,      0,  18432,    138, }, /* 1465 */
  {    30,     21,     12,      0,      0,  28672,     74, }, /* 1466 */
  {   165,     12,      3,      0,      0,  26624,    354, }, /* 1467 */
  {    30,     10,      3,      0,      0,  18432,    356, }, /* 1468 */
  {    81,      7,     12,      0,      0,  18432,    304, }, /* 1469 */
  {   165,      7,     12,      0,      0,  18432,    304, }, /* 1470 */
  {    28,      6,     12,      0,      0,  18432,     94, }, /* 1471 */
  {   154,      7,     12,      0,      0,  18432,    304, }, /* 1472 */
  {    65,      7,     12,      0,      0,  18432,     84, }, /* 1473 */
  {    65,     26,     12,      0,      0,  18432,     74, }, /* 1474 */
  {    65,     12,      3,      0,      0,  26624,    104, }, /* 1475 */
  {    65,     12,      3,      0,      0,  26624,    106, }, /* 1476 */
  {    65,     21,     12,      0,      0,  18432,    128, }, /* 1477 */
  {    99,      1,      2,      0,      0,   6472,     66, }, /* 1478 */
  {    99,     13,     12,      0,      0,  10240,    144, }, /* 1479 */
  {    99,     10,      3,      0,      0,  18432,    358, }, /* 1480 */
  {    99,     10,      3,      0,      0,  18432,    306, }, /* 1481 */
  {     1,     12,      3,      0,      0,  26624,    104, }, /* 1482 */
  {    99,     25,     12,      0,      0,  28672,    360, }, /* 1483 */
  {    99,     13,     12,      0,      0,  10240,    226, }, /* 1484 */
  {   150,     26,     12,      0,      0,  18432,     74, }, /* 1485 */
  {   150,     12,      3,      0,      0,  26624,    104, }, /* 1486 */
  {   150,     21,     12,      0,      0,  18432,    110, }, /* 1487 */
  {   150,     21,     12,      0,      0,  18432,    128, }, /* 1488 */
  {   150,     21,     12,      0,      0,  18432,     74, }, /* 1489 */
  {    44,     12,      3,      0,      0,  26624,    106, }, /* 1490 */
  {     2,      6,     12,      0,      0,  18432,     92, }, /* 1491 */
  {   161,      7,     12,      0,      0,  18432,     84, }, /* 1492 */
  {   161,     12,      3,      0,      0,  26624,     98, }, /* 1493 */
  {   161,      6,     12,      0,      0,  18432,    148, }, /* 1494 */
  {   161,      6,     12,      0,      0,  18432,    138, }, /* 1495 */
  {   161,     13,     12,      0,      0,  18432,    144, }, /* 1496 */
  {   161,     26,     12,      0,      0,  18432,     74, }, /* 1497 */
  {    91,      7,     12,      0,      0,  18432,     84, }, /* 1498 */
  {    91,     12,      3,      0,      0,  26624,     98, }, /* 1499 */
  {   162,      7,     12,      0,      0,  18432,     84, }, /* 1500 */
  {   162,     12,      3,      0,      0,  26624,     98, }, /* 1501 */
  {   162,     13,     12,      0,      0,  18432,    144, }, /* 1502 */
  {   162,     23,     12,      0,      0,  14336,     74, }, /* 1503 */
  {   169,      7,     12,      0,      0,  18432,     84, }, /* 1504 */
  {   169,      6,     12,      0,      0,  18432,    148, }, /* 1505 */
  {   169,     12,      3,      0,      0,  26624,    104, }, /* 1506 */
  {   169,     13,     12,      0,      0,  18432,    144, }, /* 1507 */
  {    94,      7,     12,      0,      0,  18432,     84, }, /* 1508 */
  {    94,     12,      3,      0,      0,  26624,     98, }, /* 1509 */
  {    94,     12,      3,      0,      0,  26624,    164, }, /* 1510 */
  {    94,     13,     12,      0,      0,  18432,    144, }, /* 1511 */
  {    94,     21,     12,      0,      0,  18432,     74, }, /* 1512 */
  {   139,      7,     12,      0,      0,  34816,     84, }, /* 1513 */
  {   139,     15,     12,      0,      0,  34816,     74, }, /* 1514 */
  {   139,     12,      3,      0,      0,  26624,     98, }, /* 1515 */
  {    79,      9,     12,      0,     34,  34816,     76, }, /* 1516 */
  {    79,      5,     12,      0,    -34,  34816,     78, }, /* 1517 */
  {    79,     12,      3,      0,      0,  26624,    164, }, /* 1518 */
  {    79,     12,      3,      0,      0,  26624,    106, }, /* 1519 */
  {    79,     12,      3,      0,      0,  26624,     98, }, /* 1520 */
  {    79,      6,     12,      0,      0,  34816,    148, }, /* 1521 */
  {    79,     13,     12,      0,      0,  34816,    144, }, /* 1522 */
  {    79,     21,     12,      0,      0,  34816,     74, }, /* 1523 */
  {    99,     15,     12,      0,      0,      0,     74, }, /* 1524 */
  {    99,     26,     12,      0,      0,      0,     74, }, /* 1525 */
  {    99,     23,     12,      0,      0,      0,     74, }, /* 1526 */
  {     5,      7,     12,      0,      0,      0,    254, }, /* 1527 */
  {    99,     26,     14,      0,      0,  28672,    362, }, /* 1528 */
  {    99,     26,     14,      0,      0,  28672,    364, }, /* 1529 */
  {    98,      2,     14,      0,      0,  18432,    366, }, /* 1530 */
  {    99,     26,     12,      0,      0,  18432,    368, }, /* 1531 */
  {    99,     26,     14,      0,      0,  18432,    370, }, /* 1532 */
  {    99,     26,     14,      0,      0,  18432,    364, }, /* 1533 */
  {    99,     26,     11,      0,      0,  18432,    372, }, /* 1534 */
  {    27,     26,     12,      0,      0,  18432,     74, }, /* 1535 */
  {    99,     26,     14,      0,      0,  18432,    250, }, /* 1536 */
  {    99,     26,     14,      0,      0,  18784,    364, }, /* 1537 */
  {    99,     26,     14,      0,      0,  28672,    374, }, /* 1538 */
  {    99,     26,     14,      0,      0,  28672,    376, }, /* 1539 */
  {    99,     24,      3,      0,      0,  28672,    378, }, /* 1540 */
  {    99,     26,     14,      0,      0,  28672,    380, }, /* 1541 */
  {    99,      1,      3,      0,      0,   6144,    382, }, /* 1542 */
};

const uint16_t PRIV(ucd_stage1)[] = { /* 17408 bytes */
  0,  1,  2,  3,  4,  5,  6,  7,  8,  9, 10, 11, 12, 13, 14, 15, /* U+0000 */
 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, /* U+0800 */
 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 41, 41, 42, 43, 44, 45, /* U+1000 */
 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, /* U+1800 */
 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, /* U+2000 */
 78, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, /* U+2800 */
 93, 94, 95, 96, 97, 98, 99,100,101,101,101,101,101,101,101,101, /* U+3000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+3800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+4000 */
101,101,101,101,101,101,101,101,101,101,101,102,101,101,101,101, /* U+4800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+5000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+5800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+6000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+6800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+7000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+7800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+8000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+8800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+9000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+9800 */
103,104,104,104,104,104,104,104,104,105,106,106,107,108,109,110, /* U+A000 */
111,112,113,114,115,116,117,118,119,120,121,122,123,124,125,119, /* U+A800 */
120,121,122,123,124,125,119,120,121,122,123,124,125,119,120,121, /* U+B000 */
122,123,124,125,119,120,121,122,123,124,125,119,120,121,122,123, /* U+B800 */
124,125,119,120,121,122,123,124,125,119,120,121,122,123,124,125, /* U+C000 */
119,120,121,122,123,124,125,119,120,121,122,123,124,125,119,120, /* U+C800 */
121,122,123,124,125,119,120,121,122,123,124,125,119,120,121,126, /* U+D000 */
127,127,127,127,127,127,127,127,127,127,127,127,127,127,127,127, /* U+D800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+E000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+E800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F000 */
128,128,129,129,130,131,132,133,134,135,136,137,138,139,140,141, /* U+F800 */
142,143,144,145,146,147,148,149,150,151,152,153,154,154,155,156, /* U+10000 */
157,158,159,160,161,162,163,164,165,166,167,168,169,170,171,172, /* U+10800 */
173,174,175,176,177,178,179,180,181,182,146,183,184,185,186,146, /* U+11000 */
187,188,189,190,191,192,193,194,195,196,197,198,146,199,200,201, /* U+11800 */
202,202,202,202,202,202,202,203,204,202,205,146,146,146,146,146, /* U+12000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,206, /* U+12800 */
207,207,207,207,207,207,207,207,208,207,207,207,207,207,207,207, /* U+13000 */
207,207,207,207,207,207,207,207,207,207,207,207,207,207,207,207, /* U+13800 */
207,207,207,207,207,207,207,209,210,210,210,210,211,146,146,146, /* U+14000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+14800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+15000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+15800 */
146,146,212,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+16000 */
213,213,213,213,214,215,216,217,146,146,218,146,219,220,221,222, /* U+16800 */
223,223,223,223,223,223,223,223,223,223,223,223,223,223,223,223, /* U+17000 */
223,223,223,223,223,223,223,223,223,223,223,223,223,223,223,223, /* U+17800 */
223,223,223,223,223,223,223,223,223,223,223,223,223,223,223,224, /* U+18000 */
223,223,223,223,223,223,225,225,225,226,227,146,146,146,146,146, /* U+18800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+19000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+19800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+1A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,228, /* U+1A800 */
229,230,231,232,232,233,146,146,146,146,146,146,146,146,146,146, /* U+1B000 */
146,146,146,146,146,146,146,146,234,235,146,146,146,146,146,146, /* U+1B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+1C000 */
146,146,146,146,146,146,146,146,236,237,236,236,236,238,239,240, /* U+1C800 */
241,242,243,244,245,246,247,146,248,249,250,251,252,253,254,255, /* U+1D000 */
256,256,256,256,257,258,146,146,146,146,146,146,146,146,259,146, /* U+1D800 */
260,261,262,146,146,263,146,146,146,264,146,265,146,146,146,266, /* U+1E000 */
267,268,269,270,270,270,270,270,271,272,273,270,274,275,270,270, /* U+1E800 */
276,277,278,279,280,281,282,283,284,285,286,287,288,289,290,291, /* U+1F000 */
292,293,294,295,296,297,236,298,281,281,281,281,281,281,281,299, /* U+1F800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+20000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+20800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+21000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+21800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+22000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+22800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+23000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+23800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+24000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+24800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+25000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+25800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+26000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+26800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+27000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+27800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+28000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+28800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+29000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+29800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,300,101,101, /* U+2A000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+2A800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,301,101, /* U+2B000 */
302,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+2B800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+2C000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,303,101,101, /* U+2C800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+2D000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+2D800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+2E000 */
101,101,101,101,101,101,101,304,101,101,101,101,305,146,146,146, /* U+2E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+2F000 */
129,129,129,129,306,146,146,146,146,146,146,146,146,146,146,307, /* U+2F800 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+30000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+30800 */
101,101,101,101,101,101,308,101,101,101,101,101,101,101,101,101, /* U+31000 */
101,101,101,101,101,101,101,101,101,101,101,101,101,101,101,101, /* U+31800 */
101,101,101,101,101,101,101,309,146,146,146,146,146,146,146,146, /* U+32000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+32800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+33000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+33800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+34000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+34800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+35000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+35800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+36000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+36800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+37000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+37800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+38000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+38800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+39000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+39800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+3F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+3F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+40000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+40800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+41000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+41800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+42000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+42800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+43000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+43800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+44000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+44800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+45000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+45800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+46000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+46800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+47000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+47800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+48000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+48800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+49000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+49800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+4F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+4F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+50000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+50800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+51000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+51800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+52000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+52800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+53000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+53800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+54000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+54800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+55000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+55800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+56000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+56800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+57000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+57800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+58000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+58800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+59000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+59800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+5F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+5F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+60000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+60800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+61000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+61800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+62000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+62800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+63000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+63800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+64000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+64800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+65000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+65800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+66000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+66800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+67000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+67800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+68000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+68800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+69000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+69800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+6F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+6F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+70000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+70800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+71000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+71800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+72000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+72800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+73000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+73800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+74000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+74800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+75000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+75800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+76000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+76800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+77000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+77800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+78000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+78800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+79000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+79800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+7F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+7F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+80000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+80800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+81000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+81800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+82000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+82800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+83000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+83800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+84000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+84800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+85000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+85800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+86000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+86800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+87000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+87800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+88000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+88800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+89000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+89800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+8F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+8F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+90000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+90800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+91000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+91800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+92000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+92800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+93000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+93800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+94000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+94800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+95000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+95800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+96000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+96800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+97000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+97800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+98000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+98800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+99000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+99800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9A000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9A800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9B000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9B800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9C000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9C800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9D000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9D800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9E000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9E800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+9F000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+9F800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A0000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A0800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A1000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A1800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A2000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A2800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A3000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A3800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A4000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A4800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A5000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A5800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A6000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A6800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A7000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A7800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A8000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A8800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A9000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+A9800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AA000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AA800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AB000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AB800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AC000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AC800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AD000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AD800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AE000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AE800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+AF000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+AF800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B0000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B0800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B1000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B1800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B2000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B2800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B3000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B3800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B4000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B4800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B5000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B5800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B6000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B6800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B7000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B7800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B8000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B8800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B9000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+B9800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BA000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BA800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BB000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BB800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BC000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BC800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BD000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BD800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BE000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BE800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+BF000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+BF800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C0000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C0800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C1000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C1800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C2000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C2800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C3000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C3800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C4000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C4800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C5000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C5800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C6000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C6800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C7000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C7800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C8000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C8800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C9000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+C9800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CA000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CA800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CB000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CB800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CC000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CC800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CD000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CD800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CE000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CE800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+CF000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+CF800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D0000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D0800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D1000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D1800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D2000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D2800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D3000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D3800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D4000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D4800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D5000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D5800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D6000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D6800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D7000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D7800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D8000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D8800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D9000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+D9800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DA000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DA800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DB000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DB800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DC000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DC800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DD000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DD800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DE000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DE800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+DF000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+DF800 */
310,311,312,313,311,311,311,311,311,311,311,311,311,311,311,311, /* U+E0000 */
311,311,311,311,311,311,311,311,311,311,311,311,311,311,311,311, /* U+E0800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E1000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E1800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E2000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E2800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E3000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E3800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E4000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E4800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E5000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E5800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E6000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E6800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E7000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E7800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E8000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E8800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E9000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+E9800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EA000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EA800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EB000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EB800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EC000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EC800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+ED000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+ED800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EE000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EE800 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,146, /* U+EF000 */
146,146,146,146,146,146,146,146,146,146,146,146,146,146,146,307, /* U+EF800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F0000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F0800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F1000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F1800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F2000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F2800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F3000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F3800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F4000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F4800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F5000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F5800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F6000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F6800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F7000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F7800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F8000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F8800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F9000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+F9800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FA000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FA800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FB000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FB800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FC000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FC800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FD000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FD800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FE000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FE800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+FF000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,314, /* U+FF800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+100000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+100800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+101000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+101800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+102000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+102800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+103000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+103800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+104000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+104800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+105000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+105800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+106000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+106800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+107000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+107800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+108000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+108800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+109000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+109800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10A000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10A800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10B000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10B800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10C000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10C800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10D000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10D800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10E000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10E800 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,128, /* U+10F000 */
128,128,128,128,128,128,128,128,128,128,128,128,128,128,128,314, /* U+10F800 */
};

const uint16_t PRIV(ucd_stage2)[] = { /* 80640 bytes, block = 128 */

/* block 0 */
  0,  0,  0,  0,  0,  0,  0,  0,  0,  1,  2,  1,  3,  4,  0,  0,
  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  5,  5,  5,  6,
  7,  8,  9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22,
 23, 23, 23, 23, 23, 23, 23, 23, 23, 23, 24, 25, 26, 27, 26,  8,
 13, 28, 28, 28, 28, 28, 28, 29, 29, 29, 29, 30, 29, 29, 29, 29,
 29, 29, 29, 31, 29, 29, 29, 29, 29, 29, 29, 15, 13, 16, 32, 33,
 34, 35, 35, 35, 35, 35, 35, 36, 36, 37, 37, 38, 36, 36, 36, 36,
 36, 36, 36, 39, 36, 36, 36, 36, 36, 36, 36, 15, 27, 16, 27,  0,

/* block 1 */
 40, 40, 40, 40, 40, 41, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40, 40,
 42, 43, 44, 44, 44, 44, 45, 43, 46, 47, 48, 49, 50, 51, 47, 46,
 52, 53, 54, 54, 46, 55, 43, 56, 46, 54, 48, 57, 58, 58, 58, 43,
 59, 59, 59, 59, 59, 60, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 50, 59, 59, 59, 59, 59, 59, 59, 61,
 62, 62, 62, 62, 62, 63, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 50, 62, 62, 62, 62, 62, 62, 62, 64,

/* block 2 */
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 67,
 68, 69, 65, 66, 65, 66, 65, 66, 70, 65, 66, 65, 66, 65, 66, 65,
 66, 65, 66, 65, 66, 65, 66, 65, 66, 71, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 72, 65, 66, 65, 66, 65, 66, 73,

/* block 3 */
 74, 75, 65, 66, 65, 66, 76, 65, 66, 77, 77, 65, 66, 70, 78, 79,
 80, 65, 66, 77, 81, 82, 83, 84, 65, 66, 85, 86, 83, 87, 88, 89,
 65, 66, 65, 66, 65, 66, 90, 65, 66, 90, 70, 70, 65, 66, 90, 65,
 66, 91, 91, 65, 66, 65, 66, 92, 65, 66, 70, 93, 65, 66, 70, 94,
 93, 93, 93, 93, 95, 96, 97, 98, 99,100,101,102,103, 65, 66, 65,
 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,104, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 69,105,106,107, 65, 66,108,109, 65, 66, 65, 66, 65, 66, 65, 66,

/* block 4 */
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
110, 70, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 70, 70, 70, 70, 70, 70,111, 65, 66,112,113,114,
114, 65, 66,115,116,117, 65, 66, 65, 67, 65, 66, 65, 66, 65, 66,
118,119,120,121,122, 70,123,123, 70,124, 70,125,126, 70, 70, 70,
123,127, 70,128,129,130,131, 70,132,133,131,134,135, 70, 70,133,
 70,136,137, 70, 70,138, 70, 70, 70, 70, 70, 70, 70,139, 70, 70,

/* block 5 */
140, 70,141,140, 70, 70, 70,142,140,143,144,144,145, 70, 70, 70,
 70, 70,146, 70, 93, 70, 70, 70, 70, 70, 70, 70, 70,147,148, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
149,149,150,149,149,149,149,149,149,151,151,152,153,152,152,152,
154,154, 46, 46, 46, 46,151,155,151,155,155,155,151,156,151,151,
157,157, 46, 46, 46, 46, 46,158, 46,159, 46, 46, 46, 46, 46, 46,
149,149,149,149,149, 46, 46, 46, 46, 46,160,160,151, 46,152, 46,
 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46, 46,

/* block 6 */
161,162,163,164,165,166,167,168,169,170,171,172,173,174,175,176,
174,177,176,178,176,176,176,176,176,176,176,176,176,176,176,176,
179,176,176,180,181,179,176,176,176,176,176,176,176,182,179,176,
183,184,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,185,176,176,186,176,176,176,176,176,176,176,176,176,187,
176,176,176,176,176,176,176,176,188,189,189,189,189,176,190,176,
176,176,176,191,191,191,191,191,191,191,191,191,191,191,191,191,
192,193,192,193,194,195,192,193,196,196,197,198,198,198,199,200,

/* block 7 */
196,196,196,196,201, 46,202,203,204,204,204,196,205,196,206,206,
207,208,209,208,208,210,208,208,211,212,213,208,214,208,208,208,
215,216,196,217,208,208,218,208,208,219,208,208,220,221,221,221,
222,223,224,223,223,225,223,223,226,227,228,223,229,223,223,223,
230,231,232,233,223,223,234,223,223,235,223,223,236,237,237,238,
239,240,241,242,242,243,244,245,192,193,192,193,192,193,192,193,
192,193,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
248,249,250,251,252,253,254,192,193,255,192,193,256,257,257,257,

/* block 8 */
258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,258,
259,259,260,259,261,259,259,259,259,259,259,259,259,259,262,259,
259,263,264,259,259,259,259,259,259,259,265,259,259,259,259,259,
266,266,267,266,268,266,266,266,266,266,266,266,266,266,269,266,
266,270,271,266,266,266,266,266,266,266,272,266,266,266,266,266,
273,273,273,273,273,273,274,273,274,273,273,273,273,273,273,273,
275,276,277,278,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,

/* block 9 */
275,276,279,280,281,282,282,281,283,283,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
284,275,276,275,276,275,276,275,276,275,276,275,276,275,276,285,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,

/* block 10 */
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
196,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,286,
286,286,286,286,286,286,286,196,196,287,288,288,288,288,288,289,
290,291,291,291,291,291,291,291,291,291,291,291,291,291,291,291,
291,291,291,291,291,291,291,291,291,291,291,291,291,291,291,291,

/* block 11 */
291,291,291,291,291,291,291,292,290,293,294,196,196,295,295,296,
297,298,298,298,298,298,298,298,298,298,298,298,298,298,298,298,
298,298,299,298,298,298,298,298,298,298,298,298,298,298,298,298,
300,300,300,300,300,300,300,300,300,300,300,300,300,300,301,300,
302,300,300,303,300,304,302,304,297,297,297,297,297,297,297,297,
305,305,305,305,305,305,305,305,305,305,305,305,305,305,305,305,
305,305,305,305,305,305,305,305,305,305,305,297,297,297,297,305,
305,305,305,302,306,297,297,297,297,297,297,297,297,297,297,297,

/* block 12 */
307,307,307,307,307,308,309,309,310,311,311,312,313,314,315,315,
316,316,316,316,316,316,316,316,316,316,316,317,318,319,319,320,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
322,321,321,321,321,321,321,321,321,321,321,323,323,323,323,323,
323,323,323,324,325,325,316,326,327,316,316,316,316,316,316,316,
328,328,328,328,328,328,328,328,328,328,311,329,329,314,321,321,
324,321,321,330,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 13 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,331,321,316,316,316,316,316,316,332,308,315,333,
333,316,316,332,316,334,334,332,332,315,333,333,333,316,321,321,
335,335,335,335,335,335,335,335,335,335,321,321,321,336,336,321,

/* block 14 */
337,337,337,338,338,338,338,338,338,338,338,339,338,339,340,341,
342,343,342,342,342,342,342,342,342,342,342,342,342,342,342,342,
342,342,342,342,342,342,342,342,342,342,342,342,342,342,342,342,
344,344,344,344,344,344,344,344,344,344,344,344,344,344,344,344,
345,345,345,345,345,345,345,345,345,345,345,340,340,342,342,342,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 15 */
346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,
346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,346,
346,346,346,346,346,346,347,347,347,347,347,347,347,347,347,347,
347,346,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
348,348,348,348,348,348,348,348,348,348,349,349,349,349,349,349,
349,349,349,349,349,349,349,349,349,349,349,349,349,349,349,349,
349,349,349,349,349,349,349,349,349,349,349,350,350,350,350,350,
350,350,350,350,351,351,352,353,354,355,356,297,297,357,358,358,

/* block 16 */
359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,359,
359,359,359,359,359,359,360,360,361,361,362,360,360,360,360,360,
360,360,360,360,362,360,360,360,362,360,360,360,360,363,297,297,
364,364,364,364,364,364,365,366,364,366,364,364,364,366,366,297,
367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,367,
367,367,367,367,367,367,367,367,367,368,368,368,297,297,369,297,
342,342,342,342,342,342,342,342,342,342,342,340,340,340,340,340,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 17 */
321,321,321,321,321,321,321,321,370,321,321,321,321,321,321,340,
307,307,340,340,340,340,340,316,333,333,333,333,333,333,333,333,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,334,327,327,333,327,327,327,
333,333,333,371,316,316,316,316,316,316,316,316,316,316,316,316,
372,372,308,326,326,326,326,326,326,326,333,333,333,333,333,333,
326,326,326,373,326,326,326,326,326,326,326,326,326,326,326,316,

/* block 18 */
374,374,374,375,376,376,376,376,376,376,376,376,376,376,376,376,
376,376,376,376,376,377,377,377,377,377,377,377,377,377,377,377,
377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,377,
377,377,377,377,377,377,377,377,377,377,374,375,378,376,375,375,
375,374,374,374,374,374,374,374,374,375,375,375,375,379,375,375,
376,380,381,176,176,374,374,374,377,377,377,377,377,377,377,377,
376,376,374,374,382,383,384,384,384,384,384,384,384,384,384,384,
385,386,376,376,376,376,376,376,377,377,377,377,377,377,377,377,

/* block 19 */
387,388,389,389,196,387,387,387,387,387,387,387,387,196,196,387,
387,196,196,387,387,390,390,390,390,390,390,390,390,390,390,390,
390,390,390,390,390,390,390,390,390,196,390,390,390,390,390,390,
390,196,390,196,196,196,390,390,390,390,196,196,391,387,392,389,
389,388,388,388,388,196,196,389,389,196,196,389,389,393,387,196,
196,196,196,196,196,196,196,392,196,196,196,196,390,390,196,390,
387,387,388,388,196,196,394,394,394,394,394,394,394,394,394,394,
390,390,395,395,396,396,396,396,396,396,397,395,387,398,399,196,

/* block 20 */
196,400,400,401,196,402,402,402,402,402,402,196,196,196,196,402,
402,196,196,402,402,402,402,402,402,402,402,402,402,402,402,402,
402,402,402,402,402,402,402,402,402,196,402,402,402,402,402,402,
402,196,402,402,196,402,402,196,402,402,196,196,403,196,401,401,
401,400,400,196,196,196,196,400,400,196,196,400,400,404,196,196,
196,400,196,196,196,196,196,196,196,402,402,402,402,196,402,196,
196,196,196,196,196,196,405,405,405,405,405,405,405,405,405,405,
400,406,402,402,402,400,407,196,196,196,196,196,196,196,196,196,

/* block 21 */
196,408,408,409,196,410,410,410,410,410,410,410,410,410,196,410,
410,410,196,410,410,411,411,411,411,411,411,411,411,411,411,411,
411,411,411,411,411,411,411,411,411,196,411,411,411,411,411,411,
411,196,411,411,196,411,411,411,411,411,196,196,412,410,409,409,
409,408,408,408,408,408,196,408,408,409,196,409,409,413,196,196,
410,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
410,410,408,408,196,196,414,414,414,414,414,414,414,414,414,414,
415,416,196,196,196,196,196,196,196,411,408,417,408,412,412,412,

/* block 22 */
196,418,419,419,196,420,420,420,420,420,420,420,420,196,196,420,
420,196,196,420,420,421,421,421,421,421,421,421,421,421,421,421,
421,421,421,421,421,421,421,421,421,196,421,421,421,421,421,421,
421,196,421,421,196,421,421,421,421,421,196,196,422,420,423,418,
419,418,418,418,418,196,196,419,419,196,196,419,419,424,196,196,
196,196,196,196,196,425,418,423,196,196,196,196,421,421,196,421,
420,420,418,418,196,196,426,426,426,426,426,426,426,426,426,426,
427,421,428,428,428,428,428,428,196,196,196,196,196,196,196,196,

/* block 23 */
196,196,429,430,196,430,430,430,430,430,430,196,196,196,430,430,
430,196,430,430,430,430,196,196,196,430,430,196,430,196,430,430,
196,196,196,430,430,196,196,196,430,430,430,196,196,196,430,430,
430,430,430,430,430,430,430,430,430,430,196,196,196,196,431,432,
429,432,432,196,196,196,432,432,432,196,432,432,432,433,196,196,
430,196,196,196,196,196,196,431,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,434,434,434,434,434,434,434,434,434,434,
435,435,435,436,437,437,437,437,437,438,437,196,196,196,196,196,

/* block 24 */
439,440,440,440,439,441,441,441,441,441,441,441,441,196,441,441,
441,196,441,441,441,442,442,442,442,442,442,442,442,442,442,442,
442,442,442,442,442,442,442,442,442,196,442,442,442,442,442,442,
442,442,442,442,442,442,442,442,442,442,196,196,443,441,439,439,
439,440,440,440,440,196,439,439,439,196,439,439,439,444,196,196,
196,196,196,196,196,439,439,196,442,442,442,196,196,441,196,196,
441,441,439,439,196,196,445,445,445,445,445,445,445,445,445,445,
196,196,196,196,196,196,196,446,447,447,447,447,447,447,447,448,

/* block 25 */
449,450,451,451,452,449,449,449,449,449,449,449,449,196,449,449,
449,196,449,449,449,449,449,449,449,449,449,449,449,449,449,449,
449,449,449,449,449,449,449,449,449,196,449,449,449,449,449,449,
449,449,449,449,196,449,449,449,449,449,196,196,453,449,451,454,
455,451,455,451,451,196,454,455,455,196,455,455,450,456,196,196,
196,196,196,196,196,455,455,196,196,196,196,196,196,449,449,196,
449,449,450,450,196,196,457,457,457,457,457,457,457,457,457,457,
196,449,449,451,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 26 */
458,458,459,459,460,460,460,460,460,460,460,460,460,196,460,460,
460,196,460,460,460,461,461,461,461,461,461,461,461,461,461,461,
461,461,461,461,461,461,461,461,461,461,461,461,461,461,461,461,
461,461,461,461,461,461,461,461,461,461,461,462,462,460,463,459,
459,458,458,458,458,196,459,459,459,196,459,459,459,462,464,465,
196,196,196,196,460,460,460,463,466,466,466,466,466,466,466,460,
460,460,458,458,196,196,467,467,467,467,467,467,467,467,467,467,
466,466,466,466,466,466,466,466,466,465,460,460,460,460,460,460,

/* block 27 */
196,468,469,469,196,470,470,470,470,470,470,470,470,470,470,470,
470,470,470,470,470,470,470,196,196,196,470,470,470,470,470,470,
470,470,470,470,470,470,470,470,470,470,470,470,470,470,470,470,
470,470,196,470,470,470,470,470,470,470,470,470,196,470,196,196,
470,470,470,470,470,470,470,196,196,196,471,196,196,196,196,472,
469,469,468,468,468,196,468,196,469,469,469,469,469,469,469,472,
196,196,196,196,196,196,473,473,473,473,473,473,473,473,473,473,
196,196,469,469,474,196,196,196,196,196,196,196,196,196,196,196,

/* block 28 */
196,475,475,475,475,475,475,475,475,475,475,475,475,475,475,475,
475,475,475,475,475,475,475,475,475,475,475,475,475,475,475,475,
475,475,475,475,475,475,475,475,475,475,475,475,475,475,475,475,
475,476,475,477,476,476,476,476,476,476,478,196,196,196,196,479,
480,480,480,480,480,475,481,482,482,482,482,482,482,476,482,483,
484,484,484,484,484,484,484,484,484,484,485,485,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 29 */
196,486,486,196,486,196,486,486,486,486,486,196,486,486,486,486,
486,486,486,486,486,486,486,486,486,486,486,486,486,486,486,486,
486,486,486,486,196,486,196,486,486,486,486,486,486,486,486,486,
486,487,486,488,487,487,487,487,487,487,489,487,487,486,196,196,
490,490,490,490,490,196,491,196,492,492,492,492,492,487,493,196,
494,494,494,494,494,494,494,494,494,494,196,196,486,486,486,486,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 30 */
495,496,496,496,497,497,497,497,498,497,497,497,497,498,498,498,
498,498,498,496,497,496,496,496,499,499,496,496,496,496,496,496,
500,500,500,500,500,500,500,500,500,500,501,501,501,501,501,501,
501,501,501,501,496,499,496,499,496,499,502,503,502,503,504,504,
495,495,495,495,495,495,495,495,196,495,495,495,495,495,495,495,
495,495,495,495,495,495,495,495,495,495,495,495,495,495,495,495,
495,495,495,495,495,495,495,495,495,495,495,495,495,196,196,196,
196,505,505,505,505,505,505,506,505,506,505,505,505,505,505,507,

/* block 31 */
505,505,508,508,509,497,499,499,495,495,495,495,495,505,505,505,
505,505,505,505,505,505,505,505,196,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,505,
505,505,505,505,505,505,505,505,505,505,505,505,505,196,496,496,
496,496,496,496,496,496,499,496,496,496,496,496,496,196,496,496,
497,497,497,497,497,510,510,510,510,497,497,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 32 */
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
511,511,511,511,511,511,511,511,511,511,511,512,512,513,513,513,
513,514,513,513,513,513,513,515,512,516,516,514,514,513,513,511,
517,517,517,517,517,517,517,517,517,517,518,518,519,519,519,519,
511,511,511,511,511,511,514,514,513,513,511,511,511,511,513,513,
513,511,512,520,520,511,511,512,512,520,520,520,520,520,511,511,
511,513,513,513,513,511,511,511,511,511,511,511,511,511,511,511,

/* block 33 */
511,511,513,512,514,513,513,520,520,520,520,520,520,521,511,520,
522,522,522,522,522,522,522,522,522,522,520,520,512,513,523,523,
524,524,524,524,524,524,524,524,524,524,524,524,524,524,524,524,
524,524,524,524,524,524,524,524,524,524,524,524,524,524,524,524,
524,524,524,524,524,524,196,524,196,196,196,196,196,524,196,196,
525,525,525,525,525,525,525,525,525,525,525,525,525,525,525,525,
525,525,525,525,525,525,525,525,525,525,525,525,525,525,525,525,
525,525,525,525,525,525,525,525,525,525,525,526,527,525,525,525,

/* block 34 */
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,529,
530,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,

/* block 35 */
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,
531,531,531,531,531,531,531,531,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,

/* block 36 */
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,196,533,533,533,533,196,196,
533,533,533,533,533,533,533,196,533,196,533,533,533,533,196,196,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,

/* block 37 */
533,533,533,533,533,533,533,533,533,196,533,533,533,533,196,196,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,196,533,533,533,533,196,196,533,533,533,533,533,533,533,196,
533,196,533,533,533,533,196,196,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,196,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,

/* block 38 */
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,196,533,533,533,533,196,196,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,533,533,533,533,196,196,534,534,534,
535,536,537,536,536,536,536,537,537,538,538,538,538,538,538,538,
538,538,539,539,539,539,539,539,539,539,539,539,539,196,196,196,

/* block 39 */
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
540,540,540,540,540,540,540,540,540,540,196,196,196,196,196,196,
541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,
541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,
541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,
541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,
541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,541,
542,542,542,542,542,542,196,196,543,543,543,543,543,543,196,196,

/* block 40 */
544,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,

/* block 41 */
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,

/* block 42 */
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,546,547,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,

/* block 43 */
548,549,549,549,549,549,549,549,549,549,549,549,549,549,549,549,
549,549,549,549,549,549,549,549,549,549,549,550,551,196,196,196,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,552,
552,552,552,552,552,552,552,552,552,552,552,553,553,553,554,554,
554,552,552,552,552,552,552,552,552,196,196,196,196,196,196,196,

/* block 44 */
555,555,555,555,555,555,555,555,555,555,555,555,555,555,555,555,
555,555,556,556,557,558,196,196,196,196,196,196,196,196,196,555,
559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,559,
559,559,560,560,561,562,562,196,196,196,196,196,196,196,196,196,
563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,563,
563,563,564,564,196,196,196,196,196,196,196,196,196,196,196,196,
565,565,565,565,565,565,565,565,565,565,565,565,565,196,565,565,
565,196,566,566,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 45 */
567,567,567,567,567,567,567,567,567,567,567,567,567,567,567,567,
567,567,567,567,567,567,567,567,567,567,567,567,567,567,567,567,
567,567,567,568,568,567,567,567,567,567,567,567,567,567,567,567,
567,567,567,567,569,569,570,571,571,571,571,571,571,571,570,570,
570,570,570,570,570,570,571,570,570,572,572,572,572,572,572,572,
572,572,573,572,574,574,575,576,577,577,575,578,567,572,196,196,
579,579,579,579,579,579,579,579,579,579,196,196,196,196,196,196,
580,580,580,580,580,580,580,580,580,580,196,196,196,196,196,196,

/* block 46 */
581,581,582,583,584,582,585,581,584,586,587,588,588,588,589,588,
590,590,590,590,590,590,590,590,590,590,196,196,196,196,196,196,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,592,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,196,196,196,196,196,196,196,

/* block 47 */
591,591,591,591,591,593,593,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,591,
591,591,591,591,591,591,591,591,591,594,591,196,196,196,196,196,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
545,545,545,545,545,545,196,196,196,196,196,196,196,196,196,196,

/* block 48 */
595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,
595,595,595,595,595,595,595,595,595,595,595,595,595,595,595,196,
596,596,596,597,597,597,597,596,596,597,597,597,196,196,196,196,
597,597,596,597,597,597,597,597,597,598,598,598,196,196,196,196,
599,196,196,196,600,600,601,601,601,601,601,601,601,601,601,601,
602,602,602,602,602,602,602,602,602,602,602,602,602,602,602,602,
602,602,602,602,602,602,602,602,602,602,602,602,602,602,196,196,
602,602,602,602,602,196,196,196,196,196,196,196,196,196,196,196,

/* block 49 */
603,603,603,603,603,603,603,603,603,603,603,603,603,603,603,603,
603,603,603,603,603,603,603,603,603,603,603,603,603,603,603,603,
603,603,603,603,603,603,603,603,603,603,603,603,196,196,196,196,
603,603,603,603,603,604,604,604,603,603,604,603,603,603,603,603,
603,603,603,603,603,603,603,603,603,603,196,196,196,196,196,196,
605,605,605,605,605,605,605,605,605,605,606,196,196,196,607,607,
608,608,608,608,608,608,608,608,608,608,608,608,608,608,608,608,
608,608,608,608,608,608,608,608,608,608,608,608,608,608,608,608,

/* block 50 */
609,609,609,609,609,609,609,609,609,609,609,609,609,609,609,609,
609,609,609,609,609,609,609,610,610,611,611,610,196,196,612,612,
613,613,613,613,613,613,613,613,613,613,613,613,613,613,613,613,
613,613,613,613,613,613,613,613,613,613,613,613,613,613,613,613,
613,613,613,613,613,613,613,613,613,613,613,613,613,613,613,613,
613,613,613,613,613,614,615,614,615,615,615,615,615,615,615,196,
616,617,615,617,617,615,615,615,615,615,615,615,615,614,614,614,
614,614,614,615,615,618,618,618,618,618,618,618,618,196,196,618,

/* block 51 */
619,619,619,619,619,619,619,619,619,619,196,196,196,196,196,196,
619,619,619,619,619,619,619,619,619,619,196,196,196,196,196,196,
620,620,620,620,620,620,620,621,622,622,622,622,620,620,196,196,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,623,624,
624,176,176,176,176,176,176,176,176,176,176,176,624,624,624,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 52 */
625,625,625,625,626,627,627,627,627,627,627,627,627,627,627,627,
627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,
627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,627,
627,627,627,627,628,629,625,625,625,625,625,629,625,629,626,626,
626,626,625,629,630,627,627,627,627,627,627,627,627,196,631,631,
632,632,632,632,632,632,632,632,632,632,631,631,633,634,631,631,
633,635,635,635,635,635,635,635,635,635,635,628,628,628,628,628,
628,628,628,628,635,635,635,635,635,635,635,635,635,631,631,631,

/* block 53 */
636,636,637,638,638,638,638,638,638,638,638,638,638,638,638,638,
638,638,638,638,638,638,638,638,638,638,638,638,638,638,638,638,
638,637,636,636,636,636,637,637,636,636,639,640,636,636,638,638,
641,641,641,641,641,641,641,641,641,641,638,638,638,638,638,638,
642,642,642,642,642,642,642,642,642,642,642,642,642,642,642,642,
642,642,642,642,642,642,642,642,642,642,642,642,642,642,642,642,
642,642,642,642,642,642,643,644,645,645,644,644,644,645,644,645,
645,645,646,646,196,196,196,196,196,196,196,196,647,647,647,647,

/* block 54 */
648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,
648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,648,
648,648,648,648,649,649,649,649,649,649,649,649,650,650,650,650,
650,650,650,650,649,649,651,652,196,196,196,653,653,654,654,654,
655,655,655,655,655,655,655,655,655,655,196,196,196,648,648,648,
656,656,656,656,656,656,656,656,656,656,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,657,
657,657,657,657,657,657,657,657,658,658,658,659,658,658,660,660,

/* block 55 */
661,662,663,664,665,666,667,668,669,275,276,196,196,196,196,196,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,670,
670,670,670,670,670,670,670,670,670,670,670,196,196,670,670,670,
671,671,671,671,671,671,671,671,196,196,196,196,196,196,196,196,
672,673,672,674,673,675,675,676,675,676,677,673,676,676,673,673,
676,678,673,673,673,673,673,673,673,679,680,681,681,675,681,681,
681,681,682,683,684,680,680,685,686,686,687,196,196,196,196,196,

/* block 56 */
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70,256,256,256,256,256,688,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,689,689,689,
689,689,150,149,149,149,689,689,689,689,689, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70,690,691, 70, 70, 70,692, 70, 70,

/* block 57 */
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,693, 70,
 70, 70, 70, 70, 70, 70,694, 70, 70, 70, 70,695,695,695,695,695,
695,695,695,695,696,695,695,695,696,695,695,695,695,695,695,695,
695,695,695,695,695,695,695,695,695,695,695,695,695,695,695,697,
698,698,189,189,176,176,176,176,176,176,176,176,176,176,176,176,
189,189,189,624,624,624,624,624,624,624,624,624,624,624,624,624,
624,624,624,624,624,624,624,624,624,624,624,624,624,624,624,624,
624,624,624,624,624,176,176,176,699,176,700,176,176,176,176,176,

/* block 58 */
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 67, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
701,702, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,

/* block 59 */
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 69, 69, 69, 69,703,704, 70, 70,705, 70,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 67, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,

/* block 60 */
706,706,706,706,706,706,706,706,707,707,707,707,707,707,707,707,
706,706,706,706,706,706,196,196,707,707,707,707,707,707,196,196,
706,706,706,706,706,706,706,706,707,707,707,707,707,707,707,707,
706,706,706,706,706,706,706,706,707,707,707,707,707,707,707,707,
706,706,706,706,706,706,196,196,707,707,707,707,707,707,196,196,
708,706,708,706,708,706,708,706,196,707,196,707,196,707,196,707,
706,706,706,706,706,706,706,706,707,707,707,707,707,707,707,707,
709,709,710,710,710,710,711,711,712,712,713,713,714,714,196,196,

/* block 61 */
715,715,715,715,715,715,715,715,716,716,716,716,716,716,716,716,
715,715,715,715,715,715,715,715,716,716,716,716,716,716,716,716,
715,715,715,715,715,715,715,715,716,716,716,716,716,716,716,716,
706,706,717,718,717,196,708,717,707,707,719,719,720,201,721,201,
201,201,717,718,717,196,708,717,722,722,722,722,720,201,201,201,
706,706,708,723,196,196,708,708,707,707,724,724,196,201,201,201,
706,706,708,725,708,250,708,708,707,707,726,726,255,201,201,201,
196,196,717,718,717,196,708,717,727,727,728,728,720,201,201,196,

/* block 62 */
729,729,729,729,729,729,729,729,729,729,729, 51,730,731,732,733,
734,734,734,734,734,734,735, 43,736,737,738,739,739,740,738,739,
 43, 43, 43, 43,741, 43, 43,742,743,744,745,746,747,748,749,750,
751,751,752,752,752, 43, 43, 43, 43, 49, 57, 43,753,754, 43,755,
756, 43, 43, 43,757,758,759,754,754,753, 43, 43, 43, 43, 43,760,
 43, 43, 50,761,755, 43, 43, 43, 43, 43,762, 43, 43,763, 43,729,
 51,764,764,764,764,765,766,767,768,769,770,770,770,770,770,770,
 54,696,196,196, 54, 54, 54, 54, 54, 54,771,772,773,774,775,695,

/* block 63 */
 54, 54, 54, 54, 54, 54, 54, 54, 54, 54,771,772,773,774,775,196,
695,695,695,695,695,695,695,695,695,695,695,695,695,196,196,196,
479,479,479,479,479,479,479,479,479,479,479,479,479,479,479,479,
479,479,479,479,479,479,479,479,479,479,479,479,479,479,479,479,
479,776,776,776,776,776,776,776,776,776,776,776,776,776,776,776,
777,777,777,777,777,777,777,777,777,777,777,777,777,778,778,778,
778,777,778,779,778,777,777,189,189,189,189,777,777,777,777,777,
780,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 64 */
781,781,782,781,781,781,781,782,781,781,783,782,782,782,783,783,
782,782,782,783,781,782,781,781,784,782,782,782,782,782,781,781,
781,781,785,781,782,781,786,781,782,787,788,789,782,782,790,783,
782,782,791,782,783,792,792,792,792,793,781,781,783,783,782,782,
794,794,794,794,794,782,783,783,795,795,781,794,781,781,796,510,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
797,797,797,797,797,797,797,797,797,797,797,797,797,797,797,797,
798,798,798,798,798,798,798,798,798,798,798,798,798,798,798,798,

/* block 65 */
799,799,799, 65, 66,799,799,799,799, 58,781,781,196,196,196,196,
 50, 50, 50, 50,800,801,801,801,801,801, 50, 50,802,802,802,802,
 50,802,802, 50,802,802, 50,802, 45,801,801,802,802,802, 50, 45,
802,802, 45, 45, 45, 45,802,802, 45, 45, 45, 45,802,802,802,802,
802,802,802,802,802,802,802,802,802,802,802,802,802,802, 50, 50,
802,802, 50,802, 50,802,802,802,802,802,802,802, 45,802, 45, 45,
 45, 45, 45, 45,802,802, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,

/* block 66 */
 50, 50,803, 50, 50, 50, 50,803,804,804,804,804,804,804, 50, 50,
 50, 50,805, 53, 50,804, 50, 50, 50, 50, 50, 50, 50, 50,803,804,
804,804,804, 50,804, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,804,804, 50, 50,
 50, 50, 50,804, 50,804, 50, 50, 50, 50, 50, 50,804, 50, 50, 50,
 50, 50,804,804,804,804, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50,804,804,804,804,804,804,804,804, 50, 50,804,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,

/* block 67 */
804,804,804,804,804,804,804,804,804,804,804,804, 50, 50, 50,804,
804,804,804, 50, 50, 50, 50, 50,804, 50, 50, 50, 50, 50, 50, 50,
 50, 50,804,804, 50, 50,804, 50,804,804, 50,804, 50, 50, 50, 50,
804,804,804,804,804,804,804,804,804, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50,804,804,804,804,804, 50, 50,
804,804, 50, 50, 50, 50,804,804,804,804,804,804,804,804,804,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804, 50, 50,
804,804,804,804,804, 50,804,804, 50, 50,804,804,804,804,804, 50,

/* block 68 */
 45, 45, 45, 45, 45, 45, 45, 45,806,807,806,807, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,808,808, 45, 45, 45, 45,
 50, 50, 45, 45, 45, 45, 45, 45, 47,809,810, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45,811,811,811,811,811,811,811,811,811,811,
811,811,811,811,811,811,811,811,811,811,811,811,811,811,811,811,
811,811,811,811,811,811,811,811,811,811,811,811,811,811,811,811,
811,811,811,811,811,811,811,811,811,811,811,811,811,811,811,811,
811,811,811,811,811,811,811,811,811,811,811, 45, 50, 45, 45, 45,

/* block 69 */
 45, 45, 45, 45, 45, 45, 45, 45,812, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45,811, 45, 45, 45, 45, 45, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50,802,802, 45,802, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 47,
802, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 50, 50, 50, 50,
 50, 50,802, 45, 45, 45, 45, 45, 45,808,808,808,808, 47, 47, 47,
808, 47, 47,808, 45, 45, 45, 45, 47, 47, 47, 45, 45, 45, 45, 45,

/* block 70 */
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,813,813,813,813,813,813,
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,813,813,813,813,813,
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,

/* block 71 */
 58, 58, 58, 58, 58, 58, 58, 58,814,814,814,814,814,814,814,814,
814,814,814,814,814,814,814,814,814,814,814,814,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,815,815,815,815,815,815,815,815,815,815,
815,815,816,815,815,815,815,815,815,815,815,815,815,815,815,815,
817,817,817,817,817,817,817,817,817,817,817,817,817,817,817,817,
817,817,817,817,817,817,817,817,817,817, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,

/* block 72 */
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,

/* block 73 */
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
802,802, 45, 45, 45, 45, 45, 45, 45, 45, 47, 47, 45, 45,802,802,
802,802,802,802,802,802,801, 50, 45, 45, 45, 45,802,802,802,802,
801, 50, 45, 45, 45, 45,802,802, 45, 45,802,802, 45, 45, 45,802,
802,802,802,802, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45,802, 45,802, 45, 45,802,802,802,802,802,802, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 50, 50, 50,800,800,818,818, 50,

/* block 74 */
 47, 47, 47, 47, 47,819,802,812,812,812,812,812,812,812, 47,812,
812, 47,812, 45,808,808,812,812, 47,812,812,812,812,820,812,812,
 47,812, 47, 47,812,812, 47,812,812,812, 47,812,812,812, 47, 47,
812,812,812,812,812,812,812,812, 47, 47, 47,812,812,812,812,812,
801,812,801,812,812,812,812,812,808,808,808,808,808,808,808,808,
808,808,808,808,812,812,812,812,812,812,812,812,812,812,812, 47,
801,819,819,801,812, 47, 47,812, 47,812,812,812,812,819,819,821,
812,812,812,812,812,812,812,812,812,812,812, 47,812,812, 47,808,

/* block 75 */
812,812,812,812,812,812, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
812,812, 47,808, 47, 47, 47, 47,812, 47,812, 47, 47,812,812,812,
 47,808,812,812,812,812,812, 47,812,812,808,808,822,812,812,812,
 47, 47,812,812,812,812,812,812,812,812,812,812,812,808,808,812,
812,812,812,812,808,808,812,812, 47,812,812,812,812,812,808, 47,
812, 47,812, 47,808,812,812,812,812,812,812,812,812,812,812,812,
812,812,812,812,812,812,812,812,812, 47,808,812,812,812,812,812,
 47, 47,808,808, 47,808,812, 47, 47,820,808,812,812,808,812,812,

/* block 76 */
812,812, 47,812,812,808, 45, 45, 47, 47,823,823,820,820,812, 47,
812,812, 47, 45, 47, 45, 47, 45, 45, 45, 45, 45, 45, 47, 45, 45,
 45, 47, 45, 45, 45, 45, 45, 45,808, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 47, 47, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 47, 45, 45, 47, 45, 45, 45, 45,808, 45,808, 45,
 45, 45, 45,808,808,808, 45,808, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 47, 47,812,812,812,758,759,758,759,758,759,758,759,
758,759,758,759,758,759, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,

/* block 77 */
 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
 58, 58, 58, 58, 45,808,808,808, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 47, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
808, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,808,
 50, 50, 50,804,804,806,807, 50,804,804, 50,804, 50,804, 50, 50,
 50, 50, 50, 50, 50,804,804, 50, 50, 50, 50, 50,804,804,804, 50,
 50, 50,804,804,804,804,806,807,806,807,806,807,806,807,806,807,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,

/* block 78 */
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,
824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,824,

/* block 79 */
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50,800,800, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,

/* block 80 */
 50, 50, 50,806,807,806,807,806,807,806,807,806,807,806,807,806,
807,806,807,806,807,806,807,806,807, 50, 50,804, 50, 50, 50, 50,
804, 50, 50,804,804,804, 50, 50,804,804,804,804,804,804,804,804,
 50, 50, 50, 50, 50, 50, 50, 50,804, 50, 50, 50, 50, 50, 50, 50,
804,804, 50, 50,804,804, 50, 50, 50, 50, 50, 50, 50, 50, 50,804,
804,804,804, 50,804,804, 50, 50,806,807,806,807, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50,804,804, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50,804, 50, 50,804,804, 50, 50,806,807, 50, 50,

/* block 81 */
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,804,804,804,804, 50,
 50, 50, 50, 50,804,804, 50, 50, 50, 50, 50, 50,804,804, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50,804,804, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 50, 50, 50, 50,804,804,804,804,804,804,804,

/* block 82 */
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
804,804,804, 50, 50, 50,804,804,804,804,804,804,804,804, 50,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,804,
804,804,804,804,804,804,804, 50, 50, 50, 50, 50, 50, 50,804, 50,
 50, 50, 50,804,804,804, 50, 50, 50, 50, 50, 50,804,804,804, 50,
 50, 50, 50, 50, 50, 50, 50,804,804,804,804, 50, 50, 50, 50, 50,

/* block 83 */
 45, 45, 45, 45, 45, 47, 47, 47, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,808,808, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
 50, 50, 50, 50, 50, 45, 45, 50, 50, 50, 50, 50, 50, 45, 45, 45,
808, 45, 45, 45, 45,808, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45,813,813, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,

/* block 84 */
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45,813, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,
 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45, 45,825, 45,

/* block 85 */
826,826,826,826,826,826,826,826,826,826,826,826,826,826,826,826,
826,826,826,826,826,826,826,826,826,826,826,826,826,826,826,826,
826,826,826,826,826,826,826,826,826,826,826,826,826,826,826,826,
827,827,827,827,827,827,827,827,827,827,827,827,827,827,827,827,
827,827,827,827,827,827,827,827,827,827,827,827,827,827,827,827,
827,827,827,827,827,827,827,827,827,827,827,827,827,827,827,827,
 65, 66,828,829,830,831,832, 65, 66, 65, 66, 65, 66,833,834,835,
836, 70, 65, 66, 70, 65, 66, 70, 70, 70, 70, 70,696,695,837,837,

/* block 86 */
246,247,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
246,247,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
246,247,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
246,247,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
246,247,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
246,247,246,247,246,247,246,247,246,247,246,247,246,247,246,247,
246,247,246,247,838,839,839,839,839,839,839,246,247,246,247,840,
840,840,246,247,196,196,196,196,196,841,841,841,842,843,842,842,

/* block 87 */
844,844,844,844,844,844,844,844,844,844,844,844,844,844,844,844,
844,844,844,844,844,844,844,844,844,844,844,844,844,844,844,844,
844,844,844,844,844,844,196,844,196,196,196,196,196,844,196,196,
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,
845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,845,
845,845,845,845,845,845,845,845,196,196,196,196,196,196,196,846,
847,196,196,196,196,196,196,196,196,196,196,196,196,196,196,848,

/* block 88 */
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,
533,533,533,533,533,533,533,196,196,196,196,196,196,196,196,196,
533,533,533,533,533,533,533,196,533,533,533,533,533,533,533,196,
533,533,533,533,533,533,533,196,533,533,533,533,533,533,533,196,
533,533,533,533,533,533,533,196,533,533,533,533,533,533,533,196,
533,533,533,533,533,533,533,196,533,533,533,533,533,533,533,196,
849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,
849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,849,

/* block 89 */
 43, 43,850,851,850,851, 43, 43, 43,850,851, 43,850,851, 43, 43,
 43, 43, 43, 43, 43, 43, 43,852, 43, 43,734, 43,850,851, 43, 43,
850,851,758,759,758,759,758,759,758,759, 43, 43, 43, 43,754,853,
854,855, 43, 43, 43, 43, 43, 43, 43, 43,734,734,856, 43, 43, 43,
734,857,738,858, 43, 43, 43, 43, 43, 43, 43, 43,859, 43,859,859,
 45, 45, 43,754,754,758,759,758,759,758,759,758,759,734,813,813,
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,
813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,813,

/* block 90 */
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,196,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 91 */
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,

/* block 92 */
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,860,
860,860,860,860,860,860,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
861,861,862,862,861,861,861,861,861,861,861,861,861,861,863,863,

/* block 93 */
729,864,865,866,781,867,868,869,870,871,872,873,874,875,874,875,
876,877, 45,878,876,877,876,877,876,877,876,877,879,880,881,881,
 45,869,869,869,869,869,869,869,869,869,882,882,882,882,883,883,
884,885,885,885,885,885,781,886,869,869,869,887,888,889,890,890,
196,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,

/* block 94 */
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,196,196,892,892,893,893,894,894,891,
895,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,897,898,899,899,896,

/* block 95 */
196,196,196,196,196,900,900,900,900,900,900,900,900,900,900,900,
900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,
900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,
196,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,902,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,

/* block 96 */
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,196,
903,903,904,904,904,904,903,903,903,903,903,903,903,903,903,903,
900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,
900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,900,
890,890,890,890,890,890,890,890,890,890,890,890,890,890,890,890,
890,890,890,890,890,890,890,890,890,890,890,890,890,890,890,890,
890,890,890,890,890,890,196,196,196,196,196,196,196,196,196,861,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,

/* block 97 */
905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
905,905,905,905,905,905,905,905,905,905,905,905,905,906,906,196,
904,904,904,904,904,904,904,904,904,904,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,907,907,907,907,907,907,907,907,
781, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,905,
905,905,905,905,905,905,905,905,905,905,905,905,906,906,906,510,

/* block 98 */
904,904,904,904,904,904,904,904,904,904,903,903,903,903,903,903,
903,903,903,903,903,903,903,908,903,908,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58, 58,
903,903,903,903,903,903,903,903,903,903,903,903,781,781,781,781,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,903,

/* block 99 */
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,909,
909,909,909,909,909,909,909,909,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,510,510,510,510,510,510,781,781,781,781,903,903,903,903,903,

/* block 100 */
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,781,781,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,
903,903,903,903,903,903,903,903,903,903,903,903,903,903,903,781,

/* block 101 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,

/* block 102 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,

/* block 103 */
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,912,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,

/* block 104 */
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,
911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,911,

/* block 105 */
911,911,911,911,911,911,911,911,911,911,911,911,911,196,196,196,
913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,
913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,
913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,913,
913,913,913,913,913,913,913,196,196,196,196,196,196,196,196,196,
914,914,914,914,914,914,914,914,914,914,914,914,914,914,914,914,
914,914,914,914,914,914,914,914,914,914,914,914,914,914,914,914,
914,914,914,914,914,914,914,914,915,915,915,915,915,915,916,917,

/* block 106 */
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,

/* block 107 */
918,918,918,918,918,918,918,918,918,918,918,918,919,920,921,921,
918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,918,
922,922,922,922,922,922,922,922,922,922,918,918,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
275,276,275,276,275,276,275,276,275,276,923,924,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,275,276,925,281,
283,283,283,926,849,849,849,849,849,849,849,849,927,927,926,928,

/* block 108 */
275,276,275,276,275,276,275,276,275,276,275,276,275,276,275,276,
275,276,275,276,275,276,275,276,275,276,275,276,929,929,849,849,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,931,931,931,931,931,931,931,931,931,931,
932,932,933,934,935,935,935,934,196,196,196,196,196,196,196,196,

/* block 109 */
936,936,936,936,936,936,936,936, 46, 46, 46, 46, 46, 46, 46, 46,
 46, 46, 46, 46, 46, 46, 46,151,151,151,151,151,151,151,151,151,
 46, 46, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 70, 70, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
695, 70, 70, 70, 70, 70, 70, 70, 70, 65, 66, 65, 66,937, 65, 66,

/* block 110 */
 65, 66, 65, 66, 65, 66, 65, 66,151,938,938, 65, 66,939, 70, 93,
 65, 66, 65, 66,940, 70, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,941,942,943,944,941, 70,
945,946,947,948, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66, 65, 66,
 65, 66, 65, 66,949,950,951, 65, 66, 65, 66,952, 65, 66,196,196,
 65, 66,196, 70,196, 70, 65, 66, 65, 66, 65, 66,953,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,695,695,695, 65, 66, 93,149,149, 70, 93, 93, 93, 93, 93,

/* block 111 */
954,954,955,954,954,954,956,954,954,954,954,955,954,954,954,954,
954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,954,
954,954,954,957,957,955,955,957,958,958,958,958,956,196,196,196,
959,959,959,960,960,960,961,961,962,963,196,196,196,196,196,196,
964,964,964,964,964,964,964,964,964,964,964,964,964,964,964,964,
964,964,964,964,964,964,964,964,964,964,964,964,964,964,964,964,
964,964,964,964,964,964,964,964,964,964,964,964,964,964,964,964,
964,964,964,964,965,965,966,966,196,196,196,196,196,196,196,196,

/* block 112 */
967,967,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,968,
968,968,968,968,967,967,967,967,967,967,967,967,967,967,967,967,
967,967,967,967,969,970,196,196,196,196,196,196,196,196,971,971,
972,972,972,972,972,972,972,972,972,972,196,196,196,196,196,196,
378,378,378,378,378,378,378,378,378,378,378,378,378,378,378,378,
378,973,376,974,376,376,376,376,385,385,385,376,385,376,376,374,

/* block 113 */
975,975,975,975,975,975,975,975,975,975,976,976,976,976,976,976,
976,976,976,976,976,976,976,976,976,976,976,976,976,976,976,976,
976,976,976,976,976,976,977,977,977,977,977,978,978,978,979,980,
981,981,981,981,981,981,981,981,981,981,981,981,981,981,981,981,
981,981,981,981,981,981,981,982,982,982,982,982,982,982,982,982,
982,982,983,984,196,196,196,196,196,196,196,196,196,196,196,985,
528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,528,
528,528,528,528,528,528,528,528,528,528,528,528,528,196,196,196,

/* block 114 */
986,986,986,987,988,988,988,988,988,988,988,988,988,988,988,988,
988,988,988,988,988,988,988,988,988,988,988,988,988,988,988,988,
988,988,988,988,988,988,988,988,988,988,988,988,988,988,988,988,
988,988,988,989,987,987,986,986,986,986,987,987,986,986,987,987,
990,991,991,991,991,991,991,992,993,993,991,991,991,991,196,994,
995,995,995,995,995,995,995,995,995,995,196,196,196,196,991,991,
511,511,511,511,511,521,996,511,511,511,511,511,511,511,511,511,
522,522,522,522,522,522,522,522,522,522,511,511,511,511,511,196,

/* block 115 */
997,997,997,997,997,997,997,997,997,997,997,997,997,997,997,997,
997,997,997,997,997,997,997,997,997,997,997,997,997,997,997,997,
997,997,997,997,997,997,997,997,997,998,998,998,998,998,998,999,
999,998,998,999,999,998,998,196,196,196,196,196,196,196,196,196,
997,997,997,998,997,997,997,997,997,997,997,997,998,999,196,196,
1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,196,196,1001,1002,1002,1002,
511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,511,
996,511,511,511,511,511,511,523,523,523,511,520,521,520,511,511,

/* block 116 */
1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,
1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,
1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,1003,
1004,1003,1004,1004,1004,1005,1005,1004,1004,1005,1003,1005,1005,1003,1004,1006,
1007,1006,1007,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,1003,1003,1008,1009,1010,
1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1012,1013,1013,1012,1012,
1014,1014,1011,1015,1015,1012,1016,196,196,196,196,196,196,196,196,196,

/* block 117 */
196,533,533,533,533,533,533,196,196,533,533,533,533,533,533,196,
196,533,533,533,533,533,533,196,196,196,196,196,196,196,196,196,
533,533,533,533,533,533,533,196,533,533,533,533,533,533,533,196,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,
 70, 70, 70,1017, 70, 70, 70, 70, 70, 70, 70,938,149,149,149,149,
 70, 70, 70, 70, 70,256, 70, 70, 70,149, 46, 46,196,196,196,196,
1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,

/* block 118 */
1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,
1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,
1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,
1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,1018,
1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,
1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,1011,
1011,1011,1011,1012,1012,1013,1012,1012,1013,1012,1012,1014,1019,1016,196,196,
1020,1020,1020,1020,1020,1020,1020,1020,1020,1020,196,196,196,196,196,196,

/* block 119 */
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,

/* block 120 */
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,

/* block 121 */
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,

/* block 122 */
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,

/* block 123 */
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,

/* block 124 */
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,

/* block 125 */
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,

/* block 126 */
1022,1022,1022,1022,1022,1022,1022,1022,1021,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,1022,
1022,1022,1022,1022,196,196,196,196,196,196,196,196,196,196,196,196,
531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,531,
531,531,531,531,531,531,531,196,196,196,196,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,532,
532,532,532,532,532,532,532,532,532,532,532,532,196,196,196,196,

/* block 127 */
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,
1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,1023,

/* block 128 */
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,

/* block 129 */
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,

/* block 130 */
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,910,910,
1025,910,1025,910,910,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,910,
1025,910,1025,910,910,1025,1025,910,910,910,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,196,196,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,

/* block 131 */
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 132 */
703,703,703,703,703,1026,1027,196,196,196,196,196,196,196,196,196,
196,196,196,292,292,292,292,292,196,196,196,196,196,305,300,305,
305,305,305,305,305,305,305,305,305,1028,305,305,305,305,305,305,
305,305,305,305,305,305,305,297,305,305,305,305,305,297,305,297,
305,305,297,305,305,297,305,305,305,305,305,305,305,305,305,305,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 133 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,370,370,370,370,370,370,370,370,370,370,370,370,370,370,
370,370,370,340,340,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 134 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,1029,1029,
1029,1029,1029,1029,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 135 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 136 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,1030,1031,
315,315,315,315,315,315,315,315,315,315,315,315,315,315,315,315,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,

/* block 137 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
340,340,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,340,340,340,340,340,340,340,315,
1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,
1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,1032,
321,321,1033,321,321,321,321,321,321,321,1029,1029,312,1034,315,315,

/* block 138 */
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1036,
1037,1037,1038,1039,1037,1038,1038,1040,1041,1037,196,196,196,196,196,196,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,927,927,
1037,1042,1042,755,755,1040,1041,1040,1041,1040,1041,1040,1041,1040,1041,1040,
1041,1043,1044,1043,1044,866,866,1040,1041,1037,1037,1037,1037,755,755,755,
1045,199,1046,196,199,1047,1038,1038,1042,1048,1049,1048,1049,1048,1049,1050,
1037,1051,1052,1053,1054,1054,794,196,1051,479,1050,1037,196,196,196,196,
1029,321,1029,321,1029,340,1029,321,1029,321,1029,321,1029,321,1029,321,

/* block 139 */
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,321,
321,321,321,321,321,321,321,321,321,321,321,321,321,340,340, 51,

/* block 140 */
196,1038,1055,1050,479,1050,1037,1056,1048,1049,1037,1052,1045,1057,1046,1058,
1059,1059,1059,1059,1059,1059,1059,1059,1059,1059,1047,199,1054,794,1054,1038,
1037,1060,1060,1060,1060,1060,1060, 59, 59, 59, 59, 59, 59, 59, 59, 59,
 59, 59, 59, 59, 59, 59, 59, 59, 59, 59, 59,1048,1051,1049,1061,755,
 46,1062,1062,1062,1062,1062,1062, 62, 62, 62, 62, 62, 62, 62, 62, 62,
 62, 62, 62, 62, 62, 62, 62, 62, 62, 62, 62,1048,794,1049,794,1048,
1049,1063,1064,1065,1066,897,896,896,896,896,896,896,896,896,896,896,
898,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,

/* block 141 */
896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,896,
896,896,896,896,896,896,896,896,896,896,896,896,896,896,1067,1067,
902,901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,
901,901,901,901,901,901,901,901,901,901,901,901,901,901,901,196,
196,196,901,901,901,901,901,901,196,196,901,901,901,901,901,901,
196,196,901,901,901,901,901,901,196,196,901,901,901,196,196,196,
479,479,794, 46,781,479,479,196,781,794,794,794,794,781,781,196,
765,765,765,765,765,765,765,765,765,1068,1068,1068,781,781,1032,1032,

/* block 142 */
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,196,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,196,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,196,1069,1069,196,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,196,196,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 143 */
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,
1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,1069,196,196,196,196,196,

/* block 144 */
1070,1071,1072,196,196,196,196,1073,1073,1073,1073,1073,1073,1073,1073,1073,
1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,
1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,1073,
1073,1073,1073,1073,196,196,196,1074,1074,1074,1074,1074,1074,1074,1074,1074,
1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,
1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,
1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,1075,
1075,1075,1075,1075,1075,1076,1076,1076,1076,1077,1077,1077,1077,1077,1077,1077,

/* block 145 */
1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1076,1076,1077,1078,1078,196,
781,781,781,781,781,781,781,781,781,781,781,781,781,196,196,196,
1077,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,189,196,196,

/* block 146 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 147 */
1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,
1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,1079,196,196,196,
1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,
1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,
1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,1080,
1080,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1081,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,
1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,1082,196,196,196,196,

/* block 148 */
1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,
1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,1083,
1084,1084,1084,1084,196,196,196,196,196,196,196,196,196,1083,1083,1083,
1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,1085,
1085,1086,1085,1085,1085,1085,1085,1085,1085,1085,1086,196,196,196,196,196,
1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,
1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,1087,
1087,1087,1087,1087,1087,1087,1088,1088,1088,1088,1088,196,196,196,196,196,

/* block 149 */
1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,
1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,1089,196,1090,
1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,
1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,1091,
1091,1091,1091,1091,196,196,196,196,1091,1091,1091,1091,1091,1091,1091,1091,
1092,1093,1093,1093,1093,1093,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 150 */
1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,
1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,1094,
1094,1094,1094,1094,1094,1094,1094,1094,1095,1095,1095,1095,1095,1095,1095,1095,
1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,
1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,1095,
1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,
1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,
1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,1096,

/* block 151 */
1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,
1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,1097,196,196,
1098,1098,1098,1098,1098,1098,1098,1098,1098,1098,196,196,196,196,196,196,
1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,
1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,1099,
1099,1099,1099,1099,196,196,196,196,1100,1100,1100,1100,1100,1100,1100,1100,
1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,
1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,1100,196,196,196,196,

/* block 152 */
1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,
1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,1101,
1101,1101,1101,1101,1101,1101,1101,1101,196,196,196,196,196,196,196,196,
1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,
1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,
1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,1102,
1102,1102,1102,1102,196,196,196,196,196,196,196,196,196,196,196,1103,
1104,1104,1104,1104,1104,1104,1104,1104,1104,1104,1104,196,1104,1104,1104,1104,

/* block 153 */
1104,1104,1104,1104,1104,1104,1104,1104,1104,1104,1104,196,1104,1104,1104,1104,
1104,1104,1104,196,1104,1104,196,1105,1105,1105,1105,1105,1105,1105,1105,1105,
1105,1105,196,1105,1105,1105,1105,1105,1105,1105,1105,1105,1105,1105,1105,1105,
1105,1105,196,1105,1105,1105,1105,1105,1105,1105,196,1105,1105,196,196,196,
1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,
1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,
1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,1106,
1106,1106,1106,1106,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 154 */
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,

/* block 155 */
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,1107,196,196,196,196,196,196,196,196,196,
1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,1107,
1107,1107,1107,1107,1107,1107,196,196,196,196,196,196,196,196,196,196,
1107,1107,1107,1107,1107,1107,1107,1107,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 156 */
149,1108,1108,149,149,149,196,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,149,
149,196,149,149,149,149,149,149,149,149,149,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 157 */
1109,1109,1109,1109,1109,1109,297,297,1109,297,1109,1109,1109,1109,1109,1109,
1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,
1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,1109,
1109,1109,1109,1109,1109,1109,297,1109,1109,297,297,297,1109,297,297,1109,
1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,1110,
1110,1110,1110,1110,1110,1110,297,1111,1112,1112,1112,1112,1112,1112,1112,1112,
1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,1113,
1113,1113,1113,1113,1113,1113,1113,1114,1114,1115,1115,1115,1115,1115,1115,1115,

/* block 158 */
1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,
1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,1116,297,
297,297,297,297,297,297,297,1117,1117,1117,1117,1117,1117,1117,1117,1117,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,1118,
1118,1118,1118,297,1118,1118,297,297,297,297,297,1119,1119,1119,1119,1119,

/* block 159 */
1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,1120,
1120,1120,1120,1120,1120,1120,1121,1121,1121,1121,1121,1121,297,297,297,1122,
1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,
1123,1123,1123,1123,1123,1123,1123,1123,1123,1123,297,297,297,297,297,1124,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 160 */
1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,
1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,1125,
1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,1126,
1126,1126,1126,1126,1126,1126,1126,1126,297,297,297,297,1127,1127,1126,1126,
1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,
297,297,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,
1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,
1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,1127,

/* block 161 */
1128,1129,1129,1129,297,1129,1129,297,297,297,297,297,1129,1129,1129,1129,
1128,1128,1128,1128,297,1128,1128,1128,297,1128,1128,1128,1128,1128,1128,1128,
1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,1128,
1128,1128,1128,1128,1128,1128,297,297,1130,1130,1130,297,297,297,297,1131,
1132,1132,1132,1132,1132,1132,1132,1132,1132,297,297,297,297,297,297,297,
1133,1133,1133,1133,1133,1133,1134,1134,1133,297,297,297,297,297,297,297,
1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,
1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1135,1136,1136,1137,

/* block 162 */
1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,
1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1138,1139,1139,1139,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
1140,1140,1140,1140,1140,1140,1140,1140,1141,1140,1140,1140,1140,1140,1140,1140,
1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,1140,
1140,1140,1140,1140,1140,1142,1142,297,297,297,297,1143,1143,1143,1143,1143,
1144,1144,1145,1144,1144,1144,1146,297,297,297,297,297,297,297,297,297,

/* block 163 */
1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,
1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,
1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,1147,
1147,1147,1147,1147,1147,1147,297,297,297,1148,1149,1149,1149,1149,1149,1149,
1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,1150,
1150,1150,1150,1150,1150,1150,297,297,1151,1151,1151,1151,1151,1151,1151,1151,
1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,1152,
1152,1152,1152,297,297,297,297,297,1153,1153,1153,1153,1153,1153,1153,1153,

/* block 164 */
1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,1154,
1154,1154,297,297,297,297,297,297,297,1155,1155,1155,1155,297,297,297,
297,297,297,297,297,297,297,297,297,1156,1156,1156,1156,1156,1156,1156,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 165 */
1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,
1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,
1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,
1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,1157,
1157,1157,1157,1157,1157,1157,1157,1157,1157,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 166 */
1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,
1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,
1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,1158,
1158,1158,1158,297,297,297,297,297,297,297,297,297,297,297,297,297,
1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,
1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,
1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,1159,
1159,1159,1159,297,297,297,297,297,297,297,1160,1160,1160,1160,1160,1160,

/* block 167 */
1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,
1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,1161,
1161,1161,1162,1162,1163,1163,1163,1163,340,340,340,340,340,340,340,340,
1164,1164,1164,1164,1164,1164,1164,1164,1164,1164,340,340,340,340,340,340,
1165,1165,1165,1165,1165,1165,1165,1165,1165,1165,1166,1166,1166,1166,1167,1166,
1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,1168,
1168,1168,1168,1168,1168,1168,297,297,297,1169,1170,1171,1171,1171,1172,1173,
1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,1174,

/* block 168 */
1174,1174,1174,1174,1174,1174,297,297,297,297,297,297,297,297,1175,1175,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 169 */
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,
1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,1176,297,

/* block 170 */
1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,
1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,
1177,1177,1177,1177,1177,1177,1177,1177,1177,1177,297,1178,1178,1179,297,297,
1177,1177,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
340,340,321,321,321,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,316,333,333,333,

/* block 171 */
1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,
1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1180,1181,1181,1181,
1181,1181,1181,1181,1181,1181,1181,1180,297,297,297,297,297,297,297,297,
1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,1182,
1182,1182,1182,1182,1182,1182,1183,1183,1183,1183,1183,1183,1183,1183,1183,1183,
1183,1184,1184,1184,1184,1185,1185,1185,1185,1185,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,1186,

/* block 172 */
1186,1186,1187,1187,1187,1187,1188,1188,1188,1188,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,1189,
1189,1189,1189,1189,1189,1190,1190,1190,1190,1190,1190,1190,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,1191,
1191,1191,1191,1191,1191,1191,1191,297,297,297,297,297,297,297,297,297,

/* block 173 */
1192,1193,1192,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,
1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,
1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,1194,
1194,1194,1194,1194,1194,1194,1194,1194,1193,1193,1193,1193,1193,1193,1193,1193,
1193,1193,1193,1193,1193,1193,1195,1196,1196,1197,1197,1197,1197,1197,196,196,
196,196,1198,1198,1198,1198,1198,1198,1198,1198,1198,1198,1198,1198,1198,1198,
1198,1198,1198,1198,1198,1198,1199,1199,1199,1199,1199,1199,1199,1199,1199,1199,
1195,1194,1194,1193,1193,1194,196,196,196,196,196,196,196,196,196,1200,

/* block 174 */
1201,1201,1202,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,
1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,
1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,1203,
1202,1202,1202,1201,1201,1201,1201,1202,1202,1204,1205,1206,1206,1207,1208,1208,
1208,1208,1201,196,196,196,196,196,196,196,196,196,196,1207,196,196,
1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,1209,
1209,1209,1209,1209,1209,1209,1209,1209,1209,196,196,196,196,196,196,196,
1210,1210,1210,1210,1210,1210,1210,1210,1210,1210,196,196,196,196,196,196,

/* block 175 */
1211,1211,1211,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,
1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,1212,
1212,1212,1212,1212,1212,1212,1212,1211,1211,1211,1211,1211,1213,1211,1211,1211,
1211,1211,1211,1214,1214,196,1215,1215,1215,1215,1215,1215,1215,1215,1215,1215,
1216,1217,1217,1217,1212,1213,1213,1212,196,196,196,196,196,196,196,196,
1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,
1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,1218,
1218,1218,1218,1219,1220,1220,1218,196,196,196,196,196,196,196,196,196,

/* block 176 */
1221,1221,1222,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,
1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,
1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,1223,
1223,1223,1223,1222,1222,1222,1221,1221,1221,1221,1221,1221,1221,1221,1221,1222,
1224,1223,1225,1225,1223,1226,1226,1227,1227,1228,1229,1229,1229,1226,1222,1221,
1230,1230,1230,1230,1230,1230,1230,1230,1230,1230,1223,1227,1223,1227,1226,1226,
196,1231,1231,1231,1231,1231,1231,1231,1231,1231,1231,1231,1231,1231,1231,1231,
1231,1231,1231,1231,1231,196,196,196,196,196,196,196,196,196,196,196,

/* block 177 */
1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,
1232,1232,196,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,
1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1232,1233,1233,1233,1234,
1234,1234,1233,1233,1234,1235,1236,1237,1238,1238,1239,1238,1238,1240,1234,1232,
1232,1234,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 178 */
1241,1241,1241,1241,1241,1241,1241,196,1241,196,1241,1241,1241,1241,196,1241,
1241,1241,1241,1241,1241,1241,1241,1241,1241,1241,1241,1241,1241,1241,196,1241,
1241,1241,1241,1241,1241,1241,1241,1241,1241,1242,196,196,196,196,196,196,
1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,
1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,
1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1243,1244,
1245,1245,1245,1244,1244,1244,1244,1244,1244,1246,1247,196,196,196,196,196,
1248,1248,1248,1248,1248,1248,1248,1248,1248,1248,196,196,196,196,196,196,

/* block 179 */
1249,1250,1251,1252,196,1253,1253,1253,1253,1253,1253,1253,1253,196,196,1253,
1253,196,196,1253,1253,1253,1253,1253,1253,1253,1253,1253,1253,1253,1253,1253,
1253,1253,1253,1253,1253,1253,1253,1253,1253,196,1253,1253,1253,1253,1253,1253,
1253,196,1253,1253,196,1253,1253,1253,1253,1253,196,1254,1255,1253,1256,1251,
1249,1251,1251,1251,1251,196,196,1251,1251,196,196,1251,1251,1257,196,196,
1253,196,196,196,196,196,196,1256,196,196,196,196,196,1258,1253,1253,
1253,1253,1251,1251,196,196,1259,1259,1259,1259,1259,1259,1259,196,196,196,
1259,1259,1259,1259,1259,196,196,196,196,196,196,196,196,196,196,196,

/* block 180 */
1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,196,1260,196,196,1260,196,
1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,
1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,1260,
1260,1260,1260,1260,1260,1260,196,1260,1261,1262,1262,1263,1263,1263,1263,1263,
1263,196,1261,196,196,1261,196,1261,1261,1261,1262,196,1262,1262,1264,1265,
1264,1266,1267,1268,1269,1269,196,1270,1270,196,196,196,196,196,196,196,
196,1271,1271,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 181 */
1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,
1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,
1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,1272,
1272,1272,1272,1272,1272,1273,1273,1273,1274,1274,1274,1274,1274,1274,1274,1274,
1273,1273,1275,1274,1274,1273,1276,1272,1272,1272,1272,1277,1277,1278,1279,1279,
1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1278,1278,196,1279,1281,1272,
1272,1272,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 182 */
1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,
1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,
1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,1282,
1283,1284,1284,1285,1285,1285,1285,1285,1285,1284,1285,1284,1284,1283,1284,1285,
1285,1284,1286,1287,1282,1282,1288,1282,196,196,196,196,196,196,196,196,
1289,1289,1289,1289,1289,1289,1289,1289,1289,1289,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 183 */
1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,
1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,
1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1290,1291,
1292,1292,1293,1293,1293,1293,196,196,1292,1292,1292,1292,1293,1293,1292,1294,
1295,1296,1297,1297,1298,1298,1299,1299,1299,1297,1297,1297,1297,1297,1297,1297,
1297,1297,1297,1297,1297,1297,1297,1297,1290,1290,1290,1290,1293,1293,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 184 */
1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,
1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,
1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,1300,
1301,1301,1301,1302,1302,1302,1302,1302,1302,1302,1302,1301,1301,1302,1301,1303,
1302,1304,1304,1305,1300,196,196,196,196,196,196,196,196,196,196,196,
1306,1306,1306,1306,1306,1306,1306,1306,1306,1306,196,196,196,196,196,196,
581,581,581,581,581,581,581,581,581,581,581,581,581,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 185 */
1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,
1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,
1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1307,1308,1309,1308,1309,1309,
1308,1308,1308,1308,1308,1308,1310,1311,1307,1312,196,196,196,196,196,196,
1313,1313,1313,1313,1313,1313,1313,1313,1313,1313,196,196,196,196,196,196,
522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,522,
522,522,522,522,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 186 */
1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,
1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,1314,196,196,1315,1316,1315,
1317,1317,1315,1315,1315,1315,1316,1315,1315,1315,1315,1318,196,196,196,196,
1319,1319,1319,1319,1319,1319,1319,1319,1319,1319,1320,1320,1321,1321,1321,1322,
1314,1314,1314,1314,1314,1314,1314,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 187 */
1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,
1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,
1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1323,1324,1324,1324,1325,
1325,1325,1325,1325,1325,1325,1325,1325,1324,1326,1327,1328,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 188 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,
1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,1329,
1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,
1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,1330,
1331,1331,1331,1331,1331,1331,1331,1331,1331,1331,1332,1332,1332,1332,1332,1332,
1332,1332,1332,196,196,196,196,196,196,196,196,196,196,196,196,1333,

/* block 189 */
1334,1334,1334,1334,1334,1334,1334,196,196,1334,196,196,1334,1334,1334,1334,
1334,1334,1334,1334,196,1334,1334,196,1334,1334,1334,1334,1334,1334,1334,1334,
1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,1334,
1335,1336,1336,1336,1336,1336,196,1336,1336,196,196,1337,1337,1338,1339,1340,
1336,1340,1336,1341,1342,1343,1342,196,196,196,196,196,196,196,196,196,
1344,1344,1344,1344,1344,1344,1344,1344,1344,1344,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 190 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1345,1345,1345,1345,1345,1345,1345,1345,196,196,1345,1345,1345,1345,1345,1345,
1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,
1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,1345,
1345,1346,1346,1346,1347,1347,1347,1347,196,196,1347,1347,1346,1346,1346,1346,
1348,1345,1349,1345,1346,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 191 */
1350,1351,1351,1351,1351,1351,1351,1352,1352,1351,1351,1350,1350,1350,1350,1350,
1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,
1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,
1350,1350,1350,1353,1354,1351,1351,1351,1351,1355,1356,1351,1351,1351,1351,1357,
1357,1357,1358,1358,1357,1357,1357,1354,196,196,196,196,196,196,196,196,
1359,1360,1360,1360,1360,1360,1360,1361,1361,1360,1360,1360,1359,1359,1359,1359,
1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,
1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,1359,

/* block 192 */
1359,1359,1359,1359,1362,1362,1362,1362,1362,1362,1360,1360,1360,1360,1360,1360,
1360,1360,1360,1360,1360,1360,1360,1361,1363,1364,1365,1366,1366,1359,1365,1365,
1365,1367,1367,196,196,196,196,196,196,196,196,196,196,196,196,196,
545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,545,
1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,
1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,
1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,1368,
1368,1368,1368,1368,1368,1368,1368,1368,1368,196,196,196,196,196,196,196,

/* block 193 */
385,385,385,385,385,385,385,385,385,385,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 194 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,
1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,1369,
1369,1370,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1371,1371,1371,1371,1371,1371,1371,1371,1371,1371,196,196,196,196,196,196,

/* block 195 */
1372,1372,1372,1372,1372,1372,1372,1372,1372,196,1372,1372,1372,1372,1372,1372,
1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,
1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1372,1373,
1374,1374,1374,1374,1374,1374,1374,196,1374,1374,1374,1374,1374,1374,1373,1375,
1372,1376,1376,1377,1378,1378,196,196,196,196,196,196,196,196,196,196,
1379,1379,1379,1379,1379,1379,1379,1379,1379,1379,1380,1380,1380,1380,1380,1380,
1380,1380,1380,1380,1380,1380,1380,1380,1380,1380,1380,1380,1380,196,196,196,
1381,1382,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,

/* block 196 */
1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,1383,
196,196,1384,1384,1384,1384,1384,1384,1384,1384,1384,1384,1384,1384,1384,1384,
1384,1384,1384,1384,1384,1384,1384,1384,196,1385,1384,1384,1384,1384,1384,1384,
1384,1385,1384,1384,1385,1384,1384,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 197 */
1386,1386,1386,1386,1386,1386,1386,196,1386,1386,196,1386,1386,1386,1386,1386,
1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,
1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,1386,
1386,1387,1387,1387,1387,1387,1387,196,196,196,1387,196,1387,1387,196,1387,
1387,1387,1388,1387,1389,1389,1390,1387,196,196,196,196,196,196,196,196,
1391,1391,1391,1391,1391,1391,1391,1391,1391,1391,196,196,196,196,196,196,
1392,1392,1392,1392,1392,1392,196,1392,1392,196,1392,1392,1392,1392,1392,1392,
1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,

/* block 198 */
1392,1392,1392,1392,1392,1392,1392,1392,1392,1392,1393,1393,1393,1393,1393,196,
1394,1394,196,1393,1393,1394,1393,1395,1392,196,196,196,196,196,196,196,
1396,1396,1396,1396,1396,1396,1396,1396,1396,1396,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 199 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,1397,
1397,1397,1397,1398,1398,1399,1399,1400,1400,196,196,196,196,196,196,196,

/* block 200 */
1401,1401,1402,1403,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,
1404,196,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,
1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,1404,
1404,1404,1404,1404,1403,1403,1401,1401,1401,1401,1401,196,196,196,1403,1403,
1401,1405,1406,1407,1407,1408,1408,1408,1408,1408,1408,1408,1408,1408,1408,1408,
1409,1409,1409,1409,1409,1409,1409,1409,1409,1409,1410,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 201 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
914,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,1411,
435,435,1411,435,1411,437,437,437,437,437,437,437,437,438,438,438,
438,437,437,437,437,437,437,437,437,437,437,437,437,437,437,437,
437,437,196,196,196,196,196,196,196,196,196,196,196,196,196,1412,

/* block 202 */
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,

/* block 203 */
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 204 */
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,
1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,1414,196,
1415,1415,1415,1415,1415,196,196,196,196,196,196,196,196,196,196,196,

/* block 205 */
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,1413,
1413,1413,1413,1413,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 206 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,
1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,
1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,
1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,
1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,
1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,1416,
1416,1417,1417,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 207 */
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,

/* block 208 */
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,1419,
1420,1418,1418,1418,1418,1418,1418,1421,1421,1421,1421,1421,1421,1421,1421,1421,
1421,1421,1421,1421,1421,1421,196,196,196,196,196,196,196,196,196,196,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,

/* block 209 */
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,
1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,1418,196,196,196,196,196,

/* block 210 */
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,

/* block 211 */
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,1422,
1422,1422,1422,1422,1422,1422,1422,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 212 */
1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,
1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1423,1424,1424,
1424,1424,1424,1424,1424,1424,1424,1424,1424,1424,1425,1425,1425,1424,1424,1426,
1427,1427,1427,1427,1427,1427,1427,1427,1427,1427,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 213 */
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,

/* block 214 */
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,930,
930,930,930,930,930,930,930,930,930,196,196,196,196,196,196,196,
1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,
1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,1428,196,
1429,1429,1429,1429,1429,1429,1429,1429,1429,1429,196,196,196,196,1430,1430,
1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,

/* block 215 */
1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,
1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,
1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,
1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,1431,196,
1432,1432,1432,1432,1432,1432,1432,1432,1432,1432,196,196,196,196,196,196,
1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,
1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,1433,196,196,
1434,1434,1434,1434,1434,1435,196,196,196,196,196,196,196,196,196,196,

/* block 216 */
1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,
1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,
1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,
1437,1437,1437,1437,1437,1437,1437,1438,1438,1439,1440,1440,1441,1441,1441,1441,
1442,1442,1443,1443,1438,1441,196,196,196,196,196,196,196,196,196,196,
1444,1444,1444,1444,1444,1444,1444,1444,1444,1444,196,1445,1445,1445,1445,1445,
1445,1445,196,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,
1436,1436,1436,1436,1436,1436,1436,1436,196,196,196,196,196,1436,1436,1436,

/* block 217 */
1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,1436,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 218 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1446,1446,1446,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,
1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,1447,
1447,1447,1447,1448,1447,1447,1447,1448,1448,1448,1448,1449,1449,1450,1451,1451,
1452,1452,1452,1452,1452,1452,1452,1452,1452,1452,196,196,196,196,196,196,

/* block 219 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,
1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,1453,
1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,
1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,1454,

/* block 220 */
1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,1455,
1455,1455,1455,1455,1455,1455,1455,1456,1457,1458,1458,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 221 */
1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,
1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,
1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,
1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,
1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,1459,196,196,196,196,1460,
1459,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,
1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,
1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,1461,

/* block 222 */
1461,1461,1461,1461,1461,1461,1461,1461,196,196,196,196,196,196,196,1462,
1462,1462,1462,1463,1463,1463,1463,1463,1463,1463,1463,1463,1463,1463,1463,1463,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1464,1465,1466,867,1467,196,196,196,196,196,196,196,196,196,196,196,
1468,1468,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 223 */
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,

/* block 224 */
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,1469,
1469,1469,1469,1469,1469,1469,1469,1469,196,196,196,196,196,196,196,196,

/* block 225 */
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,

/* block 226 */
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,1470,
1470,1470,1470,1470,1470,1470,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,1470,

/* block 227 */
1469,1469,1469,1469,1469,1469,1469,1469,1469,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 228 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1471,1471,1471,1471,196,1471,1471,1471,1471,1471,1471,1471,196,1471,1471,196,

/* block 229 */
896,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,

/* block 230 */
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,

/* block 231 */
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,891,
896,896,896,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,891,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
891,891,891,196,196,896,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,896,896,896,896,196,196,196,196,196,196,196,196,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,

/* block 232 */
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,

/* block 233 */
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,
1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,1472,196,196,196,196,

/* block 234 */
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,196,196,196,196,196,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,196,196,196,

/* block 235 */
1473,1473,1473,1473,1473,1473,1473,1473,1473,196,196,196,196,196,196,196,
1473,1473,1473,1473,1473,1473,1473,1473,1473,1473,196,196,1474,1475,1476,1477,
1478,1478,1478,1478,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 236 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,

/* block 237 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
1479,1479,1479,1479,1479,1479,1479,1479,1479,1479,196,196,196,196,196,196,

/* block 238 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 239 */
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,196,196,
176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,176,
176,176,176,176,176,176,176,196,196,196,196,196,196,196,196,196,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,

/* block 240 */
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 241 */
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,

/* block 242 */
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,196,196,196,196,196,196,196,196,196,196,

/* block 243 */
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,196,196,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,1480,1480,176,176,176,510,510,510,1481,1481,1481,
1481,1481,1481, 51, 51, 51, 51, 51, 51, 51, 51,176,176,176,176,176,

/* block 244 */
176,176,176,510,510,176,176,176,176,176,176,176,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,176,176,176,176,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,781,781,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 245 */
1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,
1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,
1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,
1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,1077,
1077,1077,1482,1482,1482,1077,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 246 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,
907,907,907,907,196,196,196,196,196,196,196,196,196,196,196,196,
907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,907,
907,907,907,907,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 247 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,196,196,196,196,196,196,196,196,196,
904,904,904,904,904,904,904,904,904,904,904,904,904,904,904,904,
904,904,907,907,907,907,907,907,907,196,196,196,196,196,196,196,

/* block 248 */
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,783,783,783,783,783,783,
783,783,795,795,783,783,783,783,783,783,783,783,783,783,783,783,
783,783,783,783,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,783,783,
783,783,783,783,783,196,795,795,783,783,783,783,783,783,783,783,
783,783,783,783,783,783,783,783,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,

/* block 249 */
782,782,783,783,783,783,783,783,783,783,795,795,783,783,783,783,
783,783,783,783,783,783,783,783,783,783,783,783,782,196,782,782,
196,196,782,196,196,782,782,196,196,782,782,782,782,196,782,782,
782,782,782,782,782,782,783,783,783,783,196,783,196,783,795,795,
783,783,783,783,196,783,783,783,783,783,783,783,783,783,783,783,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,783,783,783,783,783,783,
783,783,795,795,783,783,783,783,783,783,783,783,783,783,783,783,

/* block 250 */
783,783,783,783,782,782,196,782,782,782,782,196,196,782,782,782,
782,782,782,782,782,196,782,782,782,782,782,782,782,196,783,783,
783,783,783,783,783,783,795,795,783,783,783,783,783,783,783,783,
783,783,783,783,783,783,783,783,782,782,196,782,782,782,782,196,
782,782,782,782,782,196,782,196,196,196,782,782,782,782,782,782,
782,196,783,783,783,783,783,783,783,783,795,795,783,783,783,783,
783,783,783,783,783,783,783,783,783,783,783,783,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,

/* block 251 */
782,782,782,782,782,782,783,783,783,783,783,783,783,783,795,795,
783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,783,783,783,783,783,783,
783,783,795,795,783,783,783,783,783,783,783,783,783,783,783,783,
783,783,783,783,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,783,783,
783,783,783,783,783,783,795,795,783,783,783,783,783,783,783,783,

/* block 252 */
783,783,783,783,783,783,783,783,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,783,783,783,783,783,783,783,783,795,795,783,783,783,783,
783,783,783,783,783,783,783,783,783,783,783,783,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,783,783,783,783,783,783,783,783,795,795,
783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,

/* block 253 */
782,782,782,782,782,782,782,782,782,782,783,783,783,783,783,783,
783,783,795,795,783,783,783,783,783,783,783,783,783,783,783,783,
783,783,783,783,783,783,196,196,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,1483,783,783,783,783,783,783,783,783,783,783,783,783,783,783,
783,783,783,783,783,783,783,783,783,783,783,1483,783,783,783,783,
783,783,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,1483,783,783,783,783,

/* block 254 */
783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,
783,783,783,783,783,1483,783,783,783,783,783,783,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,1483,783,783,783,783,783,783,783,783,783,783,
783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,1483,
783,783,783,783,783,783,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,1483,
783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,

/* block 255 */
783,783,783,783,783,783,783,783,783,1483,783,783,783,783,783,783,
782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,782,
782,782,782,782,782,782,782,782,782,1483,783,783,783,783,783,783,
783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,783,
783,783,783,1483,783,783,783,783,783,783,782,783,196,196,1484,1484,
1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,
1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,
1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,1484,

/* block 256 */
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,
1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,

/* block 257 */
1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,
1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,
1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,
1486,1486,1486,1486,1486,1486,1486,1485,1485,1485,1485,1486,1486,1486,1486,1486,
1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,
1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,
1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1485,1485,1485,
1485,1485,1485,1485,1485,1486,1485,1485,1485,1485,1485,1485,1485,1485,1485,1485,

/* block 258 */
1485,1485,1485,1485,1486,1485,1485,1487,1488,1487,1487,1489,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,1486,1486,1486,1486,1486,
196,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,1486,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 259 */
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70, 93, 70, 70, 70, 70, 70,
 70, 70, 70, 70, 70, 70, 70, 70, 70, 70,694, 70, 70, 70, 70,196,
196,196,196,196,196, 70, 70, 70, 70, 70, 70,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 260 */
1490,1490,1490,1490,1490,1490,1490,196,1490,1490,1490,1490,1490,1490,1490,1490,
1490,1490,1490,1490,1490,1490,1490,1490,1490,196,196,1490,1490,1490,1490,1490,
1490,1490,196,1490,1490,196,1490,1490,1490,1490,1490,196,196,196,196,196,
929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,
929,929,929,929,929,929,929,929,929,929,929,929,1491,1491,929,929,
929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,929,
929,929,929,929,929,929,929,929,1491,929,929,929,929,929,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 261 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,849,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 262 */
1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,
1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,
1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,1492,196,196,196,
1493,1493,1493,1493,1493,1493,1493,1494,1494,1494,1494,1494,1495,1495,196,196,
1496,1496,1496,1496,1496,1496,1496,1496,1496,1496,196,196,196,196,1492,1497,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 263 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,
1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1498,1499,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,
1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,
1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1500,1501,1501,1501,1501,
1502,1502,1502,1502,1502,1502,1502,1502,1502,1502,196,196,196,196,196,1503,

/* block 264 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,
1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1504,1505,1506,1506,1506,1506,
1507,1507,1507,1507,1507,1507,1507,1507,1507,1507,196,196,196,196,196,196,

/* block 265 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,
1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1508,1509,1510,
1508,1511,1511,1511,1511,1511,1511,1511,1511,1511,1511,196,196,196,196,1512,

/* block 266 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
533,533,533,533,533,533,533,196,533,533,533,533,196,533,533,196,
533,533,533,533,533,533,533,533,533,533,533,533,533,533,533,196,

/* block 267 */
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,

/* block 268 */
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,1513,
1513,1513,1513,1513,1513,297,297,1514,1514,1514,1514,1514,1514,1514,1514,1514,
1515,1515,1515,1515,1515,1515,1515,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 269 */
1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,
1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,1516,
1516,1516,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,
1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,1517,
1517,1517,1517,1517,1518,1518,1518,1519,1520,1520,1520,1521,297,297,297,297,
1522,1522,1522,1522,1522,1522,1522,1522,1522,1522,297,297,297,297,1523,1523,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 270 */
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 271 */
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
340,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,

/* block 272 */
1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,
1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,
1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1525,1524,1524,1524,
1526,1524,1524,1524,1524,340,340,340,340,340,340,340,340,340,340,340,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 273 */
340,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,
1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,
1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1525,1524,
1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,1524,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,
297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,297,

/* block 274 */
1527,1527,1527,1527,340,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,
1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,
340,1527,1527,340,1527,340,340,1527,340,1527,1527,1527,1527,1527,1527,1527,
1527,1527,1527,340,1527,1527,1527,1527,340,1527,340,1527,340,340,340,340,
340,340,1527,340,340,340,340,1527,340,1527,340,1527,340,1527,1527,1527,
340,1527,1527,340,1527,340,340,1527,340,1527,340,1527,340,1527,340,1527,
340,1527,1527,340,1527,340,340,1527,1527,1527,1527,340,1527,1527,1527,1527,
1527,1527,1527,340,1527,1527,1527,1527,340,1527,1527,1527,1527,340,1527,340,

/* block 275 */
1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,340,1527,1527,1527,1527,1527,
1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,340,340,340,340,
340,1527,1527,1527,340,1527,1527,1527,1527,1527,340,1527,1527,1527,1527,1527,
1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,1527,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,340,
309,309,340,340,340,340,340,340,340,340,340,340,340,340,340,340,

/* block 276 */
1528,1528,1528,1528,1529,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1530,1530,1530,1530,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,

/* block 277 */
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1530,
1530,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1530,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1529,
1530,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,

/* block 278 */
814,814,814,814,814,814,814,814,814,814,814, 58, 58,1528,1528,1528,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,1528,
1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,
1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,510,510,510,510,510,510,
1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,
1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,781,781,1528,1528,1528,1528,
1532,1532,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,1532,1532,

/* block 279 */
1531,1531,1531,1531,1531,1531,1531,1531,1531,1531,510,510,510,510,1533,510,
510,1533,1533,1533,1533,1533,1533,1533,1533,1533,1533,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,1528,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,
1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,1534,

/* block 280 */
1535,1533,1536,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
510,510,510,510,510,510,510,510,510,510,1533,510,510,510,510,510,
510,510,510,510,510,510,510,510,510,510,510,510,510,510,510,1533,
510,510,1533,1533,1533,1533,1533,1536,1533,1533,1533,510,1530,1530,1530,1530,
510,510,510,510,510,510,510,510,510,1530,1530,1530,1530,1530,1530,1530,
1537,1537,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1528,1528,1528,1528,1528,1528,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,

/* block 281 */
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,

/* block 282 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,785,1528,1528,785,785,785,785,785,785,785,785,785,1529,1529,1529,
1529,1529,1529,1529,1529,1529,785,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,785,1529,1529,

/* block 283 */
1529,1529,1529,1529,1529,1538,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1528,1528,785,785,1528,785,785,785,1528,1528,785,785,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1538,1538,1538,1529,1529,1538,1529,1529,1538,1539,1539,785,785,1529,
1529,1529,1529,1529,785,785,785,785,785,785,785,785,785,785,785,785,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1528,1528,785,1529,785,1528,785,1529,1529,1529,1540,1540,1540,1540,1540,

/* block 284 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,785,
1529,785,1538,1538,1529,1529,1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,
1538,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,
1538,1538,1538,1538,1538,1538,1538,1538,1538,1529,1529,1529,1538,1529,1529,1529,

/* block 285 */
1529,1538,1538,1538,1529,1538,1538,1538,1529,1529,1529,1529,1529,1529,1529,1538,
1529,1538,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1538,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,785,1528,1529,

/* block 286 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,781,781,
781,781,781,781,781,781,1528,1528,1528,785,785,1529,1529,1529,1529,1528,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1528,1528,1528,1528,1528,1528,1528,785,
785,1528,1528,785,1539,1539,785,785,785,785,1538,1528,1528,1528,1528,1528,

/* block 287 */
1528,1528,1528,1528,1528,1528,1528,785,1528,1528,785,785,785,785,1528,1528,
1539,1528,1528,1528,1528,1538,1538,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1529,785,1528,1528,785,1528,1528,1528,1528,1528,1528,1528,
1528,785,785,1528,1528,1528,1528,1528,1528,1528,1528,1528,785,1528,1528,1528,
1528,1528,785,785,785,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,785,785,785,1528,1528,1528,1528,1528,1528,1528,1528,785,785,785,1528,
1528,785,1528,785,1528,1528,1528,1528,785,1528,1528,1528,1528,1528,1528,785,
1528,1528,1528,785,1528,1528,1528,1528,1528,1528,785,1529,1529,1529,1529,1529,

/* block 288 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1538,1538,1538,1529,1529,1529,1538,1538,1538,1538,1538,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,

/* block 289 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1538,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1538,1538,1538,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1538,1529,1529,1529,1529,1529,1528,1528,1528,1528,1528,785,1538,785,785,785,
1529,1529,1529,1528,1528,1529,1529,1529,1530,1530,1530,1530,1529,1529,1529,1529,
785,785,785,785,785,785,1528,1528,1528,785,1528,1529,1529,1530,1530,1530,
785,1528,1528,785,1529,1529,1529,1529,1529,1529,1529,1529,1529,1530,1530,1530,

/* block 290 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,1528,1528,1528,1530,1530,1530,1530,1528,1528,1528,1528,1528,

/* block 291 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,1528,1528,1528,1528,1528,1530,1530,1530,1530,1530,1530,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1530,1530,1530,1530,
1529,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,

/* block 292 */
781,781,781,781,781,781,781,781,781,781,781,781,1530,1530,1530,1530,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,1530,1530,1530,1530,1530,1530,1530,1530,
781,781,781,781,781,781,781,781,781,781,1530,1530,1530,1530,1530,1530,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,

/* block 293 */
781,781,781,781,781,781,781,781,1530,1530,1530,1530,1530,1530,1530,1530,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,1530,1530,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1530,1530,1530,1530,
1528,1528,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,

/* block 294 */
781,781,781,781,781,781,781,781,781,781,781,781,1538,1529,1529,1538,
1529,1529,1529,1529,1529,1529,1529,1529,1538,1538,1538,1538,1538,1538,1538,1538,
1529,1529,1529,1529,1529,1529,1538,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,1529,781,1538,1538,1538,1529,
1529,1529,1529,1529,1529,1529,781,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1538,1529,1529,1529,1529,1529,1529,1529,1529,

/* block 295 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1541,1541,1541,1541,1529,1538,1538,1529,1538,1538,1529,1538,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1538,1538,1538,
1529,1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,1538,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,

/* block 296 */
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,
1528,1528,1528,1528,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1528,1530,1530,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1530,1530,1530,

/* block 297 */
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1530,1530,1530,1530,1530,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,
1529,1529,1529,1538,1538,1538,1529,1530,1530,1530,1530,1530,1530,1530,1529,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1530,1530,1529,
1529,1529,1529,1529,1529,1529,1529,1529,1529,1529,1530,1530,1530,1530,1530,1530,
1538,1538,1538,1538,1538,1538,1538,1538,1538,1530,1530,1530,1530,1530,1530,1530,

/* block 298 */
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,196,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,781,
1479,1479,1479,1479,1479,1479,1479,1479,1479,1479,196,196,196,196,196,196,

/* block 299 */
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,
1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1530,1032,1032,

/* block 300 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 301 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,196,196,196,196,196,196,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,

/* block 302 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,196,196,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,

/* block 303 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,

/* block 304 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,

/* block 305 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 306 */
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,
1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,1025,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 307 */
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,1032,1032,

/* block 308 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,196,196,196,196,196,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,

/* block 309 */
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,910,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,
196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,196,

/* block 310 */
765,770,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,
1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,
1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,
1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,
1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,
1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,1542,

/* block 311 */
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,

/* block 312 */
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,

/* block 313 */
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,1035,
765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,765,

/* block 314 */
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,
1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1032,1032,
};

#if UCD_BLOCK_SIZE != 128
#error Please correct UCD_BLOCK_SIZE in pcre2_internal.h
#endif
#endif  /* SUPPORT_UNICODE */

#endif  /* PCRE2_PCRE2TEST */

/* End of pcre2_ucd.c */
