//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;

use crate::*;

/// The subkind of a DTD node kind.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmldtdnodekind?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct NSXMLDTDNodeKind(pub NSUInteger);
impl NSXMLDTDNodeKind {
    pub const NSXMLEntityGeneralKind: Self = Self(1);
    pub const NSXMLEntityParsedKind: Self = Self(2);
    pub const NSXMLEntityUnparsedKind: Self = Self(3);
    pub const NSXMLEntityParameterKind: Self = Self(4);
    pub const NSXMLEntityPredefined: Self = Self(5);
    pub const NSXMLAttributeCDATAKind: Self = Self(6);
    pub const NSXMLAttributeIDKind: Self = Self(7);
    pub const NSXMLAttributeIDRefKind: Self = Self(8);
    pub const NSXMLAttributeIDRefsKind: Self = Self(9);
    pub const NSXMLAttributeEntityKind: Self = Self(10);
    pub const NSXMLAttributeEntitiesKind: Self = Self(11);
    pub const NSXMLAttributeNMTokenKind: Self = Self(12);
    pub const NSXMLAttributeNMTokensKind: Self = Self(13);
    pub const NSXMLAttributeEnumerationKind: Self = Self(14);
    pub const NSXMLAttributeNotationKind: Self = Self(15);
    pub const NSXMLElementDeclarationUndefinedKind: Self = Self(16);
    pub const NSXMLElementDeclarationEmptyKind: Self = Self(17);
    pub const NSXMLElementDeclarationAnyKind: Self = Self(18);
    pub const NSXMLElementDeclarationMixedKind: Self = Self(19);
    pub const NSXMLElementDeclarationElementKind: Self = Self(20);
}

unsafe impl Encode for NSXMLDTDNodeKind {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for NSXMLDTDNodeKind {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern_class!(
    /// The nodes that are exclusive to a DTD
    ///
    /// Every DTD node has a name. Object value is defined as follows:
    /// <ul>
    /// <li>
    /// <b>
    /// Entity declaration
    /// </b>
    /// - the string that that entity resolves to eg "&lt;"
    /// </li>
    /// <li>
    /// <b>
    /// Attribute declaration
    /// </b>
    /// - the default value, if any
    /// </li>
    /// <li>
    /// <b>
    /// Element declaration
    /// </b>
    /// - the validation string
    /// </li>
    /// <li>
    /// <b>
    /// Notation declaration
    /// </b>
    /// - no objectValue
    /// </li>
    /// </ul>
    ///
    /// See also [Apple's documentation](https://developer.apple.com/documentation/foundation/nsxmldtdnode?language=objc)
    #[unsafe(super(NSXMLNode, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(feature = "NSXMLNode")]
    pub struct NSXMLDTDNode;
);

#[cfg(all(feature = "NSObject", feature = "NSXMLNode"))]
extern_conformance!(
    unsafe impl NSCopying for NSXMLDTDNode {}
);

#[cfg(all(feature = "NSObject", feature = "NSXMLNode"))]
unsafe impl CopyingHelper for NSXMLDTDNode {
    type Result = Self;
}

#[cfg(feature = "NSXMLNode")]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSXMLDTDNode {}
);

#[cfg(feature = "NSXMLNode")]
impl NSXMLDTDNode {
    extern_methods!(
        #[cfg(feature = "NSString")]
        /// Returns an element, attribute, entity, or notation DTD node based on the full XML string.
        #[unsafe(method(initWithXMLString:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithXMLString(
            this: Allocated<Self>,
            string: &NSString,
        ) -> Option<Retained<Self>>;

        #[cfg(feature = "NSXMLNodeOptions")]
        #[unsafe(method(initWithKind:options:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithKind_options(
            this: Allocated<Self>,
            kind: NSXMLNodeKind,
            options: NSXMLNodeOptions,
        ) -> Retained<Self>;

        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        /// Sets the DTD sub kind.
        #[unsafe(method(DTDKind))]
        #[unsafe(method_family = none)]
        pub unsafe fn DTDKind(&self) -> NSXMLDTDNodeKind;

        /// Setter for [`DTDKind`][Self::DTDKind].
        #[unsafe(method(setDTDKind:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setDTDKind(&self, dtd_kind: NSXMLDTDNodeKind);

        /// True if the system id is set. Valid for entities and notations.
        #[unsafe(method(isExternal))]
        #[unsafe(method_family = none)]
        pub unsafe fn isExternal(&self) -> bool;

        #[cfg(feature = "NSString")]
        /// Sets the public id. This identifier should be in the default catalog in /etc/xml/catalog or in a path specified by the environment variable XML_CATALOG_FILES. When the public id is set the system id must also be set. Valid for entities and notations.
        #[unsafe(method(publicID))]
        #[unsafe(method_family = none)]
        pub unsafe fn publicID(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`publicID`][Self::publicID].
        #[unsafe(method(setPublicID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPublicID(&self, public_id: Option<&NSString>);

        #[cfg(feature = "NSString")]
        /// Sets the system id. This should be a URL that points to a valid DTD. Valid for entities and notations.
        #[unsafe(method(systemID))]
        #[unsafe(method_family = none)]
        pub unsafe fn systemID(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`systemID`][Self::systemID].
        #[unsafe(method(setSystemID:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSystemID(&self, system_id: Option<&NSString>);

        #[cfg(feature = "NSString")]
        /// Set the notation name. Valid for entities only.
        #[unsafe(method(notationName))]
        #[unsafe(method_family = none)]
        pub unsafe fn notationName(&self) -> Option<Retained<NSString>>;

        #[cfg(feature = "NSString")]
        /// Setter for [`notationName`][Self::notationName].
        #[unsafe(method(setNotationName:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNotationName(&self, notation_name: Option<&NSString>);
    );
}

/// Methods declared on superclass `NSXMLNode`.
#[cfg(feature = "NSXMLNode")]
impl NSXMLDTDNode {
    extern_methods!(
        /// Invokes
        ///
        /// ```text
        ///  initWithKind:options:
        /// ```
        ///
        /// with options set to NSXMLNodeOptionsNone
        #[unsafe(method(initWithKind:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithKind(this: Allocated<Self>, kind: NSXMLNodeKind) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(feature = "NSXMLNode")]
impl NSXMLDTDNode {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new() -> Retained<Self>;
    );
}
