import {
  searchStringToObject,
  objectToSearchString
} from "serialize-query-params";
const defaultOptions = {
  searchStringToObject,
  objectToSearchString,
  updateType: "pushIn",
  includeKnownParams: void 0,
  includeAllParams: false,
  removeDefaultsFromUrl: false,
  enableBatching: false,
  skipUpdateWhenNoChange: true
};
function mergeOptions(parentOptions, currOptions) {
  if (currOptions == null) {
    currOptions = {};
  }
  const merged = { ...parentOptions, ...currOptions };
  if (currOptions.params && parentOptions.params) {
    merged.params = { ...parentOptions.params, ...currOptions.params };
  }
  return merged;
}
export {
  defaultOptions,
  mergeOptions
};
//# sourceMappingURL=options.js.map
