//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
use core::ptr::NonNull;
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

extern_class!(
    /// [Apple's documentation](https://developer.apple.com/documentation/appkit/nsbutton?language=objc)
    #[unsafe(super(NSControl, NSView, NSResponder, NSObject))]
    #[derive(Debug, PartialEq, Eq, Hash)]
    #[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
    pub struct NSButton;
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibility for NSButton {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityButton for NSButton {}
);

#[cfg(all(
    feature = "NSAccessibilityProtocols",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAccessibilityElementProtocol for NSButton {}
);

#[cfg(all(
    feature = "NSAnimation",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAnimatablePropertyContainer for NSButton {}
);

#[cfg(all(
    feature = "NSAppearance",
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSAppearanceCustomization for NSButton {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSCoding for NSButton {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSDragging",
    feature = "NSResponder",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSDraggingDestination for NSButton {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
extern_conformance!(
    unsafe impl NSObjectProtocol for NSButton {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceCompression",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceCompression for NSButton {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceItemIdentification",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceItemIdentification for NSButton {}
);

#[cfg(all(
    feature = "NSControl",
    feature = "NSResponder",
    feature = "NSUserInterfaceValidation",
    feature = "NSView"
))]
extern_conformance!(
    unsafe impl NSUserInterfaceValidations for NSButton {}
);

#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSButton {
    extern_methods!(
        #[cfg(feature = "NSImage")]
        /// Creates a standard push button with a title and image.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `image`: The image that is displayed alongside the title. In left-to-right localizations, the image is displayed to the left of the title. In right-to-left localizations, it is displayed to the right.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithTitle:image:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithTitle_image_target_action(
            title: &NSString,
            image: &NSImage,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard push button with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed on the button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "NSImage")]
        /// Creates a standard push button with the provided image. Set the image's accessibilityDescription property to ensure accessibility for this control.
        ///
        /// Parameter `image`: The image to display in the body of the button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(buttonWithImage:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn buttonWithImage_target_action(
            image: &NSImage,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard checkbox with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed alongside the checkbox.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(checkboxWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn checkboxWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        /// Creates a standard radio button with the provided title.
        ///
        /// Parameter `title`: The localized title string that is displayed alongside the radio button.
        ///
        /// Parameter `target`: The target object that receives action messages from the control.
        ///
        /// Parameter `action`: The action message sent by the control.
        ///
        /// Returns: An initialized button object.
        #[unsafe(method(radioButtonWithTitle:target:action:))]
        #[unsafe(method_family = none)]
        pub unsafe fn radioButtonWithTitle_target_action(
            title: &NSString,
            target: Option<&AnyObject>,
            action: Option<Sel>,
            mtm: MainThreadMarker,
        ) -> Retained<Self>;

        #[cfg(feature = "NSButtonCell")]
        /// Sets the button’s type, which affects its user interface and behavior when clicked. See the NSButtonType enumeration for possible options and their behaviors.
        #[unsafe(method(setButtonType:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setButtonType(&self, r#type: NSButtonType);

        /// The title displayed on the button when it’s in an off state, or an empty string if the button does not display a title. By default, a button's title is "Button".
        #[unsafe(method(title))]
        #[unsafe(method_family = none)]
        pub unsafe fn title(&self) -> Retained<NSString>;

        /// Setter for [`title`][Self::title].
        #[unsafe(method(setTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitle(&self, title: &NSString);

        /// The button's title, expressed as an attributed string.
        #[unsafe(method(attributedTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedTitle(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedTitle`][Self::attributedTitle].
        #[unsafe(method(setAttributedTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedTitle(&self, attributed_title: &NSAttributedString);

        /// The title that the button displays when the button is in an on state, or an empty string if there is no such title. Note that some button types do not display an alternate title.
        #[unsafe(method(alternateTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateTitle(&self) -> Retained<NSString>;

        /// Setter for [`alternateTitle`][Self::alternateTitle].
        #[unsafe(method(setAlternateTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlternateTitle(&self, alternate_title: &NSString);

        /// The alternate title, expressed as an attributed string.
        #[unsafe(method(attributedAlternateTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn attributedAlternateTitle(&self) -> Retained<NSAttributedString>;

        /// Setter for [`attributedAlternateTitle`][Self::attributedAlternateTitle].
        #[unsafe(method(setAttributedAlternateTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAttributedAlternateTitle(
            &self,
            attributed_alternate_title: &NSAttributedString,
        );

        /// Indicates whether the button's action has a destructive effect on user data.  AppKit may guard a destructive-actioned button against accidental presses, and may give the button a special appearance in certain contexts to caution against unintentional use.  Defaults to NO.
        #[unsafe(method(hasDestructiveAction))]
        #[unsafe(method_family = none)]
        pub unsafe fn hasDestructiveAction(&self) -> bool;

        /// Setter for [`hasDestructiveAction`][Self::hasDestructiveAction].
        #[unsafe(method(setHasDestructiveAction:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setHasDestructiveAction(&self, has_destructive_action: bool);

        #[cfg(feature = "NSSound")]
        /// The sound that plays when the user clicks the button, or nil if the button should not play a sound. The default value is nil.
        #[unsafe(method(sound))]
        #[unsafe(method_family = none)]
        pub unsafe fn sound(&self) -> Option<Retained<NSSound>>;

        #[cfg(feature = "NSSound")]
        /// Setter for [`sound`][Self::sound].
        #[unsafe(method(setSound:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSound(&self, sound: Option<&NSSound>);

        /// Sends action on deep-press or extended hover while dragging. Defaults to NO.
        #[unsafe(method(isSpringLoaded))]
        #[unsafe(method_family = none)]
        pub unsafe fn isSpringLoaded(&self) -> bool;

        /// Setter for [`isSpringLoaded`][Self::isSpringLoaded].
        #[unsafe(method(setSpringLoaded:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSpringLoaded(&self, spring_loaded: bool);

        /// Configures the maximum allowed level for an NSMultiLevelAcceleratorButton, allowed values range from [1,5]. Defaults to 2.
        #[unsafe(method(maxAcceleratorLevel))]
        #[unsafe(method_family = none)]
        pub unsafe fn maxAcceleratorLevel(&self) -> NSInteger;

        /// Setter for [`maxAcceleratorLevel`][Self::maxAcceleratorLevel].
        #[unsafe(method(setMaxAcceleratorLevel:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setMaxAcceleratorLevel(&self, max_accelerator_level: NSInteger);

        /// Sets the initial delay and repeat interval, in seconds, for repeated action messages sent when `continuous` is YES.
        #[unsafe(method(setPeriodicDelay:interval:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setPeriodicDelay_interval(&self, delay: c_float, interval: c_float);

        /// Gets the initial delay and repeat interval, in seconds, for repeated action messages sent when `continuous` is YES. Both parameters to this method must not be NULL.
        #[unsafe(method(getPeriodicDelay:interval:))]
        #[unsafe(method_family = none)]
        pub unsafe fn getPeriodicDelay_interval(
            &self,
            delay: NonNull<c_float>,
            interval: NonNull<c_float>,
        );

        #[cfg(feature = "NSButtonCell")]
        /// The bezel style of the button, which provides a set of bezel artwork, layout metrics, and content styling from a set of system-provided styles. See the NSBezelStyle enumeration for a list of available styles. The bezel style is not used if the `bordered` property is set to `NO`.
        #[unsafe(method(bezelStyle))]
        #[unsafe(method_family = none)]
        pub unsafe fn bezelStyle(&self) -> NSBezelStyle;

        #[cfg(feature = "NSButtonCell")]
        /// Setter for [`bezelStyle`][Self::bezelStyle].
        #[unsafe(method(setBezelStyle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBezelStyle(&self, bezel_style: NSBezelStyle);

        /// A Boolean value that determines whether the button draws a border.
        #[unsafe(method(isBordered))]
        #[unsafe(method_family = none)]
        pub unsafe fn isBordered(&self) -> bool;

        /// Setter for [`isBordered`][Self::isBordered].
        #[unsafe(method(setBordered:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBordered(&self, bordered: bool);

        /// A Boolean value that indicates whether the button is transparent. A transparent button never draws itself, but it receives mouse events, sends its action, and tracks the mouse properly.
        #[unsafe(method(isTransparent))]
        #[unsafe(method_family = none)]
        pub unsafe fn isTransparent(&self) -> bool;

        /// Setter for [`isTransparent`][Self::isTransparent].
        #[unsafe(method(setTransparent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTransparent(&self, transparent: bool);

        #[unsafe(method(showsBorderOnlyWhileMouseInside))]
        #[unsafe(method_family = none)]
        pub unsafe fn showsBorderOnlyWhileMouseInside(&self) -> bool;

        /// Setter for [`showsBorderOnlyWhileMouseInside`][Self::showsBorderOnlyWhileMouseInside].
        #[unsafe(method(setShowsBorderOnlyWhileMouseInside:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setShowsBorderOnlyWhileMouseInside(
            &self,
            shows_border_only_while_mouse_inside: bool,
        );

        #[cfg(feature = "NSColor")]
        /// Applies a custom color to the button's bezel, in appearances that support it. A nil value indicates an unmodified button appearance. The default value is nil.
        #[unsafe(method(bezelColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn bezelColor(&self) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`bezelColor`][Self::bezelColor].
        #[unsafe(method(setBezelColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setBezelColor(&self, bezel_color: Option<&NSColor>);

        #[cfg(feature = "NSColor")]
        /// Applies a tint color to template image and text content, in combination with other theme-appropriate effects. Only applicable to borderless buttons. A nil value indicates the standard set of effects without color modification. The default value is nil. Non-template images and attributed string values are not affected by the contentTintColor.
        #[unsafe(method(contentTintColor))]
        #[unsafe(method_family = none)]
        pub unsafe fn contentTintColor(&self) -> Option<Retained<NSColor>>;

        #[cfg(feature = "NSColor")]
        /// Setter for [`contentTintColor`][Self::contentTintColor].
        #[unsafe(method(setContentTintColor:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setContentTintColor(&self, content_tint_color: Option<&NSColor>);

        #[cfg(feature = "NSImage")]
        /// The image that appears on the button when it’s in an off state, or nil if there is no such image.
        #[unsafe(method(image))]
        #[unsafe(method_family = none)]
        pub unsafe fn image(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`image`][Self::image].
        #[unsafe(method(setImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImage(&self, image: Option<&NSImage>);

        #[cfg(feature = "NSImage")]
        /// An alternate image that appears on the button when the button is in an on state, or nil if there is no such image. Note that some button types do not display an alternate image.
        #[unsafe(method(alternateImage))]
        #[unsafe(method_family = none)]
        pub unsafe fn alternateImage(&self) -> Option<Retained<NSImage>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`alternateImage`][Self::alternateImage].
        #[unsafe(method(setAlternateImage:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAlternateImage(&self, alternate_image: Option<&NSImage>);

        #[cfg(feature = "NSCell")]
        /// The position of the button's image relative to its title. See the NSCellImagePosition enumeration for possible values.
        #[unsafe(method(imagePosition))]
        #[unsafe(method_family = none)]
        pub unsafe fn imagePosition(&self) -> NSCellImagePosition;

        #[cfg(feature = "NSCell")]
        /// Setter for [`imagePosition`][Self::imagePosition].
        #[unsafe(method(setImagePosition:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImagePosition(&self, image_position: NSCellImagePosition);

        #[cfg(feature = "NSCell")]
        /// The scaling mode applied to make the button's image fit within its bounds.
        #[unsafe(method(imageScaling))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageScaling(&self) -> NSImageScaling;

        #[cfg(feature = "NSCell")]
        /// Setter for [`imageScaling`][Self::imageScaling].
        #[unsafe(method(setImageScaling:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageScaling(&self, image_scaling: NSImageScaling);

        /// A Boolean value that determines how the button's image and title are positioned together within the button bezel. If false, the image is positioned according to the imagePosition property at the edge of the button bezel, and the title is positioned within the remaining space. If true, the button’s image is positioned directly adjacent to the title based on the imagePosition property, and the image and title are positioned within the button bezel as a single unit.
        #[unsafe(method(imageHugsTitle))]
        #[unsafe(method_family = none)]
        pub unsafe fn imageHugsTitle(&self) -> bool;

        /// Setter for [`imageHugsTitle`][Self::imageHugsTitle].
        #[unsafe(method(setImageHugsTitle:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setImageHugsTitle(&self, image_hugs_title: bool);

        #[cfg(feature = "NSImage")]
        /// Specifies a combination of point size, weight, and scale to use when sizing and displaying symbol images. If a symbol configuration isn't provided, the symbol is matched to the button's `font` property. The default value is nil.
        #[unsafe(method(symbolConfiguration))]
        #[unsafe(method_family = none)]
        pub unsafe fn symbolConfiguration(&self) -> Option<Retained<NSImageSymbolConfiguration>>;

        #[cfg(feature = "NSImage")]
        /// Setter for [`symbolConfiguration`][Self::symbolConfiguration].
        #[unsafe(method(setSymbolConfiguration:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setSymbolConfiguration(
            &self,
            symbol_configuration: Option<&NSImageSymbolConfiguration>,
        );

        #[cfg(feature = "NSCell")]
        /// The button's state. Buttons support the off and on states, and an additional mixed state depending on the value of the `allowsMixedState` property.
        #[unsafe(method(state))]
        #[unsafe(method_family = none)]
        pub unsafe fn state(&self) -> NSControlStateValue;

        #[cfg(feature = "NSCell")]
        /// Setter for [`state`][Self::state].
        #[unsafe(method(setState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setState(&self, state: NSControlStateValue);

        /// A Boolean value that indicates whether the button allows a mixed state. If NO, the button has two states (on and off), and if YES, the button has three states (on, off, and mixed). The mixed state is commonly used with checkboxes and radio buttons to indicate a value which is partially on.
        #[unsafe(method(allowsMixedState))]
        #[unsafe(method_family = none)]
        pub unsafe fn allowsMixedState(&self) -> bool;

        /// Setter for [`allowsMixedState`][Self::allowsMixedState].
        #[unsafe(method(setAllowsMixedState:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setAllowsMixedState(&self, allows_mixed_state: bool);

        /// Sets the button to its next eligible state. If the button allows mixed state, this cycles through the states in the order: on, off, mixed, on, etc. If the button does not allow mixed state, it toggles between off and on.
        #[unsafe(method(setNextState))]
        #[unsafe(method_family = none)]
        pub unsafe fn setNextState(&self);

        /// Highlights, or un-highlights, the button. Highlighting makes the button appear "pressed", which may include showing an illuminated bezel, or showing the alternate image or title, depending on the type of button.
        #[unsafe(method(highlight:))]
        #[unsafe(method_family = none)]
        pub unsafe fn highlight(&self, flag: bool);

        /// This property contains the button's key equivalent, or the empty string if no equivalent has been defined. Buttons don’t have a default key equivalent. Setting the key equivalent to the Return character causes it to act as the default button for its window.
        #[unsafe(method(keyEquivalent))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEquivalent(&self) -> Retained<NSString>;

        /// Setter for [`keyEquivalent`][Self::keyEquivalent].
        #[unsafe(method(setKeyEquivalent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyEquivalent(&self, key_equivalent: &NSString);

        #[cfg(feature = "NSEvent")]
        /// A bitmask specifying the modifier keys that are applied to the button's key equivalent. Mask bits are defined by the NSEventModifierFlags option set. The only mask bits relevant in button key-equivalent modifier masks are NSEventModifierFlagControl, NSEventModifierFlagOption, and NSEventModifierFlagCommand.
        #[unsafe(method(keyEquivalentModifierMask))]
        #[unsafe(method_family = none)]
        pub unsafe fn keyEquivalentModifierMask(&self) -> NSEventModifierFlags;

        #[cfg(feature = "NSEvent")]
        /// Setter for [`keyEquivalentModifierMask`][Self::keyEquivalentModifierMask].
        #[unsafe(method(setKeyEquivalentModifierMask:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setKeyEquivalentModifierMask(
            &self,
            key_equivalent_modifier_mask: NSEventModifierFlags,
        );

        #[cfg(feature = "NSEvent")]
        /// If the event parameter matches the button's key equivalent, the button briefly highlights and performs its action, and then returns YES. Otherwise, returns NO.
        #[unsafe(method(performKeyEquivalent:))]
        #[unsafe(method_family = none)]
        pub unsafe fn performKeyEquivalent(&self, key: &NSEvent) -> bool;

        #[cfg(feature = "NSUserInterfaceCompression")]
        #[unsafe(method(compressWithPrioritizedCompressionOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn compressWithPrioritizedCompressionOptions(
            &self,
            prioritized_options: &NSArray<NSUserInterfaceCompressionOptions>,
        );

        #[cfg(feature = "NSUserInterfaceCompression")]
        #[unsafe(method(minimumSizeWithPrioritizedCompressionOptions:))]
        #[unsafe(method_family = none)]
        pub unsafe fn minimumSizeWithPrioritizedCompressionOptions(
            &self,
            prioritized_options: &NSArray<NSUserInterfaceCompressionOptions>,
        ) -> NSSize;

        #[cfg(feature = "NSUserInterfaceCompression")]
        #[unsafe(method(activeCompressionOptions))]
        #[unsafe(method_family = none)]
        pub unsafe fn activeCompressionOptions(
            &self,
        ) -> Retained<NSUserInterfaceCompressionOptions>;
    );
}

/// Methods declared on superclass `NSControl`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSButton {
    extern_methods!(
        #[unsafe(method(initWithFrame:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithFrame(this: Allocated<Self>, frame_rect: NSRect) -> Retained<Self>;

        #[unsafe(method(initWithCoder:))]
        #[unsafe(method_family = init)]
        pub unsafe fn initWithCoder(
            this: Allocated<Self>,
            coder: &NSCoder,
        ) -> Option<Retained<Self>>;
    );
}

/// Methods declared on superclass `NSResponder`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSButton {
    extern_methods!(
        #[unsafe(method(init))]
        #[unsafe(method_family = init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;
    );
}

/// Methods declared on superclass `NSObject`.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSButton {
    extern_methods!(
        #[unsafe(method(new))]
        #[unsafe(method_family = new)]
        pub unsafe fn new(mtm: MainThreadMarker) -> Retained<Self>;
    );
}

/// NSButtonDeprecated.
#[cfg(all(feature = "NSControl", feature = "NSResponder", feature = "NSView"))]
impl NSButton {
    extern_methods!(
        #[deprecated = "Mnemonics are not used on macOS. Set the title property directly instead."]
        #[unsafe(method(setTitleWithMnemonic:))]
        #[unsafe(method_family = none)]
        pub unsafe fn setTitleWithMnemonic(&self, string_with_ampersand: Option<&NSString>);
    );
}
