package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDhcpOptionsSet invokes the vpc.DeleteDhcpOptionsSet API synchronously
func (client *Client) DeleteDhcpOptionsSet(request *DeleteDhcpOptionsSetRequest) (response *DeleteDhcpOptionsSetResponse, err error) {
	response = CreateDeleteDhcpOptionsSetResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDhcpOptionsSetWithChan invokes the vpc.DeleteDhcpOptionsSet API asynchronously
func (client *Client) DeleteDhcpOptionsSetWithChan(request *DeleteDhcpOptionsSetRequest) (<-chan *DeleteDhcpOptionsSetResponse, <-chan error) {
	responseChan := make(chan *DeleteDhcpOptionsSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDhcpOptionsSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDhcpOptionsSetWithCallback invokes the vpc.DeleteDhcpOptionsSet API asynchronously
func (client *Client) DeleteDhcpOptionsSetWithCallback(request *DeleteDhcpOptionsSetRequest, callback func(response *DeleteDhcpOptionsSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDhcpOptionsSetResponse
		var err error
		defer close(result)
		response, err = client.DeleteDhcpOptionsSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDhcpOptionsSetRequest is the request struct for api DeleteDhcpOptionsSet
type DeleteDhcpOptionsSetRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	DryRun               requests.Boolean `position:"Query" name:"DryRun"`
	DhcpOptionsSetId     string           `position:"Query" name:"DhcpOptionsSetId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteDhcpOptionsSetResponse is the response struct for api DeleteDhcpOptionsSet
type DeleteDhcpOptionsSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDhcpOptionsSetRequest creates a request to invoke DeleteDhcpOptionsSet API
func CreateDeleteDhcpOptionsSetRequest() (request *DeleteDhcpOptionsSetRequest) {
	request = &DeleteDhcpOptionsSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeleteDhcpOptionsSet", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteDhcpOptionsSetResponse creates a response to parse from DeleteDhcpOptionsSet response
func CreateDeleteDhcpOptionsSetResponse() (response *DeleteDhcpOptionsSetResponse) {
	response = &DeleteDhcpOptionsSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
