package tesladam

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ActionDiskMask invokes the tesladam.ActionDiskMask API synchronously
// api document: https://help.aliyun.com/api/tesladam/actiondiskmask.html
func (client *Client) ActionDiskMask(request *ActionDiskMaskRequest) (response *ActionDiskMaskResponse, err error) {
	response = CreateActionDiskMaskResponse()
	err = client.DoAction(request, response)
	return
}

// ActionDiskMaskWithChan invokes the tesladam.ActionDiskMask API asynchronously
// api document: https://help.aliyun.com/api/tesladam/actiondiskmask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ActionDiskMaskWithChan(request *ActionDiskMaskRequest) (<-chan *ActionDiskMaskResponse, <-chan error) {
	responseChan := make(chan *ActionDiskMaskResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ActionDiskMask(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ActionDiskMaskWithCallback invokes the tesladam.ActionDiskMask API asynchronously
// api document: https://help.aliyun.com/api/tesladam/actiondiskmask.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ActionDiskMaskWithCallback(request *ActionDiskMaskRequest, callback func(response *ActionDiskMaskResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ActionDiskMaskResponse
		var err error
		defer close(result)
		response, err = client.ActionDiskMask(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ActionDiskMaskRequest is the request struct for api ActionDiskMask
type ActionDiskMaskRequest struct {
	*requests.RpcRequest
	Op        string `position:"Query" name:"Op"`
	DiskMount string `position:"Query" name:"DiskMount"`
	Ip        string `position:"Query" name:"Ip"`
}

// ActionDiskMaskResponse is the response struct for api ActionDiskMask
type ActionDiskMaskResponse struct {
	*responses.BaseResponse
	Status  bool   `json:"Status" xml:"Status"`
	Message string `json:"Message" xml:"Message"`
	Result  string `json:"Result" xml:"Result"`
}

// CreateActionDiskMaskRequest creates a request to invoke ActionDiskMask API
func CreateActionDiskMaskRequest() (request *ActionDiskMaskRequest) {
	request = &ActionDiskMaskRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("TeslaDam", "2018-01-18", "ActionDiskMask", "tesladam", "openAPI")
	return
}

// CreateActionDiskMaskResponse creates a response to parse from ActionDiskMask response
func CreateActionDiskMaskResponse() (response *ActionDiskMaskResponse) {
	response = &ActionDiskMaskResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
