package imm

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RefreshOfficePreviewToken invokes the imm.RefreshOfficePreviewToken API synchronously
func (client *Client) RefreshOfficePreviewToken(request *RefreshOfficePreviewTokenRequest) (response *RefreshOfficePreviewTokenResponse, err error) {
	response = CreateRefreshOfficePreviewTokenResponse()
	err = client.DoAction(request, response)
	return
}

// RefreshOfficePreviewTokenWithChan invokes the imm.RefreshOfficePreviewToken API asynchronously
func (client *Client) RefreshOfficePreviewTokenWithChan(request *RefreshOfficePreviewTokenRequest) (<-chan *RefreshOfficePreviewTokenResponse, <-chan error) {
	responseChan := make(chan *RefreshOfficePreviewTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RefreshOfficePreviewToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RefreshOfficePreviewTokenWithCallback invokes the imm.RefreshOfficePreviewToken API asynchronously
func (client *Client) RefreshOfficePreviewTokenWithCallback(request *RefreshOfficePreviewTokenRequest, callback func(response *RefreshOfficePreviewTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RefreshOfficePreviewTokenResponse
		var err error
		defer close(result)
		response, err = client.RefreshOfficePreviewToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RefreshOfficePreviewTokenRequest is the request struct for api RefreshOfficePreviewToken
type RefreshOfficePreviewTokenRequest struct {
	*requests.RpcRequest
	Project      string `position:"Query" name:"Project"`
	AccessToken  string `position:"Query" name:"AccessToken"`
	RefreshToken string `position:"Query" name:"RefreshToken"`
}

// RefreshOfficePreviewTokenResponse is the response struct for api RefreshOfficePreviewToken
type RefreshOfficePreviewTokenResponse struct {
	*responses.BaseResponse
	RefreshToken            string `json:"RefreshToken" xml:"RefreshToken"`
	RequestId               string `json:"RequestId" xml:"RequestId"`
	AccessToken             string `json:"AccessToken" xml:"AccessToken"`
	RefreshTokenExpiredTime string `json:"RefreshTokenExpiredTime" xml:"RefreshTokenExpiredTime"`
	AccessTokenExpiredTime  string `json:"AccessTokenExpiredTime" xml:"AccessTokenExpiredTime"`
}

// CreateRefreshOfficePreviewTokenRequest creates a request to invoke RefreshOfficePreviewToken API
func CreateRefreshOfficePreviewTokenRequest() (request *RefreshOfficePreviewTokenRequest) {
	request = &RefreshOfficePreviewTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("imm", "2017-09-06", "RefreshOfficePreviewToken", "imm", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRefreshOfficePreviewTokenResponse creates a response to parse from RefreshOfficePreviewToken response
func CreateRefreshOfficePreviewTokenResponse() (response *RefreshOfficePreviewTokenResponse) {
	response = &RefreshOfficePreviewTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
