import React from 'react';
import { Schema } from './Schema';
import { useConfig, useSpec } from '../../contexts';
import { CommonHelpers } from '../../helpers';
import { SCHEMAS_TEXT } from '../../constants';
export var Schemas = function () {
    var asyncapi = useSpec();
    var config = useConfig();
    var schemas = !asyncapi.components().isEmpty() && asyncapi.components().schemas().all();
    if (!schemas || schemas.length === 0) {
        return null;
    }
    return (React.createElement("section", { id: "".concat(CommonHelpers.getIdentifier('schemas', config)), className: "mt-16" },
        React.createElement("h2", { className: "2xl:w-7/12 text-3xl font-light mb-4 px-8" }, SCHEMAS_TEXT),
        React.createElement("ul", null, schemas.map(function (schema) { return (React.createElement("li", { className: "mb-4", key: schema.id(), id: CommonHelpers.getIdentifier("schema-".concat(schema.id()), config) },
            React.createElement(Schema, { schemaName: schema.id(), schema: schema }))); }))));
};
//# sourceMappingURL=Schemas.js.map