/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.react;

import com.intellij.javascript.library.JSLibraryVersions;
import com.intellij.lang.ecmascript6.psi.ES6ImportExportDeclaration;
import com.intellij.lang.ecmascript6.psi.impl.ES6ImportPsiUtil;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.modules.JSImportCandidateDescriptor;
import com.intellij.lang.javascript.modules.JSImportPlaceInfo;
import com.intellij.lang.javascript.modules.imports.JSImportCandidate;
import com.intellij.lang.javascript.modules.imports.JSImportCandidatesBase;
import com.intellij.lang.javascript.modules.imports.JSImportExportType;
import com.intellij.lang.javascript.modules.imports.providers.JSCandidatesProcessor;
import com.intellij.lang.javascript.modules.imports.providers.JSImportCandidatesProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import com.intellij.util.text.SemVer;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReactHardcodedCandidatesProvider
extends JSImportCandidatesBase {
    private static final Map<String, HardcodedImport> HARDCODED_NAME_TO_MODULE = Map.of("React", new HardcodedImport("react", false, false), "PropTypes", new HardcodedImport("prop-types", false, false), "Fragment", new HardcodedImport("react", true, true));

    public ReactHardcodedCandidatesProvider(@NotNull JSImportPlaceInfo placeInfo) {
        if (placeInfo == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(0);
        }
        super(placeInfo);
    }

    public void processCandidates(@NotNull String name, @NotNull JSCandidatesProcessor processor) {
        HardcodedImport info;
        if (name == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(1);
        }
        if (processor == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(2);
        }
        if ((info = HARDCODED_NAME_TO_MODULE.get(name)) != null) {
            if (!info.myComponent && this.myPlaceInfo.getImportContext() == JSImportPlaceInfo.ImportContext.TAG || this.myPlaceInfo.getImportContext() == JSImportPlaceInfo.ImportContext.BINDING && info.mySpecifier) {
                return;
            }
            processor.processCandidate(this.getExplicitModuleIfExists(name, info));
        }
    }

    public void collectNames(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(3);
        }
        HARDCODED_NAME_TO_MODULE.keySet().forEach(consumer);
    }

    @Nullable
    private JSImportCandidate getExplicitModuleIfExists(@NotNull String referenceName, @NotNull HardcodedImport info) {
        if (referenceName == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(4);
        }
        if (info == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(5);
        }
        if (!this.checkResolution(referenceName, info)) {
            return null;
        }
        return new JSImportCandidateDescriptor(info.myModuleName, referenceName, null, ES6ImportExportDeclaration.ImportExportPrefixKind.IMPORT, (JSImportExportType)(info.mySpecifier ? ES6ImportPsiUtil.ImportExportType.SPECIFIER : ES6ImportPsiUtil.ImportExportType.DEFAULT)){

            public int getPriority() {
                return 2;
            }
        };
    }

    private boolean checkResolution(@NotNull String referenceName, @NotNull HardcodedImport info) {
        ResolveResult[] results;
        SemVer reactVersion;
        if (referenceName == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(6);
        }
        if (info == null) {
            ReactHardcodedCandidatesProvider.$$$reportNull$$$0(7);
        }
        if (referenceName.equals("React") && (reactVersion = JSLibraryVersions.getLibraryVersion((PsiElement)this.myPlaceInfo.getPlace(), (String)"react")) != null && reactVersion.getMajor() >= 17) {
            return false;
        }
        String moduleName = info.myModuleName;
        Collection elements = JSFileReferencesUtil.resolveModuleReference((PsiElement)this.myPlaceInfo.getPlace(), (String)moduleName);
        if (elements.isEmpty()) {
            return false;
        }
        return !info.mySpecifier || (results = ES6PsiUtil.resolveSymbolInModules((String)referenceName, (PsiElement)this.myPlaceInfo.getPlace(), (Collection)elements)).length != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
        }
        objectArray2[1] = "com/intellij/react/ReactHardcodedCandidatesProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "processCandidates";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNames";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getExplicitModuleIfExists";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "checkResolution";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class HardcodedImport {
        @NotNull
        private final String myModuleName;
        private final boolean myComponent;
        private final boolean mySpecifier;

        private HardcodedImport(@NotNull String moduleName, boolean isComponent, boolean isSpecifier) {
            if (moduleName == null) {
                HardcodedImport.$$$reportNull$$$0(0);
            }
            this.myModuleName = moduleName;
            this.myComponent = isComponent;
            this.mySpecifier = isSpecifier;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/intellij/react/ReactHardcodedCandidatesProvider$HardcodedImport", "<init>"));
        }
    }

    public static class MyFactory
    implements JSImportCandidatesProvider.CandidatesFactory {
        @Nullable
        public JSImportCandidatesProvider createProvider(@NotNull JSImportPlaceInfo placeInfo) {
            if (placeInfo == null) {
                MyFactory.$$$reportNull$$$0(0);
            }
            if (placeInfo.isStrictTypeContext()) {
                return null;
            }
            return new ReactHardcodedCandidatesProvider(placeInfo);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placeInfo", "com/intellij/react/ReactHardcodedCandidatesProvider$MyFactory", "createProvider"));
        }
    }
}

