/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import com.jetbrains.python.debugger.FilterResult;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.PyDebugValueGroupsKt;
import com.jetbrains.python.debugger.PyFrameAccessor;
import com.jetbrains.python.debugger.PyXValueGroup;
import com.jetbrains.python.debugger.pydev.ProcessDebugger;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000X\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u001aH\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u001a2\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00120\u00112\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004H\u0002\u001aP\u0010\u0016\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001\u001a(\u0010 \u001a\u00020\u000f2\u0014\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u001a\u0018\u00010\u00192\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\"\u0010!\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0002\u001a\u001a\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u000f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001a\u0010\"\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006%"}, d2={"DUNDER_LEN", "", "DUNDER_EX", "PROTECTED_ATTRS_EXCLUDED", "", "getPROTECTED_ATTRS_EXCLUDED", "()Ljava/util/Set;", "extractChildrenToGroup", "", "groupName", "icon", "Ljavax/swing/Icon;", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "children", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "predicate", "Lkotlin/Function1;", "", "excludedNames", "filterChildren", "Lcom/jetbrains/python/debugger/FilterResult;", "addGroupValues", "groupIcon", "groupElements", "", "Lcom/intellij/xdebugger/frame/XValue;", "myDebugProcess", "Lcom/jetbrains/python/debugger/PyFrameAccessor;", "groupType", "Lcom/jetbrains/python/debugger/pydev/ProcessDebugger$GROUP_TYPE;", "nameSuffix", "getDefaultGroupNodes", "getSpecialGroupNodes", "addSuffix", "list", "name", "intellij.python.pydev"})
public final class PyDebugValueGroupsKt {
    @NotNull
    public static final String DUNDER_LEN = "__len__";
    @NotNull
    public static final String DUNDER_EX = "__exception__";
    @NotNull
    private static final Set<String> PROTECTED_ATTRS_EXCLUDED;

    @NotNull
    public static final Set<String> getPROTECTED_ATTRS_EXCLUDED() {
        return PROTECTED_ATTRS_EXCLUDED;
    }

    public static final void extractChildrenToGroup(@NotNull String groupName, @NotNull Icon icon, @NotNull XCompositeNode node, @NotNull XValueChildrenList children2, @NotNull Function1<? super String, Boolean> predicate, @NotNull Set<String> excludedNames) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)children2, (String)"children");
        Intrinsics.checkNotNullParameter(predicate, (String)"predicate");
        Intrinsics.checkNotNullParameter(excludedNames, (String)"excludedNames");
        FilterResult filterResult = PyDebugValueGroupsKt.filterChildren(children2, predicate, excludedNames);
        node.addChildren(filterResult.getFilteredChildren(), filterResult.getGroupElements().isEmpty());
        PyDebugValueGroupsKt.addGroupValues(groupName, icon, node, filterResult.getGroupElements(), null, ProcessDebugger.GROUP_TYPE.DEFAULT, null);
    }

    private static final FilterResult filterChildren(XValueChildrenList children2, Function1<? super String, Boolean> predicate, Set<String> excludedNames) {
        FilterResult result2 = new FilterResult();
        int n = children2.size();
        for (int i = 0; i < n; ++i) {
            XValue value = children2.getValue(i);
            String name2 = children2.getName(i);
            if (!(value instanceof PyDebugValue)) continue;
            String string = ((PyDebugValue)value).getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            if (((Boolean)predicate.invoke((Object)string)).booleanValue() && !excludedNames.contains(((PyDebugValue)value).getName())) {
                result2.getGroupElements().put(name2, value);
                continue;
            }
            result2.getFilteredChildren().add(name2, value);
        }
        return result2;
    }

    public static final void addGroupValues(@NotNull String groupName, @NotNull Icon groupIcon, @NotNull XCompositeNode node, @Nullable Map<String, ? extends XValue> groupElements, @Nullable PyFrameAccessor myDebugProcess, @NotNull ProcessDebugger.GROUP_TYPE groupType, @Nullable String nameSuffix) {
        Intrinsics.checkNotNullParameter((Object)groupName, (String)"groupName");
        Intrinsics.checkNotNullParameter((Object)groupIcon, (String)"groupIcon");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)((Object)groupType), (String)"groupType");
        PyXValueGroup group2 = new PyXValueGroup(groupName, groupType, groupElements, nameSuffix, myDebugProcess, groupIcon){
            final /* synthetic */ ProcessDebugger.GROUP_TYPE $groupType;
            final /* synthetic */ Map<String, XValue> $groupElements;
            final /* synthetic */ String $nameSuffix;
            final /* synthetic */ PyFrameAccessor $myDebugProcess;
            final /* synthetic */ Icon $groupIcon;
            {
                this.$groupType = $groupType;
                this.$groupElements = $groupElements;
                this.$nameSuffix = $nameSuffix;
                this.$myDebugProcess = $myDebugProcess;
                this.$groupIcon = $groupIcon;
                super($groupName, $groupType);
            }

            public void computeChildren(XCompositeNode node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.isObsolete()) {
                    return;
                }
                ApplicationManager.getApplication().executeOnPooledThread(() -> addGroupValues.group.1.computeChildren$lambda$2(this.$groupType, this.$groupElements, this.$nameSuffix, this.$myDebugProcess, node));
            }

            public Icon getIcon() {
                return this.$groupIcon;
            }

            private static final void computeChildren$lambda$2(ProcessDebugger.GROUP_TYPE $groupType, Map $groupElements, String $nameSuffix, PyFrameAccessor $myDebugProcess, XCompositeNode $node) {
                block4: {
                    XValueChildrenList list;
                    PyFrameAccessor it;
                    XValueChildrenList xValueChildrenList;
                    if ($groupType == ProcessDebugger.GROUP_TYPE.DEFAULT) {
                        xValueChildrenList = PyDebugValueGroupsKt.access$getDefaultGroupNodes($groupElements, $nameSuffix);
                    } else {
                        PyFrameAccessor pyFrameAccessor = $myDebugProcess;
                        if (pyFrameAccessor != null) {
                            it = pyFrameAccessor;
                            boolean bl = false;
                            xValueChildrenList = PyDebugValueGroupsKt.access$getSpecialGroupNodes(it, $nameSuffix, $groupType);
                        } else {
                            xValueChildrenList = null;
                        }
                    }
                    XValueChildrenList xValueChildrenList2 = list = xValueChildrenList;
                    if (xValueChildrenList2 == null) break block4;
                    it = xValueChildrenList2;
                    boolean bl = false;
                    $node.addChildren(list, true);
                }
            }
        };
        node.addChildren(XValueChildrenList.bottomGroup((XValueGroup)group2), true);
    }

    private static final XValueChildrenList getDefaultGroupNodes(Map<String, ? extends XValue> groupElements, String nameSuffix) {
        XValueChildrenList list;
        block1: {
            list = new XValueChildrenList();
            Map<String, ? extends XValue> map2 = groupElements;
            if (map2 == null) break block1;
            Map<String, ? extends XValue> it = map2;
            boolean bl = false;
            for (Map.Entry<String, ? extends XValue> entry : groupElements.entrySet()) {
                String key = entry.getKey();
                XValue value = entry.getValue();
                String name2 = PyDebugValueGroupsKt.addSuffix(key, nameSuffix);
                list.add(name2, value);
            }
        }
        return list;
    }

    private static final XValueChildrenList getSpecialGroupNodes(PyFrameAccessor myDebugProcess, String nameSuffix, ProcessDebugger.GROUP_TYPE groupType) {
        XValueChildrenList xValueChildrenList = myDebugProcess.loadSpecialVariables(groupType);
        if (xValueChildrenList == null) {
            xValueChildrenList = new XValueChildrenList();
        }
        return PyDebugValueGroupsKt.addSuffix(xValueChildrenList, nameSuffix);
    }

    private static final XValueChildrenList addSuffix(XValueChildrenList list, String nameSuffix) {
        if (nameSuffix != null) {
            String it = nameSuffix;
            boolean bl = false;
            XValueChildrenList result2 = new XValueChildrenList();
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                XValue value = list.getValue(i);
                String name2 = list.getName(i);
                Intrinsics.checkNotNull((Object)name2);
                result2.add(PyDebugValueGroupsKt.addSuffix(name2, it), value);
            }
            return result2;
        }
        return list;
    }

    private static final String addSuffix(String name2, String nameSuffix) {
        String string = nameSuffix;
        return string == null ? name2 : name2 + string;
    }

    public static final /* synthetic */ XValueChildrenList access$getSpecialGroupNodes(PyFrameAccessor myDebugProcess, String nameSuffix, ProcessDebugger.GROUP_TYPE groupType) {
        return PyDebugValueGroupsKt.getSpecialGroupNodes(myDebugProcess, nameSuffix, groupType);
    }

    public static final /* synthetic */ XValueChildrenList access$getDefaultGroupNodes(Map groupElements, String nameSuffix) {
        return PyDebugValueGroupsKt.getDefaultGroupNodes(groupElements, nameSuffix);
    }

    static {
        Object[] objectArray = new String[]{DUNDER_LEN, DUNDER_EX};
        PROTECTED_ATTRS_EXCLUDED = SetsKt.setOf((Object[])objectArray);
    }
}

