/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.django.model.applications.DjangoApplicationModel;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.model.modelApi.DjangoModelClass;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyImportElement;
import com.jetbrains.python.psi.PyImportedNameDefiner;
import com.jetbrains.python.psi.PyStarImportElement;
import com.jetbrains.python.psi.PyTypedElement;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.TypeEvalContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DjangoUnresolvedReferenceSkipper
extends PyInspectionExtension {
    public boolean ignoreUnusedImports(@NotNull PyImportedNameDefiner importNameDefiner) {
        VirtualFile fileWithImport;
        DjangoModelApi modelApi;
        if (importNameDefiner == null) {
            DjangoUnresolvedReferenceSkipper.$$$reportNull$$$0(0);
        }
        if ((modelApi = (DjangoModelApi)DjangoModelApi.create((PyElement)importNameDefiner).getSuccessOrNull()) == null) {
            return false;
        }
        boolean starImport = importNameDefiner instanceof PyStarImportElement;
        PyImportElement importElementNameDefiner = null;
        if (!starImport) {
            if (!(importNameDefiner instanceof PyImportElement)) {
                return false;
            }
            importElementNameDefiner = (PyImportElement)importNameDefiner;
        }
        if ((fileWithImport = importNameDefiner.getContainingFile().getVirtualFile()).equals(modelApi.getSettingsFile())) {
            return true;
        }
        for (DjangoApplicationModel djangoApp : modelApi.getApplications()) {
            PyFile djangoModelFile = djangoApp.getModel();
            if (djangoModelFile == null || !djangoModelFile.getVirtualFile().equals(fileWithImport)) continue;
            return starImport || DjangoUnresolvedReferenceSkipper.skipImportInModelFile(importElementNameDefiner);
        }
        PyFile urlsFile = modelApi.getURLConfFile();
        if (urlsFile != null && urlsFile.getVirtualFile().equals(fileWithImport)) {
            return starImport || "urlpatterns".equals(importElementNameDefiner.getVisibleName());
        }
        return false;
    }

    private static boolean skipImportInModelFile(@NotNull PyImportElement nameDefiner) {
        PyClassType importedClass;
        if (nameDefiner == null) {
            DjangoUnresolvedReferenceSkipper.$$$reportNull$$$0(1);
        }
        if ((importedClass = DjangoUnresolvedReferenceSkipper.getImportedClass(nameDefiner)) == null) {
            return false;
        }
        return DjangoModelClass.isModelClass((PyClass)importedClass.getPyClass(), null);
    }

    @Nullable
    private static PyClassType getImportedClass(@NotNull PyImportElement nameDefiner) {
        PyTypedElement referenceExpression;
        if (nameDefiner == null) {
            DjangoUnresolvedReferenceSkipper.$$$reportNull$$$0(2);
        }
        if ((referenceExpression = (PyTypedElement)PyUtil.as((Object)nameDefiner.getImportReferenceExpression(), PyTypedElement.class)) == null) {
            return null;
        }
        return (PyClassType)PyUtil.as((Object)TypeEvalContext.deepCodeInsight((Project)nameDefiner.getProject()).getType(referenceExpression), PyClassType.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "importNameDefiner";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameDefiner";
                break;
            }
        }
        objectArray2[1] = "com/intellij/python/django/DjangoUnresolvedReferenceSkipper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreUnusedImports";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "skipImportInModelFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportedClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

