/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.lsp.JSServiceSetActivationRule;
import com.intellij.lang.typescript.lsp.LspServerLoader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.lang.html.VueFileTypeKt;
import org.jetbrains.vuejs.lang.typescript.service.VueLspServerLoader;
import org.jetbrains.vuejs.lang.typescript.service.VueServicesKt;
import org.jetbrains.vuejs.options.VueServiceSettings;
import org.jetbrains.vuejs.options.VueSettingsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0007H\u0014J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0014\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueServiceSetActivationRule;", "Lcom/intellij/lang/typescript/lsp/JSServiceSetActivationRule;", "<init>", "()V", "isFileAcceptableForLspServer", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "isProjectContext", "project", "Lcom/intellij/openapi/project/Project;", "context", "isEnabledInSettings", "intellij.vuejs"})
public final class VueServiceSetActivationRule
extends JSServiceSetActivationRule {
    @NotNull
    public static final VueServiceSetActivationRule INSTANCE = new VueServiceSetActivationRule();

    private VueServiceSetActivationRule() {
        super((LspServerLoader)VueLspServerLoader.INSTANCE, null);
    }

    public boolean isFileAcceptableForLspServer(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!TypeScriptLanguageServiceUtil.IS_VALID_FILE_FOR_SERVICE.value((Object)file)) {
            return false;
        }
        return VueFileTypeKt.isVueFile(file) || TypeScriptLanguageServiceUtil.ACCEPTABLE_TS_FILE.value((Object)file);
    }

    protected boolean isProjectContext(@NotNull Project project, @NotNull VirtualFile context) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return VueServicesKt.access$isVueServiceContext(project, context);
    }

    protected boolean isEnabledInSettings(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return switch (WhenMappings.$EnumSwitchMapping$0[VueSettingsKt.getVueSettings(project).getServiceType().ordinal()]) {
            case 1, 2 -> true;
            case 3 -> false;
            case 4 -> false;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VueServiceSettings.values().length];
            try {
                nArray[VueServiceSettings.AUTO.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.VOLAR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.TS_SERVICE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VueServiceSettings.DISABLED.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

