/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.scientific.console.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PlatformUtils;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.codeInsight.completion.PyRuntimeCompletionRetrievalService;
import com.jetbrains.python.console.DescriptorType;
import com.jetbrains.python.console.PyExecuteConsoleCustomizer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/intellij/python/scientific/console/completion/PyConsoleRuntimeCompletionRetrievalService;", "Lcom/jetbrains/python/codeInsight/completion/PyRuntimeCompletionRetrievalService;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "canComplete", "", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "intellij.python.scientific"})
public final class PyConsoleRuntimeCompletionRetrievalService
implements PyRuntimeCompletionRetrievalService {
    @NotNull
    private final Project project;

    public PyConsoleRuntimeCompletionRetrievalService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public boolean canComplete(@NotNull CompletionParameters parameters) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        if (!PlatformUtils.isDataSpell()) {
            return false;
        }
        if (!(parameters.getOriginalFile().getVirtualFile().getFileType() instanceof PythonFileType)) {
            return false;
        }
        VirtualFile virtualFile = parameters.getOriginalFile().getVirtualFile();
        if (!(virtualFile.getFileType() instanceof PythonFileType)) {
            return false;
        }
        PyExecuteConsoleCustomizer pyExecuteConsoleCustomizer = PyExecuteConsoleCustomizer.Companion.getInstance();
        Intrinsics.checkNotNull((Object)virtualFile);
        return pyExecuteConsoleCustomizer.getCustomDescriptorType(virtualFile) != DescriptorType.NON_INTERACTIVE;
    }
}

