/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.api;

import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.BaseSvnClient;
import org.jetbrains.idea.svn.api.VersionClient;
import org.jetbrains.idea.svn.commandLine.Command;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.commandLine.SvnCommandName;

public class CmdVersionClient
extends BaseSvnClient
implements VersionClient {
    private static final Pattern VERSION = Pattern.compile("^(\\d+)\\.(\\d+)\\.(\\d+)");
    private static final int COMMAND_TIMEOUT = 30000;

    @Override
    @NotNull
    public Version getVersion() throws SvnBindException {
        return CmdVersionClient.parseVersion(this.runCommand(true));
    }

    @NotNull
    public ProcessOutput runCommand(boolean quiet) throws SvnBindException {
        Command command = new Command(SvnCommandName.version);
        if (quiet) {
            command.put("--quiet");
        }
        ProcessOutput processOutput = this.newRuntime(this.myVcs).runLocal(command, 30000).getProcessOutput();
        if (processOutput == null) {
            CmdVersionClient.$$$reportNull$$$0(0);
        }
        return processOutput;
    }

    @NotNull
    private static Version parseVersion(@NotNull ProcessOutput output) throws SvnBindException {
        if (output == null) {
            CmdVersionClient.$$$reportNull$$$0(1);
        }
        if (output.isTimeout()) {
            throw new SvnBindException(SvnBundle.message("error.could.not.get.svn.version", output.getExitCode(), output.getStderr()));
        }
        return CmdVersionClient.parseVersion(output.getStdout());
    }

    @NotNull
    public static Version parseVersion(@NlsSafe @NotNull String versionText) throws SvnBindException {
        if (versionText == null) {
            CmdVersionClient.$$$reportNull$$$0(2);
        }
        Version result = null;
        NumberFormatException cause = null;
        Matcher matcher = VERSION.matcher(versionText);
        boolean found = matcher.find();
        if (found) {
            try {
                result = new Version(CmdVersionClient.getInt(matcher.group(1)), CmdVersionClient.getInt(matcher.group(2)), CmdVersionClient.getInt(matcher.group(3)));
            }
            catch (NumberFormatException e) {
                cause = e;
            }
        }
        if (!found || cause != null) {
            throw new SvnBindException(SvnBundle.message("error.could.not.parse.svn.version", versionText), cause);
        }
        Version version = result;
        if (version == null) {
            CmdVersionClient.$$$reportNull$$$0(3);
        }
        return version;
    }

    private static int getInt(@NotNull String value) {
        if (value == null) {
            CmdVersionClient.$$$reportNull$$$0(4);
        }
        return Integer.parseInt(value);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/api/CmdVersionClient";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "runCommand";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/api/CmdVersionClient";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseVersion";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseVersion";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getInt";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 4 -> new IllegalArgumentException(string);
        };
    }
}

