/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gateway.ssh.deploy;

import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0005\u000e\u000f\u0010\u0011\u0012B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016R\u0012\u0010\u0004\u001a\u00020\u0005X\u00a0\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u0082\u0001\u0002\u0013\u0014\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;", "", "<init>", "()V", "rawValue", "", "getRawValue$intellij_gateway_core", "()Ljava/lang/String;", "equals", "", "other", "hashCode", "", "toString", "SimpleShellArgument", "PlainText", "Substituted", "ShellPipeline", "RemotePath", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$SimpleShellArgument;", "intellij.gateway.core"})
public abstract class ShellArgument {
    private ShellArgument() {
    }

    @NotNull
    public abstract String getRawValue$intellij_gateway_core();

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ShellArgument)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.getRawValue$intellij_gateway_core(), (Object)((ShellArgument)other).getRawValue$intellij_gateway_core());
    }

    public int hashCode() {
        return this.getRawValue$intellij_gateway_core().hashCode() ^ this.getClass().hashCode();
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getRawValue$intellij_gateway_core() + ")";
    }

    public /* synthetic */ ShellArgument(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$PlainText;", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$SimpleShellArgument;", "value", "", "<init>", "(Ljava/lang/String;)V", "intellij.gateway.core"})
    public static final class PlainText
    extends SimpleShellArgument {
        public PlainText(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0012\u001a\u00020\u0013J\u0016\u0010\u0014\u001a\u00020\u00002\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003H&J!\u0010\u0019\u001a\u00020\u00002\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001a\"\u00020\u0001H&\u00a2\u0006\u0002\u0010\u001bJ\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\rH\u0086\u0002J\u0011\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0001H\u0086\u0002J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0000J\b\u0010!\u001a\u00020\rH\u0016R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\rX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0012\u0010\u0016\u001a\u00020\u0017X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0018R\u001b\u0010\u001d\u001a\u00020\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001f\u0010 \u001a\u0004\b\u001e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;", "segments", "", "pathSeparator", "", "<init>", "(Ljava/util/List;C)V", "getSegments", "()Ljava/util/List;", "getPathSeparator", "()C", "rawValue", "", "getRawValue$intellij_gateway_core", "()Ljava/lang/String;", "rawValueProtected", "getRawValueProtected", "flatten", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$SimpleShellArgument;", "join", "other", "isRooted", "", "()Z", "makeNew", "", "([Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;)Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath;", "div", "segmentsDump", "getSegmentsDump", "segmentsDump$delegate", "Lkotlin/Lazy;", "toString", "intellij.gateway.core"})
    @SourceDebugExtension(value={"SMAP\nShellArgument.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ShellArgument.kt\ncom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,134:1\n1755#2,3:135\n*S KotlinDebug\n*F\n+ 1 ShellArgument.kt\ncom/jetbrains/gateway/ssh/deploy/ShellArgument$RemotePath\n*L\n75#1:135,3\n*E\n"})
    public static abstract class RemotePath
    extends ShellArgument {
        @NotNull
        private final List<ShellArgument> segments;
        private final char pathSeparator;
        @NotNull
        private final String rawValue;
        @NotNull
        private final String rawValueProtected;
        @NotNull
        private final Lazy segmentsDump$delegate;

        public RemotePath(@NotNull List<? extends ShellArgument> segments, char pathSeparator) {
            Intrinsics.checkNotNullParameter(segments, (String)"segments");
            super(null);
            this.segments = segments;
            this.pathSeparator = pathSeparator;
            this.segmentsDump$delegate = LazyKt.lazy(() -> RemotePath.segmentsDump_delegate$lambda$1(this));
            if (this.segments.isEmpty()) {
                throw new IllegalStateException("Remote path should not be empty".toString());
            }
            boolean substitutedMarker = false;
            List visitedPaths = CollectionsKt.emptyList();
            StringBuilder result2 = new StringBuilder();
            Object object = ((Iterable)this.segments).iterator();
            int n = 0;
            while (object.hasNext()) {
                int i = n++;
                ShellArgument segment = (ShellArgument)object.next();
                if (i == 0) continue;
                if (((CharSequence)segment.getRawValue$intellij_gateway_core()).length() == 0) {
                    throw new IllegalStateException(("Remote path cannot contain empty segments. " + this.getSegmentsDump()).toString());
                }
                Object object2 = new char[]{this.pathSeparator};
                String rawTrimmed = StringsKt.trim((String)segment.getRawValue$intellij_gateway_core(), (char[])object2);
                object2 = segment;
                if (object2 instanceof RemotePath) {
                    boolean bl;
                    block17: {
                        Iterable $this$any$iv = visitedPaths;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                RemotePath it = (RemotePath)element$iv;
                                boolean bl2 = false;
                                if (!(it == segment)) continue;
                                bl = true;
                                break block17;
                            }
                            bl = false;
                        }
                    }
                    if (bl) {
                        throw new IllegalStateException(("Remote path cannot be recursive. " + this.getSegmentsDump()).toString());
                    }
                    v1 = result2.append(rawTrimmed);
                } else if (object2 instanceof Substituted) {
                    substitutedMarker = true;
                    v1 = result2.append(rawTrimmed);
                } else if (object2 instanceof PlainText) {
                    v1 = result2.append(rawTrimmed);
                } else {
                    if (object2 instanceof ShellPipeline) {
                        throw new IllegalStateException(("Remote path should not contain pipelined arguments. " + this.getSegmentsDump()).toString());
                    }
                    throw new IllegalStateException(("Unsupported path segment type: " + segment.getClass().getSimpleName() + ". " + this.getSegmentsDump()).toString());
                }
                if (i == this.segments.size() - 1) continue;
                result2.append(this.pathSeparator);
            }
            if (this.segments.size() > 1) {
                result2.insert(0, this.pathSeparator);
            }
            object = new char[1];
            object[0] = this.pathSeparator;
            result2.insert(0, StringsKt.trimEnd((String)((ShellArgument)CollectionsKt.first(this.segments)).getRawValue$intellij_gateway_core(), (char[])object));
            if (StringsKt.endsWith$default((CharSequence)((ShellArgument)CollectionsKt.last(this.segments)).getRawValue$intellij_gateway_core(), (char)this.pathSeparator, (boolean)false, (int)2, null)) {
                result2.append(this.pathSeparator);
            }
            this.rawValue = result2.toString();
            if (((CharSequence)this.rawValue).length() == 0) {
                throw new IllegalStateException(("Should not use empty paths. " + this.getSegmentsDump()).toString());
            }
            this.rawValueProtected = this.rawValue;
        }

        @NotNull
        public final List<ShellArgument> getSegments() {
            return this.segments;
        }

        public final char getPathSeparator() {
            return this.pathSeparator;
        }

        @Override
        @NotNull
        public final String getRawValue$intellij_gateway_core() {
            return this.rawValue;
        }

        @NotNull
        protected final String getRawValueProtected() {
            return this.rawValueProtected;
        }

        @NotNull
        public final SimpleShellArgument flatten() {
            return new PlainText(this.rawValue);
        }

        @NotNull
        public abstract RemotePath join(@NotNull List<? extends ShellArgument> var1);

        public abstract boolean isRooted();

        @NotNull
        public abstract RemotePath makeNew(ShellArgument ... var1);

        @NotNull
        public final RemotePath div(@NotNull RemotePath other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.join(other);
        }

        @NotNull
        public final RemotePath div(@NotNull String other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.join(CollectionsKt.listOf((Object)new PlainText(other)));
        }

        @NotNull
        public final RemotePath div(@NotNull ShellArgument other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            return this.join(CollectionsKt.listOf((Object)other));
        }

        @NotNull
        public final RemotePath join(@NotNull RemotePath other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!Intrinsics.areEqual(other.getClass(), this.getClass())) {
                throw new IllegalStateException("Should not join different path classes".toString());
            }
            return this.join(other.segments);
        }

        private final String getSegmentsDump() {
            Lazy lazy = this.segmentsDump$delegate;
            return (String)lazy.getValue();
        }

        @Override
        @NotNull
        public String toString() {
            return super.toString() + ", " + this.getSegmentsDump();
        }

        private static final CharSequence segmentsDump_delegate$lambda$1$lambda$0(ShellArgument it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return "'" + it + "'";
        }

        private static final String segmentsDump_delegate$lambda$1(RemotePath this$0) {
            return CollectionsKt.joinToString$default((Iterable)this$0.segments, (CharSequence)", ", (CharSequence)("Segments (" + this$0.segments.size() + "): "), null, (int)0, null, RemotePath::segmentsDump_delegate$lambda$1$lambda$0, (int)28, null);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$ShellPipeline;", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$SimpleShellArgument;", "value", "", "<init>", "(Ljava/lang/String;)V", "intellij.gateway.core"})
    public static final class ShellPipeline
    extends SimpleShellArgument {
        public ShellPipeline(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0090\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$SimpleShellArgument;", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument;", "rawValue", "", "<init>", "(Ljava/lang/String;)V", "getRawValue$intellij_gateway_core", "()Ljava/lang/String;", "intellij.gateway.core"})
    public static abstract class SimpleShellArgument
    extends ShellArgument {
        @NotNull
        private final String rawValue;

        public SimpleShellArgument(@NotNull String rawValue) {
            Intrinsics.checkNotNullParameter((Object)rawValue, (String)"rawValue");
            super(null);
            this.rawValue = rawValue;
        }

        @Override
        @NotNull
        public String getRawValue$intellij_gateway_core() {
            return this.rawValue;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$Substituted;", "Lcom/jetbrains/gateway/ssh/deploy/ShellArgument$SimpleShellArgument;", "value", "", "<init>", "(Ljava/lang/String;)V", "intellij.gateway.core"})
    public static final class Substituted
    extends SimpleShellArgument {
        public Substituted(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            super(value);
        }
    }
}

