/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import java.util.List;
import org.jetbrains.annotations.Nls;

public class DiagramConfigElement {
    @Nls
    private final String name;
    private final Object value;
    private final Type type;

    private DiagramConfigElement(@Nls String name, String value) {
        this.name = name;
        this.value = value;
        this.type = Type.TEXT;
    }

    public DiagramConfigElement(@Nls String name, boolean value) {
        this.name = name;
        this.value = value;
        this.type = Type.CHECKBOX;
    }

    private DiagramConfigElement(@Nls String name, List<String> value) {
        this.name = name;
        this.value = value;
        this.type = Type.COMBOBOX;
    }

    public Type getType() {
        return this.type;
    }

    @Nls
    public String getName() {
        return this.name;
    }

    public boolean isChecked() {
        return (Boolean)this.value;
    }

    public List<String> getList() {
        return (List)this.value;
    }

    public static enum Type {
        CHECKBOX,
        COMBOBOX,
        TEXT;

    }
}

