/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.table;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridSelection;
import com.intellij.database.datagrid.GridSelectionImpl;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.datagrid.SelectionModelWithViewColumns;
import com.intellij.database.datagrid.SelectionModelWithViewRows;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.database.run.ui.grid.selection.GridSelectionTrackerImpl;
import com.intellij.database.run.ui.table.TableResultView;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.IntUnaryOperator;
import javax.swing.ListSelectionModel;
import org.jetbrains.annotations.NotNull;

class TableSelectionModel
implements SelectionModel<GridRow, GridColumn>,
SelectionModelWithViewRows,
SelectionModelWithViewColumns {
    private final TableResultView myTable;
    private final DataGrid myGrid;
    private final GridSelectionTrackerImpl myTracker;

    TableSelectionModel(@NotNull TableResultView table2, @NotNull DataGrid grid) {
        if (table2 == null) {
            TableSelectionModel.$$$reportNull$$$0(0);
        }
        if (grid == null) {
            TableSelectionModel.$$$reportNull$$$0(1);
        }
        this.myTable = table2;
        this.myGrid = grid;
        this.myTracker = new GridSelectionTrackerImpl(this.myGrid, this.myTable);
        this.myTable.putClientProperty("SelectionModel", this);
    }

    @NotNull
    public GridSelectionImpl store() {
        int[] rows = TableSelectionModel.convert(this.myTable.getRowCount(), arg_0 -> this.myTable.convertRowIndexToModel(arg_0), this.myTable.getSelectedRows());
        int[] columns = TableSelectionModel.convert(this.myTable.getColumnCount(), arg_0 -> this.myTable.convertColumnIndexToModel(arg_0), this.myTable.getSelectedColumns());
        if (this.myTable.isTransposed()) {
            int[] temp = rows;
            rows = columns;
            columns = temp;
        }
        return new GridSelectionImpl((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])rows), (ModelIndexSet<GridColumn>)ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])columns));
    }

    @NotNull
    public GridSelectionTracker getTracker() {
        GridSelectionTrackerImpl gridSelectionTrackerImpl = this.myTracker;
        if (gridSelectionTrackerImpl == null) {
            TableSelectionModel.$$$reportNull$$$0(2);
        }
        return gridSelectionTrackerImpl;
    }

    public void setColumnSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getColumnModel().getSelectionModel(), false, this.myTable.getColumnCount() - 1, idx0, idx1);
    }

    public void addColumnSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getColumnModel().getSelectionModel(), true, this.myTable.getColumnCount() - 1, idx0, idx1);
    }

    public void setRowSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getSelectionModel(), false, this.myTable.getRowCount() - 1, idx0, idx1);
    }

    public void addRowSelectionInterval(int idx0, int idx1) {
        TableSelectionModel.setSelectionInterval(this.myTable.getSelectionModel(), true, this.myTable.getRowCount() - 1, idx0, idx1);
    }

    public void setColumnSelection(@NotNull ModelIndexSet<GridColumn> columns, boolean selectAtLeastOneCell) {
        if (columns == null) {
            TableSelectionModel.$$$reportNull$$$0(3);
        }
        ViewIndexSet viewIndexSet = columns.toView((CoreGrid)this.myGrid);
        this.setSelection(true, viewIndexSet.asArray());
        if (!selectAtLeastOneCell) {
            return;
        }
        GridSelectionImpl selection = this.store();
        if (selection.getSelectedRows().size() == 0) {
            int firstRow = this.myTable.getRawIndexConverter().row2Model().applyAsInt(0);
            this.setRowSelection((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[]{firstRow}), false);
        }
    }

    public void setColumnSelection(@NotNull ModelIndex<GridColumn> column, boolean selectAtLeastOneCell) {
        if (column == null) {
            TableSelectionModel.$$$reportNull$$$0(4);
        }
        this.setColumnSelection((ModelIndexSet<GridColumn>)ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])new int[]{column.value}), selectAtLeastOneCell);
    }

    public boolean isSelectionEmpty() {
        return this.myTable.getSelectionModel().isSelectionEmpty() || this.myTable.getColumnModel().getSelectionModel().isSelectionEmpty();
    }

    public boolean isSelected(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(5);
        }
        if (column == null) {
            TableSelectionModel.$$$reportNull$$$0(6);
        }
        return this.isSelected((ViewIndex<GridRow>)row.toView((CoreGrid)this.myGrid), (ViewIndex<GridColumn>)column.toView((CoreGrid)this.myGrid));
    }

    public boolean isSelected(@NotNull ViewIndex<GridRow> row, @NotNull ViewIndex<GridColumn> column) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(7);
        }
        if (column == null) {
            TableSelectionModel.$$$reportNull$$$0(8);
        }
        int displayRow = this.myTable.isTransposed() ? column.asInteger() : row.asInteger();
        int displayColumn = this.myTable.isTransposed() ? row.asInteger() : column.asInteger();
        return this.myTable.isRowSelected(displayRow) && this.myTable.isColumnSelected(displayColumn);
    }

    public boolean isSelectedColumn(@NotNull ModelIndex<GridColumn> column) {
        if (column == null) {
            TableSelectionModel.$$$reportNull$$$0(9);
        }
        ViewIndex colIdx = column.toView((CoreGrid)this.myGrid);
        int index = colIdx.asInteger();
        return this.myTable.isTransposed() ? this.myTable.isRowSelected(index) : this.myTable.isColumnSelected(index);
    }

    public boolean isSelectedRow(@NotNull ModelIndex<GridRow> row) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(10);
        }
        ViewIndex rowIdx = row.toView((CoreGrid)this.myGrid);
        int index = rowIdx.asInteger();
        return this.myTable.isTransposed() ? this.myTable.isColumnSelected(index) : this.myTable.isRowSelected(index);
    }

    public void setRowSelection(@NotNull ModelIndexSet<GridRow> rows, boolean selectAtLeastOneCell) {
        if (rows == null) {
            TableSelectionModel.$$$reportNull$$$0(11);
        }
        ViewIndexSet viewIndexSet = rows.toView((CoreGrid)this.myGrid);
        this.setSelection(false, viewIndexSet.asArray());
        if (!selectAtLeastOneCell) {
            return;
        }
        GridSelectionImpl selection = this.store();
        if (selection.getSelectedColumns().size() == 0) {
            int firstColumn = this.myTable.getRawIndexConverter().column2Model().applyAsInt(0);
            this.setColumnSelection((ModelIndexSet<GridColumn>)ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])new int[]{firstColumn}), false);
        }
    }

    public void setSelection(@NotNull ModelIndexSet<GridRow> rows, @NotNull ModelIndexSet<GridColumn> columns) {
        if (rows == null) {
            TableSelectionModel.$$$reportNull$$$0(12);
        }
        if (columns == null) {
            TableSelectionModel.$$$reportNull$$$0(13);
        }
        this.myTable.disableSelectionListeners(() -> {
            this.setRowSelection(rows, false);
            this.setColumnSelection(columns, false);
        });
        this.myTable.fireSelectionChanged();
    }

    public void setSelection(@NotNull ModelIndex<GridRow> row, @NotNull ModelIndex<GridColumn> column) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(14);
        }
        if (column == null) {
            TableSelectionModel.$$$reportNull$$$0(15);
        }
        this.myTable.disableSelectionListeners(() -> {
            this.setRowSelection(row, false);
            this.setColumnSelection(column, false);
        });
        this.myTable.fireSelectionChanged();
    }

    public void setRowSelection(@NotNull ModelIndex<GridRow> row, boolean selectAtLeastOneCell) {
        if (row == null) {
            TableSelectionModel.$$$reportNull$$$0(16);
        }
        this.setRowSelection((ModelIndexSet<GridRow>)ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])new int[]{row.value}), selectAtLeastOneCell);
    }

    public int getSelectedRowCount() {
        return this.myTable.isTransposed() ? this.myTable.getSelectedColumnCount() : this.myTable.getSelectedRowCount();
    }

    public int getSelectedColumnCount() {
        return this.myTable.isTransposed() ? this.myTable.getSelectedRowCount() : this.myTable.getSelectedColumnCount();
    }

    @NotNull
    public ModelIndex<GridRow> getSelectedRow() {
        int viewRowIndex = this.myTable.isTransposed() ? this.myTable.getSelectedColumn() : this.myTable.getSelectedRow();
        ModelIndex modelIndex = ViewIndex.forRow((CoreGrid)this.myGrid, (int)(viewRowIndex >= 0 ? viewRowIndex : -1)).toModel((CoreGrid)this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(17);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndexSet<GridRow> getSelectedRows() {
        ModelIndexSet modelIndexSet = ViewIndexSet.forRows((CoreGrid)this.myGrid, (int[])(this.myTable.isTransposed() ? this.myTable.getSelectedColumns() : this.myTable.getSelectedRows())).toModel((CoreGrid)this.myGrid);
        if (modelIndexSet == null) {
            TableSelectionModel.$$$reportNull$$$0(18);
        }
        return modelIndexSet;
    }

    @NotNull
    public ModelIndex<GridRow> getLeadSelectionRow() {
        int idx = this.myTable.isTransposed() ? this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex() : this.myTable.getSelectionModel().getLeadSelectionIndex();
        ModelIndex modelIndex = ViewIndex.forRow((CoreGrid)this.myGrid, (int)idx).toModel((CoreGrid)this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(19);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndex<GridColumn> getSelectedColumn() {
        ModelIndex modelIndex = ViewIndex.forColumn((CoreGrid)this.myGrid, (int)(this.myTable.isTransposed() ? this.myTable.getSelectedRow() : this.myTable.getSelectedColumn())).toModel((CoreGrid)this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(20);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndex<GridColumn> getLeadSelectionColumn() {
        int idx = this.myTable.isTransposed() ? this.myTable.getSelectionModel().getLeadSelectionIndex() : this.myTable.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        ModelIndex modelIndex = ViewIndex.forColumn((CoreGrid)this.myGrid, (int)idx).toModel((CoreGrid)this.myGrid);
        if (modelIndex == null) {
            TableSelectionModel.$$$reportNull$$$0(21);
        }
        return modelIndex;
    }

    @NotNull
    public ModelIndexSet<GridColumn> getSelectedColumns() {
        ModelIndexSet modelIndexSet = ViewIndexSet.forColumns((CoreGrid)this.myGrid, (int[])(this.myTable.isTransposed() ? this.myTable.getSelectedRows() : this.myTable.getSelectedColumns())).toModel((CoreGrid)this.myGrid);
        if (modelIndexSet == null) {
            TableSelectionModel.$$$reportNull$$$0(22);
        }
        return modelIndexSet;
    }

    public void selectWholeRow() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> {
            this.myGrid.getHiddenColumnSelectionHolder().setWholeRowSelected(!this.myTable.isTransposed());
            this.setColumnSelectionInterval(this.myTable.getColumnCount() - 1, 0);
        });
    }

    public void selectWholeColumn() {
        this.myGrid.getAutoscrollLocker().runWithLock(() -> this.setRowSelectionInterval(this.myTable.getRowCount() - 1, 0));
    }

    private void setSelection(boolean columns, int[] array) {
        if (this.myTable.isTransposed() && columns || !this.myTable.isTransposed() && !columns) {
            TableSelectionModel.setSelection(this.myTable.getSelectionModel(), false, this.myTable.getRowCount() - 1, array);
        } else {
            TableSelectionModel.setSelection(this.myTable.getColumnModel().getSelectionModel(), false, this.myTable.getColumnCount() - 1, array);
        }
    }

    public void addRowSelection(@NotNull ModelIndexSet<GridRow> selection) {
        if (selection == null) {
            TableSelectionModel.$$$reportNull$$$0(23);
        }
        TableSelectionModel.setSelection(this.myTable.getSelectionModel(), true, this.myTable.getRowCount() - 1, selection.asArray());
    }

    @Override
    public int selectedViewRowsCount() {
        return this.myTable.isTransposed() ? this.getSelectedRows().size() : this.getSelectedColumns().size();
    }

    @Override
    public int selectedViewColumnsCount() {
        return this.myTable.isTransposed() ? this.getSelectedColumns().size() : this.getSelectedRows().size();
    }

    private static void setSelection(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int ... selection) {
        if (maxSelectionIdx < 0) {
            return;
        }
        if (!add) {
            selectionModel.clearSelection();
        }
        for (int index : selection) {
            if (index == -1) continue;
            TableSelectionModel.setSelectionInterval(selectionModel, true, maxSelectionIdx, index, index);
        }
    }

    private static void setSelectionInterval(ListSelectionModel selectionModel, boolean add, int maxSelectionIdx, int idx0, int idx1) {
        if (maxSelectionIdx < 0) {
            return;
        }
        idx0 = TableSelectionModel.index(idx0, maxSelectionIdx);
        idx1 = TableSelectionModel.index(idx1, maxSelectionIdx);
        if (add) {
            selectionModel.addSelectionInterval(idx0, idx1);
        } else {
            selectionModel.setSelectionInterval(idx0, idx1);
        }
    }

    private static int index(int idx, int maxIdx) {
        return Math.max(0, Math.min(idx, maxIdx));
    }

    private static int[] convert(int maxIndex, IntUnaryOperator function, int[] indices) {
        return Arrays.stream(indices).filter(index -> index < maxIndex && index >= 0).map(function).filter(index -> index != -1).toArray();
    }

    @NotNull
    public GridSelection<GridRow, GridColumn> fit(@NotNull GridSelection<GridRow, GridColumn> selection) {
        if (selection == null) {
            TableSelectionModel.$$$reportNull$$$0(24);
        }
        int rowCount = this.myTable.isTransposed() ? this.myTable.getColumnCount() : this.myTable.getRowCount();
        int columnCount = this.myTable.isTransposed() ? this.myTable.getRowCount() : this.myTable.getColumnCount();
        ModelIndexSet rows = ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])TableSelectionModel.fit(selection.getSelectedRows().asArray(), rowCount));
        ModelIndexSet columns = ModelIndexSet.forColumns((CoreGrid)this.myGrid, (int[])TableSelectionModel.fit(selection.getSelectedColumns().asArray(), columnCount));
        return new GridSelectionImpl((ModelIndexSet<GridRow>)rows, (ModelIndexSet<GridColumn>)columns);
    }

    private static int[] fit(int @NotNull [] indices, int max) {
        if (indices == null) {
            TableSelectionModel.$$$reportNull$$$0(25);
        }
        ArrayList<Integer> newIndices = new ArrayList<Integer>();
        for (int index : indices) {
            if (index >= max) continue;
            newIndices.add(index);
        }
        return ArrayUtil.toIntArray(newIndices);
    }

    public void restore(@NotNull GridSelection<GridRow, GridColumn> selection) {
        if (selection == null) {
            TableSelectionModel.$$$reportNull$$$0(26);
        }
        this.myTable.clearSelection();
        SelectionModel selectionModel = this.myGrid.getSelectionModel();
        selectionModel.setSelection(selection.getSelectedRows(), selection.getSelectedColumns());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 17, 18, 19, 20, 21, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/table/TableSelectionModel";
                break;
            }
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rows";
                break;
            }
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selection";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indices";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/table/TableSelectionModel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTracker";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRow";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedRows";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionRow";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumn";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getLeadSelectionColumn";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedColumns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setColumnSelection";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isSelected";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedColumn";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isSelectedRow";
                break;
            }
            case 11: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setRowSelection";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setSelection";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addRowSelection";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "fit";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "restore";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 17, 18, 19, 20, 21, 22 -> new IllegalStateException(string);
        };
    }
}

