/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.puppet.psi.mixins;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ASTNode;
import com.intellij.lang.puppet.psi.PuppetClassDefinition;
import com.intellij.lang.puppet.psi.PuppetDelegatingLightElement;
import com.intellij.lang.puppet.psi.PuppetNameWrapper;
import com.intellij.lang.puppet.psi.PuppetScopeHolder;
import com.intellij.lang.puppet.psi.PuppetVariable;
import com.intellij.lang.puppet.psi.PuppetVariableLightElement;
import com.intellij.lang.puppet.psi.resolve.PuppetResolveUtil;
import com.intellij.lang.puppet.psi.stubs.PuppetClassDefinitionStub;
import com.intellij.lang.puppet.psi.stubs.PuppetStubBasedClassContainedPsiElementBase;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetClassStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetIncludeClassStatementsStubsIndex;
import com.intellij.lang.puppet.psi.stubs.indices.PuppetSubClassStubsIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PuppetClassDefinitionMixin
extends PuppetStubBasedClassContainedPsiElementBase<PuppetClassDefinitionStub>
implements PuppetClassDefinition {
    private static final List<String> IMPLICIT_VARIABLE_NAMES = Arrays.asList("name", "title");

    public PuppetClassDefinitionMixin(@NotNull PuppetClassDefinitionStub stub, @NotNull IStubElementType nodeType) {
        if (stub == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(0);
        }
        if (nodeType == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(1);
        }
        super(stub, nodeType);
    }

    public PuppetClassDefinitionMixin(@NotNull ASTNode node) {
        if (node == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(2);
        }
        super(node);
    }

    @Override
    @Nullable
    public String getParentClassName() {
        PuppetClassDefinitionStub stub = (PuppetClassDefinitionStub)this.getStub();
        if (stub != null) {
            return stub.getParentClassName();
        }
        PuppetNameWrapper parentClassReference = this.getAnyNameWrapper();
        return parentClassReference == null ? null : StringUtil.toLowerCase((String)parentClassReference.getText());
    }

    private List<PuppetVariable> getImplicitVariables() {
        return (List)CachedValuesManager.getCachedValue((PsiElement)this, () -> {
            ArrayList<1> result = new ArrayList<1>();
            for (String variableName : IMPLICIT_VARIABLE_NAMES) {
                result.add(new PuppetVariableLightElement((PsiManager)this.getManager(), this.getFullQualifiedName(), variableName){

                    @Override
                    @NotNull
                    public PuppetScopeHolder getScopeHolder() {
                        PuppetClassDefinitionMixin puppetClassDefinitionMixin = PuppetClassDefinitionMixin.this;
                        if (puppetClassDefinitionMixin == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return puppetClassDefinitionMixin;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/puppet/psi/mixins/PuppetClassDefinitionMixin$1", "getScopeHolder"));
                    }
                });
            }
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{this});
        });
    }

    @Override
    @Nullable
    public PuppetClassDefinition getParentClass() {
        String parentClassName = this.getParentClassName();
        if (parentClassName == null) {
            return null;
        }
        Collection definitions = PuppetClassStubsIndex.getInstance().find(parentClassName, this);
        return definitions.isEmpty() ? null : (PuppetClassDefinition)definitions.iterator().next();
    }

    @Nullable
    public Icon getIcon(int flags) {
        return AllIcons.Nodes.Class;
    }

    @Override
    @Nullable
    public String getScopeFullQualifiedName() {
        return this.getFullQualifiedName();
    }

    public PsiElement getContext() {
        return new ResolveContext(this);
    }

    @Override
    public boolean processSubClasses(PsiElementProcessor<? super PuppetClassDefinition> processor) {
        return this.processSubClasses(processor, new HashSet<PuppetClassDefinition>());
    }

    private boolean processSubClasses(PsiElementProcessor<? super PuppetClassDefinition> processor, @NotNull Set<PuppetClassDefinition> recursionSet) {
        String fullQualifiedName;
        if (recursionSet == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(3);
        }
        if (StringUtil.isEmpty((String)(fullQualifiedName = this.getFullQualifiedName()))) {
            return true;
        }
        for (PuppetClassDefinition subClass : PuppetSubClassStubsIndex.find(fullQualifiedName, this)) {
            if (!recursionSet.add(subClass)) continue;
            if (!processor.execute((PsiElement)subClass)) {
                return false;
            }
            ((PuppetClassDefinitionMixin)subClass).processSubClasses(processor, recursionSet);
        }
        return true;
    }

    @Override
    public boolean processVariablesDeclarations(PsiElementProcessor<? super PuppetVariable> processor) {
        for (PuppetVariable variable : this.getImplicitVariables()) {
            if (processor.execute((PsiElement)variable)) continue;
            return false;
        }
        return PuppetClassDefinition.super.processVariablesDeclarations(processor);
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, @Nullable PsiElement lastChildElement, @NotNull PsiElement originElement) {
        if (processor == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(4);
        }
        if (resolveState == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(5);
        }
        if (originElement == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(6);
        }
        if (super.processDeclarations(processor, resolveState, lastChildElement, originElement)) {
            for (PuppetVariable variable : this.getImplicitVariables()) {
                if (processor.execute((PsiElement)variable, resolveState)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean processParentClasses(PsiElementProcessor<? super PuppetClassDefinition> processor) {
        return this.processParentClasses(processor, new HashSet<PuppetClassDefinition>());
    }

    public boolean processParentClasses(PsiElementProcessor<? super PuppetClassDefinition> processor, @NotNull Set<PuppetClassDefinition> recursionSet) {
        PuppetClassDefinition parentClass;
        if (recursionSet == null) {
            PuppetClassDefinitionMixin.$$$reportNull$$$0(7);
        }
        if ((parentClass = this.getParentClass()) == null || !recursionSet.add(parentClass)) {
            return true;
        }
        return processor.execute((PsiElement)parentClass) && ((PuppetClassDefinitionMixin)parentClass).processParentClasses(processor, recursionSet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stub";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recursionSet";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveState";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originElement";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/puppet/psi/mixins/PuppetClassDefinitionMixin";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processSubClasses";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processDeclarations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processParentClasses";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ResolveContext
    extends PuppetDelegatingLightElement<PuppetClassDefinition> {
        ResolveContext(@NotNull PuppetClassDefinition delegate) {
            if (delegate == null) {
                ResolveContext.$$$reportNull$$$0(0);
            }
            super(delegate);
        }

        @Override
        public PsiElement getContext() {
            return null;
        }

        @Override
        public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState resolveState, @Nullable PsiElement lastChild, @NotNull PsiElement originElement) {
            if (processor == null) {
                ResolveContext.$$$reportNull$$$0(1);
            }
            if (resolveState == null) {
                ResolveContext.$$$reportNull$$$0(2);
            }
            if (originElement == null) {
                ResolveContext.$$$reportNull$$$0(3);
            }
            HashSet<String> classSet = new HashSet<String>();
            classSet.add(((PuppetClassDefinition)this.getDelegate()).getFullQualifiedName());
            if (!((PuppetClassDefinition)this.getDelegate()).processParentClasses((PsiElementProcessor<? super PuppetClassDefinition>)((PsiElementProcessor)parentClass -> !classSet.add(parentClass.getFullQualifiedName()) || PuppetResolveUtil.processChildren(parentClass, processor, resolveState, null, originElement)))) {
                return false;
            }
            ((PuppetClassDefinition)this.getDelegate()).processSubClasses((PsiElementProcessor<? super PuppetClassDefinition>)((PsiElementProcessor)subClass -> {
                classSet.add(subClass.getFullQualifiedName());
                return true;
            }));
            for (String className : classSet) {
                if (StringUtil.isEmpty((String)className)) continue;
                for (PsiElement includeStatement : PuppetIncludeClassStatementsStubsIndex.find(className, this.getDelegate())) {
                    PuppetResolveUtil.treeWalkUp(includeStatement, false, processor, resolveState);
                }
            }
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "resolveState";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "originElement";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/puppet/psi/mixins/PuppetClassDefinitionMixin$ResolveContext";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processDeclarations";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

